/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart;

import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.text.DecimalFormat;
import java.text.Format;

public class ValuePointModel {
    protected Font myFont;
    protected Point myPoint;
    protected Color myColor;
    protected double myRotation;
    protected Format myFormatter;
    protected AffineTransform myTransform;

    public ValuePointModel() {
        this.initDefaultValues();
    }

    protected void initDefaultValues() {
        this.myFormatter = new DecimalFormat("#0.0");
        ((DecimalFormat)this.myFormatter).setParseIntegerOnly(true);
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    public void setLocation(Point point) {
        this.myPoint = point;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void setRotation(double rotation) {
        this.myRotation = rotation;
    }

    public void setTransformation(AffineTransform transform) throws NoninvertibleTransformException {
        if (SystemUtils.isEqual(transform.getDeterminant(), 0.0)) {
            throw new NoninvertibleTransformException("Transform is not invertible.");
        }
        this.myTransform = transform;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Point getLocation() {
        return this.myPoint;
    }

    public Color getColor() {
        return this.myColor;
    }

    public double getRotation() {
        return this.myRotation;
    }

    public AffineTransform getTransformation() {
        return this.myTransform;
    }

    public void setDataValueFormatter(Format formatter) {
        this.myFormatter = formatter;
    }

    public Format getDataValueFormatter() {
        return this.myFormatter;
    }
}

