/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.data;

import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import java.awt.Color;
import java.util.List;

public class CompositeXYSeries
extends XYSeries {
    private GraphRenderer renderer;

    public static CompositeXYSeries create(String name, double[][] values) {
        if (values[0].length != values[1].length) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        CompositeXYSeries series = new CompositeXYSeries(name);
        int i = 0;
        while (i < values[0].length) {
            series.addXYPair(new XYPair(values[0][i], values[1][i]));
            ++i;
        }
        return series;
    }

    public static CompositeXYSeries create(String name, long[][] values) {
        if (values[0].length != values[1].length) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        CompositeXYSeries series = new CompositeXYSeries(name);
        int i = 0;
        while (i < values[0].length) {
            series.addXYPair(new XYPair(values[0][i], values[1][i]));
            ++i;
        }
        return series;
    }

    public static CompositeXYSeries create(String name, long[] values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        CompositeXYSeries series = new CompositeXYSeries(name);
        int i = 0;
        while (i < values.length) {
            series.addXYPair(new XYPair(values[i], values[i + 1]));
            i += 2;
        }
        return series;
    }

    public static CompositeXYSeries create(String name, Color color, double[][] values) {
        CompositeXYSeries series = CompositeXYSeries.create(name, values);
        series.setColor(color);
        return series;
    }

    public static CompositeXYSeries create(String name, Color color, long[][] values) {
        CompositeXYSeries series = CompositeXYSeries.create(name, values);
        series.setColor(color);
        return series;
    }

    public static CompositeXYSeries create(String name, double[] values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        CompositeXYSeries series = new CompositeXYSeries(name);
        int i = 0;
        while (i < values.length) {
            series.addXYPair(new XYPair(values[i], values[i + 1]));
            i += 2;
        }
        return series;
    }

    public static CompositeXYSeries create(String name, List<?> xValues, List<?> yValues) {
        if (xValues.size() != yValues.size()) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        CompositeXYSeries series = new CompositeXYSeries(name);
        int i = 0;
        while (i < xValues.size()) {
            series.addXYPair(new XYPair(xValues.get(i), yValues.get(i)));
            ++i;
        }
        return series;
    }

    public static CompositeXYSeries create(String name, Color color, List<?> xValues, List<?> yValues) {
        XYSeries series = CompositeXYSeries.create(name, xValues, yValues);
        series.setColor(color);
        return series;
    }

    public CompositeXYSeries(XYSeries series, GraphRenderer renderer) {
        this(series.getName(), renderer);
    }

    public CompositeXYSeries(String name) {
        super(name);
    }

    public CompositeXYSeries(String name, GraphRenderer renderer) {
        super(name);
        this.renderer = renderer;
    }

    public GraphRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GraphRenderer renderer) {
        this.renderer = renderer;
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, Color color, long[][] lArray) {
        return CompositeXYSeries.create(string, color, lArray);
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, Color color, double[][] dArray) {
        return CompositeXYSeries.create(string, color, dArray);
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, double[] dArray) {
        return CompositeXYSeries.create(string, dArray);
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, long[] lArray) {
        return CompositeXYSeries.create(string, lArray);
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, long[][] lArray) {
        return CompositeXYSeries.create(string, lArray);
    }

    public static /* bridge */ /* synthetic */ XYSeries create(String string, double[][] dArray) {
        return CompositeXYSeries.create(string, dArray);
    }
}

