/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.data;

import com.nokia.widgets.chart.data.DataSetListener;
import com.nokia.widgets.chart.data.DefaultSeriesComparator;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class XYDataSet
implements Observer {
    protected List mySeries = new ArrayList();
    protected List<DataSetListener> myListeners = new ArrayList<DataSetListener>();
    protected Comparator mySeriesComparator;

    public XYDataSet() {
        this.setSeriesComparator(new DefaultSeriesComparator());
    }

    public XYDataSet(XYSeries series) {
        this(new XYSeries[]{series});
    }

    public XYDataSet(XYSeries[] seriesList) {
        this();
        int i = 0;
        while (i < seriesList.length) {
            this.add(seriesList[i]);
            ++i;
        }
    }

    public static XYDataSet createPieChartDataSet(List<XYPair> pieChartData) {
        XYDataSet xyDataSet = new XYDataSet();
        for (XYPair pair : pieChartData) {
            if (!(pair.getX() instanceof String) || !(pair.getY() instanceof Double)) continue;
            XYSeries xySeries = new XYSeries((String)pair.getX());
            xySeries.addXYPair(pair);
            xyDataSet.add(xySeries);
        }
        return xyDataSet;
    }

    public void add(XYSeries series) {
        if (series.getXYPairsCount() == 0) {
            return;
        }
        if (series.getName() == null || series.getName().length() == 0 || this.getSeries(series.getName()) != null) {
            throw new IllegalArgumentException("A data set must have NON-EMPTY and UNIQUE name!");
        }
        series.addObserver(this);
        this.mySeries.add(series);
        this.fireSeriesAdded(series);
    }

    public void addAll(List<XYSeries> series) {
        for (XYSeries xySeries : series) {
            this.add(xySeries);
        }
    }

    public void remove(String seriesName) {
        Observable removedSeries = null;
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            if (series.getName().equals(seriesName)) {
                removedSeries = series;
                break;
            }
            ++i;
        }
        if (removedSeries != null) {
            removedSeries.deleteObserver(this);
            this.mySeries.remove(removedSeries);
            this.fireSeriesRemoved((XYSeries)removedSeries);
        }
    }

    public List<XYSeries> getAllSeries() {
        return this.mySeries;
    }

    public int getSeriesCount() {
        return this.mySeries.size();
    }

    public XYSeries getSeries(String name) {
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            if (series.getName().equals(name)) {
                return series;
            }
            ++i;
        }
        return null;
    }

    public List getXValues() {
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            values.addAll(series.getXValues());
            ++i;
        }
        return new ArrayList(values);
    }

    public List getYValues() {
        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            values.addAll(series.getYValues());
            ++i;
        }
        return new ArrayList(values);
    }

    public List getDefaultXAxisValues() {
        int maxValueCount = 0;
        List<Object> defaultValues = new ArrayList();
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            if (series.getXValues().size() > maxValueCount) {
                maxValueCount = series.getXValues().size();
                defaultValues = series.getXValues();
            }
            ++i;
        }
        return defaultValues;
    }

    public List getDefaultYAxisValues() {
        int maxValueCount = 0;
        List<Object> defaultValues = new ArrayList();
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            if (series.getYValues().size() > maxValueCount) {
                maxValueCount = series.getYValues().size();
                defaultValues = series.getYValues();
            }
            ++i;
        }
        return defaultValues;
    }

    public void removeAll() {
        int i = 0;
        while (i < this.mySeries.size()) {
            ((Observable)this.mySeries.get(i)).deleteObserver(this);
            ++i;
        }
        ArrayList series = new ArrayList();
        series.addAll(this.mySeries);
        this.mySeries.clear();
        int i2 = 0;
        while (i2 < series.size()) {
            this.fireSeriesRemoved((XYSeries)series.get(i2));
            ++i2;
        }
        series.clear();
        series = null;
    }

    public void addDataSetListener(DataSetListener listener) {
        this.myListeners.add(listener);
    }

    public void removeDataSetListener(DataSetListener listener) {
        this.myListeners.remove(listener);
    }

    public void setThresholdColor(Color color) {
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            series.setThresholdColor(color);
            ++i;
        }
    }

    public void setThresholdValue(double thresholdValue) {
        int i = 0;
        while (i < this.mySeries.size()) {
            XYSeries series = (XYSeries)this.mySeries.get(i);
            series.setThresholdValue(new Double(thresholdValue));
            ++i;
        }
    }

    public void sort() {
        Collections.sort(this.mySeries, this.mySeriesComparator);
    }

    public void setSeriesComparator(Comparator comparator) {
        this.mySeriesComparator = comparator;
    }

    protected void fireSeriesAdded(XYSeries series) {
        int i = 0;
        while (i < this.myListeners.size()) {
            this.myListeners.get(i).seriesAdded(this, series);
            ++i;
        }
    }

    protected void fireSeriesRemoved(XYSeries series) {
        int i = 0;
        while (i < this.myListeners.size()) {
            this.myListeners.get(i).seriesRemoved(this, series);
            ++i;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        int i = 0;
        while (i < this.myListeners.size()) {
            this.myListeners.get(i).seriesUpdated(this, (XYSeries)o);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (XYSeries series : this.mySeries) {
            sb.append(series).append(",");
        }
        if (this.mySeries.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }
}

