/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class XYPair
implements Serializable {
    private Object myX;
    private Object myY;
    private Object myZ;
    private BigDecimal myZBigDecimal;

    public XYPair() {
        this(new Double(0.0), new Double(0.0));
    }

    public XYPair(Object x, Object y) {
        this.myX = x;
        this.myY = y;
    }

    public XYPair(Object x, Object y, Object z) {
        this.myX = x;
        this.myY = y;
        this.myZ = z;
        this.myZBigDecimal = new BigDecimal(z.toString());
    }

    public XYPair(long x, long y) {
        this.myX = x;
        this.myY = y;
    }

    public XYPair(long x, long y, long z) {
        this(x, y);
        this.myZ = z;
    }

    public XYPair(float x, float y) {
        this.myX = new Float(x);
        this.myY = new Float(y);
    }

    public XYPair(double x, double y) {
        this.myX = new Double(x);
        this.myY = new Double(y);
    }

    public XYPair(double x, double y, double z) {
        this(x, y);
        this.myZ = new Double(z);
        this.myZBigDecimal = new BigDecimal(this.myZ.toString());
    }

    public XYPair(float x, float y, float z) {
        this(x, y);
        this.myZ = new Float(z);
        this.myZBigDecimal = new BigDecimal(this.myZ.toString());
    }

    public Object getX() {
        return this.myX;
    }

    public Object getZ() {
        return this.myZ;
    }

    public BigDecimal getZAsBigDecimal() {
        return this.myZBigDecimal;
    }

    public long getXAsLong() {
        return (Long)this.myX;
    }

    public long getYAsLong() {
        return (Long)this.myY;
    }

    public long getZAsLong() {
        return this.myZ != null ? (Long)this.myZ : 0L;
    }

    public boolean isXLong() {
        return this.myX instanceof Long;
    }

    public boolean isYLong() {
        return this.myY instanceof Long;
    }

    public boolean isYIntegerNumber() {
        return this.myY instanceof Long || this.myY instanceof Integer || this.myY instanceof Short || this.myY instanceof Byte;
    }

    public boolean isXIntegerNumber() {
        return this.myX instanceof Long || this.myX instanceof Integer || this.myX instanceof Short || this.myX instanceof Byte;
    }

    public boolean isYFloatingPointNumber() {
        return this.myY instanceof Double || this.myY instanceof Float;
    }

    public boolean isZFloatingPointNumber() {
        return this.myZ instanceof Double || this.myZ instanceof Float;
    }

    public boolean isZDouble() {
        return this.myZ instanceof Double;
    }

    public boolean isXFloatingPointNumber() {
        return this.myX instanceof Double || this.myX instanceof Float;
    }

    public double getXAsDouble() {
        if (this.myX instanceof Float) {
            return ((Float)this.myX).doubleValue();
        }
        return (Double)this.myX;
    }

    public Object getY() {
        return this.myY;
    }

    public double getYAsDouble() {
        if (this.myY instanceof Float) {
            return ((Float)this.myY).doubleValue();
        }
        return (Double)this.myY;
    }

    public float getYAsFloat() {
        return ((Float)this.myY).floatValue();
    }

    public double getZAsDouble() {
        return (Double)this.myZ;
    }

    public float getZAsFloat() {
        return ((Float)this.myZ).floatValue();
    }

    public boolean isXDate() {
        return this.myX instanceof Date;
    }

    public boolean isXDouble() {
        return this.myX instanceof Double;
    }

    public boolean isYDouble() {
        return this.myY instanceof Double;
    }

    public boolean isYDate() {
        return this.myY instanceof Date;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XYPair) {
            XYPair pair = (XYPair)obj;
            return pair.myX.equals(this.myX) && pair.myY.equals(this.myY) && pair.myZ != null ? pair.myZ.equals(this.myZ) : true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash += this.myX == null ? 0 : this.myX.hashCode();
        hash += this.myY == null ? 0 : this.myY.hashCode();
        return hash += this.myZ == null ? 0 : this.myZ.hashCode();
    }

    public String toString() {
        return "(" + this.myX + "," + this.myY + (this.myZ != null ? "," + this.myZ : "") + ")";
    }
}

