/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.data;

import com.nokia.widgets.chart.ValuePointModel;
import com.nokia.widgets.chart.data.XYPair;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Random;
import javax.swing.Icon;

public class XYSeries
extends Observable {
    protected String myName;
    protected List<XYPair> myPairs;
    protected Color myColor;
    protected Color myGradientColor;
    protected int myValueMarkerType;
    protected Icon myCustomValueMarker;
    protected Map<Object, Icon> myCustomValueMarkerForSpecValue;
    protected Object myUserObject;
    protected Color myThresholdColor;
    protected Object myThresholdValue;
    protected String myToolTip;
    protected ValuePointModel myValuePointModel;
    private boolean myUseLeftYAxis = true;
    private String myNote;
    private Point myNotePosition;

    public static XYSeries create(String name, double[][] values) {
        if (values[0].length != values[1].length) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < values[0].length) {
            series.addXYPair(new XYPair(values[0][i], values[1][i]));
            ++i;
        }
        return series;
    }

    public static XYSeries create(String name, Color color, double[][] values) {
        XYSeries series = XYSeries.create(name, values);
        series.setColor(color);
        return series;
    }

    public static XYSeries create(String name, Color color, List<XYPair> pairs) {
        XYSeries series = new XYSeries(name, pairs);
        series.setColor(color);
        return series;
    }

    public static XYSeries create(String name, Color solidColor, Color gradientColor, double[][] values) {
        XYSeries series = XYSeries.create(name, values);
        series.setColor(solidColor, gradientColor);
        return series;
    }

    public static XYSeries create(String name, double[] values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < values.length) {
            series.addXYPair(new XYPair(values[i], values[i + 1]));
            i += 2;
        }
        return series;
    }

    public static XYSeries create(String name, float[] values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < values.length) {
            series.addXYPair(new XYPair(values[i], values[i + 1]));
            i += 2;
        }
        return series;
    }

    public static XYSeries create(String name, long[] values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < values.length) {
            series.addXYPair(new XYPair(values[i], values[i + 1]));
            i += 2;
        }
        return series;
    }

    public static XYSeries create(String name, long[][] values) {
        if (values[0].length != values[1].length) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < values[0].length) {
            series.addXYPair(new XYPair(values[0][i], values[1][i]));
            ++i;
        }
        return series;
    }

    public static XYSeries create(String name, Color color, long[][] values) {
        XYSeries series = XYSeries.create(name, values);
        series.setColor(color);
        return series;
    }

    public static XYSeries create(String name, Color solidColor, Color gradientColor, long[][] values) {
        XYSeries series = XYSeries.create(name, values);
        series.setColor(solidColor, gradientColor);
        return series;
    }

    public static XYSeries create(String name, List<?> xValues, List<?> yValues) {
        if (xValues.size() != yValues.size()) {
            throw new IllegalArgumentException("There must an equal number of x and y values!");
        }
        XYSeries series = new XYSeries(name);
        int i = 0;
        while (i < xValues.size()) {
            series.addXYPair(new XYPair(xValues.get(i), yValues.get(i)));
            ++i;
        }
        return series;
    }

    public static XYSeries create(String name, Color color, List<?> xValues, List<?> yValues) {
        XYSeries series = XYSeries.create(name, xValues, yValues);
        series.setColor(color);
        return series;
    }

    public static XYSeries create(String name, Color solidColor, Color gradientColor, List<?> xValues, List<?> yValues) {
        XYSeries series = XYSeries.create(name, xValues, yValues);
        series.setColor(solidColor, gradientColor);
        return series;
    }

    public XYSeries(String name, List<XYPair> pairs) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Series must have a proper name!");
        }
        this.myName = name;
        this.myPairs = pairs;
        this.myValueMarkerType = 0;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public XYSeries(String name) {
        this(name, new ArrayList<XYPair>());
    }

    public void addXYPair(XYPair pair) {
        this.myPairs.add(pair);
        this.setChanged();
        this.notifyObservers();
    }

    public void addAllXYPairs(List<XYPair> pairs) {
        this.myPairs.addAll(pairs);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYSeries other = (XYSeries)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myPairs == null ? other.myPairs != null : !this.myPairs.equals(other.myPairs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myPairs == null ? 0 : this.myPairs.hashCode());
        return result;
    }

    public XYPair getFirstPair() {
        if (this.myPairs.size() > 0) {
            return this.myPairs.get(0);
        }
        return null;
    }

    public XYPair getLastPair() {
        if (this.myPairs.size() > 0) {
            return this.myPairs.get(this.myPairs.size() - 1);
        }
        return null;
    }

    public void setValues(List<?> xValues, List<?> yValues) {
        if (xValues.size() != yValues.size()) {
            throw new IllegalArgumentException("There must be an equal number of x and y values!");
        }
        if (this.myPairs.size() > 0) {
            this.myPairs.clear();
        }
        int i = 0;
        while (i < xValues.size()) {
            this.myPairs.add(new XYPair(xValues.get(i), yValues.get(i)));
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public List<XYPair> getXYPairs() {
        return this.myPairs;
    }

    public int getXYPairsCount() {
        return this.myPairs.size();
    }

    public double getHighestX() {
        Double highestX = new Double(0.0);
        if (this.myPairs.get(0).isXDouble()) {
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() > highestX) {
                    highestX = new Double(pair.getXAsDouble());
                }
                ++i;
            }
        }
        return highestX;
    }

    public double getHighestY() {
        Double highestY = new Double(0.0);
        if (this.myPairs.get(0).isYDouble()) {
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getYAsDouble() > highestY) {
                    highestY = new Double(pair.getYAsDouble());
                }
                ++i;
            }
        }
        return highestY;
    }

    public double getSmallestX() {
        Double smallestX = new Double(Double.MAX_VALUE);
        if (this.myPairs.get(0).isXDouble()) {
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() < smallestX) {
                    smallestX = new Double(pair.getXAsDouble());
                }
                ++i;
            }
        }
        return smallestX;
    }

    public double getSmallestY() {
        Double smallestY = new Double(Double.MAX_VALUE);
        if (this.myPairs.get(0).isYDouble()) {
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() < smallestY) {
                    smallestY = new Double(pair.getYAsDouble());
                }
                ++i;
            }
        }
        return smallestY;
    }

    public Number getHighestXAsNumber() {
        if (this.myPairs.get(0).isXFloatingPointNumber()) {
            double highestX = 0.0;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() > highestX) {
                    highestX = pair.getXAsDouble();
                }
                ++i;
            }
            return highestX;
        }
        long highestX = 0L;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getXAsLong() > highestX) {
                highestX = pair.getXAsLong();
            }
            ++i;
        }
        return highestX;
    }

    public Number getHighestYAsNumber() {
        XYPair firstPair = this.myPairs.get(0);
        if (firstPair.isYFloatingPointNumber()) {
            Number highestY = 0;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getYAsDouble() > ((Number)highestY).doubleValue()) {
                    highestY = pair.getYAsDouble();
                }
                ++i;
            }
            return firstPair.isYDouble() ? (Number)highestY : (Number)Float.valueOf(((Number)highestY).floatValue());
        }
        long highestY = 0L;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getYAsLong() > highestY) {
                highestY = pair.getYAsLong();
            }
            ++i;
        }
        return highestY;
    }

    public Number getSmallestZAsNumber() {
        XYPair firstPair = this.myPairs.get(0);
        if (firstPair.isZFloatingPointNumber()) {
            boolean isDouble = firstPair.isYDouble();
            Number smallestZ = isDouble ? Double.MAX_VALUE : 3.4028234663852886E38;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                smallestZ = isDouble ? (Number)Math.min(smallestZ, pair.getZAsDouble()) : (Number)Float.valueOf(Math.min(((Number)smallestZ).floatValue(), pair.getZAsFloat()));
                ++i;
            }
            return smallestZ;
        }
        long smallestZ = Long.MAX_VALUE;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            smallestZ = Math.max(pair.getZAsLong(), smallestZ);
            ++i;
        }
        return smallestZ;
    }

    public Number getHighestZAsNumber() {
        XYPair firstPair = this.myPairs.get(0);
        if (firstPair.isZFloatingPointNumber()) {
            Number highestZ = 0;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                highestZ = firstPair.isZDouble() ? (Number)Math.max(pair.getZAsDouble(), ((Number)highestZ).doubleValue()) : (Number)Float.valueOf(Math.max(pair.getZAsFloat(), ((Number)highestZ).floatValue()));
                ++i;
            }
            return highestZ;
        }
        long highestZ = 0L;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getZAsLong() > highestZ) {
                highestZ = pair.getZAsLong();
            }
            ++i;
        }
        return highestZ;
    }

    public Number getZAsNumber(Number y) {
        if (y == null) {
            throw new IllegalArgumentException("Argument can't be null");
        }
        if (this.myPairs.get(0).isZFloatingPointNumber()) {
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (y.equals(pair.getY())) {
                    if (pair.isZDouble()) {
                        return pair.getZAsDouble();
                    }
                    return Float.valueOf(pair.getZAsFloat());
                }
                ++i;
            }
            throw new IllegalArgumentException("No z found for y: " + y);
        }
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getZAsLong() == y.longValue()) {
                return pair.getZAsLong();
            }
            ++i;
        }
        throw new IllegalArgumentException("No z found for y: " + y);
    }

    public Number getSmallestXAsNumber() {
        if (this.myPairs.get(0).isXFloatingPointNumber()) {
            double smallestX = Double.MAX_VALUE;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() < smallestX) {
                    smallestX = pair.getXAsDouble();
                }
                ++i;
            }
            return smallestX;
        }
        long smallestX = Long.MAX_VALUE;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getXAsLong() < smallestX) {
                smallestX = pair.getXAsLong();
            }
            ++i;
        }
        return smallestX;
    }

    public Number getSmallestYAsNumber() {
        if (this.myPairs.get(0).isYFloatingPointNumber()) {
            double smallestY = Double.MAX_VALUE;
            int i = 0;
            while (i < this.myPairs.size()) {
                XYPair pair = this.myPairs.get(i);
                if (pair.getXAsDouble() < smallestY) {
                    smallestY = pair.getYAsDouble();
                }
                ++i;
            }
            return smallestY;
        }
        long smallestY = Long.MAX_VALUE;
        int i = 0;
        while (i < this.myPairs.size()) {
            XYPair pair = this.myPairs.get(i);
            if (pair.getXAsLong() < smallestY) {
                smallestY = pair.getYAsLong();
            }
            ++i;
        }
        return smallestY;
    }

    public List<Object> getXValues() {
        ArrayList<Object> xList = new ArrayList<Object>(this.myPairs.size());
        int i = 0;
        while (i < this.myPairs.size()) {
            xList.add(this.myPairs.get(i).getX());
            ++i;
        }
        return xList;
    }

    public List<Object> getYValues() {
        ArrayList<Object> yList = new ArrayList<Object>(this.myPairs.size());
        int i = 0;
        while (i < this.myPairs.size()) {
            yList.add(this.myPairs.get(i).getY());
            ++i;
        }
        return yList;
    }

    public boolean isXDateType() {
        return this.myPairs.size() > 0 && this.myPairs.get(0).isXDate();
    }

    public boolean isYDateType() {
        return this.myPairs.size() > 0 && this.myPairs.get(0).isYDate();
    }

    public String getName() {
        return this.myName;
    }

    public Color getColor() {
        return this.myColor;
    }

    public Color getGradientColor() {
        return this.myGradientColor;
    }

    public void setColor(Color solidColor) {
        this.myColor = solidColor;
        this.setChanged();
        this.notifyObservers();
    }

    public void setGradientColor(Color gradientColor) {
        this.myGradientColor = gradientColor;
        this.setChanged();
        this.notifyObservers();
    }

    public void setColor(Color solidColor, Color gradientColor) {
        this.myColor = solidColor;
        this.myGradientColor = gradientColor;
        this.setChanged();
        this.notifyObservers();
    }

    public int getValueMarkerType() {
        return this.myValueMarkerType;
    }

    public void setValueMarkerType(int valueMarker) {
        this.myValueMarkerType = valueMarker;
        this.setChanged();
        this.notifyObservers();
    }

    public Icon getCustomValueMarker() {
        return this.myCustomValueMarker;
    }

    public void setCustomValueMarker(Icon customValueMarker) {
        this.myCustomValueMarker = customValueMarker;
    }

    public Map<Object, Icon> getCustomValueMarkerForSpecValue() {
        return this.myCustomValueMarkerForSpecValue;
    }

    public void setCustomValueMarkerForSpecValue(Map<Object, Icon> customValueMarkerForSpecValue) {
        this.myCustomValueMarkerForSpecValue = customValueMarkerForSpecValue;
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public void setUserObject(Object obj) {
        this.myUserObject = obj;
        this.setChanged();
        this.notifyObservers();
    }

    public Color getThresholdColor() {
        return this.myThresholdColor;
    }

    public void setThresholdColor(Color thresholdColor) {
        this.myThresholdColor = thresholdColor;
        this.setChanged();
        this.notifyObservers();
    }

    public Object getThresholdValue() {
        return this.myThresholdValue;
    }

    public void setThresholdValue(Object threshold) {
        if (threshold instanceof Object[] && ((Object[])threshold).length != this.getXYPairsCount()) {
            throw new IllegalArgumentException("Threshold value array must be of same size as the graph value array");
        }
        this.myThresholdValue = threshold;
        this.setChanged();
        this.notifyObservers();
    }

    public void randomizeSeriesColor() {
        Random r = new Random(System.currentTimeMillis() + (long)this.myName.hashCode());
        this.myColor = new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255));
    }

    public String getToolTipText() {
        return this.myToolTip;
    }

    public void setToolTipText(String toolTip) {
        this.myToolTip = toolTip;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean getUseLeftYAxis() {
        return this.myUseLeftYAxis;
    }

    public void setUseLeftYAxis(boolean useLeftYAxis) {
        this.myUseLeftYAxis = useLeftYAxis;
        this.setChanged();
        this.notifyObservers();
    }

    public void setValuePointModel(ValuePointModel valuePointModel) {
        this.myValuePointModel = valuePointModel;
    }

    public ValuePointModel getValuePointModel() {
        return this.myValuePointModel;
    }

    public String getNote() {
        return this.myNote;
    }

    public void setNote(String note) {
        this.myNote = note;
    }

    public Point getNotePosition() {
        return this.myNotePosition;
    }

    public void setNotePosition(Point notePosition) {
        this.myNotePosition = notePosition;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (XYPair pair : this.myPairs) {
            sb.append(pair).append(",");
        }
        if (this.myPairs.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }
}

