/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisListener;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.data.HighlightMarker;
import com.nokia.widgets.util.SystemUtils;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.DateFormatter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class AxisModel
implements Axis {
    private static final double REQUIRED_LABEL_SIZE_NOT_CALCULATED = -100.0;
    private String myAxisLabel;
    private List myAxisValues;
    private Object myMinimumValue;
    private Object myMaximumValue;
    private int myAxisValueLineCount;
    private int myAxisValueLabelInterval;
    private int myValueLabelOrientation;
    private InternationalFormatter myAxisValueFormatter = null;
    private double myRequiredLabelSize = -100.0;
    private List<AxisListener> myListeners = new ArrayList<AxisListener>();
    private int myType;
    private List<MissingDataArea> myMissingData;
    private List<HighlightedDataArea> myHighlightedData;
    private Map myValueDescriptions = new HashMap();
    private String myStartDescription;
    private String myEndDescription;
    private boolean myIsUpdatingBlocked = false;

    public AxisModel() {
        this.setValueLabelOrientation(0);
        this.myType = 2;
    }

    public AxisModel(String axisLabel, boolean horizontalAxis, Object minValue, Object maxValue, int valueLineCount, int valueLabelInterval, boolean horizontalLabels, InternationalFormatter dataFormatter) {
        if (!minValue.getClass().equals(maxValue.getClass())) {
            throw new IllegalArgumentException("Minimum and maximum values cannot be of different class.");
        }
        if (!(minValue instanceof Number) && !(minValue instanceof Date)) {
            throw new IllegalArgumentException("Only Number or Date datatypes are supported for minimum and maximum value");
        }
        this.myMinimumValue = minValue;
        this.myMaximumValue = maxValue;
        this.myAxisLabel = axisLabel;
        this.myType = horizontalAxis ? 2 : 0;
        this.myAxisValueLineCount = valueLineCount;
        this.myAxisValueLabelInterval = valueLabelInterval;
        this.setValueLabelOrientation(horizontalLabels ? 0 : 90);
        this.myAxisValueFormatter = dataFormatter;
    }

    public AxisModel(String axisLabel, boolean horizontalAxis, List axisValues, int valueLabelInterval, boolean horizontalLabels, InternationalFormatter dataFormatter) {
        this.myAxisLabel = axisLabel;
        this.myType = horizontalAxis ? 2 : 0;
        this.myAxisValues = axisValues;
        this.myAxisValueLabelInterval = valueLabelInterval;
        this.setValueLabelOrientation(horizontalLabels ? 0 : 90);
        this.myAxisValueFormatter = dataFormatter;
    }

    @Override
    public String getLabel() {
        return this.myAxisLabel;
    }

    @Override
    public int getType() {
        return this.myType;
    }

    @Override
    public Object getMinValue() {
        return this.myMinimumValue;
    }

    @Override
    public Object getMaxValue() {
        return this.myMaximumValue;
    }

    @Override
    public int getValueLineCount() {
        if (this.myAxisValues != null) {
            return this.myAxisValues.size();
        }
        return this.myAxisValueLineCount;
    }

    @Override
    public int getValueLabelInterval() {
        return this.myAxisValueLabelInterval;
    }

    @Override
    public int getValueLabelOrientation() {
        return this.myValueLabelOrientation;
    }

    @Override
    public void setMinValue(Object minValue) {
        if (this.myMinimumValue != minValue) {
            this.myMinimumValue = minValue;
            this.myRequiredLabelSize = -100.0;
            this.myAxisValues = null;
            this.fireAxisModelUpdated();
        }
    }

    @Override
    public void setMaxValue(Object maxValue) {
        if (this.myMaximumValue != maxValue) {
            this.myMaximumValue = maxValue;
            this.myRequiredLabelSize = -100.0;
            if (this.myAxisValueFormatter == null) {
                if (maxValue instanceof Double) {
                    this.myAxisValueFormatter = new NumberFormatter(new DecimalFormat("0"));
                } else if (maxValue instanceof Integer) {
                    this.myAxisValueFormatter = new NumberFormatter();
                } else if (maxValue instanceof Date) {
                    this.myAxisValueFormatter = new DateFormatter();
                } else if (maxValue instanceof Long) {
                    this.myAxisValueFormatter = new NumberFormatter();
                }
            }
            this.myAxisValues = null;
            this.fireAxisModelUpdated();
        }
    }

    public void setValues(List values) {
        this.myAxisValues = Arrays.asList(values.toArray());
        this.myRequiredLabelSize = -100.0;
        this.myMinimumValue = null;
        this.myMaximumValue = null;
        this.fireAxisModelUpdated();
    }

    @Override
    public void setValueLineCount(int count) {
        if (this.myAxisValueLineCount != count) {
            this.myAxisValueLineCount = count;
            this.fireAxisModelUpdated();
        }
    }

    @Override
    public void setValueLabelInterval(int labelInterval) {
        if (this.myAxisValueLabelInterval != labelInterval) {
            this.myAxisValueLabelInterval = labelInterval;
            this.fireAxisModelUpdated();
        }
    }

    @Override
    public void setValueLabelOrientation(int orientation) {
        if (this.myValueLabelOrientation != orientation) {
            this.myValueLabelOrientation = orientation;
            this.myRequiredLabelSize = -100.0;
            this.fireAxisModelUpdated();
        }
    }

    public String getAxisValueLabel(int valueLineIndex) {
        if (this.isPlaceForValueLabel(valueLineIndex)) {
            return this.getValueLabel(valueLineIndex);
        }
        return null;
    }

    @Override
    public InternationalFormatter getDataFormatter() {
        return this.myAxisValueFormatter;
    }

    @Override
    public List<?> getValues() {
        return this.myAxisValues;
    }

    @Override
    public void setDataFormatter(InternationalFormatter formatter) {
        if (this.myAxisValueFormatter != formatter) {
            this.myAxisValueFormatter = formatter;
            this.fireAxisModelUpdated();
        }
    }

    @Override
    public void setLabel(String label) {
        if (this.myAxisLabel == null && label != null || this.myAxisLabel != null && !this.myAxisLabel.equals(label)) {
            this.myAxisLabel = label;
            this.fireAxisModelUpdated();
        }
    }

    public double getRequiredAxisValueLabelSize(FontMetrics fontMetrics, Object prototypeValue) {
        if (SystemUtils.isEqual(this.myRequiredLabelSize, -100.0)) {
            if (this.myType == 2 && this.myValueLabelOrientation == 0) {
                this.myRequiredLabelSize = fontMetrics.getHeight();
            } else if (prototypeValue != null) {
                this.myRequiredLabelSize = fontMetrics.stringWidth(prototypeValue.toString());
            } else if (this.myAxisValues != null) {
                int requiredSize = 0;
                int i = 0;
                while (i < this.myAxisValues.size()) {
                    requiredSize = this.getLabelWidth(this.myAxisValues.get(i), fontMetrics);
                    if ((double)requiredSize > this.myRequiredLabelSize) {
                        this.myRequiredLabelSize = requiredSize;
                    }
                    ++i;
                }
            } else {
                int requiredSizeMaxValue;
                int requiredSizeMinValue = this.getLabelWidth(this.myMinimumValue, fontMetrics);
                this.myRequiredLabelSize = requiredSizeMinValue > (requiredSizeMaxValue = this.getLabelWidth(this.myMaximumValue, fontMetrics)) ? (double)requiredSizeMinValue : (double)requiredSizeMaxValue;
            }
        }
        return this.myRequiredLabelSize;
    }

    public double getRequiredAxisValueLabelLenght(FontMetrics fontMetrics) {
        int myRequiredLabelLenght = 0;
        if (this.myType == 2 && this.myValueLabelOrientation == 90) {
            myRequiredLabelLenght = fontMetrics.getHeight();
        } else if (this.myAxisValues != null) {
            int requiredSize = 0;
            int i = 0;
            while (i < this.myAxisValues.size()) {
                requiredSize = this.getLabelWidth(this.myAxisValues.get(i), fontMetrics);
                if (requiredSize > myRequiredLabelLenght) {
                    myRequiredLabelLenght = requiredSize;
                }
                ++i;
            }
        } else {
            int requiredSizeMaxValue;
            int requiredSizeMinValue = this.getLabelWidth(this.myMinimumValue, fontMetrics);
            myRequiredLabelLenght = requiredSizeMinValue > (requiredSizeMaxValue = this.getLabelWidth(this.myMaximumValue, fontMetrics)) ? requiredSizeMinValue : requiredSizeMaxValue;
        }
        return myRequiredLabelLenght;
    }

    public double getValuePositionAtAxis(Object value, double axisLength) {
        if (this.myAxisValues != null) {
            int indexOfValue = this.myAxisValues.indexOf(value);
            if (indexOfValue != -1) {
                if (this.myAxisValues.size() == 1) {
                    return axisLength / (double)this.myAxisValues.size() * (double)indexOfValue;
                }
                return axisLength / (double)(this.myAxisValues.size() - 1) * (double)indexOfValue;
            }
            throw new IndexOutOfBoundsException("Value is not found from the axis scale, value: " + value);
        }
        if (value instanceof Number && this.myMinimumValue instanceof Number) {
            return this.getNumberPosition((Number)value, axisLength);
        }
        if (value instanceof Date && this.myMinimumValue instanceof Date) {
            return this.getDatePosition((Date)value, axisLength);
        }
        throw new IllegalArgumentException("Value is not of same type as the axis scale, value class: " + value.getClass().getName());
    }

    public double getPixelsPerValueUnit(double axisLength) {
        Object maxValue;
        Object minValue;
        if (this.myAxisValues != null && this.myAxisValues.size() > 0) {
            minValue = this.myAxisValues.get(0);
            maxValue = this.myAxisValues.get(this.myAxisValues.size() - 1);
        } else {
            minValue = this.myMinimumValue;
            maxValue = this.myMaximumValue;
        }
        if (minValue != null && maxValue != null) {
            if (minValue instanceof Number && maxValue instanceof Number) {
                Number minNumber = (Number)minValue;
                Number maxNumber = (Number)maxValue;
                double valueArea = maxNumber.doubleValue() - minNumber.doubleValue();
                return axisLength / valueArea;
            }
            if (minValue instanceof Date && maxValue instanceof Date) {
                Date minDate = (Date)minValue;
                Date maxDate = (Date)maxValue;
                double valueArea = maxDate.getTime() - minDate.getTime();
                return axisLength / valueArea;
            }
        }
        throw new IllegalStateException("Cannot calculate pixels per unit rate due to incompatible axis value data");
    }

    public boolean isConstantLineDensity() {
        return this.myAxisValues != null;
    }

    public void setType(int type) {
        this.myType = type;
    }

    @Override
    public void setStartDescription(String description) {
        this.myStartDescription = description;
    }

    public String getStartDescription() {
        return this.myStartDescription;
    }

    @Override
    public void setEndDescription(String description) {
        this.myEndDescription = description;
    }

    public String getEndDescription() {
        return this.myEndDescription;
    }

    @Override
    public void setValueDescription(Object axisValue, String description) {
        if (this.myAxisValues != null) {
            int i = 0;
            while (i < this.myAxisValues.size()) {
                Object value = this.myAxisValues.get(i);
                if (value.equals(axisValue)) {
                    this.setValueDescription(i, description);
                }
                ++i;
            }
        }
    }

    @Override
    public void setValueDescription(int valueIndex, String description) {
        if (this.myAxisValues != null && valueIndex < this.myAxisValues.size()) {
            this.myValueDescriptions.put(valueIndex, description);
        }
        this.fireAxisModelUpdated();
    }

    protected String getValueDescription(int valueIndex) {
        if (this.myValueDescriptions != null) {
            return (String)this.myValueDescriptions.get(valueIndex);
        }
        return null;
    }

    public void addAxisModelListener(AxisListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void markMissingData(Object startValue, Object endValue, ChartConstants.DRAW_LAYER layer) {
        if (this.myMissingData == null) {
            this.myMissingData = new ArrayList<MissingDataArea>();
        }
        this.myMissingData.add(new MissingDataArea(startValue, endValue, layer));
        this.fireAxisModelUpdated();
    }

    @Override
    public void markMissingData(Object startValue, Object endValue) {
        this.markMissingData(startValue, endValue, ChartConstants.DRAW_LAYER.BOTTOM);
    }

    @Override
    public void markMissingData(Object startValue, Object endValue, String text, ChartConstants.DRAW_LAYER layer) {
        if (this.myMissingData == null) {
            this.myMissingData = new ArrayList<MissingDataArea>();
        }
        this.myMissingData.add(new MissingDataArea(startValue, endValue, text, layer));
        this.fireAxisModelUpdated();
    }

    @Override
    public void markMissingData(Object startValue, Object endValue, String text) {
        this.markMissingData(startValue, endValue, text, ChartConstants.DRAW_LAYER.BOTTOM);
    }

    @Override
    public void markHighlightedData(Object startval, Object endVal) {
        if (this.myHighlightedData == null) {
            this.myHighlightedData = new ArrayList<HighlightedDataArea>();
        }
        this.myHighlightedData.add(new HighlightedDataArea(startval, endVal));
        this.fireAxisModelUpdated();
    }

    protected List<MissingDataArea> getMissingData() {
        return this.myMissingData;
    }

    public void removeAxisModelListener(AxisListener listener) {
        this.myListeners.remove(listener);
    }

    public void blockListenerUpdates(boolean updatingBlocked) {
        this.myIsUpdatingBlocked = updatingBlocked;
    }

    private String getValueLabel(int index) {
        Object axisValueLabel;
        if (this.myAxisValues != null) {
            axisValueLabel = this.myAxisValues.get(index);
        } else if (this.myMaximumValue instanceof Number && this.myMinimumValue instanceof Number) {
            axisValueLabel = this.getLabelForNumber(index);
        } else if (this.myMaximumValue instanceof Date && this.myMinimumValue instanceof Date) {
            axisValueLabel = this.getLabelForDate(index);
        } else {
            throw new IllegalArgumentException("Datatypes of minimum and maximum value do not match or datatypes are not supported, minimum value class: " + this.myMinimumValue.getClass().getName() + " ,maximum value class: " + this.myMaximumValue.getClass().getName());
        }
        if (this.myAxisValueFormatter != null) {
            return this.getFormattedValueLabel(axisValueLabel);
        }
        return axisValueLabel.toString();
    }

    private int getLabelWidth(Object labelText, FontMetrics fontMetrics) {
        int requiredWidth = 0;
        try {
            requiredWidth = this.myAxisValueFormatter != null ? fontMetrics.stringWidth(this.myAxisValueFormatter.valueToString(labelText)) : fontMetrics.stringWidth(labelText.toString());
        }
        catch (ParseException ex) {
            requiredWidth = fontMetrics.stringWidth(labelText.toString());
        }
        return requiredWidth;
    }

    private Object getLabelForNumber(int index) {
        Number labelValue = null;
        Number minValue = (Number)this.myMinimumValue;
        Number maxValue = (Number)this.myMaximumValue;
        if (index == 0) {
            labelValue = minValue;
        } else {
            double valueScale = (maxValue.doubleValue() - minValue.doubleValue()) / (double)(this.myAxisValueLineCount - 1);
            double valueAtIndex = valueScale * (double)index;
            labelValue = this.myMinimumValue instanceof Long && this.myMaximumValue instanceof Long ? (Number)(minValue.longValue() + (long)valueAtIndex) : (Number)new Double(minValue.doubleValue() + valueAtIndex);
        }
        return labelValue;
    }

    private Object getLabelForDate(int index) {
        Comparable<Date> labelValue = null;
        Date startDate = (Date)this.myMinimumValue;
        Date endDate = (Date)this.myMaximumValue;
        if (index == 0) {
            labelValue = startDate;
        } else {
            long timeScale = (endDate.getTime() - startDate.getTime()) / (long)(this.myAxisValueLineCount - 1);
            long valueAtIndex = timeScale * (long)index;
            labelValue = valueAtIndex + startDate.getTime();
        }
        return labelValue;
    }

    private String getFormattedValueLabel(Object value) {
        if (value instanceof Number && SystemUtils.isEqual(((Number)value).doubleValue(), 0.0)) {
            return "0";
        }
        String formattedValue = null;
        try {
            formattedValue = this.myAxisValueFormatter.valueToString(value);
        }
        catch (Throwable t) {
            formattedValue = value.toString();
        }
        return formattedValue;
    }

    private double getNumberPosition(Number value, double axisLength) {
        double position = 0.0;
        Number minValue = (Number)this.myMinimumValue;
        double valueMultiplier = value.doubleValue() - minValue.doubleValue();
        if (!SystemUtils.isEqual(valueMultiplier, 0.0)) {
            position = valueMultiplier * this.getPixelsPerValueUnit(axisLength);
        }
        return position;
    }

    private double getDatePosition(Date value, double axisLength) {
        double position = 0.0;
        Date minValue = (Date)this.myMinimumValue;
        double valueMultiplier = value.getTime() - minValue.getTime();
        if (!SystemUtils.isEqual(valueMultiplier, 0.0)) {
            position = valueMultiplier * this.getPixelsPerValueUnit(axisLength);
        }
        return position;
    }

    private boolean isPlaceForValueLabel(int valueLineIndex) {
        boolean isPlace = false;
        int valueLineCount = this.myAxisValues != null ? this.myAxisValues.size() : this.myAxisValueLineCount;
        if (valueLineIndex == 0 || valueLineIndex == valueLineCount - 1) {
            isPlace = true;
        } else if (valueLineIndex % this.myAxisValueLabelInterval == 0 && valueLineCount - valueLineIndex > this.myAxisValueLabelInterval) {
            isPlace = true;
        }
        return isPlace;
    }

    private void fireAxisModelUpdated() {
        if (!this.myIsUpdatingBlocked) {
            int i = 0;
            while (i < this.myListeners.size()) {
                this.myListeners.get(i).axisUpdated(this);
                ++i;
            }
        }
    }

    @Override
    public List<HighlightedDataArea> getHighLightedData() {
        return this.myHighlightedData;
    }

    static interface ChartDataArea {
        public Object getStart();

        public Object getEnd();
    }

    public static class HighlightedDataArea
    implements ChartDataArea {
        private HighlightMarker myHighlightStartMarker;
        private HighlightMarker myHighlightEndMarker;

        public HighlightedDataArea(Object start, Object end) {
            this.setStartObj(start);
            this.setEndObj(end);
        }

        public void setStartObj(Object startObj) {
            this.myHighlightStartMarker = startObj instanceof HighlightMarker ? (HighlightMarker)startObj : new HighlightMarker(startObj);
        }

        public HighlightMarker getStartMarker() {
            return this.myHighlightStartMarker;
        }

        public HighlightMarker getEndMarker() {
            return this.myHighlightEndMarker;
        }

        public Object getStartObj() {
            return this.getStart();
        }

        @Override
        public Object getStart() {
            if (this.myHighlightStartMarker == null) {
                return null;
            }
            return this.myHighlightStartMarker.getValue();
        }

        @Override
        public Object getEnd() {
            if (this.myHighlightEndMarker == null) {
                return null;
            }
            return this.myHighlightEndMarker.getValue();
        }

        public void setEndObj(Object endObj) {
            this.myHighlightEndMarker = endObj instanceof HighlightMarker ? (HighlightMarker)endObj : new HighlightMarker(endObj);
        }

        public Object getEndObj() {
            return this.getEnd();
        }
    }

    public static class MissingDataArea
    implements ChartDataArea {
        Object myStart;
        Object myEnd;
        String myText;
        ChartConstants.DRAW_LAYER myLayer;

        public MissingDataArea(Object start, Object end, ChartConstants.DRAW_LAYER layer) {
            this.myStart = start;
            this.myEnd = end;
            this.myLayer = layer;
        }

        public MissingDataArea(Object start, Object end, String text, ChartConstants.DRAW_LAYER layer) {
            this.myStart = start;
            this.myEnd = end;
            this.myText = text;
            this.myLayer = layer;
        }

        public MissingDataArea(Object start, Object end, String text) {
            this.myStart = start;
            this.myEnd = end;
            this.myText = text;
            this.myLayer = ChartConstants.DRAW_LAYER.BOTTOM;
        }

        public MissingDataArea(Object start, Object end) {
            this.myStart = start;
            this.myEnd = end;
            this.myLayer = ChartConstants.DRAW_LAYER.BOTTOM;
        }

        @Override
        public Object getStart() {
            return this.myStart;
        }

        @Override
        public Object getEnd() {
            return this.myEnd;
        }

        public String getText() {
            return this.myText;
        }

        public ChartConstants.DRAW_LAYER getLayer() {
            return this.myLayer;
        }
    }
}

