/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import java.awt.Color;
import java.awt.geom.Area;

public class ChartColumn {
    private Area myArea;
    private double myXPos;
    private double myYPos;
    private XYPair myXYPair;
    private XYSeries myXYSeries;
    private double myWidth;
    private Color myColor;
    private Color myGradientColor;
    private boolean myUseLeftYAxis = true;

    public ChartColumn(Chart chart, XYPair xyPair, XYSeries xySeries, double preferredWidth, GraphArea graphArea, double zero) {
        this.myYPos = xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(xyPair.getY()) : graphArea.getRightYAxisPositionForValue(xyPair.getY());
        this.myUseLeftYAxis = xySeries.getUseLeftYAxis();
        this.myXPos = (double)((int)graphArea.getXAxisPositionForValue(xyPair.getX())) - preferredWidth / 2.0;
        this.myWidth = preferredWidth;
        this.myXYPair = xyPair;
        this.myXYSeries = xySeries;
        this.myColor = xySeries.getColor();
        this.myGradientColor = xySeries.getGradientColor();
    }

    public double getWidth() {
        return this.myWidth;
    }

    public double getXPos() {
        return this.myXPos;
    }

    public double getYPos() {
        return this.myYPos;
    }

    public XYPair getXYPair() {
        return this.myXYPair;
    }

    public XYSeries getXYSeries() {
        return this.myXYSeries;
    }

    public void setXYSeries(XYSeries XYSeries2) {
        this.myXYSeries = XYSeries2;
    }

    public Color getColor() {
        return this.myColor;
    }

    public boolean getUseLeftAxis() {
        return this.myUseLeftYAxis;
    }

    public Color getGradientColor() {
        return this.myGradientColor;
    }

    public void setArea(Area area) {
        this.myArea = area;
    }

    public Area getArea() {
        return this.myArea;
    }

    public static double getCornerRadius(double columnWidth) {
        if (columnWidth <= 16.0) {
            return 3.0;
        }
        if (columnWidth <= 30.0) {
            return 5.0;
        }
        if (columnWidth <= 44.0) {
            return 6.0;
        }
        return 7.0;
    }
}

