/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisFactory;
import com.nokia.widgets.chart.AxisListener;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.data.CompositeXYSeries;
import com.nokia.widgets.chart.data.DataSetListener;
import com.nokia.widgets.chart.data.XYDataSet;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.impl.GraphLegendCheckBox;
import com.nokia.widgets.chart.impl.GraphModel;
import com.nokia.widgets.chart.impl.GraphView;
import com.nokia.widgets.chart.impl.VerticalLabel;
import com.nokia.widgets.labels.PMultiLineLabel;
import com.nokia.widgets.util.ImageUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class ChartView
extends JPanel
implements Chart,
AxisListener,
PropertyChangeListener,
DataSetListener,
ClipboardOwner,
MouseListener,
MouseMotionListener {
    private Object myChartTitle;
    private AxisModel myChartXAxisModel;
    private AxisModel myChartYLeftAxisModel;
    private AxisModel myChartYRightAxisModel;
    private List<GraphModel> myGraphModels = new ArrayList<GraphModel>();
    private JPanel myLegendPanel;
    private JPanel myLegendCheckBoxPanel;
    private Border myLegendPanelBorder = BorderFactory.createEmptyBorder();
    private GraphView myGraphView;
    private JLabel myXAxisLabel;
    private VerticalLabel myYLeftAxisLabel;
    private VerticalLabel myYRightAxisLabel;
    private Map myChartProperties = new HashMap();
    private boolean myAutomaticRepaintEnabled = true;
    private GraphRenderer myCustomRenderer;
    private List myLegendCheckboxes = new ArrayList();
    private XYDataSet myXyDataSet;
    private GraphRenderer myDataSetRenderer;
    private Set<GraphRenderer> myDataSetRenderers;
    private boolean myUseDataSetLeftAxis = true;
    private HighLightColorLabel myHighLightColorLabel;
    private JPopupMenu myAccessoryFunctionsPopupMenu;
    private boolean myIsZooming;
    private Point myHorizontalZoomStartPoint;
    private Stack<ZoomStackBundle> myZoomStack = new Stack();
    private JPanel myZoomControlPanel;

    public ChartView(Object chartTitle, AxisModel xAxisModel, AxisModel yLeftAxisModel, AxisModel yRightAxisModel, Map chartProperties) {
        super(new GridBagLayout(), true);
        this.myChartTitle = chartTitle;
        this.myChartXAxisModel = xAxisModel;
        this.myChartYLeftAxisModel = yLeftAxisModel;
        this.myChartYRightAxisModel = yRightAxisModel;
        this.myDataSetRenderers = new HashSet<GraphRenderer>();
        this.init();
        if (chartProperties != null) {
            this.setChartProperties(chartProperties);
        }
        this.buildUI();
        if (this.myChartXAxisModel != null) {
            this.myChartXAxisModel.addAxisModelListener(this);
        }
        if (this.myChartYLeftAxisModel != null) {
            this.myChartYLeftAxisModel.addAxisModelListener(this);
        }
        if (this.myChartYRightAxisModel != null) {
            this.myChartYRightAxisModel.addAxisModelListener(this);
        }
        this.addMouseListener(this);
    }

    public ChartView(Object chartTitle, AxisModel xAxisModel, AxisModel yLeftAxisModel, AxisModel yRightAxisModel) {
        this(chartTitle, xAxisModel, yLeftAxisModel, yRightAxisModel, null);
    }

    public void destroy() {
        this.clear();
        this.myGraphView.destroy();
    }

    public void updateAxes(XYDataSet dataSet) {
        XYSeries firstSeries;
        XYPair firstPair;
        XYSeries series;
        if (dataSet.getAllSeries().size() > 0 && (series = dataSet.getAllSeries().get(0)).getXYPairsCount() > 0 && (firstPair = (firstSeries = dataSet.getAllSeries().get(0)).getXYPairs().get(0)) != null) {
            if (firstPair.getY() instanceof Double || firstPair.getY() instanceof Float) {
                this.setAxis(AxisFactory.createDoubleAxis(0, this.myYLeftAxisLabel.getText(), dataSet.getYValues()));
            } else if (firstPair.getY() instanceof Date) {
                this.setAxis(AxisFactory.createDateAxis(0, this.myYLeftAxisLabel.getText(), dataSet.getYValues()));
            } else if (firstPair.getY() instanceof Long) {
                this.setAxis(AxisFactory.createLongAxis(0, this.myYLeftAxisLabel.getText(), dataSet.getYValues()));
            } else {
                this.setAxis(AxisFactory.createAxis(0, this.myYLeftAxisLabel.getText(), dataSet.getYValues()));
            }
            if (firstPair.getX() instanceof Double || firstPair.getX() instanceof Float) {
                this.setAxis(AxisFactory.createDoubleAxis(2, this.myXAxisLabel.getText(), dataSet.getXValues()));
            } else if (firstPair.getX() instanceof Date) {
                this.setAxis(AxisFactory.createDateAxis(2, this.myXAxisLabel.getText(), dataSet.getXValues()));
            } else if (firstPair.getX() instanceof Long) {
                this.setAxis(AxisFactory.createLongAxis(2, this.myXAxisLabel.getText(), dataSet.getXValues()));
            } else {
                this.setAxis(AxisFactory.createAxis(2, this.myXAxisLabel.getText(), dataSet.getXValues()));
            }
        }
    }

    public void setGraphModels(List<GraphModel> graphModels) {
        if (this.myXyDataSet != null) {
            this.myXyDataSet.removeDataSetListener(this);
            this.myXyDataSet = null;
            this.myDataSetRenderer = null;
        }
        this.updateGraphModels(graphModels);
    }

    public void setDataSet(XYDataSet dataSet, boolean useLeftAxis, GraphRenderer renderer, boolean dynamicUpdates) {
        if (this.myXyDataSet != null) {
            this.myXyDataSet.removeDataSetListener(this);
        }
        List<XYSeries> series = dataSet.getAllSeries();
        Iterator<XYSeries> iter = series.iterator();
        ArrayList<GraphModel> graphModels = new ArrayList<GraphModel>();
        while (iter.hasNext()) {
            XYSeries xySeries = iter.next();
            graphModels.add(new GraphModel(xySeries, useLeftAxis, renderer));
        }
        this.updateGraphModels(graphModels);
        this.myXyDataSet = dataSet;
        this.myDataSetRenderer = renderer;
        this.myUseDataSetLeftAxis = useLeftAxis;
        if (dynamicUpdates) {
            this.myXyDataSet.addDataSetListener(this);
        }
    }

    public void setDataSet(XYDataSet dataSet, boolean useLeftAxis, boolean dynamicUpdates) {
        if (this.myXyDataSet != null) {
            this.myXyDataSet.removeDataSetListener(this);
        }
        List<XYSeries> series = dataSet.getAllSeries();
        Iterator<XYSeries> iter = series.iterator();
        ArrayList<GraphModel> graphModels = new ArrayList<GraphModel>();
        while (iter.hasNext()) {
            XYSeries next = iter.next();
            if (!(next instanceof CompositeXYSeries)) continue;
            CompositeXYSeries xySeries = (CompositeXYSeries)next;
            graphModels.add(new GraphModel(xySeries, useLeftAxis, xySeries.getRenderer()));
        }
        this.updateGraphModels(graphModels);
        this.myXyDataSet = dataSet;
        this.myUseDataSetLeftAxis = useLeftAxis;
        if (dynamicUpdates) {
            this.myXyDataSet.addDataSetListener(this);
        }
    }

    public void addGraphModel(GraphModel graphModel) {
        graphModel.getGraphRenderer().init(this);
        this.myGraphModels.add(graphModel);
        this.updateLegendCheckBoxes();
        this.myGraphView.repaint();
        if (this.myXyDataSet != null) {
            this.myXyDataSet.add(graphModel.toSeries());
        }
    }

    public void removeGraphModel(String name) {
        for (GraphModel model : this.myGraphModels) {
            if (!model.getGraphName().equals(name)) continue;
            this.myGraphModels.remove(model);
            break;
        }
        this.updateLegendCheckBoxes();
        this.myGraphView.repaint();
    }

    public void setXAxisModel(AxisModel axisModel) {
        this.myChartXAxisModel = axisModel;
        if (this.myChartXAxisModel != null) {
            this.myXAxisLabel.setText(this.myChartXAxisModel.getLabel());
        } else {
            this.myXAxisLabel.setText("");
        }
        this.myGraphView.setXAxisModel(this.myChartXAxisModel);
    }

    public void setYLeftAxisModel(AxisModel axisModel) {
        this.myChartYLeftAxisModel = axisModel;
        if (this.myChartYLeftAxisModel != null) {
            this.myYLeftAxisLabel.setText(this.myChartYLeftAxisModel.getLabel());
        } else {
            this.myYLeftAxisLabel.setText("");
        }
        this.myGraphView.setYLeftAxisModel(this.myChartYLeftAxisModel);
    }

    public void setYRightAxisModel(AxisModel axisModel) {
        this.myChartYRightAxisModel = axisModel;
        if (this.myChartYRightAxisModel != null) {
            this.myYRightAxisLabel.setText(this.myChartYRightAxisModel.getLabel());
        } else {
            this.myYRightAxisLabel.setText("");
        }
        this.myGraphView.setYRightAxisModel(this.myChartYRightAxisModel);
    }

    public void setCustomRenderer(GraphRenderer renderer) {
        this.myCustomRenderer = renderer;
    }

    public GraphRenderer getCustomRenderer() {
        return this.myCustomRenderer;
    }

    public List<GraphModel> getGraphModels() {
        return this.myGraphModels;
    }

    public void setChartProperties(Map chartProperties) {
        this.myChartProperties.putAll(chartProperties);
    }

    public Object getChartProperty(Object chartPropertyKey) {
        return this.myChartProperties.get(chartPropertyKey);
    }

    public void setGraphPaintingEnabled(boolean enabled) {
        this.myGraphView.setGraphPaintingEnabled(enabled);
        if (enabled) {
            this.myGraphView.repaint();
        }
    }

    public AccessibleContext getGraphViewAccessibleContext() {
        return this.myGraphView == null ? null : this.myGraphView.getAccessibleContext();
    }

    public void setEditingEnabled(boolean enabled) {
        int i = 0;
        while (i < this.myLegendCheckBoxPanel.getComponents().length) {
            Component comp = this.myLegendCheckBoxPanel.getComponents()[i];
            if (comp instanceof GraphLegendCheckBox) {
                ((GraphLegendCheckBox)comp).setEditingEnabled(enabled);
            }
            ++i;
        }
    }

    public void handleLegendCheckBoxClick() {
        this.myGraphView.repaint();
    }

    public void rebuildUI() {
        if (this.myAutomaticRepaintEnabled) {
            this.removeAll();
            this.buildUI();
            this.updateLegendCheckBoxes();
            this.myGraphView.repaint();
            this.repaint();
        }
    }

    protected void updateLegendCheckBoxes() {
        if (this.myGraphModels.isEmpty() || !((Boolean)this.myChartProperties.get("showlegend")).booleanValue()) {
            this.myLegendPanel.setBorder(null);
            this.myLegendCheckBoxPanel.setVisible(false);
            this.myLegendPanel.setVisible(false);
        } else {
            int i = 0;
            while (i < this.myLegendCheckBoxPanel.getComponentCount()) {
                GraphLegendCheckBox legendCheckBox = (GraphLegendCheckBox)this.myLegendCheckBoxPanel.getComponent(i);
                legendCheckBox.destroy();
                ++i;
            }
            this.myLegendCheckBoxPanel.removeAll();
            this.createLegendCheckBoxes();
            if (((Boolean)this.myChartProperties.get("legendboxshowborder")).booleanValue()) {
                this.myLegendPanel.setBorder(this.myLegendPanelBorder);
            }
            this.myLegendCheckBoxPanel.setVisible(true);
            this.myLegendPanel.setVisible(true);
            this.myLegendPanel.revalidate();
            this.myLegendPanel.repaint();
        }
    }

    protected void updateGraphModels(List<GraphModel> graphModels) {
        this.myGraphModels.clear();
        this.myDataSetRenderers.clear();
        this.myGraphModels.addAll(graphModels);
        this.myXyDataSet = new XYDataSet();
        int i = 0;
        while (i < this.myGraphModels.size()) {
            this.myGraphModels.get(i).getGraphRenderer().init(this);
            this.myDataSetRenderers.add(this.myGraphModels.get(i).getGraphRenderer());
            this.myXyDataSet.add(this.myGraphModels.get(i).toSeries());
            ++i;
        }
        this.updateLegendCheckBoxes();
        this.myGraphView.repaint();
    }

    private void init() {
        this.myChartProperties.put("titlefont", ChartConstants.DEFAUT_CHART_TITLE_FONT);
        this.myChartProperties.put("titletextcolor", ChartConstants.DEFAULT_CHART_TITLE_LABEL_COLOR);
        this.myChartProperties.put("axisfont", ChartConstants.DEFAULT_CHART_AXIS_LABEL_FONT);
        this.myChartProperties.put("axisvaluefont", ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_FONT);
        this.myChartProperties.put("axisvaluetextcolor", ChartConstants.DEFAULT_CHART_AXIS_LABEL_COLOR);
        this.myChartProperties.put("chartbackgroundcolor", ChartConstants.DEFAULT_CHART_BACKGROUND_COLOR);
        this.myChartProperties.put("axiscolor", ChartConstants.DEFAULT_CHART_AXIS_COLOR);
        this.myChartProperties.put("bordercolor", ChartConstants.DEFAULT_GRAPH_BORDER_COLOR);
        this.myChartProperties.put("columnwidthpct", ChartConstants.DEFAULT_CHART_COLUMN_WIDTH_PCT);
        this.myChartProperties.put("gradientpaint", Boolean.TRUE);
        this.myChartProperties.put("valuemarker", ChartConstants.DEFAULT_GRAPH_VALUE_MARKER_SIZE);
        this.myChartProperties.put("thresholdmarker", ChartConstants.DEFAULT_GRAPH_VALUE_OVER_THRESHOLD_MARKER_SIZE);
        this.myChartProperties.put("gridcolor", ChartConstants.DEFAULT_GRAPH_AREA_GRID_COLOR);
        this.myChartProperties.put("graphtooltip", ChartConstants.DEFAULT_GRAPH_SHOW_VALUE_TOOLTIP);
        this.myChartProperties.put("graphnotetooltip", ChartConstants.DEFAULT_GRAPH_SHOW_VALUE_NOTE_TOOLTIP);
        this.myChartProperties.put("hidexaxis", false);
        this.myChartProperties.put("hideyaxis", false);
        this.myChartProperties.put("graphvaluepointlabel", ChartConstants.DEFAULT_GRAPH_SHOW_STATIC_VALUE_POINT_LABEL);
        this.myChartProperties.put("graphvaluepointlabelmodel", ChartConstants.DEFAULT_GRAPH_STATIC_VALUE_POINT_LABEL_MODEL);
        this.myChartProperties.put("graphvaluepointlabelrenderer", ChartConstants.DEFAULT_GRAPH_STATIC_VALUE_POINT_LABEL_RENDERER);
        this.myChartProperties.put("longlineforlabel", ChartConstants.DEFAULT_CHART_LONG_VALUE_LINE_FOR_LABEL);
        this.myChartProperties.put("showlegend", ChartConstants.DEFAULT_CHART_SHOW_LEGEND);
        this.myChartProperties.put("showxaxis", ChartConstants.DEFAULT_CHART_SHOW_XAXIS);
        this.myChartProperties.put("showleftyaxis", ChartConstants.DEFAULT_CHART_SHOW_LEFT_YAXIS);
        this.myChartProperties.put("showrightyaxis", ChartConstants.DEFAULT_CHART_SHOW_RIGHT_YAXIS);
        this.myChartProperties.put("valuetextalign", ChartConstants.DEFAULT_VALUE_LABEL_ORIENTATION);
        this.myChartProperties.put("graphbackgroundcolor", ChartConstants.DEFAULT_GRAPH_BACKGROUND_COLOR);
        this.myChartProperties.put("gridvisibility", 1);
        this.myChartProperties.put("firstseriesontopleftcorner", ChartConstants.DEFAULT_CHART_LEGEND_BOX_FIRST_SERIES_ON_TOP_LEFT_CORNER);
        this.myChartProperties.put("valuelinelengthkey", ChartConstants.DEFAULT_GRAPH_AXIS_VALUE_LINE_LENGTH);
        this.myChartProperties.put("spaceonaxisend", ChartConstants.DEFAULT_GRAPH_SPACE_ON_HORIZONTAL_AXIS_ENDS);
        this.myChartProperties.put("spaceamount", ChartConstants.DEFAULT_GRAPH_HORIZONTAL_AXIS_SPACE_AMOUNT);
        this.myChartProperties.put("legendboxshowcheckbox", ChartConstants.DEFAULT_CHART_LEGEND_BOX_SHOW_CHECKBOX);
        this.myChartProperties.put("legendboxshowborder", ChartConstants.DEFAULT_CHART_LEGEND_BOX_SHOW_BORDER);
        this.myChartProperties.put("showpielabel", ChartConstants.DEFAULT_PIE_CHART_SHOW_PIE_LABEL);
        this.myChartProperties.put("linewidth", ChartConstants.DEFAULT_GRAPH_LINE_WIDTH);
        this.myChartProperties.put("Location", "South");
        this.myChartProperties.put("ChartHighLightColor", ChartConstants.DEFAULT_CHART_HIGHLIGHT_COLOR);
        this.myChartProperties.put("ShowHighLight", ChartConstants.DEFAULT_CHART_SHOW_HIGHLIGHT);
        this.myChartProperties.put("HighLightToolTipKey", "Volatile Data");
        this.myChartProperties.put("showValueMarkers", true);
        this.myChartProperties.put("showVerticalAxisLabels", true);
        this.myChartProperties.put("AllowZoom", ChartConstants.DEFAULT_CHART_ALLOW_HORIZONTAL_ZOOM);
        this.myChartProperties.put("ZoomBoundingBoxColor", ChartConstants.DEFAULT_CHART_ZOOM_BOUNDING_BOX_COLOR);
        this.myChartProperties.put("chartMargin", new Insets(12, 12, 12, 12));
        this.myChartProperties.put("legendboxbackground", Color.WHITE);
        this.myChartProperties.put("HighlighType", "FilledRectangle");
        this.myChartProperties.put("ShowHighlightLegend", true);
        this.myChartProperties.put("sparkline", false);
    }

    private void buildUI() {
        Color backgroundColor = (Color)this.getChartProperty("chartbackgroundcolor");
        Insets margin = (Insets)this.getChartProperty("chartMargin");
        JPanel highLightDescriptionPanel = new JPanel();
        highLightDescriptionPanel.setOpaque(false);
        highLightDescriptionPanel.setLayout(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.gridx = 0;
        cc.gridy = 0;
        cc.insets = new Insets(0, 10, 0, 10);
        cc.anchor = 17;
        this.myHighLightColorLabel = new HighLightColorLabel(25, 25, (Color)this.getChartProperty("ChartHighLightColor"));
        PMultiLineLabel txt = new PMultiLineLabel((String)this.getChartProperty("ChartHighLightDescription"));
        this.myHighLightColorLabel.setMinimumSize(new Dimension(20, 20));
        highLightDescriptionPanel.setBackground(Color.WHITE);
        highLightDescriptionPanel.add((Component)this.myHighLightColorLabel, cc);
        ++cc.gridx;
        cc.weightx = 0.9;
        cc.fill = 2;
        highLightDescriptionPanel.add((Component)txt, cc);
        this.myLegendPanel = new JPanel(new GridBagLayout());
        this.myLegendPanel.setBackground(backgroundColor);
        this.myLegendCheckBoxPanel = new JPanel(new GridBagLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Object oldAa = NetUtils.antiAliasingOn(g);
                Color legendAreaBackground = (Color)ChartView.this.getChartProperty("legendboxbackground");
                if (legendAreaBackground != null) {
                    g.setColor(legendAreaBackground);
                    g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 10, 10);
                    g.setColor(UIManager.getColor("Panel.headerPanelOutline"));
                    g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
                }
                NetUtils.setAntialiasing(g, oldAa);
            }
        };
        this.myLegendCheckBoxPanel.setBackground(backgroundColor);
        if (Boolean.TRUE.equals(this.getProperty("legendboxshowborder"))) {
            this.myLegendCheckBoxPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 4, 12));
        } else {
            this.myLegendCheckBoxPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        this.myLegendPanel.add((Component)this.myLegendCheckBoxPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        String myLocation = (String)this.getChartProperty("Location");
        int xOffSet = 0;
        int yOffSet = 0;
        if ("East".compareTo(myLocation) == 0) {
            this.add((Component)this.myLegendPanel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, margin.right), 0, 0));
        } else if ("West".compareTo(myLocation) == 0) {
            this.add((Component)this.myLegendPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, margin.left, 0, 0), 0, 0));
            xOffSet = 1;
        } else if ("North".compareTo(myLocation) == 0) {
            this.add((Component)this.myLegendPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
            yOffSet = 1;
        } else if ("NorthEast".compareTo(myLocation) == 0) {
            int anchor = this.myZoomStack.isEmpty() ? 13 : 15;
            this.add((Component)this.myLegendPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, anchor, 0, new Insets(0, 0, 0, margin.right), 0, 0));
            yOffSet = 1;
        } else {
            this.add((Component)this.myLegendPanel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, margin.bottom, 0), 0, 0));
        }
        this.setBackground(backgroundColor);
        this.buildTitle(margin, xOffSet, yOffSet);
        if (Boolean.valueOf((Boolean)this.getChartProperty("ShowHighLight")).booleanValue() && Boolean.valueOf((Boolean)this.getChartProperty("ShowHighlightLegend")).booleanValue() && this.myChartXAxisModel.getHighLightedData() != null && this.myChartXAxisModel.getHighLightedData().size() > 0) {
            Color highlightCol = (Color)this.getChartProperty("ChartHighLightColor");
            this.myHighLightColorLabel.myColor = highlightCol;
            this.add((Component)highLightDescriptionPanel, new GridBagConstraints(0 + xOffSet, 1 + yOffSet, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (((Boolean)this.getChartProperty("AllowZoom")).booleanValue() && !this.myZoomStack.isEmpty()) {
            this.myZoomControlPanel = this.createZoomControlPanel();
            this.add((Component)this.myZoomControlPanel, new GridBagConstraints(1 + xOffSet, 1 + yOffSet, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myGraphView = new GraphView(this, this.myChartXAxisModel, this.myChartYLeftAxisModel, this.myChartYRightAxisModel);
        this.add((Component)this.myGraphView, new GridBagConstraints(1 + xOffSet, 2 + yOffSet, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myGraphView.addMouseMotionListener(this);
        this.buildLeftYAxisLabel(margin, xOffSet, yOffSet);
        this.buildRightYAxisLabel(margin, xOffSet, yOffSet);
        this.buildXAxisLabel(margin, xOffSet, yOffSet);
        this.updateTitleFonts();
    }

    protected void buildTitle(Insets margin, int xOffSet, int yOffSet) {
        int titleBottomMargin;
        int n = titleBottomMargin = this.myLegendPanel.isVisible() ? 0 : 12;
        if (this.myChartTitle instanceof String) {
            this.myChartTitle = new JLabel((String)this.myChartTitle);
            ((JLabel)this.myChartTitle).setForeground(new Color(0, 0, 102));
            this.add((Component)((JLabel)this.myChartTitle), new GridBagConstraints(0 + xOffSet, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(margin.top, margin.left, titleBottomMargin, 0), 0, 0));
        } else if (this.myChartTitle instanceof Component) {
            this.add((Component)this.myChartTitle, new GridBagConstraints(0 + xOffSet, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(margin.top, margin.left, titleBottomMargin, 0), 0, 0));
        }
    }

    protected void buildXAxisLabel(Insets margin, int xOffSet, int yOffSet) {
        this.myXAxisLabel = this.myChartXAxisModel != null && (Boolean)this.getChartProperty("hidexaxis") == false ? new JLabel(this.myChartXAxisModel.getLabel()) : new JLabel("");
        this.add((Component)this.myXAxisLabel, new GridBagConstraints(1 + xOffSet, 3 + yOffSet, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, margin.bottom, 0), 0, 0));
    }

    protected void buildRightYAxisLabel(Insets margin, int xOffSet, int yOffSet) {
        this.myYRightAxisLabel = this.myChartYRightAxisModel != null ? new VerticalLabel(this.myChartYRightAxisModel.getLabel(), false, this) : new VerticalLabel("", false, this);
        this.add((Component)this.myYRightAxisLabel, new GridBagConstraints(2 + xOffSet, 2 + yOffSet, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, margin.right), 0, 0));
    }

    protected void buildLeftYAxisLabel(Insets margin, int xOffSet, int yOffSet) {
        this.myYLeftAxisLabel = this.myChartYLeftAxisModel != null && (Boolean)this.getChartProperty("hideyaxis") == false ? new VerticalLabel(this.myChartYLeftAxisModel.getLabel(), false, this) : new VerticalLabel("", false, this);
        this.add((Component)this.myYLeftAxisLabel, new GridBagConstraints(0 + xOffSet, 2 + yOffSet, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, margin.left, 0, 0), 0, 0));
    }

    private void updateTitleFonts() {
        if (this.myChartTitle instanceof Component) {
            Font titleFont = (Font)this.getChartProperty("titlefont");
            int titleFontSize = titleFont.getSize() + NetLookAndFeel.getFontSizeIncrement();
            titleFont = titleFont.deriveFont((float)titleFontSize);
            ((Component)this.myChartTitle).setForeground((Color)this.getChartProperty("titletextcolor"));
            ((Component)this.myChartTitle).setFont(titleFont);
        }
        Font axisLabelFont = (Font)this.getChartProperty("axisfont");
        int axisFontSize = axisLabelFont.getSize() + NetLookAndFeel.getFontSizeIncrement();
        axisLabelFont = axisLabelFont.deriveFont((float)axisFontSize);
        Color labelTextColor = (Color)this.getChartProperty("axisvaluetextcolor");
        this.myXAxisLabel.setForeground(labelTextColor);
        this.myYLeftAxisLabel.setForeground(labelTextColor);
        this.myYRightAxisLabel.setForeground(labelTextColor);
        this.myXAxisLabel.setFont(axisLabelFont);
        this.myYLeftAxisLabel.setFont(axisLabelFont);
        this.myYRightAxisLabel.setFont(axisLabelFont);
    }

    private void createLegendCheckBoxes() {
        int rowCount;
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 8), 0, 0);
        int columnCount = ChartConstants.DEFAULT_CHART_LEGEND_BOX_COLUMN_COUNT;
        if (this.myChartProperties.get("legendboxcolumncount") != null) {
            columnCount = (Integer)this.myChartProperties.get("legendboxcolumncount");
        } else if (this.myGraphModels.size() > 8) {
            int optimalCount = this.myGraphModels.size() / 4 + 1;
            columnCount = optimalCount <= 4 ? optimalCount : columnCount;
        }
        ArrayList<GraphModel> modelList = new ArrayList<GraphModel>(this.myGraphModels);
        int size = modelList.size();
        int n = rowCount = size % columnCount == 0 ? size / columnCount : size / columnCount + 1;
        if (!((Boolean)this.myChartProperties.get("firstseriesontopleftcorner")).booleanValue()) {
            Collections.reverse(modelList);
        }
        this.myLegendCheckboxes.clear();
        int i = 0;
        while (i < modelList.size()) {
            GraphModel model = (GraphModel)modelList.get(i);
            GraphLegendCheckBox legendCheckBox = new GraphLegendCheckBox(this, model);
            legendCheckBox.setToolTipText(model.getToolTipText());
            this.myLegendCheckboxes.add(legendCheckBox);
            this.myLegendCheckBoxPanel.add((Component)legendCheckBox, gbc);
            ++gbc.gridy;
            gbc.insets = gbc.gridx == columnCount - 1 ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 0, 8);
            if (gbc.gridy == rowCount) {
                gbc.gridy = 0;
                ++gbc.gridx;
            }
            ++i;
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        Object oldValue = this.myChartProperties.get(key);
        if (oldValue == null || !oldValue.equals(value)) {
            this.myChartProperties.put(key, value);
            this.rebuildUI();
        }
    }

    @Override
    public JPanel getView() {
        return this;
    }

    public Map getProperties() {
        return this.myChartProperties;
    }

    @Override
    public void setAxis(Axis axis) {
        int type = axis.getType();
        if (type == 2) {
            this.myChartXAxisModel = (AxisModel)axis;
        } else if (type == 0) {
            this.myChartYLeftAxisModel = (AxisModel)axis;
        } else if (type == 1) {
            this.myChartYRightAxisModel = (AxisModel)axis;
        }
        this.rebuildUI();
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperties().get(key);
    }

    @Override
    public void setAutomaticRepaintEnabled(boolean enabled) {
        boolean prevValue = this.myAutomaticRepaintEnabled;
        this.myAutomaticRepaintEnabled = enabled;
        if (enabled && !prevValue) {
            this.rebuildUI();
        }
    }

    @Override
    public Axis getAxis(int type) {
        if (type == 2) {
            return this.myChartXAxisModel;
        }
        if (type == 0) {
            return this.myChartYLeftAxisModel;
        }
        if (type == 1) {
            return this.myChartYRightAxisModel;
        }
        return null;
    }

    @Override
    public void exportToPNG(final String fileName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ChartView.this.exportToPNG(fileName);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            try {
                ImageIO.write((RenderedImage)((BufferedImage)this.getImage()), "png", new File(fileName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Image getImage() {
        Dimension size = this.getSize();
        if (size.width == 0) {
            size = this.getPreferredSize();
            this.setSize(size);
            this.doLayout();
        }
        boolean originalOpaqueValue = this.isOpaque();
        this.setOpaque(true);
        BufferedImage image = ImageUtils.createCompatibleOpaqueImage(size.width, size.height);
        Graphics2D g2d = image.createGraphics();
        g2d.setClip(new Rectangle(0, 0, size.width, size.height));
        this.paint(g2d);
        g2d.dispose();
        this.setOpaque(originalOpaqueValue);
        return image;
    }

    @Override
    public Color getBackground() {
        return super.getBackground() != null ? super.getBackground() : NetUtils.decodeColor("#EBEBEB");
    }

    @Override
    public void clear() {
        this.myGraphModels.clear();
        int i = 0;
        while (i < this.myLegendCheckBoxPanel.getComponentCount()) {
            GraphLegendCheckBox legendCheckBox = (GraphLegendCheckBox)this.myLegendCheckBoxPanel.getComponent(i);
            legendCheckBox.destroy();
            ++i;
        }
        this.myLegendCheckBoxPanel.removeAll();
        if (this.myChartXAxisModel != null) {
            this.myChartXAxisModel.removeAxisModelListener(this);
        }
        if (this.myChartYLeftAxisModel != null) {
            this.myChartYLeftAxisModel.removeAxisModelListener(this);
        }
        if (this.myChartYRightAxisModel != null) {
            this.myChartYRightAxisModel.removeAxisModelListener(this);
        }
        if (this.myXyDataSet != null) {
            this.myXyDataSet.removeDataSetListener(this);
            this.myXyDataSet = null;
            this.myDataSetRenderer = null;
            this.myDataSetRenderers.clear();
        }
        this.myGraphView.clear();
    }

    @Override
    public void setTitle(Object title) {
        this.myChartTitle = title;
        this.rebuildUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("fontSizeIncrement".equals(evt.getPropertyName())) {
            int i = 0;
            while (i < this.myLegendCheckboxes.size()) {
                ((GraphLegendCheckBox)this.myLegendCheckboxes.get(i)).updateLegendTextFont();
                ++i;
            }
            this.updateTitleFonts();
            this.myGraphView.updateValueLabelFont();
            this.myGraphView.repaint();
        }
    }

    @Override
    public void axisUpdated(Axis axis) {
        this.rebuildUI();
    }

    @Override
    public void seriesAdded(XYDataSet dataSet, XYSeries series) {
        this.addGraphModel(new GraphModel(series, this.myUseDataSetLeftAxis, this.myDataSetRenderer));
        this.updateAxes(dataSet);
    }

    @Override
    public void seriesRemoved(XYDataSet dataSet, XYSeries series) {
        this.removeGraphModel(series.getName());
        this.updateAxes(dataSet);
    }

    @Override
    public void seriesUpdated(XYDataSet dataSet, XYSeries series) {
        GraphModel graphModel = null;
        int i = 0;
        while (i < this.myGraphModels.size()) {
            if (this.myGraphModels.get(i).getGraphName().equals(series.getName())) {
                this.myGraphModels.remove(i);
                graphModel = series instanceof CompositeXYSeries ? new GraphModel(series, this.myUseDataSetLeftAxis, ((CompositeXYSeries)series).getRenderer()) : new GraphModel(series, this.myUseDataSetLeftAxis, this.myDataSetRenderer);
                this.myGraphModels.add(i, graphModel);
                break;
            }
            ++i;
        }
        if (graphModel != null) {
            graphModel.getGraphRenderer().init(this);
        }
        this.updateLegendCheckBoxes();
        this.updateAxes(dataSet);
        this.myGraphView.repaint();
    }

    @Override
    public void copyDataToClipboard() {
        String EOL = System.getProperty("line.separator");
        int TAB_SEPARATOR = 9;
        List<XYSeries> series = this.myXyDataSet.getAllSeries();
        StringBuffer fr = new StringBuffer();
        fr.append(String.valueOf(this.myChartYLeftAxisModel.getLabel()) + '\t');
        int x = 0;
        while (x < series.size()) {
            fr.append(series.get(x).getName());
            if (x < series.size() - 1) {
                fr.append('\t');
            }
            ++x;
        }
        fr.append(EOL);
        int y = 0;
        while (y < series.get(0).getXYPairsCount()) {
            int x2 = 0;
            while (x2 < series.size() + 1) {
                if (x2 == 0) {
                    fr.append(this.myXyDataSet.getAllSeries().get(0).getXYPairs().get(y).getX().toString());
                } else {
                    fr.append(this.myXyDataSet.getAllSeries().get(x2 - 1).getXYPairs().get(y).getY().toString());
                }
                if (x2 == series.size()) {
                    fr.append(EOL);
                } else {
                    fr.append('\t');
                }
                ++x2;
            }
            StringSelection sel = new StringSelection(fr.toString());
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(sel, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++y;
        }
    }

    @Override
    public void saveDataToFile(String defaultPath) {
        String EOL = System.getProperty("line.separator");
        JFileChooser f = defaultPath == null ? new JFileChooser() : new JFileChooser(defaultPath);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return ".csv files";
            }
        };
        f.setFileFilter(fileFilter);
        int retval = f.showSaveDialog(this);
        if (retval == 0) {
            File file = f.getSelectedFile();
            if (f.getFileFilter() == fileFilter && f.getSelectedFile().toString().lastIndexOf(46) == -1) {
                file = new File(String.valueOf(f.getSelectedFile().getPath()) + ".csv");
            }
            Vector<Object> xAxisData = new Vector<Object>();
            int x = 0;
            while (x < this.myXyDataSet.getSeriesCount()) {
                List<Object> xVals = this.myXyDataSet.getAllSeries().get(x).getXValues();
                int y = 0;
                while (y < xVals.size()) {
                    if (!xAxisData.contains(xVals.get(y))) {
                        xAxisData.add(xVals.get(y));
                    }
                    ++y;
                }
                ++x;
            }
            int totalSeriesAmount = this.myXyDataSet.getSeriesCount();
            int xAxisDataAmount = xAxisData.size();
            Object[][] finalArray = new Object[totalSeriesAmount][xAxisDataAmount];
            int x2 = 0;
            while (x2 < xAxisData.size()) {
                int y = 0;
                while (y < this.myXyDataSet.getSeriesCount()) {
                    List<XYPair> pairs = this.myXyDataSet.getAllSeries().get(y).getXYPairs();
                    int z = 0;
                    while (z < pairs.size()) {
                        if (pairs.get(z).getX().equals(xAxisData.get(x2))) {
                            finalArray[y][x2] = pairs.get(z).getY();
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x2;
            }
            try {
                FileWriter fr = new FileWriter(file);
                List<XYSeries> series = this.myXyDataSet.getAllSeries();
                fr.write(String.valueOf(this.myChartYLeftAxisModel.getLabel()) + ',');
                int x3 = 0;
                while (x3 < series.size()) {
                    fr.write(series.get(x3).getName());
                    if (x3 < series.size() - 1) {
                        fr.write(44);
                    }
                    ++x3;
                }
                fr.write(EOL);
                int y = 0;
                while (y < xAxisDataAmount) {
                    int x4 = 0;
                    while (x4 < totalSeriesAmount + 1) {
                        if (x4 != 0) {
                            if (finalArray[x4 - 1][y] != null) {
                                fr.write(finalArray[x4 - 1][y].toString());
                            }
                        } else {
                            fr.write(xAxisData.get(y).toString());
                        }
                        if (x4 == totalSeriesAmount) {
                            fr.write(EOL);
                        } else {
                            fr.write(44);
                        }
                        ++x4;
                    }
                    ++y;
                }
                fr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void saveDataToFile() {
        this.saveDataToFile(null);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.getProperty("AllowAccessoryMouseFunctions") != null && ((Boolean)this.getProperty("AllowAccessoryMouseFunctions")).booleanValue()) {
            if (evt.getButton() == 3) {
                if (this.myAccessoryFunctionsPopupMenu == null) {
                    this.myAccessoryFunctionsPopupMenu = new JPopupMenu();
                    JMenuItem saveToFile = new JMenuItem("Save data to file..");
                    JMenuItem copyToClipboard = new JMenuItem("Copy data to clipboard");
                    saveToFile.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChartView.this.myAccessoryFunctionsPopupMenu.setVisible(false);
                            ChartView.this.saveDataToFile();
                        }
                    });
                    copyToClipboard.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChartView.this.myAccessoryFunctionsPopupMenu.setVisible(false);
                            ChartView.this.copyDataToClipboard();
                        }
                    });
                    this.myAccessoryFunctionsPopupMenu.add(saveToFile);
                    this.myAccessoryFunctionsPopupMenu.add(copyToClipboard);
                    JMenuItem exportAsPng = new JMenuItem("Save chart as png..");
                    exportAsPng.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChartView.this.myAccessoryFunctionsPopupMenu.setVisible(false);
                            JFileChooser f = new JFileChooser();
                            String path = null;
                            if (f.showSaveDialog(null) == 0) {
                                path = f.getSelectedFile().getPath();
                                ChartView.this.exportToPNG(path);
                            }
                        }
                    });
                    this.myAccessoryFunctionsPopupMenu.add(exportAsPng);
                }
                Point p = evt.getComponent().getLocationOnScreen();
                p.x += evt.getX();
                p.y += evt.getY();
                this.myAccessoryFunctionsPopupMenu.setLocation(p);
                this.myAccessoryFunctionsPopupMenu.setVisible(true);
            } else if (this.myAccessoryFunctionsPopupMenu != null) {
                this.myAccessoryFunctionsPopupMenu.setVisible(false);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.myDataSetRenderer instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.myDataSetRenderer)).mouseMoved(e);
        }
        for (GraphRenderer renderer : this.myDataSetRenderers) {
            if (!(renderer instanceof MouseMotionListener)) continue;
            ((MouseMotionListener)((Object)renderer)).mouseMoved(e);
        }
        this.myGraphView.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (((Boolean)this.getProperty("AllowZoom")).booleanValue() && e.getComponent() == this.myGraphView && e.getButton() == 1 && this.myIsZooming) {
            this.horizontalZoomIn(e);
        }
    }

    private ZoomRange createHorizontalZoomRange(Object axisMin, Object axisMax, MouseEvent e) {
        Object upperLimitValue = null;
        Object lowerLimitValue = null;
        Object prevValue = null;
        for (Object value : this.myXyDataSet.getXValues()) {
            double valuePosition = this.myGraphView.getXAxisPositionForValue(value);
            if (valuePosition >= (double)e.getX() && upperLimitValue == null) {
                upperLimitValue = value;
            }
            if (valuePosition >= (double)this.myHorizontalZoomStartPoint.x && lowerLimitValue == null) {
                lowerLimitValue = prevValue;
            }
            prevValue = value;
        }
        upperLimitValue = upperLimitValue == null ? axisMax : upperLimitValue;
        Object object = lowerLimitValue = lowerLimitValue == null ? axisMin : lowerLimitValue;
        if (lowerLimitValue instanceof Comparable && upperLimitValue instanceof Comparable && ((Comparable)upperLimitValue).compareTo(lowerLimitValue) <= 0) {
            return new ZoomRange(null, null);
        }
        return new ZoomRange(lowerLimitValue, upperLimitValue);
    }

    private void horizontalZoomIn(MouseEvent e) {
        Object axisMax;
        this.myIsZooming = false;
        Object axisMin = this.myChartXAxisModel.getValues().get(0);
        ZoomRange zoomRange = this.createHorizontalZoomRange(axisMin, axisMax = this.myChartXAxisModel.getValues().get(this.myChartXAxisModel.getValues().size() - 1), e);
        if (!zoomRange.isValid()) {
            return;
        }
        if (zoomRange.getMin() != axisMin || zoomRange.getMax() != axisMax) {
            List<XYSeries> currentSeries = this.myXyDataSet.getAllSeries();
            ArrayList<XYSeries> currentSeriesCopy = new ArrayList<XYSeries>();
            ArrayList<XYSeries> zoomedSeriesList = new ArrayList<XYSeries>();
            for (XYSeries series : currentSeries) {
                int sliceStart = series.getXValues().indexOf(zoomRange.getMin());
                int sliceEnd = series.getXValues().indexOf(zoomRange.getMax()) + 1;
                XYSeries zoomedSeries = null;
                XYSeries seriesCopy = null;
                if (series instanceof CompositeXYSeries) {
                    CompositeXYSeries compositeSeries = (CompositeXYSeries)series;
                    zoomedSeries = new CompositeXYSeries(compositeSeries, compositeSeries.getRenderer());
                    zoomedSeries.setColor(compositeSeries.getColor());
                    zoomedSeries.setValues(compositeSeries.getXValues().subList(sliceStart, sliceEnd), compositeSeries.getYValues().subList(sliceStart, sliceEnd));
                    seriesCopy = new CompositeXYSeries(compositeSeries, compositeSeries.getRenderer());
                    seriesCopy.setColor(compositeSeries.getColor());
                    seriesCopy.setValues(compositeSeries.getXValues(), compositeSeries.getYValues());
                } else {
                    zoomedSeries = XYSeries.create(series.getName(), series.getColor(), series.getXValues().subList(sliceStart, sliceEnd), series.getYValues().subList(sliceStart, sliceEnd));
                    seriesCopy = XYSeries.create(series.getName(), series.getColor(), series.getXValues(), series.getYValues());
                }
                zoomedSeries.setThresholdValue(series.getThresholdValue());
                zoomedSeriesList.add(zoomedSeries);
                currentSeriesCopy.add(seriesCopy);
            }
            List<AxisModel.ChartDataArea> zoomedHighlightAreas = this.getZoomedDataAreas(zoomRange.getMin(), zoomRange.getMax(), this.myChartXAxisModel.getHighLightedData());
            List<AxisModel.ChartDataArea> zoomedMissingDataAreas = this.getZoomedDataAreas(zoomRange.getMin(), zoomRange.getMax(), this.myChartXAxisModel.getMissingData());
            ZoomStackBundle zoomObj = new ZoomStackBundle(this.myXyDataSet, this.myChartXAxisModel.getHighLightedData(), this.myChartXAxisModel.getMissingData());
            this.myZoomStack.push(zoomObj);
            this.setZoomedDataSet(zoomedSeriesList);
            this.markZoomedDataAreas(zoomedHighlightAreas, zoomedMissingDataAreas);
            this.rebuildUI();
        }
    }

    private void setZoomedDataSet(List<XYSeries> zoomedSeriesList) {
        XYSeries[] zoomedSeries = new XYSeries[zoomedSeriesList.size()];
        XYDataSet zoomedSet = new XYDataSet(zoomedSeriesList.toArray(zoomedSeries));
        if (zoomedSeriesList.get(0) instanceof CompositeXYSeries) {
            this.setDataSet(zoomedSet, this.myUseDataSetLeftAxis, this.myAutomaticRepaintEnabled);
            this.updateAxes(zoomedSet);
        } else {
            this.setDataSet(zoomedSet, this.myUseDataSetLeftAxis, this.myDataSetRenderer, this.myAutomaticRepaintEnabled);
            this.updateAxes(zoomedSet);
        }
    }

    private void markZoomedDataAreas(List<AxisModel.ChartDataArea> highlightAreas, List<AxisModel.ChartDataArea> missingAreas) {
        AxisModel.ChartDataArea area;
        if (!missingAreas.isEmpty()) {
            for (AxisModel.ChartDataArea missingArea : missingAreas) {
                if (!(missingArea instanceof AxisModel.MissingDataArea)) continue;
                area = (AxisModel.MissingDataArea)missingArea;
                this.myChartXAxisModel.markMissingData(((AxisModel.MissingDataArea)area).getStart(), ((AxisModel.MissingDataArea)area).getEnd(), ((AxisModel.MissingDataArea)area).getText());
            }
        }
        if (!highlightAreas.isEmpty()) {
            for (AxisModel.ChartDataArea highlightArea : highlightAreas) {
                if (!(highlightArea instanceof AxisModel.HighlightedDataArea)) continue;
                area = (AxisModel.HighlightedDataArea)highlightArea;
                this.myChartXAxisModel.markHighlightedData(((AxisModel.HighlightedDataArea)area).getStartObj(), ((AxisModel.HighlightedDataArea)area).getEndObj());
            }
        }
    }

    private void horizontalZoomOut(boolean zoomOutCompletely) {
        if (!this.myZoomStack.isEmpty()) {
            ZoomStackBundle zoomObj;
            if (zoomOutCompletely) {
                zoomObj = (ZoomStackBundle)this.myZoomStack.firstElement();
                this.myZoomStack.clear();
            } else {
                zoomObj = this.myZoomStack.pop();
            }
            XYDataSet oldDataSet = zoomObj.getDataSet();
            this.myXyDataSet.removeAll();
            if (oldDataSet.getAllSeries().get(0) instanceof CompositeXYSeries) {
                this.setDataSet(oldDataSet, this.myUseDataSetLeftAxis, this.myAutomaticRepaintEnabled);
            } else {
                this.setDataSet(oldDataSet, this.myUseDataSetLeftAxis, this.myDataSetRenderer, this.myAutomaticRepaintEnabled);
            }
            this.updateAxes(oldDataSet);
            if (zoomObj.getMissingData() != null) {
                for (AxisModel.MissingDataArea missingDataArea : zoomObj.getMissingData()) {
                    this.myChartXAxisModel.markMissingData(missingDataArea.getStart(), missingDataArea.getEnd(), missingDataArea.getText());
                }
            }
            if (zoomObj.getHighlightedData() != null) {
                for (AxisModel.HighlightedDataArea highlightedDataArea : zoomObj.getHighlightedData()) {
                    this.myChartXAxisModel.markHighlightedData(highlightedDataArea.getStartObj(), highlightedDataArea.getEndObj());
                }
            }
            this.rebuildUI();
        }
    }

    private List<AxisModel.ChartDataArea> getZoomedDataAreas(Object areaMin, Object areaMax, List<? extends AxisModel.ChartDataArea> dataAreas) {
        ArrayList<AxisModel.ChartDataArea> zoomedDataAreas = new ArrayList<AxisModel.ChartDataArea>();
        if (dataAreas != null) {
            for (AxisModel.ChartDataArea chartDataArea : dataAreas) {
                Object areaStart = chartDataArea.getStart();
                Object areaEnd = chartDataArea.getEnd();
                if (((Comparable)areaEnd).compareTo(areaMin) < 0 || ((Comparable)areaStart).compareTo(areaMax) > 0) continue;
                areaStart = ((Comparable)areaStart).compareTo(areaMin) < 0 ? areaMin : areaStart;
                Object object = areaEnd = ((Comparable)areaEnd).compareTo(areaMax) > 0 ? areaMax : areaEnd;
                if (areaStart.equals(areaEnd)) continue;
                if (dataAreas.get(0) instanceof AxisModel.HighlightedDataArea) {
                    zoomedDataAreas.add(new AxisModel.HighlightedDataArea(areaStart, areaEnd));
                    continue;
                }
                zoomedDataAreas.add(new AxisModel.MissingDataArea(areaStart, areaEnd));
            }
        }
        return zoomedDataAreas;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (((Boolean)this.getChartProperty("AllowZoom")).booleanValue() && !this.myIsZooming) {
            this.myHorizontalZoomStartPoint = e.getPoint();
            this.myIsZooming = true;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.myDataSetRenderer instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.myDataSetRenderer)).mouseMoved(e);
        }
        for (GraphRenderer renderer : this.myDataSetRenderers) {
            if (!(renderer instanceof MouseMotionListener)) continue;
            ((MouseMotionListener)((Object)renderer)).mouseMoved(e);
        }
        this.myGraphView.repaint();
    }

    private JPanel createZoomControlPanel() {
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 0));
        JButton zoomOutButton = new JButton("Zoom out");
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.horizontalZoomOut(false);
            }
        });
        zoomPanel.add(zoomOutButton);
        JButton zoomResetbutton = new JButton("Reset");
        zoomResetbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.horizontalZoomOut(true);
            }
        });
        zoomPanel.add(zoomResetbutton);
        return zoomPanel;
    }

    static class HighLightColorLabel
    extends JLabel {
        private Color myColor;
        private int myWidth;
        private int myHeight;

        HighLightColorLabel(int width, int height, Color c) {
            this.myWidth = width;
            this.myHeight = height;
            this.myColor = c;
            this.setPreferredSize(new Dimension(this.myWidth, this.myHeight));
        }

        public void setPaintColor(Color c) {
            this.myColor = c;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.myColor);
            g.fillRect(2, 2, this.myWidth - 4, this.myHeight - 4);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRect(0, 0, this.myWidth - 1, this.myHeight - 1);
            super.paint(g);
        }
    }

    private static class ZoomRange {
        Object myMin;
        Object myMax;

        public ZoomRange(Object min, Object max) {
            this.myMin = min;
            this.myMax = max;
        }

        public Object getMin() {
            return this.myMin;
        }

        public Object getMax() {
            return this.myMax;
        }

        public boolean isValid() {
            return this.myMin != null && this.myMax != null;
        }
    }

    private class ZoomStackBundle {
        private XYDataSet myZoomedDataSet;
        private List<AxisModel.HighlightedDataArea> myZoomedHighlightedAreas;
        private List<AxisModel.MissingDataArea> myZoomedMissingAreas;

        public ZoomStackBundle(XYDataSet dataSet, List<AxisModel.HighlightedDataArea> highlightedArea, List<AxisModel.MissingDataArea> missingArea) {
            this.myZoomedDataSet = dataSet;
            this.myZoomedHighlightedAreas = highlightedArea;
            this.myZoomedMissingAreas = missingArea;
        }

        public XYDataSet getDataSet() {
            return this.myZoomedDataSet;
        }

        public List<AxisModel.HighlightedDataArea> getHighlightedData() {
            return this.myZoomedHighlightedAreas;
        }

        public List<AxisModel.MissingDataArea> getMissingData() {
            return this.myZoomedMissingAreas;
        }
    }
}

