/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.impl.ChartView;
import com.nokia.widgets.chart.impl.GraphModel;
import com.nokia.widgets.labels.PLabel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphLegendCheckBox
extends JPanel
implements ItemListener {
    protected ChartView myParentView;
    private JCheckBox myPaintGraphCheckBox;
    private JLabel myGraphIconAndTextLabel;
    private GraphModel myGraphModel;

    public GraphLegendCheckBox(ChartView chartView, GraphModel graphModel) {
        super(new GridBagLayout());
        this.myParentView = chartView;
        this.myGraphModel = graphModel;
        this.init();
    }

    protected void updateLegendTextFont() {
        Font f = (Font)this.myParentView.getChartProperty("axisvaluefont");
        f = f.deriveFont((float)(f.getSize() + NetLookAndFeel.getFontSizeIncrement()));
        this.myGraphIconAndTextLabel.setFont(f);
        this.revalidate();
        this.repaint();
    }

    private void init() {
        this.setBackground(ChartConstants.DEFAULT_CHART_BACKGROUND_COLOR);
        this.myPaintGraphCheckBox = new JCheckBox();
        this.myPaintGraphCheckBox.putClientProperty("JComponent.sizeVariant", "small");
        this.myPaintGraphCheckBox.setOpaque(false);
        this.myPaintGraphCheckBox.setSelected(this.myGraphModel.isGraphShown());
        this.myPaintGraphCheckBox.addItemListener(this);
        this.myPaintGraphCheckBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 4));
        this.myGraphIconAndTextLabel = PLabel.createValueText();
        Image legendBoxImage = this.myGraphModel.getGraphRenderer().getLegendBoxImage(this.myGraphModel.toSeries(), this.myPaintGraphCheckBox.getPreferredSize());
        this.myGraphIconAndTextLabel.setIcon(new ImageIcon(legendBoxImage));
        this.myGraphIconAndTextLabel.setText(this.myGraphModel.getGraphName());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 2, 0);
        boolean showCheckBox = (Boolean)this.myParentView.getProperties().get("legendboxshowcheckbox");
        if (showCheckBox) {
            this.add((Component)this.myPaintGraphCheckBox, gbc);
        }
        gbc.insets = new Insets(0, 0, 2, 2);
        this.add((Component)this.myGraphIconAndTextLabel, gbc);
        this.updateLegendTextFont();
        this.setOpaque(false);
    }

    public void destroy() {
        this.myPaintGraphCheckBox.removeItemListener(this);
    }

    public GraphModel getGraphModel() {
        return this.myGraphModel;
    }

    @Override
    public void setToolTipText(String tootip) {
        this.myPaintGraphCheckBox.setToolTipText(tootip);
        this.myGraphIconAndTextLabel.setToolTipText(tootip);
        super.setToolTipText(tootip);
    }

    public void setEditingEnabled(boolean enabled) {
        this.myPaintGraphCheckBox.setEnabled(enabled);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.myGraphModel.setGraphShown(event.getStateChange() == 1);
        this.myParentView.handleLegendCheckBoxClick();
    }
}

