/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.ValuePointModel;
import com.nokia.widgets.chart.data.CompositeXYSeries;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.GraphView;
import com.nokia.widgets.util.NSNColors;
import java.awt.Color;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class GraphModel {
    public static final int X_AXIS_VALUE_INDEX = 0;
    public static final int Y_AXIS_VALUE_INDEX = 1;
    private static final int GRAPH_VALUE_DIMENSION = 2;
    private static final Color DEFAULT_GRAPH_COLOR = NSNColors.getOrange();
    private XYSeries myXYSeries;
    private boolean myUseLeftYAxis;
    private Color myGraphColor;
    private Color myGraphGradientColor;
    private String myGraphName;
    private Object myThresholdValue;
    private Color myThresholdColor;
    private String myToolTipText;
    private Object myUserObject;
    private boolean myIsGraphShown;
    private int myMarkerType;
    private GraphRenderer myGraphRenderer;
    private ValuePointModel myValuePointModel;
    protected Icon myGraphCustomValueMarker;
    protected Map<Object, Icon> myGraphCustomValueMarkerForSpecValue;

    public static Object[][] createGraphValuesArray(List xValues, List yValues) {
        return GraphModel.createGraphValuesArray(xValues.toArray(), yValues.toArray());
    }

    public static Object[][] createGraphValuesArray(Object[] xValues, Object[] yValues) {
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("X and Y axis must have same amount of samples");
        }
        Object[][] graphValues = new Object[xValues.length][2];
        int i = 0;
        while (i < xValues.length) {
            graphValues[i][0] = xValues[i];
            graphValues[i][1] = yValues[i];
            ++i;
        }
        return graphValues;
    }

    public GraphModel(Object[][] graphValues, boolean useLeftYAxis, GraphRenderer renderer, Color graphColor, String graphName, Object thresholdValue, Color thresholdColor, Object userObject) {
        this(graphValues, useLeftYAxis, renderer, graphColor, graphColor, graphName, thresholdValue, thresholdColor, userObject);
    }

    public GraphModel(Object[][] graphValues, boolean useLeftYAxis, GraphRenderer renderer, Color graphColor, Color gradientColor, String graphName, Object thresholdValue, Color thresholdColor, Object userObject) {
        this.setGraphRenderer(renderer);
        this.myGraphColor = graphColor;
        this.myGraphGradientColor = gradientColor;
        this.myUseLeftYAxis = useLeftYAxis;
        this.myGraphName = graphName;
        this.setThresholdValue(thresholdValue);
        this.myThresholdColor = thresholdColor;
        this.myUserObject = userObject;
        this.myIsGraphShown = true;
        this.setGraphValues(graphValues);
    }

    public GraphModel(Object[][] graphValues, boolean useLeftYAxis, GraphRenderer renderer, Color graphColor, Color gradientColor, String graphName, Object thresholdValue, Color thresholdColor, String toolTip, Object userObject) {
        this(graphValues, useLeftYAxis, renderer, graphColor, gradientColor, graphName, thresholdValue, thresholdColor, userObject);
        this.myToolTipText = toolTip;
    }

    public GraphModel(Object[][] graphValues, boolean useLeftYAxis, GraphRenderer renderer, Color graphColor, String graphName, Object thresholdValue, Color thresholdColor, String toolTip, Object userObject) {
        this(graphValues, useLeftYAxis, renderer, graphColor, graphColor, graphName, thresholdValue, thresholdColor, userObject);
        this.myToolTipText = toolTip;
    }

    public GraphModel(XYSeries xySeries, boolean useLeftYAxis, GraphRenderer renderer) {
        this.setGraphRenderer(renderer);
        this.myXYSeries = xySeries;
        this.myGraphColor = xySeries.getColor() != null ? xySeries.getColor() : DEFAULT_GRAPH_COLOR;
        this.setGraphGradientColor(xySeries.getGradientColor() == null ? this.getGraphColor().brighter() : xySeries.getGradientColor());
        this.myUseLeftYAxis = useLeftYAxis;
        this.myXYSeries.setUseLeftYAxis(useLeftYAxis);
        this.myGraphName = xySeries.getName();
        this.setThresholdValue(xySeries.getThresholdValue());
        this.myThresholdColor = xySeries.getThresholdColor();
        this.myToolTipText = xySeries.getToolTipText();
        this.myUserObject = xySeries.getUserObject();
        this.myIsGraphShown = true;
        this.setValuePointModel(xySeries.getValuePointModel());
        this.setValueMarkerType(xySeries.getValueMarkerType());
        this.myXYSeries.setColor(this.myGraphColor, this.myGraphGradientColor);
        this.myGraphCustomValueMarker = xySeries.getCustomValueMarker();
        this.myGraphCustomValueMarkerForSpecValue = xySeries.getCustomValueMarkerForSpecValue();
    }

    public String getGraphName() {
        return this.myGraphName;
    }

    public boolean getUseLeftYAxis() {
        return this.myUseLeftYAxis;
    }

    public void setUsedYAxis(boolean useLeftYAxis) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setUseLeftYAxis(useLeftYAxis);
        }
        this.myUseLeftYAxis = useLeftYAxis;
    }

    public GraphRenderer getGraphRenderer() {
        return this.myGraphRenderer;
    }

    public void setGraphRenderer(GraphRenderer renderer) {
        if (this.myXYSeries instanceof CompositeXYSeries) {
            ((CompositeXYSeries)this.myXYSeries).setRenderer(renderer);
        }
        this.myGraphRenderer = renderer;
    }

    public Color getGraphColor() {
        return this.myGraphColor;
    }

    public void setGraphColor(Color graphSolidColor) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setColor(graphSolidColor);
        }
        this.myGraphColor = graphSolidColor;
    }

    public Color getGraphGradientColor() {
        return this.myGraphGradientColor;
    }

    public void setGraphGradientColor(Color graphGradientColor) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setGradientColor(graphGradientColor);
        }
        this.myGraphGradientColor = graphGradientColor;
    }

    public boolean isPaintableThreshold() {
        return this.myThresholdValue instanceof Number;
    }

    public Object getThresholdValue() {
        return this.myThresholdValue;
    }

    public void setThresholdValue(Object threshold) {
        if (threshold instanceof Object[] && ((Object[])threshold).length != this.myXYSeries.getXYPairsCount()) {
            throw new IllegalArgumentException("Threshold value array must be of same size as the graph value array");
        }
        if (this.myXYSeries != null) {
            this.myXYSeries.setThresholdValue(threshold);
        }
        this.myThresholdValue = threshold;
    }

    public Color getThresholdColor() {
        return this.myThresholdColor;
    }

    public void setThresholdColor(Color thresholdColor) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setThresholdColor(thresholdColor);
        }
        this.myThresholdColor = thresholdColor;
    }

    public Object[][] getGraphValues() {
        return GraphModel.createGraphValuesArray(this.myXYSeries.getXValues(), this.myXYSeries.getYValues());
    }

    public void setGraphValues(Object[][] graphValues) {
        if (this.myXYSeries == null) {
            this.myXYSeries = new XYSeries(this.myGraphName);
        }
        this.myXYSeries.setColor(this.myGraphColor, this.myGraphGradientColor);
        this.myXYSeries.setThresholdColor(this.myThresholdColor);
        this.myXYSeries.setToolTipText(this.myToolTipText);
        this.myXYSeries.setThresholdValue(this.myThresholdValue);
        this.myXYSeries.setUserObject(this.myUserObject);
        this.myXYSeries.setValueMarkerType(this.myMarkerType);
        this.myXYSeries.setUseLeftYAxis(this.myUseLeftYAxis);
        this.myXYSeries.setValuePointModel(this.myValuePointModel);
        this.myXYSeries.setCustomValueMarker(this.myGraphCustomValueMarker);
        this.myXYSeries.setCustomValueMarkerForSpecValue(this.myGraphCustomValueMarkerForSpecValue);
        if (graphValues != null) {
            int i = 0;
            while (i < graphValues.length) {
                this.myXYSeries.addXYPair(new XYPair(graphValues[i][0], graphValues[i][1]));
                ++i;
            }
        }
    }

    public boolean isGraphShown() {
        return this.myIsGraphShown;
    }

    public void setGraphShown(boolean isShown) {
        this.myIsGraphShown = isShown;
    }

    public void setToolTipText(String tooltip) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setToolTipText(tooltip);
        }
        this.myToolTipText = tooltip;
    }

    public String getToolTipText() {
        return this.myToolTipText;
    }

    public void setUserObject(Object userObject) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setUserObject(userObject);
        }
        this.myUserObject = userObject;
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public boolean isValueOverThreshold(Object value, int valueIndex, GraphView graphView) {
        if (this.myThresholdValue != null) {
            double yPosThreshold;
            Object thresholdValue = this.myThresholdValue instanceof Object[] ? ((Object[])this.myThresholdValue)[valueIndex] : this.myThresholdValue;
            if (thresholdValue instanceof Number) {
                return ((Number)thresholdValue).doubleValue() - ((Number)value).doubleValue() < 0.0;
            }
            if (thresholdValue instanceof Date) {
                return ((Date)thresholdValue).getTime() - ((Date)value).getTime() < 0L;
            }
            double yPosValue = graphView.getYAxisPositionForValue(value, this.myUseLeftYAxis);
            return yPosValue < (yPosThreshold = graphView.getYAxisPositionForValue(thresholdValue, this.myUseLeftYAxis));
        }
        return false;
    }

    public int getValueMarkerType() {
        return this.myMarkerType;
    }

    public void setValueMarkerType(int markerType) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setValueMarkerType(markerType);
        }
        this.myMarkerType = markerType;
    }

    public void setValuePointModel(ValuePointModel valuePointModel) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setValuePointModel(valuePointModel);
        }
        this.myValuePointModel = valuePointModel;
    }

    public ValuePointModel getValuePointModel() {
        return this.myValuePointModel;
    }

    public XYSeries toSeries() {
        return this.myXYSeries;
    }

    public Icon getGraphCustomValueMarker() {
        return this.myGraphCustomValueMarker;
    }

    public void setGraphCustomValueMarker(Icon graphCustomValueMarker) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setCustomValueMarker(graphCustomValueMarker);
        }
        this.myGraphCustomValueMarker = graphCustomValueMarker;
    }

    public Map<Object, Icon> getGraphCustomValueMarkerForSpecValue() {
        return this.myGraphCustomValueMarkerForSpecValue;
    }

    public void setGraphCustomValueMarkerForSpecValue(Map<Object, Icon> graphCustomValueMarkerForSpecValue) {
        if (this.myXYSeries != null) {
            this.myXYSeries.setCustomValueMarkerForSpecValue(graphCustomValueMarkerForSpecValue);
        }
        this.myGraphCustomValueMarkerForSpecValue = graphCustomValueMarkerForSpecValue;
    }
}

