/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import java.awt.Color;
import java.math.BigDecimal;

public class GraphValueRange {
    private BigDecimal myRangeMaxValue;
    private BigDecimal myRangeMinValue;
    private Color myColor;

    public GraphValueRange(Number minValue, Number maxValue, Color color) {
        this(BigDecimal.valueOf(minValue.doubleValue()), BigDecimal.valueOf(maxValue.doubleValue()), color);
    }

    public GraphValueRange(BigDecimal minValue, BigDecimal maxValue, Color color) {
        this.myRangeMaxValue = maxValue;
        this.myRangeMinValue = minValue;
        this.myColor = color;
    }

    public boolean belongsToRange(Number value) {
        return this.belongsToRange(BigDecimal.valueOf(value.doubleValue()));
    }

    public boolean belongsToRange(BigDecimal value) {
        return this.compareTo(value, this.myRangeMaxValue) == -1 && this.compareTo(this.myRangeMinValue, value) < 1;
    }

    private int compareTo(BigDecimal n1, BigDecimal n2) {
        return n1.compareTo(n2);
    }

    public Color getColor() {
        return this.myColor;
    }

    public String toString() {
        return "min: " + this.myRangeMinValue + " max: " + this.myRangeMaxValue + " color: " + this.myColor;
    }
}

