/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.LegendAreaRenderer;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.impl.ChartView;
import com.nokia.widgets.chart.impl.GraphModel;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import com.nokia.widgets.chart.renderers.AbstractColumnGraphRenderer;
import com.nokia.widgets.chart.renderers.ContourGraphRenderer;
import com.nokia.widgets.chart.renderers.PieChartRenderer;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.infotip.InfoTip;
import com.nokia.widgets.infotip.InfoTipEvent;
import com.nokia.widgets.infotip.VetoableInfoTipListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class GraphView
extends JComponent
implements VetoableInfoTipListener,
Accessible {
    private static final Color MISSING_DATA_TEXT_COLOR = new Color(153, 153, 153);
    private static final String MISSING_DATA_STR = "Missing Data";
    private static final Color MISSING_DATA_BACKGROUND_COLOR = new Color(230, 230, 230);
    public static final double START_X_POINT_GRAPH_AREA = 0.0;
    public static final double START_Y_POINT_GRAPH_AREA = 0.0;
    public static final double AXIS_VALUE_LINE_EXTENDED_LENGTH = 3.0;
    public static final double AXIS_VALUE_LINE_AND_VALUE_LABEL_GAP = 8.0;
    private static final int GRAPH_MARGINAL = 12;
    private static final int SPARKLINE_MARGINAL = 2;
    private static final int GRAPH_AREA_MARGINAL_WIDTH = 12;
    private static final int GRAPH_AREA_MARGINAL_HEIGHT = 15;
    private static final int SPARKLINE_AREA_MARGINAL_WIDTH = 2;
    private static final int SPARKLINE_AREA_MARGINAL_HEIGHT = 2;
    private static final int DESCRIPTION_VALUE_DISTANCE = 12;
    private ChartView myChartView;
    private AxisModel myXAxisModel;
    private AxisModel myYLeftAxisModel;
    private AxisModel myYRightAxisModel;
    private double myYLeftStartX;
    private double mySpaceAdjustedLeftX;
    private double myYLeftStartY;
    private double myYRightEndX;
    private double mySpaceAdjustedRightX;
    private double myYRightEndY;
    private Line2D.Double myAxisLine = new Line2D.Double();
    private Map<Shape, Object> myGraphValueTooltips = new HashMap<Shape, Object>();
    private Map<Shape, Object> myHighlightedAreaToolTips = new HashMap<Shape, Object>();
    private boolean myHasGraphTooltip;
    private ComponentListener myComponentListener;
    private boolean myUseExtendedValueLines;
    private Font myAxisLabelFont;
    private double myAxisValueLineLength;
    private int myAxisEndSpaceAmount = 0;
    private GraphPaintArea myGraphPaintArea;
    private InfoTip myInfoTip;
    private Object[][] myPriorityArray;
    private boolean myIsZooming;
    private int myGraphMargin;
    private boolean myIsDirty;
    private boolean myIsPainting;
    private Rectangle myHorizontalZoomBoundingBox;
    private Rectangle myGraphBorder = new Rectangle();
    private int myCustomLegendAreaSpaceWidth;

    public GraphView(ChartView chartView, AxisModel xAxisModel, AxisModel yLeftAxisModel, AxisModel yRightAxisModel) {
        this.myChartView = chartView;
        this.myXAxisModel = xAxisModel;
        this.myYLeftAxisModel = yLeftAxisModel;
        this.myYRightAxisModel = yRightAxisModel;
        this.myGraphMargin = Boolean.TRUE.equals(this.getChartProperty("sparkline")) ? 2 : 12;
        this.updateValueLabelFont();
        this.myInfoTip = new InfoTip((Component)this, "");
        this.myInfoTip.setTipContentActive(false);
        this.myInfoTip.setDisplayStrategy(2);
        this.myInfoTip.setShowDelay(250);
        this.myInfoTip.addInfoTipListener(this);
        this.myGraphPaintArea = new GraphPaintArea();
        this.myHasGraphTooltip = (Boolean)this.myChartView.getChartProperty("graphtooltip");
        if (this.myHasGraphTooltip) {
            this.setToolTipText("");
        }
        this.initListeners();
        this.myAxisValueLineLength = (Double)this.myChartView.getChartProperty("valuelinelengthkey");
        this.myUseExtendedValueLines = (Boolean)this.getChartProperty("longlineforlabel");
        this.addMouseListener(this.myChartView);
        this.addZoomBoundingBoxListener();
    }

    private void addZoomBoundingBoxListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (((Boolean)GraphView.this.myChartView.getProperty("AllowZoom")).booleanValue() && GraphView.this.myIsZooming) {
                    GraphView.this.myHorizontalZoomBoundingBox = null;
                    GraphView.this.myIsZooming = false;
                    GraphView.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (((Boolean)GraphView.this.myChartView.getProperty("AllowZoom")).booleanValue()) {
                    GraphView.this.updateZoomBoundingBox(e);
                    Rectangle paintAreaRect = GraphView.this.myGraphPaintArea.getBounds();
                    int boxLowerRightX = e.getX() < paintAreaRect.x + paintAreaRect.width ? e.getX() : paintAreaRect.x + paintAreaRect.width;
                    int boxLowerRightY = e.getY() < paintAreaRect.y + paintAreaRect.height ? e.getY() : paintAreaRect.y + paintAreaRect.height;
                    GraphView.this.myHorizontalZoomBoundingBox = new Rectangle(((GraphView)GraphView.this).myHorizontalZoomBoundingBox.x, ((GraphView)GraphView.this).myHorizontalZoomBoundingBox.y, boxLowerRightX - ((GraphView)GraphView.this).myHorizontalZoomBoundingBox.x, boxLowerRightY - ((GraphView)GraphView.this).myHorizontalZoomBoundingBox.y);
                    GraphView.this.repaint();
                }
            }
        });
    }

    private void updateZoomBoundingBox(MouseEvent e) {
        if (!this.myIsZooming) {
            Rectangle paintAreaRect = this.myGraphPaintArea.getBounds();
            int boxTopLeftX = e.getX() < paintAreaRect.x + paintAreaRect.width ? e.getX() : paintAreaRect.x + paintAreaRect.width;
            int boxTopLeftY = e.getY() < paintAreaRect.y + paintAreaRect.height ? e.getY() : paintAreaRect.y + paintAreaRect.height;
            boxTopLeftX = boxTopLeftX > paintAreaRect.x ? boxTopLeftX : paintAreaRect.x;
            boxTopLeftY = boxTopLeftY > paintAreaRect.y ? boxTopLeftY : paintAreaRect.y;
            this.myHorizontalZoomBoundingBox = new Rectangle(new Point(boxTopLeftX, boxTopLeftY));
            this.myIsZooming = true;
        }
    }

    protected void updateValueLabelFont() {
        this.myAxisLabelFont = (Font)this.myChartView.getChartProperty("axisvaluefont");
        int fontSize = this.myAxisLabelFont.getSize() + NetLookAndFeel.getFontSizeIncrement();
        this.myAxisLabelFont = this.myAxisLabelFont.deriveFont((float)fontSize);
    }

    private void initListeners() {
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GraphView.this.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                GraphView.this.repaint();
            }
        };
        this.myChartView.addComponentListener(this.myComponentListener);
    }

    public void destroy() {
        this.clear();
    }

    public void clear() {
        this.myGraphValueTooltips.clear();
        this.myChartView.removeComponentListener(this.myComponentListener);
        this.myHighlightedAreaToolTips.clear();
    }

    public void setXAxisModel(AxisModel axisModel) {
        this.myXAxisModel = axisModel;
    }

    public void setYLeftAxisModel(AxisModel axisModel) {
        this.myYLeftAxisModel = axisModel;
    }

    public void setYRightAxisModel(AxisModel axisModel) {
        this.myYRightAxisModel = axisModel;
    }

    public double getXAxisPositionForValue(Object value) {
        double adjustment = 0.0;
        if (this.myXAxisModel != null) {
            adjustment = this.myXAxisModel.getValuePositionAtAxis(value, this.mySpaceAdjustedRightX - this.mySpaceAdjustedLeftX);
            return this.mySpaceAdjustedLeftX + adjustment;
        }
        throw new IllegalStateException("X axis model is not set");
    }

    public double getYAxisPositionForValue(Object value, boolean axisAlignYLeft) {
        double adjustment = 0.0;
        if (axisAlignYLeft) {
            if (this.myYLeftAxisModel != null) {
                adjustment = this.myYLeftAxisModel.getValuePositionAtAxis(value, this.myYRightEndY - this.myYLeftStartY);
                return this.myYRightEndY - adjustment;
            }
            throw new IllegalStateException("Left Y axis model not in use");
        }
        if (this.myYRightAxisModel != null) {
            adjustment = this.myYRightAxisModel.getValuePositionAtAxis(value, this.myYRightEndY - this.myYLeftStartY);
            return this.myYRightEndY - adjustment;
        }
        throw new IllegalStateException("Right Y axis model not in use");
    }

    public double getGraphXStart() {
        return this.myYLeftStartX;
    }

    public double getAdjustedGraphXStart() {
        return this.mySpaceAdjustedLeftX;
    }

    public double getGraphYStart() {
        return this.myYLeftStartY;
    }

    public double getGraphXEnd() {
        return this.myYRightEndX;
    }

    public double getAdjustedGraphXEnd() {
        return this.mySpaceAdjustedRightX;
    }

    public double getGraphYEnd() {
        return this.myYRightEndY;
    }

    public void setGraphPaintingEnabled(boolean paint) {
        this.myIsPainting = paint;
    }

    public Object getChartProperty(Object key) {
        return this.myChartView.getChartProperty(key);
    }

    public boolean hasGraphTooltips() {
        return this.myHasGraphTooltip;
    }

    public void addValueTooltip(Shape graphValueArea, Object graphValue) {
        if (!this.myGraphValueTooltips.containsKey(graphValueArea)) {
            this.myGraphValueTooltips.put(graphValueArea, graphValue);
        }
    }

    public void addHighLightToolTip(Object start, Object end, Object value) {
        double startx = this.getXAxisPositionForValue(start);
        double endx = this.getXAxisPositionForValue(end);
        Rectangle graphArea = new Rectangle((int)startx, (int)this.getGraphYStart(), (int)(endx - startx), (int)this.getGraphYEnd());
        if (!this.myHighlightedAreaToolTips.containsKey(graphArea)) {
            this.myHighlightedAreaToolTips.put(graphArea, value);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return null;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public void setDirty(boolean isDirty) {
        if (!this.myIsPainting) {
            this.myIsDirty = isDirty;
        }
    }

    private void paintGraph(Graphics g) {
        this.myGraphMargin = Boolean.TRUE.equals(this.getChartProperty("sparkline")) ? 2 : 12;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Rectangle graphArea = this.getGraphArea();
        Graphics2D g2d = null;
        g2d = (Graphics2D)g;
        this.myCustomLegendAreaSpaceWidth = this.computeCustomLegendAreaWidth(graphArea, g.getFontMetrics());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color background = (Color)this.myChartView.getChartProperty("chartbackgroundcolor");
        if (background != null) {
            g2d.setColor(background);
            g2d.fillRect(0, 0, width, height);
        } else if (this.myChartView.getView() != null && this.myChartView.getView().isOpaque()) {
            GradientUtils.drawVerticalBackgroundGradient((Container)this, (Graphics)g2d, new Rectangle(0, 0, width, height));
        }
        Color color = (Color)this.myChartView.getChartProperty("graphbackgroundcolor");
        boolean containsPieChart = this.containsPieChart();
        if (color != null) {
            g2d.setColor(color);
            this.calculateLeftEndLocation(graphArea);
            this.calculateRightEndLocation(graphArea);
            int backgroundWidth = (int)this.myYRightEndX - (int)this.myYLeftStartX + 20;
            if (backgroundWidth > 0) {
                Object oldAa = NetUtils.antiAliasingOn(g2d);
                int chartXPosition = (int)this.myYLeftStartX - 10;
                if (this.myYLeftAxisModel != null) {
                    chartXPosition = (int)((double)chartXPosition + (this.getRequiredAxisSpace(this.myYLeftAxisModel) - (double)this.myGraphMargin));
                    backgroundWidth = (int)((double)backgroundWidth - (this.getRequiredAxisSpace(this.myYLeftAxisModel) - (double)this.myGraphMargin));
                }
                if (this.myYRightAxisModel != null) {
                    backgroundWidth = (int)((double)backgroundWidth - (this.getRequiredAxisSpace(this.myYRightAxisModel) + (double)this.myGraphMargin - 42.0));
                }
                if (containsPieChart) {
                    g2d.fill(graphArea);
                } else {
                    g2d.fillRoundRect(chartXPosition, (int)this.myYLeftStartY - 11, backgroundWidth, (int)this.myYRightEndY - (int)this.myYLeftStartY + 23, 9, 9);
                }
                NetUtils.setAntialiasing(g2d, oldAa);
            }
        }
        this.calculateAxisMaxValue();
        boolean containsContourChart = this.containsContourChart();
        if (!containsPieChart && !containsContourChart) {
            this.paintHighLightedData(g2d, false);
        }
        if (!containsPieChart) {
            this.paintAxis(g2d, graphArea);
        }
        this.paintMissingData(g2d, ChartConstants.DRAW_LAYER.BOTTOM);
        this.paintGraphs(g2d);
        if (containsContourChart) {
            this.paintHighLightedData(g2d, true);
        }
        this.paintMissingData(g2d, ChartConstants.DRAW_LAYER.TOP);
        this.paintCustomLegendArea(g2d);
        if (((Boolean)this.myChartView.getProperty("AllowZoom")).booleanValue() && this.myIsZooming) {
            g2d.setColor((Color)this.myChartView.getProperty("ZoomBoundingBoxColor"));
            g2d.fillRect(this.myHorizontalZoomBoundingBox.x, this.myGraphPaintArea.getBounds().y, this.myHorizontalZoomBoundingBox.width, this.myGraphPaintArea.getBounds().height);
        }
    }

    private int computeCustomLegendAreaWidth(Rectangle graphArea, FontMetrics fontMetrics) {
        if (this.isCustomLegendAreaSet()) {
            LegendAreaRenderer renderer = (LegendAreaRenderer)this.myChartView.getProperty("CustomLegendAreaRenderer");
            Map legendDataMap = (Map)this.myChartView.getProperty("CustomLegendAreaDataMap");
            return NetUtils.getLongestStringLength(legendDataMap.keySet(), fontMetrics) + renderer.getBounds((Rectangle)graphArea, (Object)legendDataMap, (FontMetrics)fontMetrics).width;
        }
        return 0;
    }

    private boolean containsPieChart() {
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            if (model.getGraphRenderer() instanceof PieChartRenderer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsContourChart() {
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            if (model.getGraphRenderer() instanceof ContourGraphRenderer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private GraphModel getColumnGraphModel() {
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            GraphRenderer renderer = model.getGraphRenderer();
            if (renderer instanceof AbstractColumnGraphRenderer) {
                return model;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintGraph(g);
    }

    protected void paintError(Graphics2D g, Rectangle graphArea) {
        g.setColor(Color.red);
        int x1 = graphArea.x + this.myGraphMargin;
        int y1 = graphArea.y;
        int x2 = graphArea.width + this.myGraphMargin;
        int y2 = graphArea.height - (int)this.getRequiredAxisSpace(this.myXAxisModel);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x1, y2, x2, y1);
    }

    protected void paintAxis(Graphics2D g, Rectangle graphArea) {
        Object oldAa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        NetLookAndFeel.toggleTextAntialiasing(g);
        Color borderColor = (Color)this.myChartView.getChartProperty("bordercolor");
        GraphModel columnGraphModel = this.getColumnGraphModel();
        int preferredHalfColumnWidth = this.getPreferredHalfColumnWidth(graphArea, columnGraphModel);
        if (((Boolean)this.getChartProperty("spaceonaxisend")).booleanValue()) {
            int axisSpaceAmount = (Integer)this.getChartProperty("spaceamount");
            this.myAxisEndSpaceAmount = axisSpaceAmount == ChartConstants.DEFAULT_GRAPH_HORIZONTAL_AXIS_SPACE_AMOUNT ? this.calculateXAxisAutomaticGap(graphArea) : axisSpaceAmount + preferredHalfColumnWidth;
        } else if (columnGraphModel != null) {
            Object[] xValues = columnGraphModel.toSeries().getXValues().toArray();
            this.myAxisEndSpaceAmount = xValues.length > 2 ? preferredHalfColumnWidth : this.calculateXAxisAutomaticGap(graphArea);
        }
        this.paintLeftYAxis(g, graphArea, borderColor);
        this.paintRightYAxis(g, graphArea);
        if (!((Boolean)this.getChartProperty("hidexaxis")).booleanValue()) {
            this.paintAxisValueLines(g, this.myXAxisModel, graphArea, (Color)this.getChartProperty("gridcolor"));
        }
        NetUtils.setAntialiasing(g, oldAa);
        this.paintGraphBorders(g, graphArea);
    }

    private int getPreferredHalfColumnWidth(Rectangle graphArea, GraphModel columnGraphModel) {
        if (columnGraphModel != null) {
            Object[] xValues = columnGraphModel.toSeries().getXValues().toArray();
            return (int)((AbstractColumnGraphRenderer)columnGraphModel.getGraphRenderer()).getPreferredColumnWidth(xValues, graphArea) / 2;
        }
        return 0;
    }

    private void paintHighLightedData(Graphics2D g, boolean isContourGraph) {
        if (this.myXAxisModel.getHighLightedData() != null && ((Boolean)this.getChartProperty("ShowHighLight")).booleanValue()) {
            List<AxisModel.HighlightedDataArea> hlData = this.myXAxisModel.getHighLightedData();
            int x = 0;
            while (x < hlData.size()) {
                AxisModel.HighlightedDataArea a = hlData.get(x);
                double xstart = this.getXAxisPositionForValue(a.getStartObj());
                double xend = this.getXAxisPositionForValue(a.getEndObj());
                Color color = a.getStartMarker().getColor();
                g.setColor(color != null ? color : (Color)this.getChartProperty("ChartHighLightColor"));
                String highlightType = (String)this.getChartProperty("HighlighType");
                boolean sparkline = Boolean.TRUE.equals(this.getChartProperty("sparkline"));
                int y1 = (int)this.myYLeftStartY + 1;
                if ("Lines".equals(highlightType)) {
                    int highlightEndXLocation;
                    if (isContourGraph) {
                        g.setColor(NetUtils.getColor(g.getColor(), 200));
                    }
                    Stroke oldStroke = g.getStroke();
                    g.setStroke(new BasicStroke(sparkline ? 1 : 2));
                    int offset = sparkline ? 1 : 4;
                    int y2 = y1 + this.myGraphPaintArea.getBounds().height + offset;
                    Object oldAa = NetUtils.antiAliasingOff(g);
                    if (xstart < this.getAdjustedGraphXEnd() + 12.0 - 2.0) {
                        g.drawLine((int)xstart, y1 - offset, (int)xstart, y2);
                    }
                    if ((double)(highlightEndXLocation = (int)xstart + 1 + (int)Math.round(xend - xstart)) < this.getAdjustedGraphXEnd() + 12.0 - 2.0) {
                        g.drawLine(highlightEndXLocation, y1 - offset, highlightEndXLocation, y2);
                    }
                    NetUtils.setAntialiasing(g, oldAa);
                    g.setColor(NetUtils.getColor(g.getColor(), 45));
                    g.setStroke(oldStroke);
                }
                if (!isContourGraph) {
                    double fillEnd = Math.min(xend, this.getAdjustedGraphXEnd() + 12.0 - 2.0);
                    double fillStart = Math.max(xstart, this.getAdjustedGraphXStart() - 12.0 + 2.0);
                    fillEnd = Math.max(fillEnd, fillStart);
                    g.fillRect((int)fillStart + 1, y1, (int)Math.round(fillEnd - fillStart), this.myGraphPaintArea.getBounds().height);
                }
                g.setColor(MISSING_DATA_TEXT_COLOR);
                ++x;
            }
        }
    }

    private void paintMissingData(Graphics2D g, ChartConstants.DRAW_LAYER layer) {
        if (this.myXAxisModel.getMissingData() != null) {
            List<AxisModel.MissingDataArea> missingData = this.myXAxisModel.getMissingData();
            Color oldColor = g.getColor();
            int i = 0;
            while (i < missingData.size()) {
                AxisModel.MissingDataArea area = missingData.get(i);
                if (area.getLayer() == layer) {
                    g.setColor(MISSING_DATA_BACKGROUND_COLOR);
                    double startX = this.getXAxisPositionForValue(area.getStart());
                    double endX = this.getXAxisPositionForValue(area.getEnd());
                    String missingDataText = area.getText() != null ? area.getText() : MISSING_DATA_STR;
                    g.fillRect((int)startX + 2, (int)this.myYLeftStartY + 1, (int)Math.round(endX - startX) - 4, (int)(this.myYRightEndY - this.myYLeftStartY - 1.0));
                    g.setColor(MISSING_DATA_TEXT_COLOR);
                    AffineTransform t = g.getTransform();
                    double xLoc = startX + (endX - startX) / 2.0;
                    double yPos = (this.myYRightEndY - this.myYLeftStartY - (double)SwingUtilities.computeStringWidth(g.getFontMetrics(), missingDataText)) / 2.0;
                    g.rotate(-1.5707963267948966, xLoc, this.myYRightEndY);
                    g.drawString(missingDataText, (int)(xLoc + yPos), (int)this.myYRightEndY + g.getFont().getSize() / 2);
                    g.setTransform(t);
                }
                ++i;
            }
            g.setColor(oldColor);
        }
    }

    private void paintCustomLegendArea(Graphics2D g) {
        if (this.isCustomLegendAreaSet()) {
            Object dataObject = this.myChartView.getProperty("CustomLegendAreaDataMap");
            LegendAreaRenderer legendAreaRenderer = (LegendAreaRenderer)this.myChartView.getProperty("CustomLegendAreaRenderer");
            Object property = this.myChartView.getProperty("CustomLegendAreaName");
            String name = property == null ? "" : (String)property;
            legendAreaRenderer.paintLegendArea(g, this.myGraphBorder, this.myChartView, dataObject, name);
        }
    }

    private boolean isCustomLegendAreaSet() {
        Object map = this.myChartView.getProperty("CustomLegendAreaDataMap");
        Object renderer = this.myChartView.getProperty("CustomLegendAreaRenderer");
        return map != null && renderer instanceof LegendAreaRenderer;
    }

    protected void paintAxisValueLines(Graphics2D g, AxisModel axisModel, Rectangle graphArea, Color gridColor) {
        double axisScale;
        double axisLinePos = 0.0;
        double axisLineX1Pos = 0.0;
        double axisLineX2Pos = 0.0;
        double axisLineY1Pos = 0.0;
        double axisLineY2Pos = 0.0;
        g.setColor((Color)this.myChartView.getChartProperty("axiscolor"));
        if (axisModel.getType() == 2) {
            axisLineY1Pos = this.myYRightEndY;
            axisLineY2Pos = this.myYRightEndY + this.myAxisValueLineLength;
            axisScale = (this.mySpaceAdjustedRightX - this.mySpaceAdjustedLeftX) / ((double)axisModel.getValueLineCount() - 1.0);
            axisLinePos = this.mySpaceAdjustedLeftX;
            this.drawAxisEndsDescriptions(g);
        } else {
            double y2;
            double y1;
            double requiredXAxisHeight = this.getRequiredAxisSpace(this.myXAxisModel);
            double requiredYAxisWidth = this.getRequiredAxisSpace(axisModel);
            if (axisModel.equals(this.myYLeftAxisModel)) {
                double x1 = (double)graphArea.x + requiredYAxisWidth;
                y1 = graphArea.y;
                y2 = graphArea.getHeight() - requiredXAxisHeight;
                axisLineX1Pos = x1 - this.myAxisValueLineLength + 10.0;
                axisLineX2Pos = x1;
                this.myYLeftStartX = x1;
                this.myYLeftStartY = y1;
                this.mySpaceAdjustedLeftX = x1 + (double)this.myAxisEndSpaceAmount;
            } else {
                double x1 = graphArea.getWidth() - requiredYAxisWidth;
                y1 = graphArea.y;
                double x2 = graphArea.getWidth() - requiredYAxisWidth;
                y2 = graphArea.getHeight() - requiredXAxisHeight;
                axisLineX1Pos = x1;
                axisLineX2Pos = x1 + this.myAxisValueLineLength;
                this.myYRightEndX = x2;
                this.mySpaceAdjustedRightX = x2 - (double)this.myAxisEndSpaceAmount;
                this.myYRightEndY = y2;
            }
            axisScale = (y2 - y1) / ((double)axisModel.getValueLineCount() - 1.0);
            axisLinePos = y2;
        }
        int gapForLabels = 6;
        double requiredSpace = 0.0;
        if (this.myXAxisModel != null) {
            double availableSpace;
            if (this.myXAxisModel.getValues() != null) {
                requiredSpace = (double)this.myXAxisModel.getValues().size() * (this.myXAxisModel.getRequiredAxisValueLabelLenght(this.getFontMetrics(this.myAxisLabelFont)) + 6.0);
            }
            if (requiredSpace >= (availableSpace = this.getSize().getWidth())) {
                int factor = (int)Math.ceil(requiredSpace / availableSpace);
                this.myXAxisModel.setValueLabelInterval(factor + 1);
            } else {
                this.myXAxisModel.setValueLabelInterval(1);
            }
        }
        if (!Boolean.TRUE.equals(this.getChartProperty("sparkline"))) {
            this.paintAxisValueLinesAndLabels(g, axisModel, axisLinePos, axisLineX1Pos, axisLineX2Pos, axisLineY1Pos, axisLineY2Pos, axisScale, gridColor);
        }
    }

    private int calculateXAxisAutomaticGap(Rectangle graphArea) {
        int values = this.myXAxisModel.getValueLineCount() + 1;
        double requiredLeftYAxisWidth = this.myYLeftAxisModel != null ? this.getRequiredAxisSpace(this.myYLeftAxisModel) : 0.0;
        double requiredRightYAxisWidth = this.myYRightAxisModel != null ? this.getRequiredAxisSpace(this.myYRightAxisModel) : 0.0;
        double graphAreaEnd = (double)graphArea.width - (double)this.myGraphMargin - this.calculateXAxisExtraSpace() - requiredRightYAxisWidth;
        double graphAreaStart = (double)graphArea.x + requiredLeftYAxisWidth;
        return (int)(graphAreaEnd - graphAreaStart) / values;
    }

    protected void paintGraphBorders(Graphics2D g, Rectangle graphArea) {
        int width = (int)this.myYRightEndX - (int)this.myYLeftStartX + 20;
        if (width > 0) {
            this.myGraphBorder = new Rectangle((int)this.myYLeftStartX - 10, (int)this.myYLeftStartY - 12, width, (int)(this.myYRightEndY - this.myYLeftStartY + 24.0));
            NetUtils.drawCurvedDropShadow(g, (int)this.myYLeftStartX - 7, (int)this.myYRightEndY + 13, width - 6, true);
            NetUtils.drawRoundedRect((Graphics)g, (Color)this.getChartProperty("bordercolor"), this.myGraphBorder.x, this.myGraphBorder.y, this.myGraphBorder.width, this.myGraphBorder.height, 9);
        }
    }

    private void drawAxisEndsDescriptions(Graphics2D g) {
        float yLoc;
        float xLoc;
        Color oldColor = g.getColor();
        g.setColor(ChartConstants.DEFAULT_CHART_AXIS_VALUE_DESCRIPTION_COLOR);
        if (this.myXAxisModel.getStartDescription() != null) {
            GlyphVector startDesc = this.myAxisLabelFont.createGlyphVector(g.getFontRenderContext(), this.myXAxisModel.getStartDescription());
            xLoc = (float)(this.myYLeftStartX - startDesc.getVisualBounds().getWidth() / 2.0);
            yLoc = (float)(this.myYRightEndY + startDesc.getVisualBounds().getHeight() + 12.0 + this.myAxisValueLineLength + (double)NetLookAndFeel.getFontSizeIncrement() + 8.0);
            g.drawGlyphVector(startDesc, xLoc, yLoc);
        }
        if (this.myXAxisModel.getEndDescription() != null) {
            GlyphVector endDesc = this.myAxisLabelFont.createGlyphVector(g.getFontRenderContext(), this.myXAxisModel.getEndDescription());
            xLoc = (float)(this.myYRightEndX - endDesc.getVisualBounds().getWidth() / 2.0);
            yLoc = (float)(this.myYRightEndY + endDesc.getVisualBounds().getHeight() + 12.0 + this.myAxisValueLineLength + (double)NetLookAndFeel.getFontSizeIncrement() + 8.0);
            g.drawGlyphVector(endDesc, xLoc, yLoc);
        }
        g.setColor(oldColor);
    }

    protected void paintAxisValueLabelAndDesc(Graphics2D graphics, AxisModel axisModel, String scaleLabelText, double scaleLineX, double scaleLineY, int axisValueIndex) {
        GlyphVector glyphVector = this.myAxisLabelFont.createGlyphVector(graphics.getFontRenderContext(), scaleLabelText);
        float xLabel = (float)scaleLineX;
        float yLabel = (float)scaleLineY;
        AffineTransform origTransform = graphics.getTransform();
        int rotation = axisModel.getValueLabelOrientation() % 360;
        if (axisModel.getType() == 2) {
            yLabel = (float)((double)yLabel + 8.0);
            yLabel = (float)((double)yLabel + glyphVector.getVisualBounds().getHeight() / 2.0);
            graphics.rotate(Math.toRadians(rotation), xLabel, yLabel);
            yLabel += (float)glyphVector.getVisualBounds().getHeight() / 2.0f;
            if (!(rotation > 20 && rotation < 160 || rotation > 200 && rotation < 340)) {
                xLabel -= (float)glyphVector.getVisualBounds().getWidth() / 2.0f;
            } else if (rotation > 180) {
                xLabel -= (float)glyphVector.getVisualBounds().getWidth();
            }
        } else {
            if (axisModel.equals(this.myYLeftAxisModel)) {
                xLabel = (float)((double)xLabel - 8.0);
                xLabel = (float)((double)xLabel - glyphVector.getVisualBounds().getHeight() / 2.0);
            } else {
                xLabel = (float)((double)xLabel + 8.0);
                xLabel = (float)((double)xLabel + glyphVector.getVisualBounds().getHeight() / 2.0);
            }
            graphics.rotate(Math.toRadians(rotation), xLabel, yLabel);
            yLabel += (float)glyphVector.getVisualBounds().getHeight() / 2.0f;
            if (rotation > 70 && rotation < 110 || rotation > 250 && rotation < 290) {
                xLabel = (float)((double)xLabel - glyphVector.getVisualBounds().getWidth() / 2.0);
            } else if ((rotation < 90 || rotation > 270) && axisModel.equals(this.myYLeftAxisModel)) {
                xLabel = (float)((double)xLabel - glyphVector.getVisualBounds().getWidth());
            } else if (rotation > 90 && rotation < 270 && axisModel.equals(this.myYRightAxisModel)) {
                xLabel = (float)((double)xLabel + glyphVector.getVisualBounds().getWidth());
            }
        }
        Color oldColor = graphics.getColor();
        graphics.setColor(ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_COLOR);
        graphics.drawGlyphVector(glyphVector, xLabel, yLabel);
        graphics.setTransform(origTransform);
        if (axisModel.getValueLabelOrientation() == 0 && axisModel.getValueDescription(axisValueIndex) != null) {
            GlyphVector descVector = this.myAxisLabelFont.createGlyphVector(graphics.getFontRenderContext(), axisModel.getValueDescription(axisValueIndex));
            graphics.setColor(ChartConstants.DEFAULT_CHART_AXIS_VALUE_DESCRIPTION_COLOR);
            graphics.drawGlyphVector(descVector, xLabel, yLabel + 12.0f + (float)NetLookAndFeel.getFontSizeIncrement());
        }
        graphics.setColor(oldColor);
    }

    private void calculateAxisMaxValue() {
        HashMap rendererSeriesMap = new HashMap();
        this.myPriorityArray = new Object[2][this.myChartView.getGraphModels().size()];
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            if (model.isGraphShown()) {
                List<XYSeries> rendererSeries;
                if (rendererSeriesMap.containsKey(model.getGraphRenderer())) {
                    rendererSeries = (List)rendererSeriesMap.get(model.getGraphRenderer());
                    rendererSeries.add(model.toSeries());
                } else {
                    rendererSeries = new ArrayList<XYSeries>();
                    rendererSeries.add(model.toSeries());
                    rendererSeriesMap.put(model.getGraphRenderer(), rendererSeries);
                    AbstractBaseGraphRenderer rend = (AbstractBaseGraphRenderer)model.getGraphRenderer();
                    this.searchPlace(model.getGraphRenderer(), this.getPriority(rend), 0);
                }
            }
            ++i;
        }
        i = this.myChartView.getGraphModels().size() - 1;
        while (i >= 0) {
            if (this.myPriorityArray[1][i] != null) {
                GraphRenderer rend = (GraphRenderer)this.myPriorityArray[1][i];
                rend.setAxisMaxValue((List)rendererSeriesMap.get(rend));
            }
            --i;
        }
    }

    protected void paintGraphs(Graphics2D g) {
        boolean showNoteInTooltip;
        GraphRenderer rend;
        if (this.myHasGraphTooltip) {
            this.myGraphValueTooltips.clear();
            this.myHighlightedAreaToolTips.clear();
        }
        HashMap rendererSeriesMap = new HashMap();
        this.myPriorityArray = new Object[2][this.myChartView.getGraphModels().size()];
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            if (model.isGraphShown()) {
                List<XYSeries> rendererSeries;
                if (rendererSeriesMap.containsKey(model.getGraphRenderer())) {
                    rendererSeries = (List)rendererSeriesMap.get(model.getGraphRenderer());
                    rendererSeries.add(model.toSeries());
                } else {
                    rendererSeries = new ArrayList<XYSeries>();
                    rendererSeries.add(model.toSeries());
                    rendererSeriesMap.put(model.getGraphRenderer(), rendererSeries);
                    rend = (AbstractBaseGraphRenderer)model.getGraphRenderer();
                    this.searchPlace(model.getGraphRenderer(), this.getPriority((AbstractBaseGraphRenderer)rend), 0);
                }
            }
            ++i;
        }
        i = this.myChartView.getGraphModels().size() - 1;
        while (i >= 0) {
            if (this.myPriorityArray[1][i] != null) {
                GraphRenderer rend2 = (GraphRenderer)this.myPriorityArray[1][i];
                rend2.paintGraphs((List)rendererSeriesMap.get(rend2), g, this.myGraphPaintArea);
            }
            --i;
        }
        Iterator iterator = rendererSeriesMap.entrySet().iterator();
        for (Map.Entry entry : rendererSeriesMap.entrySet()) {
            rend = (GraphRenderer)entry.getKey();
            rend.paintThresholds((List)rendererSeriesMap.get(rend), g, this.myGraphPaintArea);
        }
        boolean sparkline = Boolean.TRUE.equals(this.getChartProperty("sparkline"));
        if (!sparkline && !(showNoteInTooltip = Boolean.TRUE.equals(this.getChartProperty("graphnotetooltip")))) {
            this.paintNotes(g);
        }
    }

    protected void paintNotes(Graphics2D g) {
        int i = 0;
        while (i < this.myChartView.getGraphModels().size()) {
            GraphModel model = this.myChartView.getGraphModels().get(i);
            XYSeries series = model.toSeries();
            if (series.getNote() != null) {
                double y;
                double x;
                String note = series.getNote();
                Point notePosition = series.getNotePosition();
                if (notePosition == null) {
                    x = this.getXAxisPositionForValue(series.getHighestXAsNumber()) - 12.0;
                    y = this.getYAxisPositionForValue(series.getHighestYAsNumber(), true);
                } else {
                    x = notePosition.getX() * (double)this.getWidth() / 100.0;
                    y = notePosition.getY() * (double)this.getHeight() / 100.0;
                }
                g.setFont(g.getFont().deriveFont(1));
                int width = SwingUtilities.computeStringWidth(this.getFontMetrics(g.getFont()), note);
                int height = this.getFontMetrics(this.getFont()).getHeight();
                int margin = 4;
                Object oldAa = NetUtils.antiAliasingOn(g);
                int noteTotalWidth = width + 2 * margin + 5;
                double notex = Math.min(x, this.getGraphXEnd() + 36.0 - (double)noteTotalWidth);
                RectangularShape roundRect = NetUtils.getRoundedRect(this, (int)notex - margin - 2, (int)y - height - 12 - margin, noteTotalWidth, height + 2 * margin, 10);
                GradientUtils.drawVerticalGradient((JComponent)this, (Graphics)g, "Balloon.backgroundGradient", (Shape)roundRect);
                PArrowIcon callout = new PArrowIcon(9, 5, (Color)NetLookAndFeel.getBlack(), 5);
                callout.paintIcon(this, g, (int)x + 8, (int)y - 11);
                NetUtils.setAntialiasing(g, oldAa);
                g.setColor(Color.WHITE);
                g.drawString(note, (int)notex, (int)y - height);
            }
            ++i;
        }
    }

    private int getPriority(AbstractBaseGraphRenderer renderer) {
        return renderer.getPriority();
    }

    private void searchPlace(GraphRenderer rend, int x, int index) {
        int y = index;
        while (y < this.myChartView.getGraphModels().size()) {
            if (this.myPriorityArray[0][y] != null) {
                int arrayPriority = (Integer)this.myPriorityArray[0][y];
                if (x < arrayPriority) {
                    GraphRenderer tempRenderer = (GraphRenderer)this.myPriorityArray[1][y];
                    this.myPriorityArray[1][y] = rend;
                    this.myPriorityArray[0][y] = x;
                    this.searchPlace(tempRenderer, arrayPriority, y);
                    y = this.myChartView.getGraphModels().size();
                }
            } else {
                this.myPriorityArray[0][y] = x;
                this.myPriorityArray[1][y] = rend;
                y = this.myChartView.getGraphModels().size();
            }
            ++y;
        }
    }

    private void paintLeftYAxis(Graphics2D graphics, Rectangle graphArea, Color borderColor) {
        if (this.myYLeftAxisModel != null) {
            if (this.paintGraphGrid() && this.myYRightAxisModel == null) {
                this.paintAxisValueLines(graphics, this.myYLeftAxisModel, graphArea, (Color)this.getChartProperty("gridcolor"));
            } else {
                this.paintAxisValueLines(graphics, this.myYLeftAxisModel, graphArea, null);
            }
        } else {
            this.calculateLeftEndLocation(graphArea);
            double x2 = (double)graphArea.x + (double)this.myGraphMargin;
            double y2 = (double)graphArea.height - this.getRequiredAxisSpace(this.myXAxisModel);
            graphics.setColor(borderColor);
            this.myAxisLine.setLine(this.myYLeftStartX, this.myYLeftStartY, x2, y2);
            graphics.draw(this.myAxisLine);
        }
    }

    private void paintRightYAxis(Graphics2D graphics, Rectangle graphArea) {
        if (this.myYRightAxisModel != null) {
            if (this.paintGraphGrid()) {
                this.paintAxisValueLines(graphics, this.myYRightAxisModel, graphArea, (Color)this.getChartProperty("gridcolor"));
            } else {
                this.paintAxisValueLines(graphics, this.myYRightAxisModel, graphArea, null);
            }
        } else {
            this.calculateRightEndLocation(graphArea);
        }
    }

    private void calculateLeftEndLocation(Rectangle graphArea) {
        this.myYLeftStartX = (double)graphArea.x + (double)this.myGraphMargin;
        this.myYLeftStartY = graphArea.y;
    }

    private void calculateRightEndLocation(Rectangle graphArea) {
        double x2 = (Boolean)this.getChartProperty("hideyaxis") != false ? (double)graphArea.width : (this.myXAxisModel.getValueLabelOrientation() != 90 ? (double)graphArea.width - (double)this.myGraphMargin - this.calculateXAxisExtraSpace() : (double)graphArea.width - (double)this.myGraphMargin);
        if (this.isCustomLegendAreaSet()) {
            x2 -= (double)this.myCustomLegendAreaSpaceWidth;
        }
        double y2 = (double)graphArea.height - this.getRequiredAxisSpace(this.myXAxisModel);
        this.myYRightEndX = x2;
        this.myYRightEndY = y2;
        this.mySpaceAdjustedRightX = x2 - (double)this.myAxisEndSpaceAmount;
    }

    private void paintAxisValueLinesAndLabels(Graphics2D graphics, AxisModel axisModel, double axisLinePos, double axisLineX1Pos, double axisLineX2Pos, double axisLineY1Pos, double axisLineY2Pos, double axisScale, Color gridColor) {
        double axisLinePosTemp = axisLinePos;
        int scaleLineIndex = 0;
        int gridVisibility = (Integer)this.myChartView.getChartProperty("gridvisibility");
        Boolean showVerticalAxisLabels = (Boolean)this.myChartView.getChartProperty("showVerticalAxisLabels");
        while (scaleLineIndex < axisModel.getValueLineCount()) {
            String scaleLabelText = axisModel.getAxisValueLabel(scaleLineIndex);
            if (axisModel.getType() == 2) {
                if (gridColor != null && (gridVisibility == 0 || gridVisibility == 2 || gridVisibility == 3)) {
                    this.drawVerticalGridLine(graphics, axisLinePosTemp, axisLineY2Pos, gridColor);
                }
                if (this.myXAxisModel != null && (gridVisibility == 0 || gridVisibility == 2 || gridVisibility == 3)) {
                    if (scaleLabelText != null && this.myUseExtendedValueLines) {
                        this.myAxisLine.setLine(axisLinePosTemp, axisLineY1Pos, axisLinePosTemp, axisLineY2Pos + 3.0);
                        graphics.draw(this.myAxisLine);
                    } else {
                        this.myAxisLine.setLine(axisLinePosTemp, axisLineY1Pos, axisLinePosTemp, axisLineY2Pos);
                        graphics.draw(this.myAxisLine);
                    }
                }
                if (scaleLabelText != null) {
                    this.paintAxisValueLabelAndDesc(graphics, axisModel, scaleLabelText, axisLinePosTemp, axisLineY2Pos, scaleLineIndex);
                }
                axisLinePosTemp += axisScale;
            } else {
                if (gridColor != null && (gridVisibility == 0 || gridVisibility == 1 || scaleLineIndex == 0 && gridVisibility == 3)) {
                    int xOffset = gridVisibility == 3 ? 24 : 0;
                    this.paintHorizontalGridLine(graphics, axisModel, gridColor, xOffset, axisLinePosTemp, axisLineX2Pos);
                }
                if (this.myXAxisModel != null && (gridVisibility == 0 || gridVisibility == 1)) {
                    if (scaleLabelText != null && this.myUseExtendedValueLines) {
                        if (axisModel.equals(this.myYLeftAxisModel)) {
                            this.myAxisLine.setLine(axisLineX1Pos - 3.0, axisLinePosTemp, axisLineX2Pos, axisLinePosTemp);
                            graphics.draw(this.myAxisLine);
                        } else {
                            this.myAxisLine.setLine(axisLineX1Pos, axisLinePosTemp, axisLineX2Pos + 3.0, axisLinePosTemp);
                            graphics.draw(this.myAxisLine);
                        }
                    } else {
                        this.myAxisLine.setLine(axisLineX1Pos, axisLinePosTemp, axisLineX2Pos, axisLinePosTemp);
                        graphics.draw(this.myAxisLine);
                    }
                }
                if (showVerticalAxisLabels.booleanValue() && scaleLabelText != null) {
                    if (axisModel.equals(this.myYLeftAxisModel)) {
                        this.paintAxisValueLabelAndDesc(graphics, axisModel, scaleLabelText, axisLineX1Pos, axisLinePosTemp, scaleLineIndex);
                    } else {
                        this.paintAxisValueLabelAndDesc(graphics, axisModel, scaleLabelText, axisLineX2Pos, axisLinePosTemp, scaleLineIndex);
                    }
                }
                axisLinePosTemp -= axisScale;
            }
            ++scaleLineIndex;
        }
    }

    private void drawVerticalGridLine(Graphics2D graphics, double axisLinePos, double axisLineY2Pos, Color gridColor) {
        Color oldColor = graphics.getColor();
        graphics.setColor(gridColor);
        this.myAxisLine.setLine(axisLinePos, axisLineY2Pos - this.myAxisValueLineLength, axisLinePos, this.myYLeftStartY);
        graphics.draw(this.myAxisLine);
        graphics.setColor(oldColor);
    }

    private void paintHorizontalGridLine(Graphics2D graphics, AxisModel axisModel, Color gridColor, int xOffset, double grapLineYPos, double scaleLineX2Pos) {
        Color oldColor = graphics.getColor();
        graphics.setColor(gridColor);
        double graphLineX1Pos = 0.0;
        double graphLineX2Pos = 0.0;
        if (axisModel.equals(this.myYLeftAxisModel)) {
            graphLineX1Pos = scaleLineX2Pos - (double)xOffset;
            graphLineX2Pos = (double)(this.getGraphArea().width - this.myGraphMargin) - this.calculateXAxisExtraSpace() + (double)xOffset - (double)this.myCustomLegendAreaSpaceWidth;
        } else {
            graphLineX1Pos = this.myYLeftStartX;
            graphLineX2Pos = this.myYRightEndX;
        }
        this.myAxisLine.setLine(graphLineX1Pos, grapLineYPos, graphLineX2Pos, grapLineYPos);
        graphics.draw(this.myAxisLine);
        graphics.setColor(oldColor);
    }

    private Rectangle getGraphArea() {
        Rectangle area = new Rectangle();
        area.x = this.myGraphMargin;
        double yLeftMaxHeight = -1.0;
        double yRightMaxHeight = -1.0;
        boolean leftChanged = false;
        boolean rightChanged = false;
        if (this.myYLeftAxisModel != null && this.myYLeftAxisModel.getValueLabelOrientation() != 0) {
            yLeftMaxHeight = this.getRequiredAxisSpace(this.myYLeftAxisModel) / 2.0;
            leftChanged = true;
        }
        if (this.myYRightAxisModel != null && this.myYRightAxisModel.getValueLabelOrientation() != 0) {
            yRightMaxHeight = this.getRequiredAxisSpace(this.myYRightAxisModel) / 2.0;
            rightChanged = true;
        }
        area.y = !leftChanged && !rightChanged ? this.myGraphMargin : (yLeftMaxHeight > yRightMaxHeight ? this.myGraphMargin + (int)yLeftMaxHeight : this.myGraphMargin + (int)yRightMaxHeight);
        boolean sparkline = Boolean.TRUE.equals(this.getChartProperty("sparkline"));
        area.width = this.getWidth() - (sparkline ? 2 : 12);
        area.height = this.getHeight() - (sparkline ? 2 : 15);
        return area;
    }

    @Override
    public Color getBackground() {
        return super.getBackground() != null ? super.getBackground() : NetUtils.decodeColor("#EBEBEB");
    }

    private double getRequiredAxisSpace(AxisModel axisModel) {
        if (axisModel.getType() == 2 && ((Boolean)this.getChartProperty("hidexaxis")).booleanValue()) {
            return 0.0;
        }
        if ((axisModel.getType() == 0 || axisModel.getType() == 1) && ((Boolean)this.getChartProperty("hideyaxis")).booleanValue()) {
            return 0.0;
        }
        double reqSpace = this.myAxisValueLineLength;
        if (axisModel.getType() == 2 || Boolean.TRUE.equals(this.getChartProperty("showVerticalAxisLabels"))) {
            Object prototypeValue = this.getChartProperty("yaxisprototypevalue");
            reqSpace += axisModel.getRequiredAxisValueLabelSize(this.getFontMetrics(this.myAxisLabelFont), prototypeValue);
        }
        if (((Boolean)this.getChartProperty("longlineforlabel")).booleanValue()) {
            reqSpace += 3.0;
        }
        return reqSpace;
    }

    private boolean paintGraphGrid() {
        Object gridColor = this.getChartProperty("gridcolor");
        if (gridColor != null) {
            if (this.myYLeftAxisModel != null && this.myYRightAxisModel != null) {
                return this.myYLeftAxisModel.getValueLineCount() == this.myYRightAxisModel.getValueLineCount();
            }
            return true;
        }
        return false;
    }

    private double calculateXAxisExtraSpace() {
        double space = 0.0;
        FontMetrics fm = this.getFontMetrics(this.myAxisLabelFont);
        if (this.myXAxisModel.getValueLabelOrientation() != 90) {
            Object prototypeValue = this.getChartProperty("yaxisprototypevalue");
            space = this.myXAxisModel.getRequiredAxisValueLabelSize(fm, prototypeValue);
        }
        return space;
    }

    protected Rectangle calculateBackgroundGridArea(Rectangle graphArea) {
        double requiredXAxisHeight = this.getRequiredAxisSpace(this.myXAxisModel);
        double requiredLeftYAxisWidth = this.getRequiredAxisSpace(this.myYLeftAxisModel);
        double leftX = (double)graphArea.x + requiredLeftYAxisWidth;
        double leftY = graphArea.y;
        double width = this.myYRightEndX - leftX;
        double height = (double)graphArea.height - leftY - requiredXAxisHeight;
        return new Rectangle((int)leftX, (int)leftY, (int)width, (int)height);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGraphView();
        }
        return this.accessibleContext;
    }

    @Override
    public void infoTipWillBecomeInvisible(InfoTipEvent event) {
    }

    @Override
    public boolean infoTipWillBecomeVisible(InfoTipEvent event) {
        if (!this.myHasGraphTooltip) {
            return false;
        }
        Point mousePoint = event.getMouseLocation();
        for (Shape graphShape : this.myGraphValueTooltips.keySet()) {
            if (!graphShape.contains(mousePoint.x, mousePoint.y)) continue;
            ((JLabel)this.myInfoTip.getTipContent()).setText(this.myGraphValueTooltips.get(graphShape).toString());
            return true;
        }
        Iterator<Shape> i = this.myHighlightedAreaToolTips.keySet().iterator();
        if (((Boolean)this.getChartProperty("ShowHighLight")).booleanValue()) {
            while (i.hasNext()) {
                Shape graphShape = i.next();
                if (!graphShape.contains(mousePoint.x, mousePoint.y)) continue;
                ((JLabel)this.myInfoTip.getTipContent()).setText(this.myHighlightedAreaToolTips.get(graphShape).toString());
                return true;
            }
        }
        return false;
    }

    public class AccessibleGraphView
    extends JComponent.AccessibleJComponent {
        public AccessibleGraphView() {
            super(GraphView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CANVAS;
        }
    }

    protected class GraphPaintArea
    implements GraphArea {
        protected GraphPaintArea() {
        }

        @Override
        public Rectangle getBounds() {
            return GraphView.this.calculateBackgroundGridArea(GraphView.this.getGraphArea());
        }

        @Override
        public double getXAxisPositionForValue(Object value) {
            return GraphView.this.getXAxisPositionForValue(value);
        }

        @Override
        public double getLeftYAxisPositionForValue(Object value) {
            return GraphView.this.getYAxisPositionForValue(value, true);
        }

        @Override
        public double getRightYAxisPositionForValue(Object value) {
            return GraphView.this.getYAxisPositionForValue(value, false);
        }

        @Override
        public double getAdjustedGraphXStart() {
            return GraphView.this.getAdjustedGraphXStart();
        }

        @Override
        public double getAdjustedGraphXEnd() {
            return GraphView.this.getAdjustedGraphXEnd();
        }

        @Override
        public void addToolTip(Shape area, String toolTip) {
            GraphView.this.addValueTooltip(area, toolTip);
        }

        @Override
        public void removeToolTips() {
            GraphView.this.myGraphValueTooltips.clear();
            GraphView.this.myHighlightedAreaToolTips.clear();
            GraphView.this.repaint();
        }

        @Override
        public void addHighlightToolTip(Object start, Object end, String toolTip) {
            GraphView.this.addHighLightToolTip(start, end, toolTip);
        }

        public List<AxisModel.HighlightedDataArea> getHighLightedAreas() {
            return GraphView.this.myXAxisModel.getHighLightedData();
        }
    }
}

