/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.text.DecimalFormat;
import java.util.Random;

public class PieSlice {
    private static final String STRING_DECIMAL_FORMAT = "#.##%";
    private double myValue;
    private Color myPrimaryColor;
    private Color myGradientColor;
    private Color myDefaultPrimaryColor;
    private Color myDefaultGradientColor;
    private Color myRollOverColor;
    private Polygon myPolygonSlice;
    private int myStartAngle;
    private int myArcAngle;
    private String myLabel;
    private double myPercentValue;

    public PieSlice(double value, String label, Color primaryColor, Color gradientColor) {
        this.myValue = value;
        this.myLabel = label;
        this.myArcAngle = -1;
        this.myStartAngle = -1;
        this.myRollOverColor = new Color(0, 0, 0, 0);
        this.myDefaultPrimaryColor = this.myPrimaryColor = primaryColor == null ? this.randomizePieColor() : primaryColor;
        this.myDefaultGradientColor = this.myGradientColor = gradientColor == null ? NetUtils.darker(primaryColor, 0.85) : gradientColor;
    }

    public double getValue() {
        return this.myValue;
    }

    public Color getPrimaryColor() {
        return this.myPrimaryColor;
    }

    public Color getGradientColor() {
        return this.myGradientColor;
    }

    public Color getRollOverColor() {
        return this.myRollOverColor;
    }

    public Polygon getPolygonSlice() {
        return this.myPolygonSlice;
    }

    public void setPolygonSlice(Polygon polygonSlice) {
        this.myPolygonSlice = polygonSlice;
    }

    public boolean isInside(Point locationOnScreen) {
        return this.myPolygonSlice.contains(locationOnScreen);
    }

    public void doMouseEntered() {
        this.myPrimaryColor = NetUtils.brighter(this.myPrimaryColor, 0.85);
        this.myGradientColor = NetUtils.brighter(this.myGradientColor, 0.85);
        this.myRollOverColor = NetTheme.getHoverColor();
    }

    public void doMouseExit() {
        this.myPrimaryColor = this.myDefaultPrimaryColor;
        this.myGradientColor = this.myDefaultGradientColor;
        this.myRollOverColor = new Color(0, 0, 0, 0);
    }

    public void setStartAngle(int startAngle) {
        this.myStartAngle = startAngle;
    }

    public void setArcAngle(int arcAngle) {
        this.myArcAngle = arcAngle;
    }

    public int getStartAngle() {
        return this.myStartAngle;
    }

    public int getArcAngle() {
        return this.myArcAngle;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getPercentString() {
        DecimalFormat df = new DecimalFormat(STRING_DECIMAL_FORMAT);
        return df.format(this.myPercentValue);
    }

    public double getPercentValue() {
        return this.myPercentValue;
    }

    public Color randomizePieColor() {
        Random r = new Random(System.currentTimeMillis() + (long)this.myLabel.hashCode());
        return new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255));
    }

    public void setPercentage(double percentValue) {
        this.myPercentValue = percentValue;
    }
}

