/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.impl;

import com.nokia.widgets.chart.impl.VerticalLabel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    private static final VerticalLabelUI verticalLabelUI = new VerticalLabelUI();
    private static Rectangle theIconArea = new Rectangle();
    private static Rectangle theTextArea = new Rectangle();
    private static Rectangle theViewArea = new Rectangle();
    private static Insets theViewInsets = new Insets(0, 0, 0, 0);

    @Override
    public Dimension getPreferredSize(JComponent comp) {
        Dimension dim = super.getPreferredSize(comp);
        return new Dimension(dim.height, dim.width);
    }

    public static ComponentUI createUI(JComponent c) {
        return verticalLabelUI;
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        Icon icon;
        JLabel label = (JLabel)component;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = graphics.getFontMetrics();
        theViewInsets = component.getInsets(theViewInsets);
        VerticalLabelUI.theViewArea.x = VerticalLabelUI.theViewInsets.left;
        VerticalLabelUI.theViewArea.y = VerticalLabelUI.theViewInsets.top;
        VerticalLabelUI.theViewArea.height = component.getWidth() - (VerticalLabelUI.theViewInsets.left + VerticalLabelUI.theViewInsets.right);
        VerticalLabelUI.theViewArea.width = component.getHeight() - (VerticalLabelUI.theViewInsets.top + VerticalLabelUI.theViewInsets.bottom);
        VerticalLabelUI.theIconArea.height = 0;
        VerticalLabelUI.theIconArea.width = 0;
        VerticalLabelUI.theIconArea.y = 0;
        VerticalLabelUI.theIconArea.x = 0;
        VerticalLabelUI.theTextArea.height = 0;
        VerticalLabelUI.theTextArea.width = 0;
        VerticalLabelUI.theTextArea.y = 0;
        VerticalLabelUI.theTextArea.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, theViewArea, theIconArea, theTextArea);
        Graphics2D g2 = (Graphics2D)graphics;
        AffineTransform tr = g2.getTransform();
        if (((VerticalLabel)component).isClockwise()) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -component.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-component.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(component, graphics, VerticalLabelUI.theIconArea.x, VerticalLabelUI.theIconArea.y);
        }
        if (text != null) {
            int textX = VerticalLabelUI.theTextArea.x;
            int textY = VerticalLabelUI.theTextArea.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, graphics, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, graphics, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }
}

