/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.GraphRenderer;
import com.nokia.widgets.chart.ValuePointModel;
import com.nokia.widgets.chart.ValuePointRenderer;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.renderers.ChartTooltipFormatter;
import com.nokia.widgets.util.SystemUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.InternationalFormatter;

public abstract class AbstractBaseGraphRenderer
implements GraphRenderer {
    protected Chart myChart;
    protected Map<XYSeries, List<Point>> myXYSeriesToValuePoints;
    protected int myDrawPriority = 5;
    private static Stroke theDashedStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{5.0f}, 0.0f);
    private Line2D.Double myThresholdLine = new Line2D.Double();
    private boolean myShowTooltips;
    protected ChartTooltipFormatter myTooltipFormatter;

    @Override
    public void init(Chart chart) {
        this.myChart = chart;
        this.myTooltipFormatter = new ChartTooltipFormatter(this.myChart);
        this.myXYSeriesToValuePoints = new HashMap<XYSeries, List<Point>>();
        this.myShowTooltips = (Boolean)this.myChart.getProperty("graphtooltip");
    }

    protected boolean hasTooltips() {
        return this.myShowTooltips;
    }

    protected void paintHighLightData(GraphArea graphArea) {
        Axis xAxis;
        if (this.hasTooltips() && (xAxis = this.myChart.getAxis(2)).getHighLightedData() != null && ((Boolean)this.myChart.getProperty("ShowHighLight")).booleanValue()) {
            int x = 0;
            while (x < xAxis.getHighLightedData().size()) {
                AxisModel.HighlightedDataArea highlightedDataArea = xAxis.getHighLightedData().get(x);
                String descriptionText = (String)this.myChart.getProperty("HighLightToolTipKey");
                if (highlightedDataArea.getStartMarker() != null && highlightedDataArea.getStartMarker().getDescription() != null) {
                    descriptionText = highlightedDataArea.getStartMarker().getDescription().toString();
                }
                String ttText = this.getFormattedTooltipText(xAxis, highlightedDataArea, descriptionText);
                graphArea.addHighlightToolTip(highlightedDataArea.getStartObj(), highlightedDataArea.getEndObj(), ttText);
                ++x;
            }
        }
    }

    private String getFormattedTooltipText(Axis xAxis, AxisModel.HighlightedDataArea highlightedDataArea, String descriptionText) {
        InternationalFormatter formatter = xAxis.getDataFormatter();
        if (formatter != null) {
            try {
                return String.format("%s: %s...%s", descriptionText, formatter.valueToString(highlightedDataArea.getStartObj()), formatter.valueToString(highlightedDataArea.getEndObj()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return String.format("%s: %s...%s", descriptionText, highlightedDataArea.getStartObj(), highlightedDataArea.getEndObj());
    }

    protected void paintStaticValuePointLabel(List<XYSeries> xySeries, Graphics2D graphics) {
        if (((Boolean)this.myChart.getProperty("graphvaluepointlabel")).booleanValue()) {
            for (XYSeries key : this.myXYSeriesToValuePoints.keySet()) {
                this.paintValuePointLabel(key, this.myXYSeriesToValuePoints.get(key), graphics);
            }
        }
    }

    protected void paintValuePointLabel(XYSeries xySeries, List<Point> valuePoints, Graphics2D graphics) {
        ValuePointModel vpModel = xySeries.getValuePointModel() != null ? xySeries.getValuePointModel() : (ValuePointModel)this.myChart.getProperty("graphvaluepointlabelmodel");
        ValuePointRenderer valuePointRenderer = (ValuePointRenderer)this.myChart.getProperty("graphvaluepointlabelrenderer");
        Color oldColor = graphics.getColor();
        graphics.setColor(xySeries.getColor());
        int i = 0;
        while (i < valuePoints.size()) {
            Point point = valuePoints.get(i);
            valuePointRenderer.paintValuePointLabel(xySeries.getXYPairs().get(i), graphics, (int)point.getX(), (int)point.getY(), vpModel);
            ++i;
        }
        graphics.setColor(oldColor);
    }

    public int getPriority() {
        return this.myDrawPriority;
    }

    @Override
    public void paintThresholds(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        int i = 0;
        while (i < xySeries.size()) {
            XYSeries series = xySeries.get(i);
            if (series.getThresholdValue() != null) {
                int height;
                graphics.setColor(series.getThresholdColor() != null ? series.getThresholdColor() : series.getColor());
                if (series.getThresholdValue() instanceof Object[]) {
                    return;
                }
                double yPos = series.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(series.getThresholdValue()) : graphArea.getRightYAxisPositionForValue(series.getThresholdValue());
                if (!SystemUtils.isEqual(yPos, height = graphArea.getBounds().y + graphArea.getBounds().height)) {
                    Stroke oldStroke = graphics.getStroke();
                    graphics.setStroke(theDashedStroke);
                    this.myThresholdLine.setLine(graphArea.getBounds().x, yPos, graphArea.getBounds().x + graphArea.getBounds().width, yPos);
                    graphics.draw(this.myThresholdLine);
                    graphics.setStroke(oldStroke);
                }
            }
            ++i;
        }
    }

    @Override
    public void setAxisMaxValue(List<XYSeries> xySeries) {
    }
}

