/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import java.awt.Rectangle;
import java.util.Date;
import java.util.List;

public abstract class AbstractColumnGraphRenderer
extends AbstractBaseGraphRenderer {
    public double getPreferredColumnWidth(Object[] xValues, GraphArea graphArea) {
        return this.doGetPreferredColumnWidth(xValues, graphArea, graphArea.getBounds().width, graphArea.getAdjustedGraphXStart());
    }

    private double doGetPreferredColumnWidth(Object[] xValues, Object graphArea, double width, double startX) {
        Object value = null;
        double retVal = 0.0;
        if (xValues.length > 0) {
            value = xValues[0];
        }
        double density = 0.0;
        boolean isValueDiffConstant = false;
        if (value instanceof Number) {
            density = this.getSampleDensityForNumber(xValues);
        } else if (value instanceof Date) {
            density = this.getSampleDensityForDate(xValues);
        } else {
            isValueDiffConstant = true;
        }
        double columnWidthPct = (Double)this.myChart.getProperty("columnwidthpct");
        if (this.myChart.getAxis(2).getValues() != null || isValueDiffConstant) {
            retVal = Math.floor((width - startX) / Math.max((double)(xValues.length - 1), 1.0) * columnWidthPct);
        } else {
            double pixelsPerAxisUnit = 0.0;
            pixelsPerAxisUnit = graphArea instanceof Rectangle ? this.getPixelsPerXAxisUnit((Rectangle)graphArea) : this.getPixelsPerXAxisUnit(((GraphArea)graphArea).getBounds());
            retVal = Math.floor(density * pixelsPerAxisUnit * columnWidthPct);
        }
        retVal = this.limitFromAbove(retVal);
        retVal = this.limitFromBelow(retVal);
        return retVal;
    }

    protected double limitFromBelow(double columnWidth) {
        return columnWidth < 8.0 ? 8.0 : columnWidth;
    }

    protected double limitFromAbove(double columnWidth) {
        return columnWidth > 60.0 ? 60.0 : columnWidth;
    }

    public double getPreferredColumnWidth(Object[] xValues, Rectangle graphArea) {
        return this.doGetPreferredColumnWidth(xValues, graphArea, graphArea.width, graphArea.x);
    }

    private double getPixelsPerXAxisUnit(Rectangle graphArea) {
        Object maxValue;
        Object minValue;
        double axisLength = graphArea.getBounds().width;
        List<?> values = this.myChart.getAxis(2).getValues();
        if (values != null && values.size() > 0) {
            minValue = values.get(0);
            maxValue = values.get(values.size() - 1);
        } else {
            minValue = this.myChart.getAxis(2).getMinValue();
            maxValue = this.myChart.getAxis(2).getMaxValue();
        }
        if (minValue != null && maxValue != null) {
            if (minValue instanceof Number && maxValue instanceof Number) {
                Number minNumber = (Number)minValue;
                Number maxNumber = (Number)maxValue;
                double valueArea = maxNumber.doubleValue() - minNumber.doubleValue();
                return axisLength / valueArea;
            }
            if (minValue instanceof Date && maxValue instanceof Date) {
                Date minDate = (Date)minValue;
                Date maxDate = (Date)maxValue;
                double valueArea = maxDate.getTime() - minDate.getTime();
                return axisLength / valueArea;
            }
        }
        throw new IllegalStateException("Cannot calculate pixels per unit rate due to incompatible axis value data");
    }

    private double getSampleDensityForNumber(Object[] xValues) {
        double difference = 0.0;
        int i = 0;
        while (i + 1 < xValues.length) {
            double value1 = ((Number)xValues[i]).doubleValue();
            double value2 = ((Number)xValues[i + 1]).doubleValue();
            double valueMargin = Math.abs(value2 - value1);
            if (i == 0 || valueMargin < difference) {
                difference = valueMargin;
            }
            ++i;
        }
        return difference;
    }

    private double getSampleDensityForDate(Object[] xValues) {
        double difference = 0.0;
        int i = 0;
        while (i + 1 < xValues.length) {
            long value1 = ((Date)xValues[i]).getTime();
            long value2 = ((Date)xValues[i + 1]).getTime();
            double valueMargin = Math.abs(value2 - value1);
            if (i == 0 || valueMargin < difference) {
                difference = valueMargin;
            }
            ++i;
        }
        return difference;
    }
}

