/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisFactory;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

public class CascadedAreaGraphRenderer
extends AbstractBaseGraphRenderer {
    private Polygon myStackedArea = new Polygon();
    private int[][] originAxisPosition;
    private double[] cascadeNumber;
    private double[] negativeCascadeNumbers;
    private boolean myContainsPosNegValues = false;

    protected void updatePolygonPoints(XYSeries series, GraphArea area) {
        int i;
        this.myStackedArea.reset();
        int x = 0;
        int y = 0;
        Object xValue = null;
        Double yValue = null;
        if (this.cascadeNumber == null) {
            this.cascadeNumber = new double[series.getXYPairsCount()];
            this.negativeCascadeNumbers = new double[series.getXYPairsCount()];
            this.originAxisPosition = series.getXYPairsCount() == 1 ? new int[2][2] : new int[series.getXYPairsCount()][2];
            int polygonCornerY = (int)area.getLeftYAxisPositionForValue(0.0);
            if (x - area.getBounds().x < area.getBounds().x + area.getBounds().width - x) {
                this.myStackedArea.addPoint(area.getBounds().x + area.getBounds().width, polygonCornerY);
                this.myStackedArea.addPoint(area.getBounds().x + 1, polygonCornerY);
            } else {
                this.myStackedArea.addPoint(area.getBounds().x + 1, polygonCornerY);
                this.myStackedArea.addPoint(area.getBounds().x + area.getBounds().width, polygonCornerY);
            }
        } else {
            i = this.originAxisPosition.length - 1;
            while (i >= 0) {
                this.myStackedArea.addPoint(this.originAxisPosition[i][0], this.originAxisPosition[i][1]);
                --i;
            }
        }
        i = 0;
        while (i < series.getXYPairsCount()) {
            xValue = series.getXValues().get(i);
            Object value = series.getYValues().get(i);
            boolean isValueNegative = false;
            if (value instanceof Number) {
                double tempValue = ((Number)value).doubleValue();
                if (SystemUtils.isEqual(tempValue, ChartConstants.VALUE_NOT_DEFINED)) {
                    tempValue = 0.0;
                }
                if (tempValue >= 0.0) {
                    int n = i;
                    this.cascadeNumber[n] = this.cascadeNumber[n] + tempValue;
                } else {
                    int n = i;
                    this.negativeCascadeNumbers[n] = this.negativeCascadeNumbers[n] + tempValue;
                    isValueNegative = true;
                }
            }
            yValue = !isValueNegative ? Double.valueOf(this.cascadeNumber[i]) : Double.valueOf(this.negativeCascadeNumbers[i]);
            x = (int)area.getXAxisPositionForValue(xValue);
            if (x == area.getBounds().x) {
                ++x;
            }
            y = (int)area.getLeftYAxisPositionForValue(yValue);
            this.myStackedArea.addPoint(x, y);
            this.originAxisPosition[i][0] = x;
            this.originAxisPosition[i][1] = y;
            if (series.getXYPairsCount() == 1) {
                this.myStackedArea.addPoint(area.getBounds().x + area.getBounds().width, y);
                this.originAxisPosition[1][0] = area.getBounds().x + area.getBounds().width;
                this.originAxisPosition[1][1] = y;
            }
            ++i;
        }
    }

    public void initCascadeNumber() {
        this.cascadeNumber = null;
        this.originAxisPosition = null;
    }

    @Override
    public void init(Chart chart) {
        this.initCascadeNumber();
        super.init(chart);
        this.myDrawPriority = 10;
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = img.createGraphics();
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(xySeries.getColor());
        Polygon stackedArea = new Polygon();
        stackedArea.addPoint(0, (int)((double)size.height * 0.75));
        stackedArea.addPoint(0, (int)((double)size.height * 0.5));
        stackedArea.addPoint(size.width / 2, (int)((double)size.height * 0.25));
        stackedArea.addPoint(size.width, (int)((double)size.height * 0.5));
        stackedArea.addPoint(size.width, (int)((double)size.height * 0.75));
        g.drawPolygon(stackedArea);
        g.fillPolygon(stackedArea);
        NetUtils.setAntialiasing(g, oldAa);
        return img;
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D g, GraphArea graphArea) {
        this.cascadeNumber = null;
        this.paintHighLightData(graphArea);
        this.setAxisMaxValue(xySeries);
        int x = 0;
        while (x < xySeries.size()) {
            XYSeries singleSeries = xySeries.get(x);
            this.updatePolygonPoints(singleSeries, graphArea);
            Color areaBorderColor = (Color)this.myChart.getProperty("stackedareacolor");
            if (areaBorderColor != null) {
                g.setColor(areaBorderColor);
                g.draw(this.myStackedArea);
            }
            Color color = xySeries.get(x).getColor();
            if (this.myChart.getProperty("gradientpaint") == Boolean.TRUE) {
                Rectangle b = this.myStackedArea.getBounds();
                GradientPaint gp = new GradientPaint(0.0f, b.y, singleSeries.getColor(), 0.0f, b.y + b.height, color.brighter().brighter());
                g.setPaint(gp);
            } else {
                g.setColor(singleSeries.getColor());
            }
            g.fill(this.myStackedArea);
            ++x;
        }
    }

    @Override
    public void paintThresholds(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
    }

    @Override
    public void setAxisMaxValue(List<XYSeries> xySeries) {
        boolean positiveAndNegativeValues;
        int seriesSize = xySeries.get(0).getXYPairsCount();
        Object[] cascadedPositiveValues = new Object[seriesSize];
        Object[] cascadedNegativeValues = new Object[seriesSize];
        boolean containsPositiveValues = false;
        boolean containsNegativeValues = false;
        for (XYSeries series : xySeries) {
            int i = 0;
            while (i < seriesSize) {
                Number yValue;
                if (series.getLastPair().isYFloatingPointNumber()) {
                    yValue = Double.parseDouble(series.getYValues().get(i).toString());
                    if (SystemUtils.isEqual((Double)yValue, ChartConstants.VALUE_NOT_DEFINED)) {
                        yValue = 0.0;
                    }
                    if ((Double)yValue >= 0.0) {
                        cascadedPositiveValues[i] = cascadedPositiveValues[i] != null ? (Number)((Double)yValue + (Double)cascadedPositiveValues[i]) : (Number)yValue;
                        if (cascadedNegativeValues[i] == null) {
                            cascadedNegativeValues[i] = 0.0;
                        }
                        containsPositiveValues = true;
                    } else {
                        cascadedNegativeValues[i] = cascadedNegativeValues[i] != null ? (Number)((Double)yValue + (Double)cascadedNegativeValues[i]) : (Number)yValue;
                        if (cascadedPositiveValues[i] == null) {
                            cascadedPositiveValues[i] = 0.0;
                        }
                        containsNegativeValues = true;
                    }
                } else if (series.getLastPair().isYIntegerNumber()) {
                    yValue = Long.parseLong(series.getYValues().get(i).toString());
                    if ((Long)yValue >= 0L) {
                        cascadedPositiveValues[i] = cascadedPositiveValues[i] != null ? (Number)((Long)yValue + (Long)cascadedPositiveValues[i]) : (Number)yValue;
                        if (cascadedNegativeValues[i] == null) {
                            cascadedNegativeValues[i] = 0L;
                        }
                        containsPositiveValues = true;
                    } else {
                        cascadedNegativeValues[i] = cascadedNegativeValues[i] != null ? (Number)((Long)yValue + (Long)cascadedNegativeValues[i]) : (Number)yValue;
                        if (cascadedPositiveValues[i] == null) {
                            cascadedPositiveValues[i] = 0L;
                        }
                        containsNegativeValues = true;
                    }
                }
                ++i;
            }
        }
        BigDecimal maxValue = null;
        BigDecimal minValue = null;
        boolean bl = positiveAndNegativeValues = containsPositiveValues && containsNegativeValues;
        if (positiveAndNegativeValues) {
            Arrays.sort(cascadedPositiveValues);
            Arrays.sort(cascadedNegativeValues);
            BigDecimal absNegativeMinValue = new BigDecimal(cascadedNegativeValues[0].toString()).abs();
            BigDecimal maxBDValue = new BigDecimal(cascadedPositiveValues[cascadedPositiveValues.length - 1].toString());
            maxValue = maxBDValue.max(absNegativeMinValue);
            minValue = maxValue.negate();
            this.myContainsPosNegValues = true;
        } else if (containsPositiveValues) {
            Arrays.sort(cascadedPositiveValues);
            maxValue = new BigDecimal(cascadedPositiveValues[cascadedPositiveValues.length - 1].toString());
            minValue = new BigDecimal(cascadedNegativeValues[0].toString());
        } else {
            Arrays.sort(cascadedNegativeValues);
            minValue = new BigDecimal(cascadedNegativeValues[0].toString());
            maxValue = new BigDecimal(cascadedPositiveValues[0].toString());
        }
        Axis axis = this.myChart.getAxis(0);
        ((AxisModel)axis).blockListenerUpdates(true);
        if (maxValue.compareTo(new BigDecimal(0)) == 0) {
            axis.setMaxValue(new Double(0.0));
        } else {
            axis.setMaxValue(AxisFactory.calculateAxisMaxValue(axis, !positiveAndNegativeValues, maxValue));
        }
        if (minValue.compareTo(new BigDecimal(0)) == 0) {
            axis.setMinValue(new Double(0.0));
        } else {
            axis.setMinValue(-AxisFactory.calculateAxisMaxValue(axis, !positiveAndNegativeValues, minValue.abs()).doubleValue());
        }
        if (this.myContainsPosNegValues && axis.getValueLineCount() % 2 == 0) {
            axis.setValueLineCount(axis.getValueLineCount() + 1);
        }
        ((AxisModel)axis).blockListenerUpdates(false);
    }
}

