/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.GradientUtils;
import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.AxisFactory;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.AxisModel;
import com.nokia.widgets.chart.impl.ChartColumn;
import com.nokia.widgets.chart.renderers.AbstractColumnGraphRenderer;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class CascadedColumnGraphRenderer
extends AbstractColumnGraphRenderer {
    private List<ChartColumn> myLastPositiveColumns;
    private List<ChartColumn> myLastNegativeColumns;
    private List<List<ChartColumn>> myColumnGroups = new ArrayList<List<ChartColumn>>();
    boolean myContainsPosNegValues = false;

    public CascadedColumnGraphRenderer() {
        this.myLastNegativeColumns = new ArrayList<ChartColumn>();
        this.myLastPositiveColumns = new ArrayList<ChartColumn>();
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(xySeries.getColor());
        int rectWidth = size.width;
        int rectHeight = size.height / 2;
        int posY = size.height / 2 - rectHeight / 2;
        g.fillRect(0, posY, rectWidth, rectHeight);
        return img;
    }

    @Override
    public void init(Chart chart) {
        super.init(chart);
        this.myDrawPriority = 6;
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        this.resetLists();
        if (this.myChart.getAxis(2).getHighLightedData() != null) {
            int x = 0;
            while (x < this.myChart.getAxis(2).getHighLightedData().size()) {
                AxisModel.HighlightedDataArea s = this.myChart.getAxis(2).getHighLightedData().get(x);
                String ttText = String.valueOf((String)this.myChart.getProperty("HighLightToolTipKey")) + ": " + s.getStartObj() + " - " + s.getEndObj();
                graphArea.addHighlightToolTip(s.getStartObj(), s.getEndObj(), ttText);
                ++x;
            }
        }
        this.setAxisMaxValue(xySeries);
        double zero = graphArea.getLeftYAxisPositionForValue(0.0);
        this.createColumnList(xySeries, graphArea, zero);
        this.paintGraphColumn(graphics, graphArea, zero);
    }

    private void resetLists() {
        this.myColumnGroups.clear();
        this.myLastNegativeColumns.clear();
        this.myLastPositiveColumns.clear();
    }

    private void createColumnList(List<XYSeries> xySeries, GraphArea graphArea, double zero) {
        double preferredColumnWidth = this.getPreferredColumnWidth(xySeries.get(0).getXValues().toArray(), graphArea);
        for (XYSeries series : xySeries) {
            int pairSize = series.getXYPairsCount();
            List<XYPair> pairList = series.getXYPairs();
            int index = 0;
            while (index < pairSize) {
                double yPos;
                XYPair pair = pairList.get(index);
                ChartColumn column = new ChartColumn(this.myChart, pair, series, preferredColumnWidth, graphArea, zero);
                if (index == this.myColumnGroups.size()) {
                    this.myColumnGroups.add(index, new ArrayList());
                }
                this.myColumnGroups.get(index).add(column);
                if (index == this.myLastNegativeColumns.size() || index == this.myLastPositiveColumns.size()) {
                    this.myLastNegativeColumns.add(column);
                    this.myLastPositiveColumns.add(column);
                }
                if ((yPos = column.getYPos()) > zero) {
                    this.myLastNegativeColumns.set(index, column);
                } else {
                    this.myLastPositiveColumns.set(index, column);
                }
                ++index;
            }
        }
    }

    @Override
    public void paintThresholds(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
    }

    protected void paintGraphColumn(Graphics2D g, GraphArea area, double zero) {
        Color borderColor = (Color)this.myChart.getProperty("columnbordercolor");
        boolean hasTooltips = Boolean.parseBoolean(this.myChart.getProperty("graphtooltip").toString());
        Area columnArea = null;
        Rectangle2D.Double clip = new Rectangle2D.Double();
        int groupIndex = 0;
        while (groupIndex < this.myColumnGroups.size()) {
            List<ChartColumn> columnGroup = this.myColumnGroups.get(groupIndex);
            double xPos = columnGroup.get(0).getXPos();
            RectangularShape columnShape = null;
            double previousNegValues = 0.0;
            double previousValues = 0.0;
            int columnIndex = 0;
            while (columnIndex < columnGroup.size()) {
                ChartColumn column = columnGroup.get(columnIndex);
                double width = column.getWidth();
                double radius = ChartColumn.getCornerRadius(width);
                double yPos = column.getYPos();
                double height = zero - yPos;
                if (height < 0.0) {
                    Area negClip;
                    if (this.myContainsPosNegValues) {
                        if (this.myLastNegativeColumns.get(groupIndex).equals(column)) {
                            columnShape = new RoundRectangle2D.Double(xPos, zero - previousNegValues - radius, width, yPos - zero + radius, radius, radius);
                            columnArea = new Area(columnShape);
                            ((Rectangle2D)clip).setRect(xPos, zero - previousNegValues - radius, width, radius);
                            negClip = new Area(clip);
                            columnArea.subtract(negClip);
                        } else {
                            columnShape = new Rectangle2D.Double(xPos, zero - previousNegValues, width, yPos - zero);
                            columnArea = new Area(columnShape);
                        }
                        previousNegValues -= yPos - zero;
                    } else {
                        if (this.myLastNegativeColumns.get(groupIndex).equals(column)) {
                            columnShape = new RoundRectangle2D.Double(xPos, zero - previousValues - radius, width, yPos - zero + radius, radius, radius);
                            columnArea = new Area(columnShape);
                            ((Rectangle2D)clip).setRect(xPos, zero - previousNegValues - radius, width, radius);
                            negClip = new Area(clip);
                            columnArea.subtract(negClip);
                        } else {
                            columnShape = new Rectangle2D.Double(xPos, zero - previousValues, width, yPos - zero);
                            columnArea = new Area(columnShape);
                        }
                        previousValues -= yPos - zero;
                    }
                } else {
                    if (this.myLastPositiveColumns.get(groupIndex).equals(column)) {
                        columnShape = new RoundRectangle2D.Double(xPos, yPos - previousValues, width, height + radius, radius, radius);
                        columnArea = new Area(columnShape);
                        ((Rectangle2D)clip).setRect(xPos, yPos - previousValues + height, width, radius);
                        Area posClip = new Area(clip);
                        columnArea.subtract(posClip);
                    } else {
                        columnShape = new Rectangle2D.Double(xPos, yPos - previousValues, width, height);
                        columnArea = new Area(columnShape);
                    }
                    previousValues += height;
                }
                Color color = column.getColor();
                if (this.myChart.getProperty("gradientpaint") == Boolean.TRUE) {
                    GradientUtils.drawHorizontalGradient((JComponent)this.myChart.getView(), (Graphics)g, new Color[]{color, column.getGradientColor()}, (Shape)columnArea);
                } else {
                    g.setColor(color);
                    g.fill(columnArea);
                }
                if (borderColor != null) {
                    g.setColor(borderColor);
                    g.draw(columnArea);
                }
                if (hasTooltips) {
                    String note = null;
                    if (this.myChart.getProperty("graphnotetooltip") == Boolean.TRUE) {
                        note = column.getXYSeries().getNote();
                    }
                    area.addToolTip((Shape)columnArea.clone(), this.myTooltipFormatter.createTooltipText(column.getXYPair(), column.getUseLeftAxis(), note));
                }
                ++columnIndex;
            }
            ++groupIndex;
        }
    }

    @Override
    public void setAxisMaxValue(List<XYSeries> xySeries) {
        boolean positiveAndNegativeValues;
        int seriesSize = xySeries.get(0).getXYPairsCount();
        Object[] cascadedPositiveValues = new Object[seriesSize];
        Object[] cascadedNegativeValues = new Object[seriesSize];
        boolean containsPositiveValues = false;
        boolean containsNegativeValues = false;
        for (XYSeries series : xySeries) {
            int i = 0;
            while (i < seriesSize) {
                Number yValue;
                if (series.getLastPair().isYFloatingPointNumber()) {
                    yValue = Double.parseDouble(series.getYValues().get(i).toString());
                    if (SystemUtils.isEqual((Double)yValue, ChartConstants.VALUE_NOT_DEFINED)) {
                        yValue = 0.0;
                    }
                    if ((Double)yValue >= 0.0) {
                        cascadedPositiveValues[i] = cascadedPositiveValues[i] != null ? (Number)((Double)yValue + (Double)cascadedPositiveValues[i]) : (Number)yValue;
                        if (cascadedNegativeValues[i] == null) {
                            cascadedNegativeValues[i] = 0.0;
                        }
                        containsPositiveValues = true;
                    } else {
                        cascadedNegativeValues[i] = cascadedNegativeValues[i] != null ? (Number)((Double)yValue + (Double)cascadedNegativeValues[i]) : (Number)yValue;
                        if (cascadedPositiveValues[i] == null) {
                            cascadedPositiveValues[i] = 0.0;
                        }
                        containsNegativeValues = true;
                    }
                } else if (series.getLastPair().isYIntegerNumber()) {
                    yValue = Long.parseLong(series.getYValues().get(i).toString());
                    if ((Long)yValue >= 0L) {
                        cascadedPositiveValues[i] = cascadedPositiveValues[i] != null ? (Number)((Long)yValue + (Long)cascadedPositiveValues[i]) : (Number)yValue;
                        if (cascadedNegativeValues[i] == null) {
                            cascadedNegativeValues[i] = 0L;
                        }
                        containsPositiveValues = true;
                    } else {
                        cascadedNegativeValues[i] = cascadedNegativeValues[i] != null ? (Number)((Long)yValue + (Long)cascadedNegativeValues[i]) : (Number)yValue;
                        if (cascadedPositiveValues[i] == null) {
                            cascadedPositiveValues[i] = 0L;
                        }
                        containsNegativeValues = true;
                    }
                }
                ++i;
            }
        }
        BigDecimal maxValue = null;
        BigDecimal minValue = null;
        boolean bl = positiveAndNegativeValues = containsPositiveValues && containsNegativeValues;
        if (positiveAndNegativeValues) {
            Arrays.sort(cascadedPositiveValues);
            Arrays.sort(cascadedNegativeValues);
            BigDecimal absNegativeMinValue = new BigDecimal(cascadedNegativeValues[0].toString()).abs();
            BigDecimal maxBDValue = new BigDecimal(cascadedPositiveValues[cascadedPositiveValues.length - 1].toString());
            maxValue = maxBDValue.max(absNegativeMinValue);
            minValue = maxValue.negate();
            this.myContainsPosNegValues = true;
        } else if (containsPositiveValues) {
            Arrays.sort(cascadedPositiveValues);
            maxValue = new BigDecimal(cascadedPositiveValues[cascadedPositiveValues.length - 1].toString());
            minValue = new BigDecimal(cascadedNegativeValues[0].toString());
        } else {
            Arrays.sort(cascadedNegativeValues);
            minValue = new BigDecimal(cascadedNegativeValues[0].toString());
            maxValue = new BigDecimal(cascadedPositiveValues[0].toString());
        }
        Axis axis = this.myChart.getAxis(0);
        ((AxisModel)axis).blockListenerUpdates(true);
        if (maxValue.compareTo(new BigDecimal(0)) == 0) {
            axis.setMaxValue(new BigDecimal(0));
        } else {
            axis.setMaxValue(AxisFactory.calculateAxisMaxValue(axis, !positiveAndNegativeValues, maxValue));
        }
        if (minValue.compareTo(new BigDecimal(0)) == 0) {
            axis.setMinValue(new BigDecimal(0));
        } else {
            axis.setMinValue(-AxisFactory.calculateAxisMaxValue(axis, !positiveAndNegativeValues, minValue.abs()).doubleValue());
        }
        if (this.myContainsPosNegValues && axis.getValueLineCount() % 2 == 0) {
            axis.setValueLineCount(axis.getValueLineCount() + 1);
        }
        ((AxisModel)axis).blockListenerUpdates(false);
    }
}

