/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Axis;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.util.WidgetResources;
import java.text.ParseException;
import javax.swing.UIManager;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.InternationalFormatter;

public class ChartTooltipFormatter {
    protected static final String TIP_TEXT_COLOR_TAG = String.format("<font color=%s>", NetUtils.encodeColor(NetLookAndFeel.getWhite()));
    protected static final String TIP_LABEL_COLOR_TAG = String.format("<font color=%s>", NetUtils.encodeColor(UIManager.getColor("Label.tipLabelForeground")));
    private Chart myChart;

    public ChartTooltipFormatter(Chart chart) {
        this.myChart = chart;
    }

    protected String createTooltipText(XYPair xyPair, boolean useLeftAxis, String note) {
        Integer gridVisibility;
        Axis xAxis = this.myChart.getAxis(2);
        Axis yAxis = this.myChart.getAxis(useLeftAxis ? 0 : 1);
        String xValue = this.getFormattedValue(xyPair.getX(), xAxis);
        String xAxisName = xAxis.getLabel();
        if (xAxisName == null) {
            xAxisName = "";
        }
        String yValue = this.getFormattedValue(xyPair.getY(), yAxis);
        String yAxisName = yAxis.getLabel();
        if (yAxisName == null || yAxisName.trim().length() == 0) {
            yAxisName = WidgetResources.getString("ChartDefaultYAxisLabelInTooltip");
        }
        boolean vertical = (gridVisibility = (Integer)this.myChart.getProperty("gridvisibility")) == 2 || gridVisibility == 3;
        boolean yValuesAreUnimportant = vertical && Boolean.FALSE.equals(this.myChart.getProperty("showVerticalAxisLabels"));
        String addNote = "";
        if (note != null) {
            addNote = String.valueOf(note) + "<br><br>";
        }
        if (yValuesAreUnimportant) {
            return String.format("<html>%s" + addNote + "%s%s: %s%s", TIP_TEXT_COLOR_TAG, TIP_LABEL_COLOR_TAG, xAxisName, TIP_TEXT_COLOR_TAG, xValue);
        }
        return String.format("<html>%s" + addNote + "%s%s: %s%s<br>%s%s:  %s%s", TIP_TEXT_COLOR_TAG, TIP_LABEL_COLOR_TAG, xAxisName, TIP_TEXT_COLOR_TAG, xValue, TIP_LABEL_COLOR_TAG, yAxisName, TIP_TEXT_COLOR_TAG, yValue);
    }

    private String getFormattedValue(Object value, Axis axis) {
        InternationalFormatter formatter = axis.getDataFormatter();
        if (formatter == null) {
            return String.valueOf(value);
        }
        try {
            return ((DefaultFormatter)formatter).valueToString(value);
        }
        catch (ParseException e) {
            return String.valueOf(value);
        }
    }
}

