/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.ChartColumn;
import com.nokia.widgets.chart.renderers.ColumnGraphRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class ClusteredColumnGraphRenderer
extends ColumnGraphRenderer {
    @Override
    public void init(Chart chart) {
        super.init(chart);
        this.myDrawPriority = 2;
    }

    @Override
    protected void defineColumnAreas(double zero) {
        Rectangle2D.Double clip = new Rectangle2D.Double();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double();
        for (Object key : this.myColumnGroups.keySet()) {
            List columnGroup = (List)this.myColumnGroups.get(key);
            int numCols = columnGroup.size();
            if (numCols <= 0) continue;
            ChartColumn defCol = (ChartColumn)columnGroup.get(0);
            double xPos = defCol.getXPos();
            double width = defCol.getWidth();
            double radius = ChartColumn.getCornerRadius(width);
            clip.setRect(xPos, zero, width, radius);
            Area posClip = new Area(clip);
            clip.setRect(xPos, zero - radius, width, radius);
            Area negClip = new Area(clip);
            radius = ChartColumn.getCornerRadius(width /= (double)numCols);
            double twoRadius = radius * 2.0;
            int colIndex = 0;
            while (colIndex < numCols) {
                ChartColumn col = (ChartColumn)columnGroup.get(colIndex);
                double yPos = col.getYPos();
                if (yPos != zero) {
                    Area colArea = null;
                    double columnWidth = width - 1.0;
                    if (yPos < zero) {
                        rect.setRoundRect(xPos, yPos, columnWidth, zero - yPos + radius, twoRadius, twoRadius);
                        colArea = new Area(rect);
                        colArea.subtract(posClip);
                    } else if (yPos > zero) {
                        rect.setRoundRect(xPos, zero - radius, columnWidth, yPos - zero + radius, twoRadius, twoRadius);
                        colArea = new Area(rect);
                        colArea.subtract(negClip);
                    }
                    col.setArea(colArea);
                }
                xPos += width;
                ++colIndex;
            }
        }
    }

    @Override
    protected double limitFromAbove(double columnWidth) {
        return columnWidth > 120.0 ? 120.0 : columnWidth;
    }

    @Override
    protected void paintColumnBorder(Graphics2D graphics, Area colArea) {
        Color borderColor = (Color)this.myChart.getProperty("columnbordercolor");
        if (borderColor != null) {
            graphics.setColor(borderColor);
            Object oldAa = NetUtils.antiAliasingOn(graphics);
            graphics.draw(colArea);
            NetUtils.setAntialiasing(graphics, oldAa);
        }
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeriesList, Graphics2D graphics, GraphArea graphArea) {
        super.paintGraphs(xySeriesList, graphics, graphArea);
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)img).getGraphics();
        graphics.setColor(xySeries.getColor());
        int rectWidth = size.width;
        int rectHeight = size.height / 3;
        int posY = size.height / 2 - rectHeight / 2;
        graphics.fillRect(0, posY, rectWidth, rectHeight);
        graphics.dispose();
        return img;
    }
}

