/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.LegendAreaRenderer;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;

public class ColorGradientLegendAreaRenderer
implements LegendAreaRenderer {
    private static final int BAR_WIDTH = 15;
    private static final int LEGEND_DISTANCE = 22;
    private static final int STRING_DISTANCE = 6;
    private static final int NAME_DISTANCE = 12;

    @Override
    public void paintLegendArea(Graphics2D graphics, Rectangle graphBorder, Chart chart, Object dataObject, String name) {
        if (!this.isValidDataObject(dataObject)) {
            return;
        }
        Map legendMap = (Map)dataObject;
        this.drawBarAndLabel(graphics, graphBorder, chart, legendMap);
        this.drawLegendTitle(graphics, graphBorder, name, legendMap);
    }

    private void drawBarAndLabel(Graphics2D graphics, Rectangle graphBorder, Chart chart, Map legendMap) {
        int size = legendMap.size();
        ArrayList entryList = new ArrayList(legendMap.entrySet());
        int i = 0;
        while (i < size) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            Rectangle rectangle = this.createBarPortion(graphBorder, i, size);
            Color primary = (Color)entry.getValue();
            int nextIndex = i + 1;
            Color secondary = nextIndex == size ? Color.BLACK : (Color)((Map.Entry)entryList.get(nextIndex)).getValue();
            Color[] gradient = new Color[]{primary, secondary};
            GradientUtils.drawVerticalGradient((JComponent)chart.getView(), (Graphics)graphics, gradient, (Shape)rectangle);
            graphics.setColor(ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_COLOR);
            int x = rectangle.x + rectangle.width + 6;
            int y = rectangle.y + graphics.getFontMetrics().getHeight() / 2 + rectangle.height / 2;
            graphics.drawString((String)entry.getKey(), x, y);
            ++i;
        }
    }

    private Rectangle createBarPortion(Rectangle graphBorder, int index, int size) {
        int x = graphBorder.x + graphBorder.width + 22;
        int y = graphBorder.height * index / size;
        int w = 15;
        int h = graphBorder.height / size + 1;
        return new Rectangle(x, y, w, h);
    }

    private void drawLegendTitle(Graphics2D graphics, Rectangle graphBorder, String name, Map<String, Color> legendMap) {
        GlyphVector glyphVector = graphics.getFont().createGlyphVector(graphics.getFontRenderContext(), name);
        float xLabel = graphBorder.x + graphBorder.width + this.getBounds((Rectangle)graphBorder, legendMap, (FontMetrics)graphics.getFontMetrics()).width;
        float yLabel = graphBorder.y + graphBorder.height / 2 - graphics.getFontMetrics().stringWidth(name) / 2;
        graphics.rotate(Math.toRadians(90.0), xLabel, yLabel);
        graphics.drawGlyphVector(glyphVector, xLabel, yLabel);
    }

    @Override
    public Rectangle getBounds(Rectangle graphBorder, Object dataObject, FontMetrics fontMetrics) {
        if (this.isValidDataObject(dataObject)) {
            Map dataMap = (Map)dataObject;
            int width = NetUtils.getLongestStringLength(dataMap.keySet(), fontMetrics) + 22 + 15 + 6 + 12;
            int height = graphBorder.height;
            return new Rectangle(width, height);
        }
        return new Rectangle();
    }

    @Override
    public boolean isValidDataObject(Object dataObject) {
        if (!(dataObject instanceof Map)) {
            return false;
        }
        Map legendValueMap = (Map)dataObject;
        for (Map.Entry entry : legendValueMap.entrySet()) {
            if (!(entry instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mapEntry = entry;
            if (!(mapEntry.getKey() instanceof String)) {
                return false;
            }
            if (mapEntry.getValue() instanceof Color) continue;
            return false;
        }
        return true;
    }
}

