/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.ChartColumn;
import com.nokia.widgets.chart.renderers.AbstractColumnGraphRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class ColumnGraphRenderer
extends AbstractColumnGraphRenderer {
    protected List<XYSeries> myXYSeriesList = new ArrayList<XYSeries>();
    protected Map<Object, List<ChartColumn>> myColumnGroups = new HashMap<Object, List<ChartColumn>>();
    protected Map<Object, Double> myPosLimits = new HashMap<Object, Double>();
    protected Map<Object, Double> myNegLimits = new HashMap<Object, Double>();

    @Override
    public void init(Chart chart) {
        super.init(chart);
        this.myDrawPriority = 4;
    }

    protected void createColumnData(List<XYSeries> xySeriesList, Graphics2D graphics, GraphArea graphArea, double zero) {
        this.myColumnGroups.clear();
        this.myPosLimits.clear();
        this.myNegLimits.clear();
        this.myXYSeriesToValuePoints.clear();
        for (XYSeries xySeries : xySeriesList) {
            for (Object x : xySeries.getXValues()) {
                if (this.myColumnGroups.get(x) != null) continue;
                this.myColumnGroups.put(x, new ArrayList());
                this.myPosLimits.put(x, zero);
                this.myNegLimits.put(x, zero);
            }
        }
        int listSize = xySeriesList.size();
        int seriesIndex = 0;
        while (seriesIndex < listSize) {
            XYSeries xySeries = xySeriesList.get(seriesIndex);
            ArrayList<Point> dataPoints = new ArrayList<Point>();
            double preferredWidth = this.getPreferredColumnWidth(this.myColumnGroups.keySet().toArray(), graphArea);
            List<XYPair> xyPairs = xySeries.getXYPairs();
            int numPairs = xyPairs.size();
            int pairIndex = 0;
            while (pairIndex < numPairs) {
                XYPair xyPair = xyPairs.get(pairIndex);
                ChartColumn column = new ChartColumn(this.myChart, xyPair, xySeries, preferredWidth, graphArea, zero);
                Object x = xyPair.getX();
                if (column.getYPos() < this.myPosLimits.get(x)) {
                    this.myPosLimits.put(x, column.getYPos());
                } else if (column.getYPos() > this.myNegLimits.get(x)) {
                    this.myNegLimits.put(x, column.getYPos());
                }
                this.myColumnGroups.get(x).add(column);
                dataPoints.add(new Point((int)column.getXPos(), (int)column.getYPos()));
                ++pairIndex;
            }
            this.myXYSeriesToValuePoints.put(xySeries, dataPoints);
            ++seriesIndex;
        }
        this.myXYSeriesList = xySeriesList;
        this.defineColumnAreas(zero);
    }

    protected void defineColumnAreas(double zero) {
        Rectangle2D.Double clip = new Rectangle2D.Double();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double();
        for (Object key : this.myColumnGroups.keySet()) {
            List<ChartColumn> columnGroup = this.myColumnGroups.get(key);
            int numCols = columnGroup.size();
            if (numCols <= 0) continue;
            double posLimit = this.myPosLimits.get(key);
            double negLimit = this.myNegLimits.get(key);
            ChartColumn defCol = columnGroup.get(0);
            double xPos = defCol.getXPos();
            double width = defCol.getWidth();
            double radius = ChartColumn.getCornerRadius(width);
            double twoRadius = radius * 2.0;
            clip.setRect(xPos, zero, width, radius);
            Area posClip = new Area(clip);
            clip.setRect(xPos, zero - radius, width, radius);
            Area negClip = new Area(clip);
            int colIndex = 0;
            while (colIndex < numCols) {
                ChartColumn col = columnGroup.get(colIndex);
                double yPos = col.getYPos();
                if (yPos != zero) {
                    Area colArea = null;
                    if (yPos < zero) {
                        rect.setRoundRect(xPos, posLimit, width, zero - posLimit + radius, twoRadius, twoRadius);
                        colArea = new Area(rect);
                        colArea.subtract(posClip);
                        if (yPos > posLimit) {
                            clip.setRect(xPos, posLimit, width, yPos - posLimit);
                            colArea.subtract(new Area(clip));
                        }
                    } else if (yPos > zero) {
                        rect.setRoundRect(xPos, zero - radius, width, negLimit - zero + radius, twoRadius, twoRadius);
                        colArea = new Area(rect);
                        colArea.subtract(negClip);
                        if (yPos < negLimit) {
                            clip.setRect(xPos, yPos, width, negLimit - yPos);
                            colArea.subtract(new Area(clip));
                        }
                    }
                    int i = 0;
                    while (i < colIndex) {
                        Area prevArea = columnGroup.get(i).getArea();
                        if (prevArea != null) {
                            prevArea.subtract(colArea);
                            if (prevArea.isEmpty()) {
                                columnGroup.get(i).setArea(null);
                            }
                        }
                        ++i;
                    }
                    col.setArea(colArea);
                }
                ++colIndex;
            }
        }
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeriesList, Graphics2D graphics, GraphArea graphArea) {
        double zero = graphArea.getLeftYAxisPositionForValue(new Double(0.0));
        this.createColumnData(xySeriesList, graphics, graphArea, zero);
        this.paintHighLightData(graphArea);
        Object oldAa = NetUtils.antiAliasingOn(graphics);
        for (Object key : this.myColumnGroups.keySet()) {
            List<ChartColumn> colGroup = this.myColumnGroups.get(key);
            int numCols = colGroup.size();
            int j = 0;
            while (j < numCols) {
                ChartColumn col = colGroup.get(j);
                if (col.getArea() != null) {
                    Paint oldPaint = graphics.getPaint();
                    if (this.myChart.getProperty("gradientpaint") == Boolean.TRUE) {
                        GradientUtils.drawHorizontalGradient((JComponent)this.myChart.getView(), (Graphics)graphics, new Color[]{col.getColor(), col.getGradientColor()}, (Shape)col.getArea());
                    } else {
                        graphics.setColor(col.getColor());
                        graphics.fill(col.getArea());
                    }
                    this.paintColumnBorder(graphics, col.getArea());
                    graphics.setPaint(oldPaint);
                    if (this.hasTooltips()) {
                        String note = null;
                        if (this.myChart.getProperty("graphnotetooltip") == Boolean.TRUE) {
                            note = col.getXYSeries().getNote();
                        }
                        graphArea.addToolTip(col.getArea(), this.myTooltipFormatter.createTooltipText(col.getXYPair(), col.getUseLeftAxis(), note));
                    }
                }
                ++j;
            }
        }
        NetUtils.setAntialiasing(graphics, oldAa);
        this.paintStaticValuePointLabel(xySeriesList, graphics);
    }

    protected void paintColumnBorder(Graphics2D graphics, Area colArea) {
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)img).getGraphics();
        graphics.setColor(xySeries.getColor());
        int rectWidth = size.width;
        int rectHeight = size.height / 2;
        int posY = size.height / 2 - rectHeight / 2;
        graphics.fillRect(0, posY, rectWidth, rectHeight);
        graphics.dispose();
        return img;
    }
}

