/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.GraphValueRange;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContourGraphRenderer
extends AbstractBaseGraphRenderer {
    protected static final Color GRAPH_DARK_BLUE = new Color(0, 0, 255);
    protected static final Color GRAPH_BLUE = new Color(6, 249, 255);
    protected static final Color GRAPH_LIGHT_BLUE = new Color(48, 255, 199);
    protected static final Color GRAPH_GREEN_BLUE = new Color(127, 253, 118);
    protected static final Color GRAPH_GREEN = new Color(127, 253, 118);
    protected static final Color GRAPH_YELLOW = new Color(238, 254, 33);
    protected static final Color GRAPH_ORANGE_RED = new Color(151, 15, 30);
    protected static final Color GRAPH_RED = new Color(190, 0, 6);
    protected static final Color[] DEFAULT_CONTOUR_CHART_COLORS = new Color[]{GRAPH_DARK_BLUE, GRAPH_BLUE, GRAPH_LIGHT_BLUE, GRAPH_GREEN_BLUE, GRAPH_GREEN, new Color(212, 250, 96), ChartConstants.GRAPH_YELLOW_SOLID, ChartConstants.GRAPH_LIGHT_ORANGE_SOLID, ChartConstants.GRAPH_ORANGE_SOLID, GRAPH_ORANGE_RED, ChartConstants.GRAPH_RED_SOLID, GRAPH_RED};
    private List<GraphValueRange> myRanges;
    private List<Color> myColors;

    public void setValueRanges(List<GraphValueRange> valueRanges) {
        this.myRanges = valueRanges;
    }

    public void setValueRangeColors(List<Color> valueRangeColors) {
        this.myColors = valueRangeColors;
    }

    @Override
    public void setAxisMaxValue(List<XYSeries> xySeries) {
        if (this.myRanges != null) {
            return;
        }
        Object[] highestZ = new Number[xySeries.size()];
        Object[] lowestZ = new Number[xySeries.size()];
        int i = 0;
        while (i < xySeries.size()) {
            highestZ[i] = xySeries.get(i).getHighestZAsNumber();
            lowestZ[i] = xySeries.get(i).getSmallestZAsNumber();
            ++i;
        }
        Arrays.sort(highestZ);
        Arrays.sort(lowestZ);
        this.createDefaultRanges(new BigDecimal(lowestZ[0].toString()), new BigDecimal(highestZ[xySeries.size() - 1].toString()));
    }

    private void createDefaultRanges(BigDecimal myMinValue, BigDecimal myMaxValue) {
        List<Color> colors;
        this.myRanges = new ArrayList<GraphValueRange>();
        if (this.myColors != null) {
            colors = this.myColors;
        } else {
            colors = new ArrayList<Color>();
            int i = 0;
            while (i < DEFAULT_CONTOUR_CHART_COLORS.length) {
                colors.add(DEFAULT_CONTOUR_CHART_COLORS[i]);
                ++i;
            }
        }
        BigDecimal totalRange = myMaxValue.subtract(myMinValue);
        BigDecimal range = totalRange.divide(new BigDecimal(colors.size()), MathContext.DECIMAL32);
        BigDecimal max = null;
        BigDecimal min = null;
        boolean firstRound = true;
        for (Color color : colors) {
            if (firstRound) {
                max = myMinValue.add(range);
                this.myRanges.add(new GraphValueRange(myMinValue, max, color));
                min = max;
                firstRound = false;
                continue;
            }
            max = min.add(range);
            this.myRanges.add(new GraphValueRange(min, max, color));
            min = max;
        }
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        double height = Math.ceil(graphArea.getBounds().getHeight() / (double)xySeries.get(0).getXYPairsCount());
        double width = Math.ceil(graphArea.getBounds().getWidth() / (double)xySeries.size());
        double yAdjust = 0.0;
        HashMap<Integer, Double> yPositions = new HashMap<Integer, Double>();
        Rectangle2D.Double valueMarker = new Rectangle2D.Double();
        int i = xySeries.size() - 1;
        while (i >= 0) {
            XYSeries series = xySeries.get(i);
            if (series.getFirstPair().getYAsDouble() == 0.0) {
                yAdjust = height;
            }
            graphics.setColor(series.getColor());
            this.paintContourSerie(graphics, series, graphArea, width, height, yAdjust, yPositions, valueMarker);
            yAdjust = height / 2.0;
            --i;
        }
    }

    private void paintContourSerie(Graphics2D graphics, XYSeries xySeries, GraphArea graphArea, double width, double height, double yAdjust, Map<Integer, Double> yPositions, Rectangle2D valueMarker) {
        List<XYPair> xyPairs = xySeries.getXYPairs();
        Color tempColor = graphics.getColor();
        GraphValueRange tempRange = null;
        Double xPos = null;
        Double currentYPosition = null;
        BigDecimal zToPaint = null;
        int i = 0;
        while (i < xyPairs.size()) {
            Double yPos;
            XYPair xyPair = xyPairs.get(i);
            if (xPos == null) {
                xPos = graphArea.getXAxisPositionForValue(xyPair.getX());
            }
            if ((yPos = yPositions.get(i)) == null) {
                yPos = graphArea.getLeftYAxisPositionForValue(xyPair.getY());
                yPositions.put(i, yPos);
            }
            if (i == 0) {
                currentYPosition = yPos;
            }
            BigDecimal zDecimal = xyPair.getZAsBigDecimal();
            if (SystemUtils.isEqual(yPos, currentYPosition, 0.4)) {
                zToPaint = zToPaint == null ? zDecimal : zToPaint.max(zDecimal);
            } else {
                valueMarker.setFrame(xPos, currentYPosition - yAdjust, width, height);
                if (tempRange != null && tempRange.belongsToRange(zToPaint)) {
                    graphics.setColor(tempRange.getColor());
                } else {
                    for (GraphValueRange range : this.myRanges) {
                        if (!range.belongsToRange(zToPaint)) continue;
                        tempRange = range;
                        graphics.setColor(range.getColor());
                        break;
                    }
                }
                graphics.fill(valueMarker);
                currentYPosition = yPos;
                zToPaint = zDecimal;
            }
            ++i;
        }
        graphics.setColor(tempColor);
    }

    @Override
    public void paintThresholds(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)img).getGraphics();
        graphics.setColor(xySeries.getColor());
        int rectWidth = size.width;
        int rectHeight = size.height / 2;
        int posY = size.height / 2 - rectHeight / 2;
        graphics.fillRect(0, posY, rectWidth, rectHeight);
        graphics.dispose();
        return img;
    }
}

