/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.widgets.chart.ValuePointModel;
import com.nokia.widgets.chart.ValuePointRenderer;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;

public class DefaultValuePointRenderer
implements ValuePointRenderer {
    @Override
    public void paintValuePointLabel(XYPair xyPair, Graphics2D graphics, int xPos, int yPos, ValuePointModel model) {
        Color tempColor = graphics.getColor();
        Font tempFont = graphics.getFont();
        this.paintWithModelValues(graphics, xyPair, xPos, yPos, model);
        this.restoreCurrentProperties(graphics, xPos, yPos, model, tempColor, tempFont);
    }

    protected void paintWithModelValues(Graphics2D graphics, XYPair xyPair, int xPos, int yPos, ValuePointModel model) {
        int movedX = xPos;
        int movedY = yPos;
        String formattedValue = xyPair.getY().toString();
        if (model.getColor() != null) {
            graphics.setColor(model.getColor());
        }
        if (model.getDataValueFormatter() != null) {
            formattedValue = model.getDataValueFormatter().format(xyPair.getY());
        }
        if (model.getFont() != null) {
            graphics.setFont(model.getFont());
        }
        if (model.getTransformation() != null) {
            graphics.setTransform(model.getTransformation());
        } else {
            if (model.getLocation() != null) {
                Point move = model.getLocation();
                movedX += move.x;
                movedY += move.y;
            }
            if (!SystemUtils.isEqual(model.getRotation(), Double.MAX_VALUE)) {
                graphics.rotate(model.getRotation(), xPos, yPos);
            }
        }
        graphics.drawString(formattedValue, movedX, movedY);
    }

    protected void restoreCurrentProperties(Graphics2D graphics, int xPos, int yPos, ValuePointModel model, Color tempColor, Font tempFont) {
        graphics.setColor(tempColor);
        graphics.setFont(tempFont);
        if (model.getTransformation() != null) {
            try {
                graphics.setTransform(model.getTransformation().createInverse());
            }
            catch (Exception exception) {}
        } else if (!SystemUtils.isEqual(model.getRotation(), Double.MAX_VALUE)) {
            graphics.rotate(-model.getRotation(), xPos, yPos);
        }
    }
}

