/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import com.nokia.widgets.util.SystemUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LineGraphRenderer
extends AbstractBaseGraphRenderer
implements MouseMotionListener,
MouseListener {
    private static final double DELTA = 1.0E-5;
    private static final double POSITION_NOT_DEFINED = -1.0;
    private static final double TOOLTIP_AREA_DIAMETER = 6.0;
    private static final int BORDER_HORIZONTAL_INSETS = 10;
    private Line2D.Double myValueLine = new Line2D.Double();
    private Ellipse2D.Double myValueOverThresholdMarker = new Ellipse2D.Double();
    private Rectangle myGraphArea;
    private Map<XYSeries, List<RollOverEffect>> myValueMarkers;
    private Stroke myStroke;

    public LineGraphRenderer() {
        this.myDrawPriority = 0;
        this.myValueMarkers = new HashMap<XYSeries, List<RollOverEffect>>();
    }

    private void paintGraphLines(Graphics2D graphics, XYSeries xySeries, GraphArea graphArea, Double valueMarkerSize) {
        double xPosPrevious = -1.0;
        double yPosPrevious = -1.0;
        boolean useLeftYAxis = xySeries.getUseLeftYAxis();
        int markerType = xySeries.getValueMarkerType();
        Color color = xySeries.getColor();
        if (((Boolean)this.myChart.getProperty("sparkline")).booleanValue()) {
            color = color.darker();
        }
        ArrayList<RollOverEffect> tempRollOverEffects = new ArrayList<RollOverEffect>();
        List<XYPair> xyPairs = xySeries.getXYPairs();
        Object thresholdValue = xySeries.getThresholdValue();
        ArrayList<Point> dataPoints = new ArrayList<Point>();
        boolean areValueMarkersPainted = (Boolean)this.myChart.getProperty("showValueMarkers");
        boolean areTooltipsShown = (Boolean)this.myChart.getProperty("graphtooltip");
        Icon icon = null;
        Icon iconPrevious = null;
        Map<Object, Icon> iconMap = xySeries.getCustomValueMarkerForSpecValue();
        Rectangle graphAreaBounds = graphArea.getBounds();
        this.paintHighLightData(graphArea);
        int i = 0;
        while (i < xyPairs.size()) {
            if (xyPairs.get(i) != null) {
                XYPair xyPair = xyPairs.get(i);
                icon = this.getValueMarkerIcon(iconMap, xyPair, xySeries);
                Number yValue = this.getYValueAsNumber(xyPair);
                double xPos = graphArea.getXAxisPositionForValue(xyPair.getX());
                if (!(xPos < graphArea.getAdjustedGraphXStart() - 10.0) && !(xPos > graphArea.getAdjustedGraphXEnd() + 10.0)) {
                    boolean isPreviousPositionDefined;
                    double yPos;
                    double d = yPos = useLeftYAxis ? graphArea.getLeftYAxisPositionForValue(xyPair.getY()) : graphArea.getRightYAxisPositionForValue(xyPair.getY());
                    if (areTooltipsShown) {
                        Ellipse2D.Double markerArea = this.createTooltipArea(xPos, yPos, xyPair, xySeries.getUseLeftYAxis(), valueMarkerSize, graphArea);
                        tempRollOverEffects.add(new RollOverEffect(xPos, yPos, markerArea, color, markerType, valueMarkerSize, icon));
                    }
                    boolean isYValueDefined = !SystemUtils.isEqual(yValue.doubleValue(), ChartConstants.VALUE_NOT_DEFINED, 1.0E-5);
                    boolean isYValueShown = !SystemUtils.isEqual(yValue.doubleValue(), ChartConstants.VALUE_NOT_SHOWN, 1.0E-5);
                    boolean bl = isPreviousPositionDefined = !SystemUtils.isEqual(xPosPrevious, -1.0) && !SystemUtils.isEqual(yPosPrevious, -1.0);
                    if (isPreviousPositionDefined && isYValueDefined && !SystemUtils.isEqual(yPosPrevious, ChartConstants.VALUE_NOT_DEFINED, 1.0E-5) && isYValueShown && !SystemUtils.isEqual(yPosPrevious, ChartConstants.VALUE_NOT_SHOWN, 1.0E-5)) {
                        this.drawLineSegment(graphics, xPosPrevious, yPosPrevious, xPos, yPos);
                    }
                    if (areValueMarkersPainted && isYValueDefined && isYValueShown) {
                        if (isPreviousPositionDefined) {
                            this.paintValueMarker(graphics, xPosPrevious, yPosPrevious, valueMarkerSize, markerType, iconPrevious);
                        }
                        this.paintValueMarker(graphics, xPos, yPos, valueMarkerSize, markerType, icon);
                    }
                    dataPoints.add(new Point((int)xPos, (int)yPos));
                    if (thresholdValue != null && isYValueDefined && isYValueShown) {
                        double thresholdPos;
                        Object thresval = thresholdValue instanceof Object[] ? ((Object[])thresholdValue)[i] : thresholdValue;
                        double d2 = thresholdPos = useLeftYAxis ? graphArea.getLeftYAxisPositionForValue(thresval) : graphArea.getRightYAxisPositionForValue(thresval);
                        if (thresholdPos > yPos) {
                            this.paintValueOverThreshold(graphics, xySeries.getThresholdColor() != null ? xySeries.getThresholdColor() : color, xPos, yPos);
                        }
                    }
                    if (isYValueShown) {
                        xPosPrevious = xPos;
                    }
                    if (isYValueDefined) {
                        if (isYValueShown) {
                            yPosPrevious = yPos;
                        }
                    } else {
                        yPosPrevious = ChartConstants.VALUE_NOT_DEFINED;
                    }
                    iconPrevious = icon;
                }
            }
            ++i;
        }
        if (this.myGraphArea != null && this.myGraphArea.getHeight() != graphAreaBounds.getHeight()) {
            this.myXYSeriesToValuePoints.clear();
        }
        if (areTooltipsShown && !this.myXYSeriesToValuePoints.keySet().contains(xySeries)) {
            boolean chartAllowsZoom;
            boolean bl = chartAllowsZoom = this.myChart.getProperty("AllowZoom") != null && (Boolean)this.myChart.getProperty("AllowZoom") != false;
            if (!chartAllowsZoom) {
                this.myValueMarkers.put(xySeries, tempRollOverEffects);
            } else {
                XYSeries zoomedSeriesCopy = null;
                for (XYSeries valueMarkerSeries : this.myValueMarkers.keySet()) {
                    if (!valueMarkerSeries.getName().equals(xySeries.getName())) continue;
                    zoomedSeriesCopy = valueMarkerSeries;
                    break;
                }
                if (zoomedSeriesCopy != null) {
                    this.myValueMarkers.remove(zoomedSeriesCopy);
                }
                this.myValueMarkers.put(xySeries, tempRollOverEffects);
            }
        }
        this.myXYSeriesToValuePoints.put(xySeries, dataPoints);
        this.myGraphArea = new Rectangle(graphAreaBounds);
    }

    protected Number getYValueAsNumber(XYPair xyPair) {
        if (xyPair.isYIntegerNumber()) {
            return xyPair.getYAsLong();
        }
        return xyPair.getYAsDouble();
    }

    protected void drawLineSegment(Graphics2D graphics, double xPosPrevious, double yPosPrevious, double xPos, double yPos) {
        Stroke oldStroke = graphics.getStroke();
        if (this.myStroke != null) {
            graphics.setStroke(this.myStroke);
        }
        this.myValueLine.setLine(xPosPrevious, yPosPrevious, xPos, yPos);
        graphics.draw(this.myValueLine);
        graphics.setStroke(oldStroke);
    }

    private void paintValueMarker(Graphics2D g, double x, double y, Double valueMarkerSize, int markerType, Icon icon) {
        double markerSize;
        if (valueMarkerSize != null && (markerSize = valueMarkerSize.doubleValue()) > 0.0) {
            Color graphBackgroundColor;
            double xPos = x - markerSize / 2.0;
            double yPos = y - markerSize / 2.0;
            Color tempColor = g.getColor();
            Color color = graphBackgroundColor = (Color)this.myChart.getProperty("graphbackgroundcolor") != null ? (Color)this.myChart.getProperty("graphbackgroundcolor") : ChartConstants.GRAPH_BACKGROUND_WHITE;
            if (markerType == 1) {
                g.setColor(graphBackgroundColor);
                Rectangle2D.Double valueMarkerEmptySpace = new Rectangle2D.Double();
                valueMarkerEmptySpace.setFrame(xPos - 1.0, yPos - 1.0, markerSize + 2.0, markerSize + 2.0);
                g.fill(valueMarkerEmptySpace);
                g.setColor(tempColor);
                Rectangle2D.Double valueMarker = new Rectangle2D.Double();
                valueMarker.setFrame(xPos, yPos, markerSize, markerSize);
                g.fill(valueMarker);
            } else if (markerType == 0) {
                g.setColor(graphBackgroundColor);
                g.fillOval((int)xPos - 1, (int)yPos - 1, (int)markerSize + 2, (int)markerSize + 2);
                g.setColor(tempColor);
                g.fillOval((int)xPos, (int)yPos, (int)markerSize, (int)markerSize);
            } else if (markerType == 2) {
                g.setColor(graphBackgroundColor);
                Polygon emptySpace = new Polygon();
                emptySpace.addPoint((int)xPos - 2, (int)(yPos + markerSize + 1.0));
                emptySpace.addPoint((int)x, (int)yPos - 2);
                emptySpace.addPoint((int)(xPos + markerSize + 2.0), (int)(yPos + markerSize + 1.0));
                g.fillPolygon(emptySpace);
                g.setColor(tempColor);
                Polygon p = new Polygon();
                p.addPoint((int)xPos, (int)(yPos + markerSize));
                p.addPoint((int)x, (int)yPos);
                p.addPoint((int)(xPos + markerSize), (int)(yPos + markerSize));
                g.fillPolygon(p);
            } else if (markerType == 3) {
                if (icon != null) {
                    if (icon instanceof ImageIcon) {
                        g.drawImage(((ImageIcon)icon).getImage(), (int)xPos, (int)yPos, 8, 8, null);
                    } else {
                        g.setColor(graphBackgroundColor);
                        g.fillOval((int)xPos - 1, (int)yPos - 1, (int)markerSize + 2, (int)markerSize + 2);
                        g.setColor(tempColor);
                        g.fillOval((int)xPos, (int)yPos, (int)markerSize, (int)markerSize);
                    }
                } else {
                    g.setColor(graphBackgroundColor);
                    g.fillOval((int)xPos - 1, (int)yPos - 1, (int)markerSize + 2, (int)markerSize + 2);
                    g.setColor(tempColor);
                    g.fillOval((int)xPos, (int)yPos, (int)markerSize, (int)markerSize);
                }
            }
        }
    }

    private Ellipse2D.Double createTooltipArea(double xPos, double yPos, XYPair xyPair, boolean useLeftYAxis, Double valueMarkerSize, GraphArea graphArea) {
        Ellipse2D.Double tooltipArea = valueMarkerSize != null ? new Ellipse2D.Double(xPos - valueMarkerSize / 2.0, yPos - valueMarkerSize / 2.0, valueMarkerSize, valueMarkerSize) : new Ellipse2D.Double(xPos - 3.0, yPos - 3.0, 6.0, 6.0);
        if (xyPair == null) {
            return tooltipArea;
        }
        graphArea.addToolTip(tooltipArea, this.myTooltipFormatter.createTooltipText(xyPair, useLeftYAxis, null));
        return tooltipArea;
    }

    private void paintValueOverThreshold(Graphics2D graphics, Color thresholdColor, double x, double y) {
        double markerSize;
        Double thresholdMarkerSize = (Double)this.myChart.getProperty("thresholdmarker");
        if (thresholdMarkerSize != null && (markerSize = thresholdMarkerSize.doubleValue()) > 0.0) {
            Color oldColor = graphics.getColor();
            graphics.setColor(thresholdColor);
            double xPos = x - markerSize / 2.0;
            double yPos = y - markerSize / 2.0;
            this.myValueOverThresholdMarker.setFrame(xPos, yPos, markerSize, markerSize);
            graphics.draw(this.myValueOverThresholdMarker);
            graphics.setColor(oldColor);
        }
    }

    private Ellipse2D.Double createRollOverEfect(double x, double y) {
        Ellipse2D.Double rollOverEfect = new Ellipse2D.Double();
        Double thresholdMarkerSize = 13.0;
        double markerSize = thresholdMarkerSize;
        double xPos = x - markerSize / 2.0 - 0.5;
        double yPos = y - markerSize / 2.0 - 0.5;
        rollOverEfect.setFrame(xPos, yPos, markerSize, markerSize);
        return rollOverEfect;
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        Float width = (Float)this.myChart.getProperty("linewidth");
        this.myStroke = width != null ? new BasicStroke(width.floatValue()) : null;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = xySeries.size() - 1;
        while (i >= 0) {
            XYSeries series = xySeries.get(i);
            Double valueMarkerSize = (Double)this.myChart.getProperty("valuemarker");
            graphics.setColor(series.getColor());
            if (series.getXYPairsCount() > 0) {
                this.paintGraphLines(graphics, series, graphArea, valueMarkerSize);
            }
            --i;
        }
        this.paintStaticValuePointLabel(xySeries, graphics);
        int closestMarker = Integer.MAX_VALUE;
        RollOverEffect closestRollOver = null;
        for (XYSeries visibleSeries : this.myValueMarkers.keySet()) {
            if (!xySeries.contains(visibleSeries)) continue;
            for (RollOverEffect efect : this.myValueMarkers.get(visibleSeries)) {
                if (efect.getDistanceToMousePointer() <= -1 || efect.getDistanceToMousePointer() >= closestMarker) continue;
                closestRollOver = efect;
                closestMarker = efect.getDistanceToMousePointer();
            }
        }
        if (closestRollOver != null) {
            this.paintRollover(graphics, closestRollOver);
        }
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)img).getGraphics();
        Object oldAa = NetUtils.antiAliasingOn(graphics);
        graphics.setColor(xySeries.getColor());
        int y = size.height / 2;
        graphics.drawLine(0, y, 0 + size.width, y);
        int rectWidth = (int)((double)size.width * 0.48);
        int rectHeight = (int)((double)size.height * 0.48);
        Number valueMarker = (Number)this.myChart.getProperty("valuemarker");
        int markerType = xySeries.getValueMarkerType();
        if (valueMarker != null && valueMarker.doubleValue() > 0.0) {
            int posX = size.width / 2 - rectWidth / 2;
            int posY = size.height / 2 - rectHeight / 2;
            if (markerType == 1) {
                graphics.fillRect(posX, posY, rectWidth, rectHeight);
            } else if (markerType == 0) {
                graphics.fillOval(posX, posY, rectWidth, rectHeight);
            } else if (markerType == 2) {
                Polygon p = new Polygon();
                p.addPoint(posX, --posY + rectHeight);
                p.addPoint(posX + rectWidth / 2, posY);
                p.addPoint(posX + rectWidth, posY + rectHeight);
                graphics.fillPolygon(p);
            }
        }
        NetUtils.setAntialiasing(graphics, oldAa);
        graphics.dispose();
        return img;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (XYSeries series : this.myValueMarkers.keySet()) {
            for (RollOverEffect marker : this.myValueMarkers.get(series)) {
                marker.calculateDistanceToMouse(e.getPoint());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
    }

    private void paintRollover(Graphics2D g, RollOverEffect marker) {
        Color graphBackgroundColor = (Color)this.myChart.getProperty("graphbackgroundcolor") != null ? (Color)this.myChart.getProperty("graphbackgroundcolor") : ChartConstants.GRAPH_BACKGROUND_WHITE;
        Color tempColor = g.getColor();
        g.setColor(graphBackgroundColor);
        g.setStroke(new BasicStroke(2.0f));
        g.fill(this.createRollOverEfect(marker.getX(), marker.getY()));
        g.setColor(marker.getColor());
        this.paintValueMarker(g, marker.getX(), marker.getY(), marker.getMarkerSize(), marker.getMarkerType(), marker.getCustomValueMarker());
        g.draw(this.createRollOverEfect(marker.getX(), marker.getY()));
        g.setColor(tempColor);
    }

    private Icon getValueMarkerIcon(Map<Object, Icon> iconMap, XYPair xyPair, XYSeries xySeries) {
        Icon tempIcon;
        if (iconMap != null && (tempIcon = iconMap.get(xyPair)) != null) {
            return tempIcon;
        }
        return xySeries.getCustomValueMarker();
    }

    private class RollOverEffect {
        private Shape myValueMarker;
        private Color myColor;
        private int myDistanceToMousePointer = -1;
        private double myX;
        private double myY;
        protected int myValueMarkerType;
        protected Icon myCustomValueMarker;
        protected double myValueMarkerSize;

        public RollOverEffect(double x, double y, Shape valueMarker, Color color, int markerType, double markerSize, Icon customValueMarkerIcon) {
            this.myX = x;
            this.myY = y;
            this.myValueMarker = valueMarker;
            this.myColor = color;
            this.myValueMarkerType = markerType;
            this.myValueMarkerSize = markerSize;
            this.myCustomValueMarker = customValueMarkerIcon;
        }

        public int calculateDistanceToMouse(Point point) {
            Rectangle markerBounds = this.myValueMarker.getBounds();
            if (this.myValueMarker.contains(point)) {
                int centerX = markerBounds.x + markerBounds.width / 2;
                int centerY = markerBounds.y + markerBounds.height / 2;
                this.myDistanceToMousePointer = Math.abs(centerX - point.x) + Math.abs(centerY - point.y);
            } else {
                this.myDistanceToMousePointer = -1;
            }
            return this.myDistanceToMousePointer;
        }

        public Color getColor() {
            return this.myColor;
        }

        public int getDistanceToMousePointer() {
            return this.myDistanceToMousePointer;
        }

        public double getX() {
            return this.myX;
        }

        public double getY() {
            return this.myY;
        }

        public int getMarkerType() {
            return this.myValueMarkerType;
        }

        public Icon getCustomValueMarker() {
            return this.myCustomValueMarker;
        }

        public double getMarkerSize() {
            return this.myValueMarkerSize;
        }
    }
}

