/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.NetTheme;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.impl.PieSlice;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.FontUIResource;

public class PieChartRenderer
extends AbstractBaseGraphRenderer
implements MouseMotionListener {
    private static final int LABEL_BOUNDS_OFFSET = 1;
    private static final int MAX_ALLOWABLE_LABEL_STACK = 3;
    private static final int LARGE_OUTER_CIRCLE_RADIUS = 165;
    private static final int LARGE_INNER_CIRCLE_RADIUS = 100;
    private static final int SMALL_OUTER_CIRCLE_RADIUS = 55;
    private static final int SMALL_INNER_CIRCLE_RADIUS = 30;
    private static final int LABEL_OFFSET = 10;
    private static final int SPACE_OFFSET = 5;
    private static final int MARGIN_OFFSET = 10;
    private BasicStroke myOuterSliceStroke;
    private BasicStroke myInnerSliceStroke;
    private final BasicStroke myRollOverStroke = new BasicStroke(1.0f, 0, 1);
    private BasicStroke myOuterSliceHoveredStroke;
    private BasicStroke myInnerSliceHoveredStroke;
    private List<PieSlice> mySlices = new ArrayList<PieSlice>();
    private int myOuterCircleRadius;
    private int myInnerCircleRadius;
    private int myXMargin;
    private int myYMargin;
    private double myThickness;
    private List<XYSeries> myXySeries;
    private List<Rectangle> myLabelBounds = new ArrayList<Rectangle>();
    private FontMetrics myFontMetricsPlain;
    private FontMetrics myFontMetricsBold;
    private double myPieSize;

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        if (!xySeries.equals(this.myXySeries)) {
            this.makeSlices(xySeries);
        }
        this.myLabelBounds.clear();
        FontUIResource font = this.myChart.getProperty("PieSize").equals("SmallPie") ? NetTheme.getSmallChartTextFont().deriveFont(10.25f) : NetTheme.getSmallControlTextFont();
        graphics.setFont(font);
        this.computeMargin(xySeries, graphics.getFontMetrics(graphics.getFont().deriveFont(1)));
        Object pieChartSize = this.myChart.getProperty("PieSize");
        this.myOuterCircleRadius = pieChartSize.equals("LargePie") ? 165 : 55;
        this.myInnerCircleRadius = pieChartSize.equals("LargePie") ? 100 : 30;
        this.myThickness = this.myOuterCircleRadius - this.myInnerCircleRadius;
        this.myOuterSliceStroke = new BasicStroke((float)this.myThickness, 0, 1);
        this.myInnerSliceStroke = new BasicStroke((float)(this.myThickness / 2.0), 0, 1);
        this.myOuterSliceHoveredStroke = new BasicStroke((float)this.myThickness + 2.0f, 0, 1);
        this.myInnerSliceHoveredStroke = new BasicStroke((float)(this.myThickness / 2.0) + 2.0f, 0, 1);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        int currentValue = -90;
        int startAngle = 0;
        int arcLength = 0;
        PieSlice hoveredSlice = null;
        boolean isHoveredSlice = false;
        for (PieSlice slice : this.mySlices) {
            isHoveredSlice = false;
            startAngle = currentValue;
            arcLength = (int)Math.round(slice.getValue() * 360.0 / this.myPieSize);
            if (slice.getRollOverColor().equals(NetTheme.getHoverColor())) {
                hoveredSlice = slice;
                isHoveredSlice = true;
            }
            if (slice.equals(this.mySlices.get(this.mySlices.size() - 1))) {
                arcLength = 270 - startAngle;
            }
            slice.setStartAngle(startAngle);
            slice.setArcAngle(arcLength + startAngle);
            this.drawArc(graphics, startAngle, arcLength, slice, isHoveredSlice);
            this.drawPieSliceBounds(startAngle, arcLength, slice);
            currentValue += arcLength;
        }
        if (((Boolean)this.myChart.getProperty("showpielabel")).booleanValue()) {
            this.drawPieLabels(graphics, this.mySlices);
        }
        if (hoveredSlice != null) {
            this.drawRollOver(graphics, hoveredSlice);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawPieLabels(Graphics2D graphics, List<PieSlice> slices) {
        void var4_5;
        ArrayList sortedList = new ArrayList();
        boolean bl = false;
        while (var4_5 < 4) {
            sortedList.add(new ArrayList());
            ++var4_5;
        }
        for (PieSlice pieSlice : slices) {
            int angle = (pieSlice.getStartAngle() + pieSlice.getArcAngle()) / 2;
            Quadrant quadrant = this.getQuadrant(angle);
            switch (quadrant) {
                case I: {
                    ((List)sortedList.get(0)).add(pieSlice);
                    break;
                }
                case II: {
                    ((List)sortedList.get(1)).add(0, pieSlice);
                    break;
                }
                case III: {
                    ((List)sortedList.get(2)).add(pieSlice);
                    break;
                }
                case IV: {
                    ((List)sortedList.get(3)).add(0, pieSlice);
                    break;
                }
                default: {
                    this.drawLabel(graphics, pieSlice);
                }
            }
        }
        for (List list : sortedList) {
            for (PieSlice slice : list) {
                this.drawLabel(graphics, slice);
            }
        }
    }

    private void computeMargin(List<XYSeries> xySeries, FontMetrics fontMetrics) {
        int maxLength = 0;
        for (XYSeries series : xySeries) {
            maxLength = Math.max(fontMetrics.stringWidth(series.getName()), maxLength);
        }
        int percentWidth = fontMetrics.stringWidth("99.99%");
        this.myXMargin = maxLength + percentWidth + 10 + 10;
        this.myYMargin = fontMetrics.getAscent() * 3 + 10 + 10;
    }

    private void makeSlices(List<XYSeries> xySeries) {
        this.mySlices.clear();
        this.myPieSize = 0.0;
        for (XYSeries series : xySeries) {
            XYPair pair = series.getFirstPair();
            this.mySlices.add(new PieSlice(pair.getYAsDouble(), series.getName(), series.getColor(), series.getGradientColor()));
            this.myPieSize += pair.getYAsDouble();
        }
        for (PieSlice slice : this.mySlices) {
            slice.setPercentage(slice.getValue() / this.myPieSize);
        }
        this.myXySeries = xySeries;
    }

    private void drawArc(Graphics2D g2D, int startAngle, int arcLength, PieSlice slice, boolean isHovered) {
        double offSet = isHovered ? 1 : 0;
        Arc2D.Double outerSliceRegion = new Arc2D.Double((double)this.myXMargin + this.myThickness / 2.0 - offSet / 4.0, (double)this.myYMargin + this.myThickness / 2.0 - offSet / 4.0, (double)(this.myOuterCircleRadius * 2) - this.myThickness + offSet / 2.0, (double)(this.myOuterCircleRadius * 2) - this.myThickness + offSet / 2.0, -startAngle, -arcLength, 0);
        Arc2D.Double innerSliceRegion = new Arc2D.Double((double)this.myXMargin + this.myThickness * 0.75 + offSet / 4.0, (double)this.myYMargin + this.myThickness * 0.75 + offSet / 4.0, (double)(this.myInnerCircleRadius * 2) + this.myThickness / 2.0 - offSet / 2.0, (double)(this.myInnerCircleRadius * 2) + this.myThickness / 2.0 - offSet / 2.0, -startAngle, -arcLength, 0);
        g2D.setColor(slice.getPrimaryColor());
        g2D.setStroke(isHovered ? this.myOuterSliceHoveredStroke : this.myOuterSliceStroke);
        g2D.draw(outerSliceRegion);
        g2D.setColor(slice.getGradientColor());
        g2D.setStroke(isHovered ? this.myInnerSliceHoveredStroke : this.myInnerSliceStroke);
        g2D.draw(innerSliceRegion);
    }

    private void drawPieSliceBounds(int startAngle, int arcAngle, PieSlice slice) {
        double value;
        Polygon polygonSliceRegion = new Polygon();
        int i = startAngle;
        while (i <= arcAngle + startAngle + 1) {
            value = (double)i / 360.0;
            polygonSliceRegion.addPoint((int)((double)(this.myOuterCircleRadius + this.myXMargin) + (double)this.myOuterCircleRadius * Math.cos(2.0 * value * Math.PI)), (int)((double)(this.myOuterCircleRadius + this.myYMargin) + (double)this.myOuterCircleRadius * Math.sin(2.0 * value * Math.PI)));
            ++i;
        }
        i = arcAngle + startAngle + 1;
        while (i >= startAngle) {
            value = (double)i / 360.0;
            polygonSliceRegion.addPoint((int)((double)this.myInnerCircleRadius + this.myThickness + (double)this.myXMargin + (double)this.myInnerCircleRadius * Math.cos(2.0 * value * Math.PI)), (int)((double)this.myInnerCircleRadius + this.myThickness + (double)this.myYMargin + (double)this.myInnerCircleRadius * Math.sin(2.0 * value * Math.PI)));
            --i;
        }
        slice.setPolygonSlice(polygonSliceRegion);
    }

    private void drawRollOver(Graphics2D g2D, PieSlice slice) {
        int startAngle = slice.getStartAngle();
        int arcLength = slice.getArcAngle() - slice.getStartAngle();
        g2D.setStroke(this.myRollOverStroke);
        g2D.setColor(slice.getRollOverColor());
        Arc2D.Double outerSliceRollOver = new Arc2D.Double(this.myXMargin - 1, this.myYMargin - 1, this.myOuterCircleRadius * 2 + 2, this.myOuterCircleRadius * 2 + 2, -startAngle, -arcLength, 0);
        g2D.draw(outerSliceRollOver);
        Arc2D.Double innerSliceRollOver = new Arc2D.Double((double)this.myXMargin + this.myThickness + 1.0, (double)this.myYMargin + this.myThickness + 1.0, this.myInnerCircleRadius * 2 - 2, this.myInnerCircleRadius * 2 - 2, -startAngle, -arcLength, 0);
        g2D.draw(innerSliceRollOver);
        g2D.drawLine((int)outerSliceRollOver.getStartPoint().getX(), (int)outerSliceRollOver.getStartPoint().getY(), (int)innerSliceRollOver.getStartPoint().getX(), (int)innerSliceRollOver.getStartPoint().getY());
        g2D.drawLine((int)outerSliceRollOver.getEndPoint().getX(), (int)outerSliceRollOver.getEndPoint().getY(), (int)innerSliceRollOver.getEndPoint().getX(), (int)innerSliceRollOver.getEndPoint().getY());
    }

    private void drawLabel(Graphics2D g2d, PieSlice slice) {
        g2d.setColor(ChartConstants.DEFAULT_CHART_AXIS_LABEL_COLOR);
        int angle = (slice.getStartAngle() + slice.getArcAngle()) / 2;
        int additionalOffset = 0;
        int angleOffset = 0;
        this.myFontMetricsPlain = g2d.getFontMetrics(g2d.getFont());
        this.myFontMetricsBold = g2d.getFontMetrics(g2d.getFont().deriveFont(1));
        Point labelPoint = this.computeLabelCoordinate(slice, angle, additionalOffset);
        int stringWidth = this.myFontMetricsBold.stringWidth(slice.getLabel()) + 5 + this.myFontMetricsPlain.stringWidth(slice.getPercentString());
        Rectangle currentBounds = new Rectangle(labelPoint.x - 1, labelPoint.y - this.myFontMetricsBold.getAscent() - 1, stringWidth + 2, this.myFontMetricsBold.getAscent() + 2);
        for (Rectangle stringBounds : this.myLabelBounds) {
            while (stringBounds.intersects(currentBounds) && angleOffset + angle < slice.getArcAngle() - 1) {
                labelPoint = this.computeLabelCoordinate(slice, ++angleOffset + angle, additionalOffset);
                currentBounds.x = labelPoint.x - 1;
                currentBounds.y = labelPoint.y - this.myFontMetricsBold.getAscent() - 1;
            }
            while (stringBounds.intersects(currentBounds)) {
                labelPoint = this.computeLabelCoordinate(slice, angle, ++additionalOffset);
                currentBounds.x = labelPoint.x - 1;
                currentBounds.y = labelPoint.y - this.myFontMetricsBold.getAscent() - 1;
            }
        }
        g2d.setFont(g2d.getFont().deriveFont(1));
        g2d.drawString(slice.getLabel(), labelPoint.x, labelPoint.y);
        g2d.setColor(ChartConstants.DEFAULT_CHART_AXIS_VALUE_LABEL_COLOR);
        g2d.setFont(g2d.getFont().deriveFont(0));
        g2d.drawString(slice.getPercentString(), labelPoint.x + this.myFontMetricsBold.stringWidth(slice.getLabel()) + 5, labelPoint.y);
        this.myLabelBounds.add(currentBounds);
    }

    private Point computeLabelCoordinate(PieSlice slice, int angle, int additionalOffSet) {
        int xOffset = 10;
        int yOffset = 10;
        double value = (double)angle / 360.0;
        Quadrant quadrant = this.getQuadrant(angle);
        if (angle > 350 || angle <= 15 || angle > 165 && angle <= 195) {
            yOffset = (int)((double)yOffset - (double)yOffset * value);
        } else if (angle > 75 && angle <= 105 || angle > 255 && angle <= 285) {
            xOffset = (int)((double)xOffset - (double)xOffset * value);
        }
        if (this.myChart.getProperty("PieSize").equals("SmallPie")) {
            yOffset /= 2;
            xOffset /= 2;
        }
        int textWidthOffset = 0;
        int textHeightOffset = 0;
        if (quadrant == Quadrant.II || quadrant == Quadrant.III || angle == 180) {
            textWidthOffset = this.myFontMetricsBold.stringWidth(slice.getLabel()) + 5 + this.myFontMetricsPlain.stringWidth(slice.getPercentString());
        }
        if (angle > 45 && angle <= 135) {
            textHeightOffset = this.myFontMetricsBold.getAscent();
        }
        int x = (int)((double)(this.myOuterCircleRadius + this.myXMargin) + (double)(this.myOuterCircleRadius + Math.abs(xOffset) + additionalOffSet) * Math.cos(2.0 * value * Math.PI)) - textWidthOffset;
        int y = (int)((double)(this.myOuterCircleRadius + this.myYMargin) + (double)(this.myOuterCircleRadius + Math.abs(yOffset) + additionalOffSet) * Math.sin(2.0 * value * Math.PI)) + textHeightOffset;
        return new Point(x, y);
    }

    private Quadrant getQuadrant(int angle) {
        if (angle > 0 && angle < 90) {
            return Quadrant.I;
        }
        if (angle > 90 && angle < 180) {
            return Quadrant.II;
        }
        if (angle > 180 && angle < 270) {
            return Quadrant.III;
        }
        if (!(angle <= -90 && angle <= 270 || angle >= 0 && angle >= 360)) {
            return Quadrant.IV;
        }
        if (angle == 0 || angle == 180) {
            return Quadrant.X_AXIS;
        }
        if (angle == -90 || angle == 90 || angle == 270) {
            return Quadrant.Y_AXIS;
        }
        return null;
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setBackground(new Color(0, 0, 0, 0));
        g.setColor(xySeries.getColor());
        int diameter = size.width < size.height ? size.width : size.height;
        g.fillOval(diameter / 4, diameter / 4, diameter / 2, diameter / 2);
        return image;
    }

    @Override
    public void init(Chart chart) {
        this.myChart = chart;
    }

    @Override
    public void paintThresholds(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (PieSlice slice : this.mySlices) {
            slice.doMouseExit();
        }
        for (PieSlice slice : this.mySlices) {
            if (!slice.isInside(e.getPoint())) continue;
            slice.doMouseEntered();
            break;
        }
    }

    private static enum Quadrant {
        I,
        II,
        III,
        IV,
        X_AXIS,
        Y_AXIS;

    }
}

