/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.chart.renderers;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.chart.Chart;
import com.nokia.widgets.chart.ChartConstants;
import com.nokia.widgets.chart.GraphArea;
import com.nokia.widgets.chart.data.XYPair;
import com.nokia.widgets.chart.data.XYSeries;
import com.nokia.widgets.chart.renderers.AbstractBaseGraphRenderer;
import com.nokia.widgets.util.SystemUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class StackedAreaGraphRenderer
extends AbstractBaseGraphRenderer {
    private Polygon myStackedArea = new Polygon();

    @Override
    public void init(Chart chart) {
        super.init(chart);
        this.myDrawPriority = 8;
    }

    private void updatePolygonPoints(XYSeries xySeries, GraphArea graphArea) {
        this.myStackedArea.reset();
        int x = 0;
        int y = 0;
        Object xValue = null;
        Object yValue = null;
        Object yValuePrevious = new Double(0.0);
        List<XYPair> xyPairs = xySeries.getXYPairs();
        boolean lonesomeValue = false;
        ArrayList<Point> dataPoints = new ArrayList<Point>();
        int i = 0;
        while (i < xyPairs.size()) {
            if (xyPairs.get(i) != null) {
                Double zeroValue = new Double(0.0);
                xValue = xyPairs.get(i).getX();
                yValue = xyPairs.get(i).getY();
                x = (int)graphArea.getXAxisPositionForValue(xValue);
                if (x == (int)graphArea.getBounds().getX()) {
                    ++x;
                }
                y = (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(yValue) : graphArea.getRightYAxisPositionForValue(yValue));
                if (yValuePrevious == ChartConstants.VALUE_NOT_DEFINED) {
                    if (i + 1 < xyPairs.size() && SystemUtils.isEqual(xyPairs.get(i + 1).getYAsDouble(), ChartConstants.VALUE_NOT_DEFINED)) {
                        int previousX = (int)graphArea.getXAxisPositionForValue(xyPairs.get(i - 1).getX());
                        int nextX = (int)graphArea.getXAxisPositionForValue(xyPairs.get(i + 1).getX());
                        this.myStackedArea.addPoint((x + previousX) / 2, (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(zeroValue) : graphArea.getRightYAxisPositionForValue(zeroValue)));
                        this.myStackedArea.addPoint((x + previousX) / 2, y);
                        this.myStackedArea.addPoint(x + 2, y);
                        this.myStackedArea.addPoint((x + nextX) / 2, y);
                        lonesomeValue = true;
                    } else {
                        this.myStackedArea.addPoint(x, (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(zeroValue) : graphArea.getRightYAxisPositionForValue(zeroValue)));
                    }
                }
                if (xyPairs.size() == 1) {
                    this.myStackedArea.addPoint((int)graphArea.getAdjustedGraphXEnd(), y);
                }
                if (yValue != ChartConstants.VALUE_NOT_DEFINED && !lonesomeValue) {
                    this.myStackedArea.addPoint(x, y);
                    dataPoints.add(new Point(x, y));
                }
                if (i + 1 < xyPairs.size() && xyPairs.get(i + 1) != null) {
                    XYPair nextXYpair = xyPairs.get(i + 1);
                    Number bb = null;
                    bb = nextXYpair.isYIntegerNumber() ? (Number)nextXYpair.getYAsLong() : (Number)new Double(nextXYpair.getYAsDouble());
                    if (SystemUtils.isEqual(((Number)bb).doubleValue(), ChartConstants.VALUE_NOT_DEFINED)) {
                        if (lonesomeValue) {
                            int nextX = (int)graphArea.getXAxisPositionForValue(nextXYpair.getX());
                            this.myStackedArea.addPoint((x + nextX) / 2, (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(zeroValue) : graphArea.getRightYAxisPositionForValue(zeroValue)));
                        } else {
                            this.myStackedArea.addPoint(x, (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(zeroValue) : graphArea.getRightYAxisPositionForValue(zeroValue)));
                        }
                    }
                }
                yValuePrevious = yValue;
                lonesomeValue = false;
            }
            ++i;
        }
        this.myXYSeriesToValuePoints.put(xySeries, dataPoints);
        int graphYEnd = (int)(xySeries.getUseLeftYAxis() ? graphArea.getLeftYAxisPositionForValue(new Double(0.0)) : graphArea.getRightYAxisPositionForValue(new Double(0.0)));
        if ((double)x - graphArea.getAdjustedGraphXStart() < graphArea.getAdjustedGraphXEnd() - (double)x) {
            this.myStackedArea.addPoint((int)graphArea.getAdjustedGraphXStart() + 1, graphYEnd);
            this.myStackedArea.addPoint((int)graphArea.getAdjustedGraphXEnd(), graphYEnd);
        } else {
            this.myStackedArea.addPoint((int)graphArea.getAdjustedGraphXEnd(), graphYEnd);
            this.myStackedArea.addPoint((int)graphArea.getAdjustedGraphXStart() + 1, graphYEnd);
        }
    }

    @Override
    public void paintGraphs(List<XYSeries> xySeries, Graphics2D graphics, GraphArea graphArea) {
        this.paintHighLightData(graphArea);
        Color areaBorderColor = (Color)this.myChart.getProperty("stackedareacolor");
        Object oldAa = NetUtils.antiAliasingOn(graphics);
        int i = 0;
        while (i < xySeries.size()) {
            Color fillColor;
            this.updatePolygonPoints(xySeries.get(i), graphArea);
            if (areaBorderColor != null) {
                graphics.setColor(areaBorderColor);
                graphics.draw(this.myStackedArea);
            }
            Paint oldPaint = graphics.getPaint();
            Color color = xySeries.get(i).getColor();
            boolean paintOutline = Boolean.TRUE.equals(this.myChart.getProperty("paintOutline"));
            Color color2 = fillColor = paintOutline ? NetUtils.getColor(color, 175) : color;
            if (this.myChart.getProperty("gradientpaint") == Boolean.TRUE) {
                Rectangle b = this.myStackedArea.getBounds();
                GradientPaint gp = new GradientPaint(0.0f, b.y, fillColor, 0.0f, b.y + b.height, fillColor.brighter().brighter());
                graphics.setPaint(gp);
            } else {
                graphics.setColor(fillColor);
            }
            graphics.fill(this.myStackedArea);
            if (paintOutline) {
                graphics.setColor(color);
                graphics.setStroke(new BasicStroke(2.0f));
                NetUtils.antiAliasingOff(graphics);
                graphics.draw(this.myStackedArea);
            }
            graphics.setPaint(oldPaint);
            NetUtils.setAntialiasing(graphics, oldAa);
            ++i;
        }
        this.paintStaticValuePointLabel(xySeries, graphics);
    }

    @Override
    public Image getLegendBoxImage(XYSeries xySeries, Dimension size) {
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)img).getGraphics();
        Object oldAa = NetUtils.antiAliasingOn(graphics);
        Color color = xySeries.getColor();
        graphics.setColor(color);
        Polygon stackedArea = new Polygon();
        stackedArea.addPoint(0, (int)((double)size.height * 0.75));
        stackedArea.addPoint(0, (int)((double)size.height * 0.5));
        stackedArea.addPoint(size.width / 2, (int)((double)size.height * 0.25));
        stackedArea.addPoint(size.width, (int)((double)size.height * 0.5));
        stackedArea.addPoint(size.width, (int)((double)size.height * 0.75));
        boolean paintOutline = Boolean.TRUE.equals(this.myChart.getProperty("paintOutline"));
        boolean paintGradient = Boolean.TRUE.equals(this.myChart.getProperty("gradientpaint"));
        if (paintGradient) {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color, 0.0f, size.height, color.brighter().brighter());
            ((Graphics2D)graphics).setPaint(gp);
            ((Graphics2D)graphics).fill(stackedArea);
        } else {
            graphics.fillPolygon(stackedArea);
        }
        if (paintOutline) {
            graphics.setColor(color);
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            NetUtils.antiAliasingOff(graphics);
            ((Graphics2D)graphics).draw(stackedArea);
        }
        graphics.dispose();
        NetUtils.setAntialiasing(graphics, oldAa);
        return img;
    }
}

