/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.checkboxlist;

import com.nokia.widgets.checkboxlist.CheckBoxListCellRenderer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class CheckBoxList
extends JList {
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean isCheckBoxEnabled = true;
    private boolean isClickInCheckBoxOnly = false;
    private DefaultListSelectionModel myCheckBoxListSelectionModel;
    protected Handler myHandler;

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(Vector<?> listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(Object[] listData) {
        super(listData);
        this.init();
    }

    public CheckBoxList(ListModel dataModel) {
        super(dataModel);
        this.init();
    }

    protected void init() {
        this.myCheckBoxListSelectionModel = new DefaultListSelectionModel();
        this.setSelectionMode(0);
        CheckBoxListCellRenderer renderer = new CheckBoxListCellRenderer();
        this.setCellRenderer(renderer);
        this.myHandler = this.createHandler();
        this.myCheckBoxListSelectionModel.addListSelectionListener(this.myHandler);
        this.insertMouseListener(this, this.myHandler, 0);
        this.addKeyListener(this.myHandler);
        this.addPropertyChangeListener("model", this.myHandler);
        ListModel model = this.getModel();
        if (model != null) {
            model.addListDataListener(this.myHandler);
        }
    }

    private void insertMouseListener(Component component, MouseListener l, int index) {
        MouseListener[] listeners = component.getMouseListeners();
        int i = 0;
        while (i < listeners.length) {
            component.removeMouseListener(listeners[i]);
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            MouseListener listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
            ++i;
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled(int index) {
        return true;
    }

    public boolean isCheckBoxVisible(int index) {
        return true;
    }

    public boolean isCheckBoxEnabled() {
        return this.isCheckBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean enabled) {
        if (enabled != this.isCheckBoxEnabled) {
            boolean old = this.isCheckBoxEnabled;
            this.isCheckBoxEnabled = enabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, old, this.isCheckBoxEnabled);
            this.repaint();
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this.isClickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean aFlag) {
        if (aFlag != this.isClickInCheckBoxOnly) {
            boolean old = this.isClickInCheckBoxOnly;
            this.isClickInCheckBoxOnly = aFlag;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this.isClickInCheckBoxOnly);
        }
    }

    public DefaultListSelectionModel getCheckBoxSelectionModel() {
        return this.myCheckBoxListSelectionModel;
    }

    public void setCheckBoxListSelectionModel(DefaultListSelectionModel model) {
        this.myCheckBoxListSelectionModel = model;
    }

    public int[] getCheckBoxSelectedIndices() {
        DefaultListSelectionModel listSelectionModel = this.getCheckBoxSelectionModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] temp = new int[1 + (iMax - iMin)];
        int n = 0;
        int i = iMin;
        while (i <= iMax) {
            if (listSelectionModel.isSelectedIndex(i)) {
                temp[n] = i;
                ++n;
            }
            ++i;
        }
        int[] indices = new int[n];
        System.arraycopy(temp, 0, indices, 0, n);
        return indices;
    }

    public void setCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void addCheckBoxSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void removeCheckBoxListSelectedIndex(int index) {
        if (index >= 0 && index < this.getModel().getSize()) {
            this.getCheckBoxSelectionModel().removeSelectionInterval(index, index);
        }
    }

    public void setCheckBoxListSelectedIndices(int[] indices) {
        DefaultListSelectionModel listSelectionModel = this.getCheckBoxSelectionModel();
        try {
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel.clearSelection();
            int size = this.getModel().getSize();
            int indice = 0;
            while (indice < indices.length) {
                if (indice >= 0 && indice < size) {
                    listSelectionModel.addSelectionInterval(indices[indice], indices[indice]);
                }
                ++indice;
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void setSelectedObjects(Object[] selected) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int x = 0;
        while (x < this.getModel().getSize()) {
            int y = 0;
            while (y < selected.length) {
                if (this.getModel().getElementAt(x) != null && selected[y] != null && selected[y].equals(this.getModel().getElementAt(x))) {
                    indices.add(x);
                }
                ++y;
            }
            ++x;
        }
        int[] selectedIndices = new int[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            Integer row = (Integer)indices.get(i);
            selectedIndices[i] = row;
            ++i;
        }
        this.setCheckBoxListSelectedIndices(selectedIndices);
    }

    public void setSelectedObjects(Vector<?> elements) {
        Object[] arr = new Object[elements.size()];
        int x = 0;
        while (x < elements.size()) {
            arr[x] = elements.get(x);
            ++x;
        }
        this.setSelectedObjects(arr);
    }

    public Object[] getCheckBoxSelectedValues() {
        DefaultListSelectionModel listSelectionModel = this.getCheckBoxSelectionModel();
        ListModel model = this.getModel();
        int iMin = listSelectionModel.getMinSelectionIndex();
        int iMax = listSelectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] temp = new Object[1 + (iMax - iMin)];
        int n = 0;
        int i = iMin;
        while (i <= iMax) {
            if (listSelectionModel.isSelectedIndex(i)) {
                temp[n] = model.getElementAt(i);
                ++n;
            }
            ++i;
        }
        Object[] indices = new Object[n];
        System.arraycopy(temp, 0, indices, 0, n);
        return indices;
    }

    public int getCheckBoxSelectedIndex() {
        return this.getCheckBoxSelectionModel().getMinSelectionIndex();
    }

    public Object getCheckBoxSelectedValue() {
        int i = this.getCheckBoxSelectionModel().getMinSelectionIndex();
        return i == -1 ? null : this.getModel().getElementAt(i);
    }

    public void setCheckBoxSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else {
            ListModel model = this.getModel();
            int i = 0;
            int c = model.getSize();
            while (i < c) {
                if (anObject.equals(model.getElementAt(i))) {
                    this.setCheckBoxListSelectedIndex(i);
                    if (shouldScroll) {
                        this.ensureIndexIsVisible(i);
                    }
                    this.repaint();
                    return;
                }
                ++i;
            }
            this.setCheckBoxListSelectedIndex(-1);
        }
        this.repaint();
    }

    public void addCheckBoxSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel model = this.getModel();
            int i = 0;
            int c = model.getSize();
            while (i < c) {
                if (anObject.equals(model.getElementAt(i))) {
                    this.addCheckBoxSelectedIndex(i);
                    if (shouldScroll) {
                        this.ensureIndexIsVisible(i);
                    }
                    this.repaint();
                    return;
                }
                ++i;
            }
        }
    }

    public void addCheckBoxSelectedValues(Object[] objects) {
        if (objects != null) {
            ListModel model = this.getModel();
            boolean changed = false;
            int i = 0;
            int c = model.getSize();
            while (i < c) {
                int x = 0;
                while (x < objects.length) {
                    if (objects[x] != null && objects[x].equals(model.getElementAt(i))) {
                        this.addCheckBoxSelectedIndex(i);
                        changed = true;
                    }
                    ++x;
                }
                ++i;
            }
            if (changed) {
                this.repaint();
            }
        }
    }

    public void removeCheckBoxListSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject != null) {
            ListModel model = this.getModel();
            int i = 0;
            int c = model.getSize();
            while (i < c) {
                if (anObject.equals(model.getElementAt(i))) {
                    this.removeCheckBoxListSelectedIndex(i);
                    if (shouldScroll) {
                        this.ensureIndexIsVisible(i);
                    }
                    this.repaint();
                    return;
                }
                ++i;
            }
        }
    }

    public void selectAll() {
        this.getCheckBoxSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
    }

    public void selectNone() {
        this.getCheckBoxSelectionModel().removeIndexInterval(0, this.getModel().getSize() - 1);
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        protected CheckBoxList myList;
        private int myHotspot;

        public Handler(CheckBoxList list) {
            this.myHotspot = new JCheckBox().getPreferredSize().width + 5;
            this.myList = list;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() instanceof ListModel) {
                ((ListModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ListModel) {
                ((ListModel)evt.getNewValue()).addListDataListener(this);
            }
        }

        protected boolean clickIsInCheckBox(MouseEvent e) {
            int index = this.myList.locationToIndex(e.getPoint());
            Rectangle bounds = this.myList.getCellBounds(index, index);
            if (bounds != null) {
                if (this.myList.getComponentOrientation().isLeftToRight()) {
                    return e.getX() < bounds.x + this.myHotspot;
                }
                return e.getX() > bounds.x + bounds.width - this.myHotspot;
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.myList.isCheckBoxEnabled() || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.myList.isClickInCheckBoxOnly() || this.clickIsInCheckBox(e)) {
                int index = this.myList.locationToIndex(e.getPoint());
                this.toggleSelection(index);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.myList.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        protected void toggleSelections() {
            int[] indices = this.myList.getSelectedIndices();
            DefaultListSelectionModel selectionModel = this.myList.getCheckBoxSelectionModel();
            selectionModel.removeListSelectionListener(this);
            selectionModel.setValueIsAdjusting(true);
            try {
                if (indices.length > 0) {
                    boolean selected = selectionModel.isSelectedIndex(indices[0]);
                    int index = 0;
                    while (index < indices.length) {
                        if (this.myList.isCheckBoxEnabled(indices[index])) {
                            if (selected && selectionModel.isSelectedIndex(indices[index])) {
                                selectionModel.removeSelectionInterval(indices[index], indices[index]);
                            } else if (!selected && !selectionModel.isSelectedIndex(indices[index])) {
                                selectionModel.addSelectionInterval(indices[index], indices[index]);
                            }
                        }
                        ++index;
                    }
                }
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
                selectionModel.addListSelectionListener(this);
                this.myList.repaint();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.myList.repaint();
        }

        protected void toggleSelection(int index) {
            if (!this.myList.isEnabled() || !this.myList.isCheckBoxEnabled(index)) {
                return;
            }
            DefaultListSelectionModel selectionModel = this.myList.getCheckBoxSelectionModel();
            boolean selected = selectionModel.isSelectedIndex(index);
            selectionModel.removeListSelectionListener(this);
            try {
                if (selected) {
                    selectionModel.removeSelectionInterval(index, index);
                } else {
                    selectionModel.addSelectionInterval(index, index);
                }
            }
            finally {
                selectionModel.addListSelectionListener(this);
                this.myList.repaint();
            }
        }

        protected void toggleSelection() {
            int index = this.myList.getSelectedIndex();
            this.toggleSelection(index);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            DefaultListSelectionModel listSelectionModel = this.myList.getCheckBoxSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(minIndex, maxIndex - minIndex + 1, true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            DefaultListSelectionModel listSelectionModel = this.myList.getCheckBoxSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    }
}

