/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.checkboxlist;

import com.nokia.widgets.checkboxlist.CheckBoxList;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.list.FilteredListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CheckBoxListCellRenderer
extends JPanel
implements ListCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JCheckBox myCheckBox = null;
    protected PLabel myLabel;
    protected static Border noFocusBorder;
    private static boolean theNoFocusBorderChanged;

    static {
        theNoFocusBorderChanged = false;
    }

    public CheckBoxListCellRenderer() {
        if (!theNoFocusBorderChanged) {
            noFocusBorder = UIManager.getBorder("List.noFocusCellBorder");
            theNoFocusBorderChanged = true;
        }
        this.myCheckBox = new JCheckBox();
        this.myCheckBox.setPreferredSize(new Dimension(20, 20));
        this.myCheckBox.putClientProperty("JComponent.sizeVariant", "small");
        this.myCheckBox.setOpaque(false);
        this.myCheckBox.setBackground(null);
        this.myCheckBox.setForeground(null);
        this.myCheckBox.setBorder(BorderFactory.createEmptyBorder());
        this.myLabel = PLabel.createValueText();
        this.myLabel.setOpaque(false);
        this.myLabel.setBackground(null);
        this.putClientProperty("OceanTouch.hoverXOffset", this.myCheckBox.getPreferredSize().width);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.myCheckBox, "Before");
        this.add((Component)this.myLabel, "Center");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.applyComponentOrientation(list.getComponentOrientation());
        this.updateCheckbox(list, index);
        this.updateLabel(list, value, isSelected);
        this.updateBorder(isSelected, cellHasFocus);
        this.updateBackground(list, isSelected);
        return this;
    }

    private void updateBackground(JList list, boolean isSelected) {
        if (isSelected && list.isEnabled()) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
    }

    private void updateBorder(boolean isSelected, boolean cellHasFocus) {
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
    }

    private void updateLabel(JList list, Object value, boolean issSelected) {
        this.myLabel.setEnabled(list.isEnabled());
        this.myLabel.setFont(list.getFont());
        if (value instanceof Icon) {
            this.myLabel.setIcon((Icon)value);
            this.myLabel.setText("");
        } else {
            this.myLabel.setIcon(null);
            this.myLabel.setText(value == null || "".equals(value) ? " " : value.toString());
            this.myLabel.setForeground(issSelected ? list.getSelectionForeground() : list.getForeground());
        }
    }

    private void updateCheckbox(JList list, int index) {
        DefaultListSelectionModel selectionModel = ((CheckBoxList)list).getCheckBoxSelectionModel();
        if (selectionModel != null) {
            boolean enabled = list.isEnabled() && ((CheckBoxList)list).isCheckBoxEnabled() && ((CheckBoxList)list).isCheckBoxEnabled(index);
            this.myCheckBox.setEnabled(enabled);
            this.myCheckBox.getModel().setArmed(false);
            int originalIndex = this.getOriginalIndex(list, index);
            this.myCheckBox.setSelected(selectionModel.isSelectedIndex(originalIndex));
            if (this.isMouseRollOver(list, index)) {
                this.myCheckBox.getModel().setRollover(true);
            } else {
                this.myCheckBox.getModel().setRollover(false);
            }
        }
    }

    private int getOriginalIndex(JList list, int index) {
        if (list.getModel() instanceof FilteredListModel) {
            return ((FilteredListModel)list.getModel()).getOriginalIndex(index);
        }
        return index;
    }

    private boolean isMouseRollOver(JList list, int index) {
        Point rolloverPosition = (Point)list.getClientProperty("BlueTouch.rolloveredCell");
        if (rolloverPosition != null && rolloverPosition.getX() != -1.0 && rolloverPosition.getY() != -1.0) {
            int rolloverIndex = this.getOriginalIndex(list, list.locationToIndex(rolloverPosition));
            Rectangle cellBounds = list.getCellBounds(index, index);
            if (index == rolloverIndex) {
                return cellBounds.contains(rolloverPosition);
            }
        }
        return false;
    }

    public static class UIResource
    extends CheckBoxListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

