/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.checkboxtree;

import com.nokia.widgets.checkboxtree.CheckBoxTreeCellRenderer;
import com.nokia.widgets.checkboxtree.CheckBoxTreeSelectionModel;
import com.nokia.widgets.tree.PDefaultTreeCellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree {
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_DIG_IN = "digIn";
    protected CheckBoxTreeCellRenderer myTreeCellRenderer;
    private CheckBoxTreeSelectionModel myCheckBoxTreeSelectionModel;
    private boolean isCheckBoxEnabled = true;
    private PropertyChangeListener myModelChangeListener;
    private TreeCellRenderer myDefaultTreeCellRenderer;
    private boolean myDefaultIconsInUse = true;
    private boolean isClickInCheckBoxOnly = false;
    private boolean myIsSelectDisabledChildNodes = true;

    public CheckBoxTree() {
        this.init();
    }

    public CheckBoxTree(Object[] value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Vector<?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(Hashtable<?, ?> value) {
        super(value);
        this.init();
    }

    public CheckBoxTree(TreeNode root) {
        super(root);
        this.init();
    }

    public CheckBoxTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public CheckBoxTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    protected void init() {
        this.myCheckBoxTreeSelectionModel = this.createCheckBoxTreeSelectionModel(this.getModel());
        this.myCheckBoxTreeSelectionModel.setTree(this);
        this.getSelectionModel().setSelectionMode(1);
        this.setDefaultIcons(false);
        Handler handler = this.createHandler();
        this.insertMouseListener(this, handler, 0);
        this.addKeyListener(handler);
        this.myCheckBoxTreeSelectionModel.addTreeSelectionListener(handler);
        if (this.myModelChangeListener == null) {
            this.myModelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectionModel".equals(evt.getPropertyName())) {
                        CheckBoxTree.this.updateRowMapper();
                    }
                    if ("model".equals(evt.getPropertyName()) && evt.getNewValue() instanceof TreeModel) {
                        CheckBoxTree.this.myCheckBoxTreeSelectionModel.setModel((TreeModel)evt.getNewValue());
                    }
                }
            };
        }
        this.addPropertyChangeListener("selectionModel", this.myModelChangeListener);
        this.addPropertyChangeListener("model", this.myModelChangeListener);
        this.updateRowMapper();
        this.putClientProperty("componentPressed", new Point(-1, -1));
    }

    private void insertMouseListener(Component component, MouseListener l, int index) {
        MouseListener[] listeners = component.getMouseListeners();
        int i = 0;
        while (i < listeners.length) {
            component.removeMouseListener(listeners[i]);
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            MouseListener listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
            ++i;
        }
        if (index < 0 || index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }

    protected CheckBoxTreeSelectionModel createCheckBoxTreeSelectionModel(TreeModel model) {
        return new CheckBoxTreeSelectionModel(model);
    }

    private void updateRowMapper() {
        this.myCheckBoxTreeSelectionModel.setRowMapper(this.getSelectionModel().getRowMapper());
    }

    @Override
    public TreeCellRenderer getCellRenderer() {
        TreeCellRenderer renderer = this.getActualCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer();
        }
        if (this.myTreeCellRenderer == null) {
            this.myTreeCellRenderer = this.createCellRenderer(renderer);
        } else {
            this.myTreeCellRenderer.setDefaultTreeRenderer(renderer);
        }
        return this.myTreeCellRenderer;
    }

    private TreeCellRenderer getDefaultRenderer() {
        if (this.myDefaultTreeCellRenderer == null) {
            this.myDefaultTreeCellRenderer = new PDefaultTreeCellRenderer();
        }
        return this.myDefaultTreeCellRenderer;
    }

    public TreeCellRenderer getActualCellRenderer() {
        if (this.myTreeCellRenderer != null) {
            return this.myTreeCellRenderer.getDefaultTreeRenderer();
        }
        return super.getCellRenderer();
    }

    @Override
    public void setCellRenderer(TreeCellRenderer renderer) {
        TreeCellRenderer x = renderer;
        if (x == null) {
            x = this.getDefaultRenderer();
        }
        super.setCellRenderer(x);
        if (this.myTreeCellRenderer != null) {
            this.myTreeCellRenderer.setDefaultTreeRenderer(x);
        }
    }

    public boolean isDefaultIcons() {
        return this.myDefaultIconsInUse;
    }

    public void setDefaultIcons(boolean b) {
        if (b == this.myDefaultIconsInUse) {
            return;
        }
        this.myDefaultIconsInUse = b;
        if (this.myDefaultIconsInUse) {
            this.myTreeCellRenderer.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
            this.myTreeCellRenderer.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
            this.myTreeCellRenderer.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        } else {
            this.myTreeCellRenderer.setLeafIcon(null);
            this.myTreeCellRenderer.setClosedIcon(null);
            this.myTreeCellRenderer.setOpenIcon(null);
        }
        this.treeDidChange();
    }

    protected CheckBoxTreeCellRenderer createCellRenderer(TreeCellRenderer renderer) {
        final CheckBoxTreeCellRenderer checkBoxTreeCellRenderer = new CheckBoxTreeCellRenderer(renderer);
        this.addPropertyChangeListener("cellRenderer", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeCellRenderer treeCellRenderer = (TreeCellRenderer)evt.getNewValue();
                if (treeCellRenderer != checkBoxTreeCellRenderer) {
                    checkBoxTreeCellRenderer.setDefaultTreeRenderer(treeCellRenderer);
                } else {
                    checkBoxTreeCellRenderer.setDefaultTreeRenderer(null);
                }
            }
        });
        return checkBoxTreeCellRenderer;
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    public CheckBoxTreeSelectionModel getCheckBoxTreeSelectionModel() {
        return this.myCheckBoxTreeSelectionModel;
    }

    public boolean isCheckBoxEnabled() {
        return this.isCheckBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this.isCheckBoxEnabled) {
            Boolean oldValue = this.isCheckBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            this.isCheckBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, oldValue, newValue);
            this.repaint();
        }
    }

    public boolean isCheckBoxEnabled(TreePath path) {
        return true;
    }

    public boolean isCheckBoxVisible(TreePath path) {
        return true;
    }

    public boolean isDigInMode() {
        return this.getCheckBoxTreeSelectionModel().isDigInMode();
    }

    public void setDigInMode(boolean digIn) {
        boolean old = this.isDigInMode();
        if (old != digIn) {
            this.getCheckBoxTreeSelectionModel().setDigInMode(digIn);
            this.firePropertyChange(PROPERTY_DIG_IN, old, digIn);
            this.repaint();
        }
    }

    public boolean isClickInCheckBoxOnly() {
        return this.isClickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean aFlag) {
        if (aFlag != this.isClickInCheckBoxOnly) {
            boolean old = this.isClickInCheckBoxOnly;
            this.isClickInCheckBoxOnly = aFlag;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this.isClickInCheckBoxOnly);
        }
    }

    public boolean isSelectDisabledChildNodes() {
        return this.myIsSelectDisabledChildNodes;
    }

    public void setSelectDisabledChildNodes(boolean selectDisabledChildNodes) {
        this.myIsSelectDisabledChildNodes = selectDisabledChildNodes;
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    protected static class Handler
    implements MouseListener,
    KeyListener,
    TreeSelectionListener {
        protected CheckBoxTree myTree;
        int myHotspot;
        private int myToggleCount;
        private TreePath currentlyPressed;

        public Handler(CheckBoxTree tree) {
            this.myHotspot = new JCheckBox().getPreferredSize().width;
            this.myToggleCount = -1;
            this.currentlyPressed = null;
            this.myTree = tree;
        }

        protected TreePath getTreePathForMouseEvent(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            if (!this.myTree.isCheckBoxEnabled()) {
                return null;
            }
            TreePath path = this.myTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return null;
            }
            if (this.isClickInCheckBox(e, path)) {
                return path;
            }
            return null;
        }

        protected boolean isClickInCheckBox(MouseEvent e, TreePath path) {
            if (!this.myTree.isCheckBoxVisible(path)) {
                return false;
            }
            if (!this.myTree.isClickInCheckBoxOnly()) {
                return true;
            }
            Rectangle bounds = this.myTree.getPathBounds(path);
            if (this.myTree.getComponentOrientation().isLeftToRight()) {
                return e.getX() < bounds.x + this.myHotspot;
            }
            return e.getX() > bounds.x + bounds.width - this.myHotspot;
        }

        private TreePath preventToggleEvent(MouseEvent e) {
            int toggleCount;
            TreePath pathForMouseEvent = this.getTreePathForMouseEvent(e);
            if (pathForMouseEvent != null && (toggleCount = this.myTree.getToggleClickCount()) != -1) {
                this.myToggleCount = toggleCount;
                this.myTree.setToggleClickCount(-1);
            }
            return pathForMouseEvent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.preventToggleEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.currentlyPressed = this.preventToggleEvent(e);
            if (this.myTree.getPathForLocation(e.getX(), e.getY()) != null) {
                Point point = (Point)this.myTree.getClientProperty("componentPressed");
                int row = this.myTree.getClosestRowForLocation(e.getY(), e.getY());
                point.move(row, (int)point.getY());
                this.myTree.putClientProperty("componentPressed", point);
                this.myTree.treeDidChange();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreePath path = this.preventToggleEvent(e);
            if (path != null && this.currentlyPressed != null && this.currentlyPressed.equals(path)) {
                this.toggleSelection(path);
                e.consume();
            }
            this.myTree.putClientProperty("componentPressed", new Point(-1, -1));
            this.myTree.treeDidChange();
            if (this.myToggleCount != -1) {
                this.myTree.setToggleClickCount(this.myToggleCount);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!this.myTree.isCheckBoxEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.myTree.treeDidChange();
        }

        private void toggleSelection(TreePath path) {
            if (!this.myTree.isEnabled() || !this.myTree.isCheckBoxEnabled(path)) {
                return;
            }
            CheckBoxTreeSelectionModel model = this.myTree.getCheckBoxTreeSelectionModel();
            boolean selected = model.isPathSelected(path, model.isDigInMode());
            model.removeTreeSelectionListener(this);
            try {
                if (!model.isSingleEventMode()) {
                    model.setBatchMode(true);
                }
                if (selected) {
                    model.removeSelectionPath(path);
                } else {
                    model.addSelectionPath(path);
                }
            }
            finally {
                if (!model.isSingleEventMode()) {
                    model.setBatchMode(false);
                }
                model.addTreeSelectionListener(this);
                this.myTree.treeDidChange();
            }
        }

        protected void toggleSelections() {
            TreePath[] treePaths = this.myTree.getSelectionPaths();
            if (treePaths == null) {
                return;
            }
            int i = 0;
            while (i < treePaths.length) {
                this.toggleSelection(treePaths[i]);
                ++i;
            }
        }
    }
}

