/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.checkboxtree;

import com.nokia.widgets.checkboxtree.CheckBoxTree;
import com.nokia.widgets.checkboxtree.CheckBoxTreeSelectionModel;
import com.nokia.widgets.tristatecheckbox.TristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
Serializable,
Accessible {
    protected TristateCheckBox myCheckBox = null;
    protected JComponent myEmptyBox = null;
    protected TreeCellRenderer myDefaultTreeRenderer;

    public CheckBoxTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public CheckBoxTreeCellRenderer(TreeCellRenderer renderer) {
        this.setName("CheckBoxTree.cellRenderer");
        this.myCheckBox = new TristateCheckBox();
        this.myEmptyBox = (JComponent)Box.createHorizontalStrut(this.myCheckBox.getPreferredSize().width);
        this.myCheckBox.setSizeVariant("small");
        this.myCheckBox.setName("CheckBoxTree.checkBox");
        this.myCheckBox.setOpaque(false);
        this.myEmptyBox.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 1, 0));
        this.putClientProperty("OceanTouch.hoverXOffset", this.myCheckBox.getPreferredSize().width + 2);
        this.setLayout(new BorderLayout(2, 0));
        this.myDefaultTreeRenderer = renderer;
    }

    public TreeCellRenderer getDefaultTreeRenderer() {
        return this.myDefaultTreeRenderer;
    }

    public void setDefaultTreeRenderer(TreeCellRenderer renderer) {
        this.myDefaultTreeRenderer = renderer;
    }

    public TristateCheckBox getCheckBox() {
        return this.myCheckBox;
    }

    @Override
    public Component getTreeCellRendererComponent(final JTree tree, final Object value, final boolean selected, final boolean expanded, final boolean leaf, final int row, final boolean hasFocus) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckBoxTreeCellRenderer.this.renderTreeCell(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            });
        } else {
            this.renderTreeCell(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        return this;
    }

    private void renderTreeCell(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        CheckBoxTreeSelectionModel selectionModel;
        this.applyComponentOrientation(tree.getComponentOrientation());
        TreePath path = tree.getPathForRow(row);
        if (path != null && tree instanceof CheckBoxTree && (selectionModel = ((CheckBoxTree)tree).getCheckBoxTreeSelectionModel()) != null) {
            Point pressed;
            this.myCheckBox.getModel().setArmed(false);
            this.myCheckBox.setEnabled(true);
            if (selectionModel.isPathSelected(path, selectionModel.isDigInMode())) {
                this.myCheckBox.setSelected(true);
            } else if (selectionModel.isDigInMode() && selectionModel.isPartiallySelected(path)) {
                this.myCheckBox.setPending(true);
            } else {
                this.myCheckBox.setSelected(false);
            }
            boolean enabled = tree.isEnabled() && ((CheckBoxTree)tree).isCheckBoxEnabled() && ((CheckBoxTree)tree).isCheckBoxEnabled(path);
            this.myCheckBox.setEnabled(enabled);
            Point rolloverPosition = (Point)tree.getClientProperty("BlueTouch.rolloveredCell");
            if (rolloverPosition != null) {
                int rolloverRow = (int)rolloverPosition.getX();
                if (row == rolloverRow) {
                    this.myCheckBox.getModel().setRollover(true);
                } else {
                    this.myCheckBox.getModel().setRollover(false);
                }
            }
            if ((pressed = (Point)tree.getClientProperty("componentPressed")) != null) {
                int pressedRow = (int)pressed.getX();
                if (row == pressedRow) {
                    this.myCheckBox.getModel().setPressed(true);
                    this.myCheckBox.getModel().setArmed(true);
                } else {
                    this.myCheckBox.getModel().setPressed(false);
                }
            }
        }
        if (this.myDefaultTreeRenderer != null) {
            JComponent treeCellRendererComponent = (JComponent)this.myDefaultTreeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (path == null || !(tree instanceof CheckBoxTree) || ((CheckBoxTree)tree).isCheckBoxVisible(path)) {
                this.remove(this.myEmptyBox);
                this.add((Component)this.myCheckBox, "Before");
            } else {
                this.remove(this.myCheckBox);
                this.add((Component)this.myEmptyBox, "After");
            }
            this.add(treeCellRendererComponent);
        }
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : Color.WHITE);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myDefaultTreeRenderer instanceof JComponent) {
            Point p = event.getPoint();
            p.translate(-this.myCheckBox.getWidth(), 0);
            MouseEvent newEvent = new MouseEvent((JComponent)((Object)this.myDefaultTreeRenderer), event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            String tip = ((JComponent)((Object)this.myDefaultTreeRenderer)).getToolTipText(newEvent);
            if (tip != null) {
                return tip;
            }
        }
        return super.getToolTipText(event);
    }

    public void setOpenIcon(Icon newIcon) {
        ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).setOpenIcon(newIcon);
    }

    public Icon getOpenIcon() {
        return ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).getOpenIcon();
    }

    public void setClosedIcon(Icon newIcon) {
        ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).setClosedIcon(newIcon);
    }

    public Icon getClosedIcon() {
        return ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).getClosedIcon();
    }

    public void setLeafIcon(Icon newIcon) {
        ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).setLeafIcon(newIcon);
    }

    public Icon getLeafIcon() {
        return ((DefaultTreeCellRenderer)this.myDefaultTreeRenderer).getLeafIcon();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null && this.myDefaultTreeRenderer instanceof JComponent) {
            this.accessibleContext = ((JComponent)((Object)this.myDefaultTreeRenderer)).getAccessibleContext();
        }
        return this.accessibleContext;
    }
}

