/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.checkboxtree;

import com.nokia.widgets.checkboxtree.CheckBoxTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class CheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel myModel;
    private boolean isDigInMode = true;
    private CheckBoxTree myParentTree;
    private boolean isSingleEventMode = true;
    private boolean myFireEvent = true;
    private boolean myBatchMode = false;
    private List<TreePath> myToBeAddedList = new ArrayList<TreePath>();
    private List<TreePath> myToBeRemovedList = new ArrayList<TreePath>();

    public CheckBoxTreeSelectionModel(TreeModel model) {
        this(model, true);
    }

    public CheckBoxTreeSelectionModel(TreeModel model, boolean digIn) {
        this.myModel = model;
        this.isDigInMode = digIn;
        this.setSelectionMode(4);
    }

    void setTree(CheckBoxTree tree) {
        this.myParentTree = tree;
    }

    public void setModel(TreeModel model) {
        this.myModel = model;
    }

    public TreeModel getModel() {
        return this.myModel;
    }

    public boolean isDigInMode() {
        return this.isDigInMode;
    }

    public void setDigInMode(boolean b) {
        this.isDigInMode = b;
    }

    public boolean isPartiallySelected(TreePath path) {
        if (this.isPathSelected(path, true)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        int i = 0;
        while (i < selectionPaths.length) {
            if (this.isDescendant(selectionPaths[i], path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public TreePath[] getSelectionPathsIncludingPartiallySelected() {
        TreePath[] selectedPaths = this.getSelectionPaths();
        if (selectedPaths == null) {
            return new TreePath[0];
        }
        HashSet<TreePath> selectedPathsSet = new HashSet<TreePath>();
        TreePath[] treePathArray = selectedPaths;
        int n = selectedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath selectedPath = treePathArray[n2];
            this.addPathToSet(selectedPath, selectedPathsSet);
            ++n2;
        }
        TreePath[] allPaths = new TreePath[selectedPathsSet.size()];
        allPaths = selectedPathsSet.toArray(allPaths);
        return allPaths;
    }

    private void addPathToSet(TreePath selectedPath, Set<TreePath> selectedPathsSet) {
        if (selectedPath != null) {
            selectedPathsSet.add(selectedPath);
            this.addPathToSet(selectedPath.getParentPath(), selectedPathsSet);
        }
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.isPathSelected(this.myParentTree.getPathForRow(row), this.myParentTree.isDigInMode());
    }

    public boolean isPathSelected(TreePath path, boolean digIn) {
        if (path == null) {
            return false;
        }
        return super.isPathSelected(path);
    }

    private boolean isDescendant(TreePath path1, TreePath path2) {
        Object[] obj2;
        Object[] obj1 = path1.getPath();
        if (obj1.length < (obj2 = path2.getPath()).length) {
            return false;
        }
        int i = 0;
        while (i < obj2.length) {
            if (obj1[i] != obj2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void notifyPathChange(Vector changedPaths, TreePath oldLeadSelection) {
        if (this.myFireEvent) {
            super.notifyPathChange(changedPaths, oldLeadSelection);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        if (!this.isDigInMode() || this.selectionMode == 1) {
            super.setSelectionPaths(pPaths);
        } else {
            this.clearSelection();
            this.addSelectionPaths(pPaths);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        if (!this.isDigInMode()) {
            super.addSelectionPaths(paths);
            return;
        }
        this.addSelectionPathsInDigInMode(paths);
    }

    private void addSelectionPathsInDigInMode(TreePath[] paths) {
        boolean fireEventAtTheEnd = false;
        if (this.isSingleEventMode() && this.myFireEvent) {
            this.myFireEvent = false;
            fireEventAtTheEnd = true;
        }
        try {
            this.delegateAddSelectionPaths(paths);
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                this.selectPathAndAllChildren(path);
                TreePath temp = path;
                while (temp != null) {
                    if (this.areSiblingsSelected(temp)) {
                        if ((temp = temp.getParentPath()) == null) continue;
                        this.delegateAddSelectionPaths(new TreePath[]{temp});
                        continue;
                    }
                    temp = null;
                }
                ++n2;
            }
        }
        finally {
            this.myFireEvent = true;
            if (this.isSingleEventMode() && fireEventAtTheEnd) {
                this.notifyPathChange(paths, true, paths[0]);
            }
        }
    }

    private void selectPathAndAllChildren(TreePath path) {
        Object lastPathComponent = path.getLastPathComponent();
        int childCount = this.getModel().getChildCount(lastPathComponent);
        if (childCount > 0) {
            TreePath[] childPaths = new TreePath[childCount];
            int idx = 0;
            while (idx < childCount) {
                Object child = this.getModel().getChild(lastPathComponent, idx);
                TreePath treePath = path.pathByAddingChild(child);
                if (this.isSelectableForDisabledChildNodes(treePath)) {
                    childPaths[idx] = treePath;
                    this.selectPathAndAllChildren(childPaths[idx]);
                }
                ++idx;
            }
            this.delegateAddSelectionPaths(childPaths);
        }
    }

    private void deselectPathAndAllChildrenAndParents(TreePath path) {
        TreePath tempPath = path;
        Object lastPathComponent = tempPath.getLastPathComponent();
        int childCount = this.getModel().getChildCount(lastPathComponent);
        if (childCount > 0) {
            TreePath[] childPaths = new TreePath[childCount];
            int idx = 0;
            while (idx < childCount) {
                Object child = this.getModel().getChild(lastPathComponent, idx);
                TreePath treePath = tempPath.pathByAddingChild(child);
                if (this.isSelectableForDisabledChildNodes(treePath)) {
                    childPaths[idx] = treePath;
                    this.deselectPathAndAllChildrenAndParents(childPaths[idx]);
                }
                ++idx;
            }
            this.delegateRemoveSelectionPaths(childPaths);
        }
        int pathDepth = tempPath.getPathCount() - 1;
        TreePath[] pathToRoot = new TreePath[pathDepth];
        int idx = 0;
        while (idx < pathDepth) {
            pathToRoot[idx] = tempPath = tempPath.getParentPath();
            ++idx;
        }
        this.delegateRemoveSelectionPaths(pathToRoot);
    }

    private boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.myModel.getChildCount(parentNode);
        int i = 0;
        while (i < childCount) {
            Object childNode = this.myModel.getChild(parentNode, i);
            if (childNode != node) {
                TreePath childPath = parent.pathByAddingChild(childNode);
                if (this.myParentTree != null && !this.myParentTree.isCheckBoxVisible(childPath) && !this.isPathSelected(childPath, true)) {
                    return false;
                }
                if (this.myParentTree != null && this.isSelectableForDisabledChildNodes(childPath) && !this.isPathSelected(childPath)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isSelectableForDisabledChildNodes(TreePath childPath) {
        return this.myParentTree.isSelectDisabledChildNodes() || this.myParentTree.isCheckBoxEnabled(childPath);
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        this.removeSelectionPaths(paths, true);
    }

    public void removeSelectionPaths(TreePath[] paths, boolean fireEvent) {
        if (!this.isDigInMode()) {
            super.removeSelectionPaths(paths);
            return;
        }
        this.removeSelectionPathsInDiginMode(paths, fireEvent);
    }

    private void removeSelectionPathsInDiginMode(TreePath[] paths, boolean fireEvent) {
        ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            if (path.getPathCount() == 1) {
                toBeRemoved.add(path);
            } else {
                this.toggleRemoveSelection(path, fireEvent);
            }
            ++n2;
        }
        if (toBeRemoved.size() > 0) {
            this.delegateRemoveSelectionPaths(toBeRemoved.toArray(new TreePath[toBeRemoved.size()]));
        }
        for (TreePath remove : toBeRemoved) {
            this.deselectPathAndAllChildrenAndParents(remove);
        }
    }

    private void toggleRemoveSelection(TreePath path, boolean fireEvent) {
        boolean fireEventAtTheEnd = false;
        if (fireEvent && this.isSingleEventMode() && this.myFireEvent) {
            this.myFireEvent = false;
            fireEventAtTheEnd = true;
        }
        try {
            this.delegateRemoveSelectionPaths(new TreePath[]{path});
            this.deselectPathAndAllChildrenAndParents(path);
        }
        catch (Throwable throwable) {
            if (fireEvent) {
                this.myFireEvent = true;
                if (this.isSingleEventMode() && fireEventAtTheEnd) {
                    this.notifyPathChange(new TreePath[]{path}, false, path);
                }
            }
            throw throwable;
        }
        if (fireEvent) {
            this.myFireEvent = true;
            if (this.isSingleEventMode() && fireEventAtTheEnd) {
                this.notifyPathChange(new TreePath[]{path}, false, path);
            }
        }
    }

    public boolean isSingleEventMode() {
        return this.isSingleEventMode;
    }

    public void setSingleEventMode(boolean singleEventMode) {
        this.isSingleEventMode = singleEventMode;
    }

    protected void notifyPathChange(TreePath[] changedPaths, boolean isNew, TreePath oldLeadSelection) {
        if (this.myFireEvent) {
            int count = changedPaths.length;
            boolean[] newness = new boolean[count];
            int counter = 0;
            while (counter < count) {
                newness[counter] = isNew;
                ++counter;
            }
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, changedPaths, newness, oldLeadSelection, this.leadPath);
            this.fireValueChanged(event);
        }
    }

    public boolean isBatchMode() {
        return this.myBatchMode;
    }

    public void setBatchMode(boolean batchMode) {
        this.myBatchMode = batchMode;
        if (!this.myBatchMode) {
            super.addSelectionPaths(this.myToBeAddedList.toArray(new TreePath[this.myToBeAddedList.size()]));
            this.myToBeAddedList.clear();
            super.removeSelectionPaths(this.myToBeRemovedList.toArray(new TreePath[this.myToBeRemovedList.size()]));
            this.myToBeRemovedList.clear();
        }
    }

    private void delegateRemoveSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.removeSelectionPaths(paths);
        } else {
            int i = 0;
            while (i < paths.length) {
                this.myToBeRemovedList.add(paths[i]);
                this.myToBeAddedList.remove(paths[i]);
                ++i;
            }
        }
    }

    private void delegateAddSelectionPaths(TreePath[] paths) {
        if (!this.isBatchMode()) {
            super.addSelectionPaths(paths);
        } else {
            int i = 0;
            while (i < paths.length) {
                this.myToBeAddedList.add(paths[i]);
                this.myToBeRemovedList.remove(paths[i]);
                ++i;
            }
        }
    }
}

