/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.colorslider;

import com.nokia.widgets.colorslider.ColorSliderUI;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorSlider
extends JSlider {
    private static final String uiClassID = "ColorSliderUI";
    private ChangeListener myColorListener;
    private int myWestEndColorBlue;
    private int myWestEndColorGreen;
    private int myWestEndColorRed;
    private int myEastEndColorBlue;
    private int myEastEndColorGreen;
    private int myEastEndColorRed;
    private transient Color myColor = null;
    private int myDefaultValue;
    private int mySliderType;
    private static final int SLIDER_TYPE_HUE_SLIDER = 0;
    private static final int SLIDER_TYPE_CUSTOM_SLIDER = 1;

    static {
        UIManager.put(uiClassID, ColorSliderUI.class.getName());
    }

    public ColorSlider() {
        super(0, 255, 0);
        this.init(null, null, 0);
    }

    public ColorSlider(Color westEndColor, Color eastEndColor) {
        super(0, 255, 0);
        this.init(westEndColor, eastEndColor, 1);
    }

    private void init(Color color1, Color color2, int sliderType) {
        this.mySliderType = sliderType;
        if (color1 != null) {
            this.myWestEndColorRed = color1.getRed();
            this.myWestEndColorGreen = color1.getGreen();
            this.myWestEndColorBlue = color1.getBlue();
        }
        if (color2 != null) {
            this.myEastEndColorRed = color2.getRed();
            this.myEastEndColorGreen = color2.getGreen();
            this.myEastEndColorBlue = color2.getBlue();
        }
        this.setMinorTickSpacing(this.getMaximum() / 5);
        this.setMajorTickSpacing(this.getMaximum());
        this.setMaximum(255);
        this.setMinimum(0);
        this.setValue(0);
        this.setPaintTicks(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.myColorListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                float relativeValue = (float)ColorSlider.this.getValue() / (float)(ColorSlider.this.getMaximum() - ColorSlider.this.getMinimum());
                ColorSlider.this.myColor = ColorSlider.this.calculateColorFromNormalizedSliderValue(relativeValue);
                ColorSlider.this.repaint();
            }
        };
        this.addChangeListener(this.myColorListener);
        this.setDefaultValue();
        this.fireStateChanged();
    }

    public void setUI(ColorSliderUI newUI) {
        super.setUI(newUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((ColorSliderUI)UIManager.getUI(this));
        this.updateLabelUIs();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.removeChangeListener(this.myColorListener);
        super.addChangeListener(l);
        super.addChangeListener(this.myColorListener);
    }

    public void setDefaultValue() {
        this.myDefaultValue = this.getValue();
    }

    public void resetToDefault() {
        this.setValue(this.myDefaultValue);
    }

    public Color getColor() {
        return this.myColor;
    }

    private Color calculateColorFromNormalizedSliderValue(float value) {
        Color color = null;
        if (this.mySliderType == 0) {
            color = Color.getHSBColor(value, 1.0f, 1.0f);
        } else {
            int sliderValue = this.getValue();
            float max = this.getMaximum();
            float redc = this.myWestEndColorRed - this.myEastEndColorRed;
            float greenc = this.myWestEndColorGreen - this.myEastEndColorGreen;
            float bluec = this.myWestEndColorBlue - this.myEastEndColorBlue;
            int red = (int)(redc / max * (float)sliderValue);
            int green = (int)(greenc / max * (float)sliderValue);
            int blue = (int)(bluec / max * (float)sliderValue);
            color = new Color(this.myWestEndColorRed - red, this.myWestEndColorGreen - green, this.myWestEndColorBlue - blue);
        }
        return color;
    }
}

