/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.commandbar;

import com.nokia.widgets.layout.RowAlignLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class CommandBar
extends JToolBar {
    public static final String LEFT = "West";
    public static final String RIGHT = "East";

    public CommandBar() {
        this.init();
    }

    public CommandBar(int top, int left, int bottom, int right) {
        this.init();
        this.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    public CommandBar(String name) {
        super(name);
        this.init();
    }

    public CommandBar(String name, int top, int left, int bottom, int right) {
        this.init();
        this.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
    }

    @Override
    public void setOrientation(int orientation) {
        if (orientation != 0) {
            throw new IllegalArgumentException("Command Bar only supports horizontal orientation.");
        }
        super.setOrientation(orientation);
    }

    public JButton add(Action action, Object constraints) {
        JButton button = this.createActionComponent(action);
        if (action != null && action.getValue("Name") != null) {
            button.setName(action.getValue("Name").toString());
        }
        button.setAction(action);
        this.add((Component)button, constraints);
        button.setFocusable(true);
        return button;
    }

    @Override
    protected JButton createActionComponent(Action action) {
        JButton result = super.createActionComponent(action);
        result.setHorizontalTextPosition(11);
        result.setVerticalTextPosition(0);
        result.setMargin(new Insets(2, 4, 2, 4));
        result.setHideActionText(false);
        return result;
    }

    protected void init() {
        RowAlignLayout layout = new RowAlignLayout(2, 0, 0);
        layout.setButtonBar(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        layout.setComponentScaled(false);
        this.setLayout(layout);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            child.setEnabled(enabled);
            ++n2;
        }
        super.setEnabled(enabled);
    }
}

