/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.datepicker;

import com.nokia.widgets.PComboBox;
import com.nokia.widgets.datepicker.DatePickerPopup;
import com.nokia.widgets.datepicker.DatePickerUI;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.UIManager;

public class DatePicker
extends PComboBox {
    private static final String uiClassID = "DatePickerUI";
    private DateFormat DATE_FORMAT = DateFormat.getDateInstance(1);
    private Date myDate;
    private Calendar myCalendar = null;
    private boolean myWithTime = true;
    private boolean mytwentyFourHourFormat = true;

    static {
        UIManager.put(uiClassID, DatePickerUI.class.getName());
    }

    public DatePicker() {
        this(null, null);
    }

    public DatePicker(boolean withTime) {
        this(null, null, withTime, false);
    }

    public DatePicker(boolean withTime, boolean twentyFourHourFormat) {
        this(null, null, withTime, twentyFourHourFormat);
    }

    public DatePicker(DateFormat dateFormat) {
        this(dateFormat, null);
    }

    public DatePicker(DateFormat dateFormat, boolean withTime) {
        this(dateFormat, null, withTime, false);
    }

    public DatePicker(DateFormat dateFormat, boolean withTime, boolean twentyFourHourFormat) {
        this(dateFormat, null, withTime, twentyFourHourFormat);
    }

    public DatePicker(Calendar calendar) {
        this(null, calendar);
    }

    public DatePicker(Calendar calendar, boolean withTime) {
        this(null, calendar, withTime, false);
    }

    public DatePicker(Calendar calendar, boolean withTime, boolean twentyFourHourFormat) {
        this(null, calendar, withTime, twentyFourHourFormat);
    }

    public DatePicker(DateFormat dateFormat, Calendar calendar, boolean withTime) {
        this(dateFormat, calendar, withTime, false);
    }

    public DatePicker(DateFormat dateFormat, Calendar calendar) {
        this(dateFormat, calendar, false, false);
    }

    public DatePicker(DateFormat dateFormat, Calendar calendar, boolean withTime, boolean twentyFourHourFormat) {
        if (calendar != null) {
            this.myCalendar = (Calendar)calendar.clone();
        } else {
            this.myCalendar = Calendar.getInstance();
            this.myCalendar.setLenient(false);
        }
        this.DATE_FORMAT.setLenient(false);
        if (dateFormat != null) {
            this.DATE_FORMAT = dateFormat;
        }
        this.myWithTime = withTime;
        this.mytwentyFourHourFormat = twentyFourHourFormat;
        this.setModel(new MyModel());
        DatePickerPopup popup = ((DatePickerUI)this.getUI()).getPopup();
        popup.setCalendar(this.myCalendar);
        popup.setDateFormat(this.DATE_FORMAT);
        this.setEditable(true);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((DatePickerUI)UIManager.getUI(this));
    }

    public Calendar getCalendar() {
        return this.myCalendar;
    }

    public Date getSelectedDate() {
        String s = this.getSelectedItem().toString();
        try {
            return this.DATE_FORMAT.parse(s);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public DateFormat getDateFormat() {
        return this.DATE_FORMAT;
    }

    public boolean isWithTime() {
        return this.myWithTime;
    }

    public boolean isTwentyFourHourFormat() {
        return this.mytwentyFourHourFormat;
    }

    protected void setDateToPopup(String dateStr) throws ParseException {
        this.dataModel.setSelectedItem(dateStr);
        this.myDate = this.DATE_FORMAT.parse(dateStr);
        ((DatePickerUI)this.getUI()).getPopup().setDate(this.myDate);
    }

    protected void dateChanged(Calendar cal) {
        this.myDate = cal.getTime();
        String s = this.DATE_FORMAT.format(this.myDate);
        this.dataModel.setSelectedItem(s);
        this.setSelectedItem(s);
    }

    private class MyModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String item;

        private MyModel() {
            this.item = DatePicker.this.DATE_FORMAT.format(DatePicker.this.myCalendar.getTime());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.item = anItem.toString();
            this.fireContentsChanged(this, 0, 1);
        }

        @Override
        public Object getSelectedItem() {
            return this.item;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public Object getElementAt(int index) {
            return this.item;
        }
    }
}

