/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.datepicker;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.datepicker.DatePicker;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.PValidationEvent;
import com.nokia.widgets.text.PValidationException;
import com.nokia.widgets.text.PValidationListener;
import com.nokia.widgets.util.ClientPropertyUtil;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class DatePickerEditor
extends BasicComboBoxEditor
implements PValidationListener,
DocumentListener {
    private DatePicker myParent;

    public DatePickerEditor() {
        this.editor = new PTextField("", 9){

            @Override
            public void setText(String s) {
                if (this.getText().equals(s)) {
                    return;
                }
                super.setText(s);
            }
        };
        this.editor.setMargin(new Insets(0, 3, 0, 6));
        this.editor.setBorder(UIManager.getBorder("Datepicker.Editor.Border"));
        this.editor.putClientProperty("OrangeTouch.openRightEdge", true);
        this.editor.addFocusListener(this);
        ((PTextField)this.editor).setValidateOnFocusLost(true);
        ((PTextField)this.editor).addValidationListener(this);
        ((PTextField)this.editor).addDocumentListener(this);
    }

    @Override
    public Component getEditorComponent() {
        Integer alignment = ClientPropertyUtil.integerValue(this.myParent, "Combobox.horizontalAlignment");
        if (!ClientProperties.UNKNOWN_VALUE.equals(alignment)) {
            this.editor.setHorizontalAlignment(alignment);
        }
        if (this.myParent != null && this.myParent.isPopupVisible()) {
            this.editor.putClientProperty("OrangeTouch.openBottomEdge", true);
        }
        return super.getEditorComponent();
    }

    void setParent(DatePicker parent) {
        this.myParent = parent;
    }

    private String getDateString() {
        return this.getItem() != null ? this.getItem().toString() : "";
    }

    @Override
    public void validate(PValidationEvent event) throws PValidationException {
        String date = this.getDateString();
        try {
            if (date.length() > 0) {
                this.myParent.getDateFormat().parse(date);
            }
        }
        catch (Exception e) {
            if (this.myParent.getDateFormat() instanceof SimpleDateFormat) {
                String message = WidgetResources.getString("InvalidDateFormat_Text");
                throw new PValidationException(MessageFormat.format(message, ((SimpleDateFormat)this.myParent.getDateFormat()).toPattern().toUpperCase()));
            }
            throw new PValidationException();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        String dateStr = this.getDateString();
        try {
            this.myParent.getDateFormat().parse(dateStr);
            this.myParent.setDateToPopup(dateStr);
        }
        catch (ParseException e1) {
            Logger.getLogger("Cannot parse current date in DatepickerEditor.java." + e1.getMessage());
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent.isPopupVisible()) {
            this.myParent.hidePopup();
        }
    }
}

