/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.datepicker;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.buttons.PulldownPopupMenuBorder;
import com.nokia.widgets.datepicker.DatePicker;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.util.ComponentUtils;
import com.nokia.widgets.util.ScaleUtils;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DatePickerPopup
extends BasicComboPopup
implements PopupMenuListener {
    private final SimpleDateFormat MONTH_YEAR_FORMAT = new SimpleDateFormat("MMMM yyyy");
    private static final Color OTHER_MONTH_BG = UIManager.getColor("Datepicker.OtherMonth.Background");
    private static final Color HEADER_FG = UIManager.getColor("Datepicker.MonthLabel.ForeColor");
    private static final Color WORK_DAY_BG = UIManager.getColor("Datepicker.CurrentMonth.Background");
    private Calendar TODAY;
    private static final int DAYS_IN_WEEK = 7;
    private static int WEEKS_IN_MONTH = 6;
    private PLabel myCurrentMonthLabel;
    private MonthTableModel myTableModel;
    private MonthTableCellRenderer myTableRenderer;
    private MonthTable myTable;
    private Calendar myMainMonth;
    private Calendar mySelectedDate;
    private Calendar myCalendar;
    private PButton myNowButton;
    private PButton myDoneButton;
    private boolean myAcceptHide = true;
    private PSpinner myAmPmSpinner;
    private PSpinner myHourSpinner;
    private PSpinner myMinuteSpinner;
    private DatePicker myParent;

    public DatePickerPopup(DatePicker parent) {
        super(parent);
        this.putClientProperty("OrangeTouch.isPulldown", true);
        this.setBorder(new PulldownPopupMenuBorder(4));
        this.putClientProperty("OrangeTouch.isFocusablePopup", false);
        this.putClientProperty("OrangeTouch.isLightbox", true);
        this.comboBox = parent;
        this.myParent = parent;
        this.setFocusable(true);
        this.setCalendar(parent.getCalendar());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() == 27) {
                    DatePickerPopup.this.hide(true);
                }
            }
        });
    }

    public void setCalendar(Calendar cal) {
        if (cal != null) {
            this.myCalendar = cal;
            this.TODAY = (Calendar)cal.clone();
            this.mySelectedDate = (Calendar)cal.clone();
            this.myMainMonth = (Calendar)cal.clone();
            this.myTableModel = new MonthTableModel();
            this.myTable = new MonthTable(this.myTableModel);
            this.myTableRenderer = new MonthTableCellRenderer();
            this.buildUI();
            this.redrawCalendar();
        }
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BorderLayout(8, 8));
    }

    @Override
    public void show() {
        Point pointA = new Point(this.comboBox.getWidth(), this.comboBox.getHeight());
        if (this.mySelectedDate.get(2) != this.myMainMonth.get(2)) {
            this.myMainMonth = (Calendar)this.mySelectedDate.clone();
            this.redrawCalendar();
        }
        this.pack();
        int newPopupX = pointA.x - this.getPreferredSize().width + 2;
        int newPopupY = pointA.y - 3;
        this.show(this.comboBox, newPopupX, newPopupY);
    }

    public void setDate(Date date) {
        this.mySelectedDate.setTime(date);
        this.myMainMonth = (Calendar)this.mySelectedDate.clone();
        this.redrawCalendar();
    }

    @Override
    public void hide() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (focusOwner != null && this.isSpinnersFocusOwner(focusOwner)) {
            return;
        }
        if (this.isAcceptHide()) {
            super.hide();
        }
    }

    private boolean isSpinnersFocusOwner(Component focusOwner) {
        return focusOwner == this.myAmPmSpinner || focusOwner == this.myHourSpinner || focusOwner == this.myMinuteSpinner;
    }

    public void hide(boolean b) {
        this.setAcceptHide(true);
        this.hide();
    }

    void redrawCalendar() {
        this.myCurrentMonthLabel.setText(this.MONTH_YEAR_FORMAT.format(this.myMainMonth.getTime()));
        this.myTableModel.setCalendar();
        this.myTable.setSelection();
        this.myTable.packCells();
        this.pack();
        this.repaint();
    }

    private void nowButtonPressed() {
        this.mySelectedDate = Calendar.getInstance();
        if (this.mySelectedDate.get(2) != this.myMainMonth.get(2)) {
            this.myMainMonth = (Calendar)this.TODAY.clone();
            this.redrawCalendar();
        }
        this.myTable.setSelection();
        ((DatePicker)this.comboBox).dateChanged(this.mySelectedDate);
        if (this.myParent.isWithTime()) {
            Date spinnerDate = this.mySelectedDate.getTime();
            if (!this.myParent.isTwentyFourHourFormat()) {
                this.myAmPmSpinner.setValue(spinnerDate);
            }
            this.myHourSpinner.setValue(spinnerDate);
            this.myMinuteSpinner.setValue(spinnerDate);
        } else {
            this.doneButtonPressed();
        }
    }

    private void doneButtonPressed() {
        this.hide(true);
    }

    void changeDate(DateValue value) {
        this.mySelectedDate = (Calendar)this.myMainMonth.clone();
        this.mySelectedDate.add(2, value.getMonth());
        this.mySelectedDate.set(5, value.getDate());
        if (this.myParent.isWithTime()) {
            Date dHour = (Date)this.myHourSpinner.getModel().getValue();
            Calendar cHour = Calendar.getInstance();
            cHour.setTime(dHour);
            int hourValue = 0;
            if (this.myParent.isTwentyFourHourFormat()) {
                hourValue = cHour.get(11);
                this.mySelectedDate.set(11, hourValue);
            } else {
                hourValue = cHour.get(10);
                this.mySelectedDate.set(10, hourValue);
                Date dAmPm = (Date)this.myAmPmSpinner.getModel().getValue();
                Calendar cAmPm = Calendar.getInstance();
                cAmPm.setTime(dAmPm);
                int amPmValue = cAmPm.get(9);
                this.mySelectedDate.set(9, amPmValue);
            }
            Date dminute = (Date)this.myMinuteSpinner.getModel().getValue();
            Calendar cMin = Calendar.getInstance();
            cMin.setTime(dminute);
            int minValue = cMin.get(12);
            this.mySelectedDate.set(12, minValue);
        }
        ((DatePicker)this.comboBox).dateChanged(this.mySelectedDate);
    }

    private void buildUI() {
        this.addPopupMenuListener(this);
        this.add(this.createPopupMainPanel());
        this.pack();
    }

    private PPanel createPopupMainPanel() {
        PPanel mainPanel = new PPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.createCalendarPanel(mainPanel);
        PPanel bottomPanel = new PPanel(new BorderLayout());
        this.createTimeSpinners(bottomPanel);
        this.createNowDoneButtons(bottomPanel);
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    private void createCalendarPanel(PPanel mainPanel) {
        PPanel monthHeader = this.createMonthHeader();
        PPanel tablePanel = new PPanel(new PVerticalLayout(3, 3, 0, 0));
        tablePanel.add(monthHeader);
        this.myTable.getTableHeader().setBorder(BorderFactory.createEmptyBorder());
        tablePanel.add(this.myTable.getTableHeader());
        tablePanel.add(this.myTable);
        mainPanel.add(tablePanel);
    }

    private void createNowDoneButtons(PPanel bottomPanel) {
        RowAlignLayout layout = new RowAlignLayout(5, 0, 6);
        layout.setComponentScaled(false);
        PPanel buttonPanel = new PPanel(layout);
        this.createNowButton();
        buttonPanel.add(this.myNowButton);
        if (this.myParent.isWithTime()) {
            this.createDoneButton();
            buttonPanel.add(this.myDoneButton);
        }
        bottomPanel.add((Component)buttonPanel, "South");
    }

    private void createTimeSpinners(PPanel bottomPanel) {
        if (this.myParent.isWithTime()) {
            PPanel timePanel = new PPanel();
            timePanel.setLayout(new PHorizontalLayout(2, 6, 0, 0));
            timePanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            timePanel.add(this.createHoursSpinner());
            timePanel.add(new JLabel(":"));
            timePanel.add(this.createMinutesSpinner());
            if (!this.myParent.isTwentyFourHourFormat()) {
                timePanel.add(this.createAMPMSpinner());
            }
            JPanel midPanel = new JPanel(new FlowLayout(2, 0, 0));
            midPanel.add(timePanel);
            bottomPanel.add(midPanel);
        }
    }

    private void createDoneButton() {
        this.myDoneButton = new PButton(WidgetResources.getString("DatePicker.Done_Text"));
        AbstractAction doneButtonAction = new AbstractAction(WidgetResources.getString("DatePicker.Done_Text")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePickerPopup.this.doneButtonPressed();
                DatePickerPopup.this.updateDate();
            }
        };
        this.myDoneButton.setAction(doneButtonAction);
        if (this.myParent.isWithTime()) {
            this.myDoneButton.setDefaultButton(true);
        }
    }

    private void createNowButton() {
        this.myNowButton = new PButton();
        AbstractAction nowButtonAction = new AbstractAction(this.myParent.isWithTime() ? WidgetResources.getString("DatePicker.Now_Text") : WidgetResources.getString("DatePicker.Today_Text")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePickerPopup.this.setHideableWhenParentIsTable(false);
                DatePickerPopup.this.nowButtonPressed();
            }
        };
        this.myNowButton.setAction(nowButtonAction);
        this.myNowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DatePickerPopup.this.setHideableWhenParentIsTable(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DatePickerPopup.this.setHideableWhenParentIsTable(false);
            }

            @Override
            public void mouseEntered(MouseEvent myE) {
                DatePickerPopup.this.setHideableWhenParentIsTable(false);
            }

            @Override
            public void mouseExited(MouseEvent myE) {
                DatePickerPopup.this.setHideableWhenParentIsTable(true);
            }
        });
    }

    private void setHideableWhenParentIsTable(boolean hide) {
        if (this.myParent.getParent() instanceof JTable) {
            this.setAcceptHide(hide);
        }
    }

    private PPanel createMonthHeader() {
        PPanel monthHeader = new PPanel();
        monthHeader.setPreferredSize(new Dimension(this.myTable.getWidth(), ScaleUtils.scale(25)));
        monthHeader.setLayout(new BorderLayout());
        monthHeader.add((Component)this.createArrowButton(true, -1), "West");
        this.myCurrentMonthLabel = new PLabel("", 0);
        this.myCurrentMonthLabel.setFont(UIManager.getFont("Datepicker.MonthLabel.font"));
        this.myCurrentMonthLabel.setForeground(HEADER_FG);
        monthHeader.add(this.myCurrentMonthLabel);
        monthHeader.add((Component)this.createArrowButton(false, 1), "East");
        return monthHeader;
    }

    protected void updateDate() {
        DateValue value;
        if (this.myTable.getSelectedRow() != -1 && this.myTable.getSelectedColumn() != -1 && (value = this.populateDateValue()).isCurrentMonth()) {
            this.changeDate(value);
        }
    }

    private DateValue populateDateValue() {
        return (DateValue)this.myTableModel.getValueAt(this.myTable.getSelectedRow(), this.myTable.getSelectedColumn());
    }

    private PSpinner createAMPMSpinner() {
        this.myAmPmSpinner = new PSpinner();
        Date spinnerDate = this.myCalendar.getTime();
        SpinnerDateModel model = new SpinnerDateModel(spinnerDate, null, null, 9);
        model.setValue(spinnerDate);
        model.setCalendarField(9);
        this.myAmPmSpinner.setModel(model);
        JSpinner.DateEditor editor = new JSpinner.DateEditor((JSpinner)this.myAmPmSpinner, "a");
        editor.getTextField().setColumns(2);
        this.myAmPmSpinner.setEditor(editor);
        return this.myAmPmSpinner;
    }

    private PSpinner createMinutesSpinner() {
        this.myMinuteSpinner = new PSpinner();
        Date spinnerDate = this.myCalendar.getTime();
        SpinnerDateModel model = new SpinnerDateModel(spinnerDate, null, null, 12);
        model.setCalendarField(12);
        String format = "mm";
        this.myMinuteSpinner.setModel(model);
        this.myMinuteSpinner.setEditor(new JSpinner.DateEditor((JSpinner)this.myMinuteSpinner, format));
        return this.myMinuteSpinner;
    }

    private PSpinner createHoursSpinner() {
        SpinnerDateModel model;
        this.myHourSpinner = new PSpinner();
        Date spinnerDate = this.myCalendar.getTime();
        String format = "hh";
        if (this.myParent.isTwentyFourHourFormat()) {
            model = new SpinnerDateModel(spinnerDate, null, null, 11);
            format = "HH";
        } else {
            model = new SpinnerDateModel(spinnerDate, null, null, 10);
        }
        this.myHourSpinner.setModel(model);
        this.myHourSpinner.setEditor(new JSpinner.DateEditor((JSpinner)this.myHourSpinner, format));
        return this.myHourSpinner;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.myNowButton.setToolTipText(dateFormat.format(this.TODAY.getTime()));
    }

    private PToolButton createArrowButton(boolean left, final int amount) {
        PToolButton arrowButton = new PToolButton();
        if (left) {
            arrowButton.setToolTipText(WidgetResources.getString("DatePicker.Previous_Text"));
            arrowButton.setIcon(new PArrowIcon(7, 4, (Color)NetLookAndFeel.getFocusColor(), 7));
        } else {
            arrowButton.setToolTipText(WidgetResources.getString("DatePicker.Next_Text"));
            arrowButton.setIcon(new PArrowIcon(7, 4, (Color)NetLookAndFeel.getFocusColor(), 3));
        }
        arrowButton.setPreferredSize(new Dimension(24, 18));
        arrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DatePickerPopup.this.myMainMonth.add(2, amount);
                DatePickerPopup.this.redrawCalendar();
            }
        });
        return arrowButton;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.setAcceptHide(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.isPopupFocusOwner() || this.myParent.getEditorComponent().hasFocus()) {
            this.comboBox.requestFocusInWindow();
        }
    }

    private boolean isPopupFocusOwner() {
        Component[] children;
        if (this.isFocusOwner()) {
            return true;
        }
        Component[] componentArray = children = this.getComponents();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component.isFocusOwner()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.setAcceptHide(true);
        this.myTable.putClientProperty("BlueTouch.rolloveredCell", new Point(-1, -1));
    }

    private boolean isAcceptHide() {
        return this.myAcceptHide;
    }

    private void setAcceptHide(boolean acceptHide) {
        this.myAcceptHide = acceptHide;
    }

    private static final class DateValue {
        private int myDate;
        private int myMonth;
        private boolean myIsToday = false;

        DateValue(int date, int month, int year) {
            this.myDate = date;
            this.myMonth = month;
        }

        private boolean isCurrentMonth() {
            return this.getMonth() == 0;
        }

        void setToday(boolean flag) {
            this.myIsToday = flag;
        }

        int getDate() {
            return this.myDate;
        }

        int getMonth() {
            return this.myMonth;
        }

        boolean isToday() {
            return this.myIsToday;
        }

        public String toString() {
            return Integer.toString(this.myDate);
        }
    }

    private final class MonthTable
    extends PTable {
        public MonthTable(TableModel dataModel) {
            super(dataModel);
            this.setTableHeader(new MonthTableHeader(this.getColumnModel()));
            this.setSelectionMode(0);
            this.setCellSelectionEnabled(true);
            this.setAlternate(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setGridColor(NetTheme.getComponentOutlineColor());
            this.setShowGrid(true);
            this.addMouseListener(new MonthTableMouseAdapter());
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            if (rowIndex >= 0 && columnIndex >= 0) {
                DateValue value = (DateValue)this.getValueAt(rowIndex, columnIndex);
                if (value.isCurrentMonth()) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            } else {
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(NetTheme.getComponentOutlineColor());
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return DatePickerPopup.this.myTableRenderer;
        }

        public void setSelection() {
            this.changeSelection(this.getSelectedRow(), this.getSelectedColumn(), true, false);
            int month = 12 * DatePickerPopup.this.mySelectedDate.get(1) + DatePickerPopup.this.mySelectedDate.get(2) - (12 * DatePickerPopup.this.myMainMonth.get(1) + DatePickerPopup.this.myMainMonth.get(2));
            int date = DatePickerPopup.this.mySelectedDate.get(5);
            if (month >= -1 && month <= 1) {
                int row = 0;
                block0: while (row < WEEKS_IN_MONTH) {
                    int col = 0;
                    while (col < 7) {
                        DateValue value = (DateValue)this.getValueAt(row, col);
                        if (value.getMonth() == month && value.getDate() == date) {
                            this.changeSelection(row, col, false, false);
                            break block0;
                        }
                        ++col;
                    }
                    ++row;
                }
            }
        }

        private final class MonthTableMouseAdapter
        extends MouseAdapter {
            private MonthTableMouseAdapter() {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int column;
                int row;
                DateValue clickedValue;
                Point point = e.getPoint();
                if (!DatePickerPopup.this.myParent.isWithTime() && this.isMousePointerInsideTheComponent(point) && (clickedValue = (DateValue)MonthTable.this.getValueAt(row = MonthTable.this.rowAtPoint(point), column = MonthTable.this.columnAtPoint(point))).isCurrentMonth()) {
                    DateValue selectedValue = (DateValue)MonthTable.this.getValueAt(MonthTable.this.getSelectedRow(), MonthTable.this.getSelectedColumn());
                    DatePickerPopup.this.changeDate(selectedValue);
                    DatePickerPopup.this.hide(true);
                }
            }

            private boolean isMousePointerInsideTheComponent(Point point) {
                return MonthTable.this.getParent().getBounds().contains(point);
            }
        }
    }

    private final class MonthTableCellRenderer
    extends DefaultTableCellRenderer {
        private Border myTodayBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(NetLookAndFeel.getFocusColor()));
        private Border myTodayBorderFirstColumn = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1), BorderFactory.createLineBorder(NetLookAndFeel.getFocusColor()));
        private boolean myIsRollovered = false;
        private boolean myIsFirstRow = false;
        private boolean myIsFirstColumn = false;

        private MonthTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
            this.setHorizontalAlignment(0);
            this.setFont(UIManager.getFont("Datepicker.DaysLabel.font"));
            DateValue dateValue = (DateValue)value;
            this.myIsRollovered = ComponentUtils.isRolloveredCell(table, row, column) && dateValue.isCurrentMonth() && !dateValue.isToday();
            this.myIsFirstRow = row == 0;
            boolean bl = this.myIsFirstColumn = column == 0;
            if (dateValue.isCurrentMonth()) {
                if (dateValue.isToday()) {
                    this.setBorder(this.myIsFirstColumn ? this.myTodayBorderFirstColumn : this.myTodayBorder);
                }
                if (!isSelected) {
                    this.setBackground(WORK_DAY_BG);
                } else {
                    this.setForeground(UIManager.getColor("Datepicker.SelectedDate.ForeColor"));
                }
            } else {
                this.setText("");
                this.setBackground(OTHER_MONTH_BG);
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.myIsRollovered) {
                g.setColor(NetTheme.getHoverColor());
                Object oldAa = NetUtils.antiAliasingOn(g);
                int yOffset = this.myIsFirstRow ? 1 : 0;
                int xOffset = this.myIsFirstColumn ? 1 : 0;
                NetUtils.paintHoverEffect(g, this, 2 + xOffset, 2 + yOffset, this.getWidth() - 5 - xOffset, this.getHeight() - 4 - yOffset, null);
                NetUtils.setAntialiasing(g, oldAa);
            }
        }
    }

    private final class MonthTableHeader
    extends JTableHeader {
        public MonthTableHeader(TableColumnModel model) {
            super(model);
            PTableHeaderRenderer headerRenderer = new PTableHeaderRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
                    this.setHorizontalAlignment(0);
                    this.setForeground(HEADER_FG);
                    this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    return this;
                }
            };
            headerRenderer.setContentAreaFilled(false);
            this.setDefaultRenderer(headerRenderer);
            this.setReorderingAllowed(false);
            this.setResizingAllowed(false);
        }
    }

    private final class MonthTableModel
    extends AbstractTableModel {
        final String[] WEEK_DAYS = new String[7];
        Object[][] data;

        public MonthTableModel() {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE");
            Calendar calendar = (Calendar)DatePickerPopup.this.myCalendar.clone();
            calendar.set(7, calendar.getFirstDayOfWeek());
            int i = 0;
            while (i < 7) {
                String format = formatter.format(calendar.getTime());
                int limit = format.length() >= 3 ? 3 : format.length();
                this.WEEK_DAYS[i] = format.substring(0, limit).toUpperCase();
                calendar.add(5, 1);
                ++i;
            }
        }

        MonthTableModel setCalendar() {
            Calendar cal = (Calendar)DatePickerPopup.this.myMainMonth.clone();
            cal.set(5, 1);
            cal.get(5);
            cal.set(7, cal.getFirstDayOfWeek());
            this.data = new Object[WEEKS_IN_MONTH][7];
            int month = -1;
            int year = cal.get(2) == 11 ? -1 : 0;
            int i = 0;
            while (i < WEEKS_IN_MONTH) {
                int j = 0;
                while (j < 7) {
                    int date = cal.get(5);
                    if (date == 1) {
                        ++month;
                        if (year == -1) {
                            year = 0;
                        } else if (cal.get(2) == 0 && month == 1) {
                            year = 1;
                        }
                    }
                    DateValue value = new DateValue(date, month, year);
                    value.setToday(DatePickerPopup.this.TODAY.get(5) == cal.get(5) && DatePickerPopup.this.TODAY.get(2) == cal.get(2) && DatePickerPopup.this.TODAY.get(1) == cal.get(1));
                    this.data[i][j] = value;
                    cal.add(5, 1);
                    ++j;
                }
                ++i;
            }
            return this;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return WEEKS_IN_MONTH;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public String getColumnName(int col) {
            return this.WEEK_DAYS[col];
        }
    }
}

