/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.datepicker;

import com.nokia.laf.NetComboBoxUI;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.datepicker.DatePicker;
import com.nokia.widgets.datepicker.DatePickerEditor;
import com.nokia.widgets.datepicker.DatePickerPopup;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;

public class DatePickerUI
extends NetComboBoxUI {
    private DatePicker myParent;
    private DatePickerPopup myPopup;
    private static final Icon CALENDER_ICON = NetUtils.loadIcon("n_ot2_action-navi_calendar_normal16.png");
    private static final Icon FOCUSED_CALENDAR_ICON = NetUtils.loadIcon("n_ot2_action-navi_calendar_focus16.png");

    public DatePickerUI(DatePicker parent) {
        this.myParent = parent;
    }

    public static ComponentUI createUI(JComponent c) {
        return new DatePickerUI((DatePicker)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myPopup = null;
        this.myParent = null;
        super.uninstallUI(c);
    }

    @Override
    public ComboBoxEditor createEditor() {
        DatePickerEditor ed = new DatePickerEditor();
        ed.setParent(this.myParent);
        return ed;
    }

    public DatePickerPopup getPopup() {
        return this.myPopup;
    }

    @Override
    protected ComboPopup createPopup() {
        if (this.myPopup == null) {
            this.myPopup = new DatePickerPopup(this.myParent);
        }
        return this.myPopup;
    }

    @Override
    protected Icon getArrowIcon(boolean isTableCellEditor) {
        return new DatePickerIcon();
    }

    private class DatePickerIcon
    implements Icon {
        private DatePickerIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                if (NetUtils.isFocused(DatePickerUI.this.myParent)) {
                    FOCUSED_CALENDAR_ICON.paintIcon(c, g, x + 2, y);
                } else {
                    CALENDER_ICON.paintIcon(c, g, x + 2, y);
                }
            } else {
                UIManager.getLookAndFeel().getDisabledIcon((JComponent)c, CALENDER_ICON).paintIcon(c, g, x - 2, y + 1);
            }
        }

        @Override
        public int getIconWidth() {
            return CALENDER_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return CALENDER_ICON.getIconHeight();
        }
    }
}

