/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.drilldown;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.HeaderBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.drilldown.Drilldown;
import com.nokia.widgets.drilldown.DrilldownElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.JComponent;

class DrillDownElementBorder
extends HeaderBorder {
    public DrillDownElementBorder() {
        super("", false, false);
    }

    @Override
    public void paintBackground(Graphics g, JComponent c) {
        int contentHeight = c.getHeight() - BOTTOM_SHADOW_HEIGHT;
        Shape background = NetUtils.getRoundedRect(c, 1, 1, c.getWidth() - 2, contentHeight / 4, NetTheme.getComponentOutlineRounding(c), 5);
        Color[] top = new Color[]{NetUtils.decodeColor("#F8F9FA"), NetUtils.decodeColor("#E8EAEC")};
        GradientUtils.drawVerticalGradient(c, g, top, background);
        Color[] bottom = new Color[]{NetUtils.decodeColor("#E8EAEC"), NetUtils.decodeColor("#FAFAFA")};
        GradientUtils.drawVerticalGradient(c, g, bottom, 1, contentHeight / 4, c.getWidth() - 2, contentHeight - contentHeight / 4 - contentHeight / 3);
        background = NetUtils.getRoundedRect(c, 1, contentHeight * 2 / 3, c.getWidth() - 2, contentHeight / 3 + 2, NetTheme.getComponentOutlineRounding(c), 1);
        g.setColor(NetUtils.decodeColor("#FAFAFA"));
        ((Graphics2D)g).fill(background);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        DrilldownElement drilldownElement = (DrilldownElement)c;
        Drilldown drilldown = (Drilldown)drilldownElement.getParent();
        Insets insets = drilldownElement.getInsets();
        Graphics2D g2d = (Graphics2D)g;
        Object oldAa = NetUtils.antiAliasingOn(g);
        if (drilldown.isFocusOwner() && drilldown.getSelectedElements().size() == 0 && drilldown.indexOf(drilldownElement) == drilldown.getAnchorSelectionIndex()) {
            this.paintFocus(g, drilldownElement, insets);
        }
        if (drilldown.isSelectedItem(drilldownElement)) {
            g.setColor(NetTheme.getHoverColor());
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g.drawRoundRect(insets.left, 1, drilldownElement.getWidth() - (insets.left + insets.right) - 1, drilldownElement.getHeight() - 12, 9, 9);
            g2d.setStroke(stroke);
            this.paintLeadSelection(g, drilldownElement, drilldown, insets);
        }
        NetUtils.setAntialiasing(g, oldAa);
    }

    protected void paintLeadSelection(Graphics g, DrilldownElement drilldownElement, Drilldown drilldown, Insets insets) {
        if (drilldown.isFocusOwner() && drilldown.getLeadSelectionIndex() == drilldown.indexOf(drilldownElement)) {
            this.paintFocus(g, drilldownElement, insets);
        }
    }

    private void paintFocus(Graphics g, DrilldownElement drilldownElement, Insets insets) {
        g.setColor(NetLookAndFeel.getFocusColor());
        g.drawRoundRect(insets.left, 1, drilldownElement.getWidth() - (insets.left + insets.right) - 1, drilldownElement.getHeight() - 12, 9, 9);
    }
}

