/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.drilldown;

import com.nokia.widgets.drilldown.DrilldownElement;
import com.nokia.widgets.drilldown.DrilldownEvent;
import com.nokia.widgets.drilldown.DrilldownFilter;
import com.nokia.widgets.drilldown.DrilldownListener;
import com.nokia.widgets.drilldown.DrilldownPanel;
import com.nokia.widgets.drilldown.DrilldownUI;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.slidingpanel.SlidingPanelStateChangeEvent;
import com.nokia.widgets.slidingpanel.SlidingPanelStateListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Drilldown<T extends DrilldownElement>
extends JPanel
implements ListDataListener,
SlidingPanelStateListener {
    private static final Insets ELEMENT_INSETS = new Insets(1, 3, 0, 3);
    private ListModel myListModel = new DefaultListModel();
    ListSelectionModel mySelectionModel = new DefaultListSelectionModel();
    private Map<Integer, DrilldownPanel> myDrilldownPanels = new HashMap<Integer, DrilldownPanel>();
    private int myTimerDelay = 1;
    private int myColumnCount;
    private boolean myColumnCountSetByUser = false;
    private boolean myShowSlidingPanel = true;
    private List<ListDataListener> myListDataListeners = new ArrayList<ListDataListener>();
    private List<DrilldownListener> myDrilldownListeners = new ArrayList<DrilldownListener>();
    private JPanel myFiller = new JPanel();
    private JPanel myBottomFiller = new JPanel();
    private DrilldownFilter<T> myFilter = new DrilldownFilter<T>(){

        @Override
        public boolean isAccepted(T element, int index) {
            return true;
        }
    };
    private boolean myAnimationEnabledForChildPanels = true;

    public Drilldown() {
        this(new ArrayList());
    }

    public Drilldown(final List<T> elements) {
        this(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return elements.get(index);
            }

            @Override
            public int getSize() {
                return elements.size();
            }
        });
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(new DrilldownUI());
    }

    @Override
    public DrilldownUI getUI() {
        return (DrilldownUI)this.ui;
    }

    public Drilldown(ListModel listModel, int columnCount) {
        this.myBottomFiller.setOpaque(false);
        this.myFiller.setOpaque(false);
        this.setOpaque(false);
        this.setFocusable(true);
        this.setLayout(new GridBagLayout());
        this.add(this.myFiller);
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.fillBoth();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        this.add(this.myBottomFiller);
        this.setColumnCount(columnCount);
        this.setModel(listModel);
        this.addElementsToDrilldownContainer();
        this.updateUI();
        this.mySelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                Drilldown.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Drilldown.this.setLayoutConstraints();
            }
        });
    }

    public Drilldown(ListModel listModel, int columnCount, boolean animationEnabledForChildPanels) {
        this(listModel, columnCount);
        this.myAnimationEnabledForChildPanels = animationEnabledForChildPanels;
    }

    public Drilldown(ListModel listModel) {
        this(listModel, 3);
    }

    public Drilldown(int columnCount) {
        this(new DefaultListModel(), columnCount);
    }

    public DrilldownFilter<T> getFilter() {
        return this.myFilter;
    }

    public int getTimerDelay() {
        return this.myTimerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.myTimerDelay = timerDelay;
        for (DrilldownPanel panel : this.myDrilldownPanels.values()) {
            panel.setTimerDelay(this.myTimerDelay);
        }
    }

    public void highlight(String text) {
        Drilldown.highlight(this, null);
        Drilldown.highlight(this, text);
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public static void highlight(JComponent element, String text) {
        element.putClientProperty("OrangeTouch.highlightText", text);
        Component[] componentArray = element.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof PLabel) {
                ((PLabel)child).highlight(text);
            } else if (child instanceof DrilldownElement) {
                Drilldown.highlight((JComponent)child, text);
            }
            ++n2;
        }
    }

    public void setColumnCount(int columnCount) {
        if (this.myColumnCount != columnCount) {
            this.myColumnCount = columnCount;
            this.myColumnCountSetByUser = columnCount > -1;
            this.removeDrilldownPanels();
            this.setLayoutConstraints();
            this.revalidate();
            this.repaint();
        }
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        if (this.myListModel == model) {
            return;
        }
        this.clear();
        ListModel oldValue = this.myListModel;
        if (oldValue != null) {
            oldValue.removeListDataListener(this);
        }
        this.myListModel = model;
        this.addElementsToDrilldownContainer();
        this.myListModel.addListDataListener(this);
        this.firePropertyChange("model", oldValue, this.myListModel);
        this.clearSelection();
        this.revalidate();
        this.repaint();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().setSelectionInterval(anchor, lead);
    }

    public void setValueIsAdjusting(boolean b) {
        this.getSelectionModel().setValueIsAdjusting(b);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public void ensureIndexIsVisible(int index) {
        Component element = (Component)this.getModel().getElementAt(index);
        this.scrollRectToVisible(element.getBounds());
    }

    public void setSelectedIndex(int index) {
        if (index >= this.getModel().getSize() || !((Component)this.getElement(index)).isEnabled()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public List<T> getSelectedElements() {
        ListSelectionModel selectionModel = this.getSelectionModel();
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0 || this.getElements().isEmpty() || iMax >= this.getModel().getSize() || iMin >= this.getModel().getSize()) {
            return Collections.emptyList();
        }
        ArrayList<DrilldownElement> selectedItems = new ArrayList<DrilldownElement>();
        int idx = iMin;
        while (idx <= iMax) {
            if (selectionModel.isSelectedIndex(idx)) {
                selectedItems.add((DrilldownElement)this.getElements().get(idx));
            }
            ++idx;
        }
        return selectedItems;
    }

    public List<T> getVisibleElements() {
        ArrayList<DrilldownElement> result = new ArrayList<DrilldownElement>();
        for (DrilldownElement element : this.getElements()) {
            if (!element.isVisible()) continue;
            result.add(element);
        }
        return result;
    }

    public List<T> getVisibleSelectedElements() {
        ArrayList<DrilldownElement> result = new ArrayList<DrilldownElement>();
        for (DrilldownElement element : this.getElements()) {
            if (!element.isVisible() || !this.isSelectedItem(element)) continue;
            result.add(element);
        }
        return result;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int index) {
        return this.getSelectionModel().isSelectedIndex(index);
    }

    public void addListDataListener(ListDataListener listener) {
        this.myListDataListeners.add(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.myListDataListeners.remove(listener);
    }

    public int indexOf(T element) {
        List<T> elements = this.getElements();
        int idx = 0;
        while (idx < elements.size()) {
            DrilldownElement elem = (DrilldownElement)elements.get(idx);
            if (elem == element) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public boolean isSelectedItem(T item) {
        return this.getSelectionModel().isSelectedIndex(this.indexOf(item));
    }

    public void setElements(final List<T> elements) {
        this.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return elements.get(index);
            }

            @Override
            public int getSize() {
                return elements.size();
            }
        });
    }

    protected void clear() {
        for (DrilldownElement element : this.getElements()) {
            this.remove(element);
        }
        this.removeDrilldownPanels();
    }

    private void addElementsToDrilldownContainer() {
        this.createElements();
        this.setLayoutConstraints();
    }

    private void createElements() {
        for (DrilldownElement element : this.getElements()) {
            this.add((Component)element, new GridBagConstraints());
        }
    }

    private void removeDrilldownPanels() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof DrilldownPanel) {
                this.remove(comp);
            }
            ++n2;
        }
        this.myDrilldownPanels.clear();
    }

    private void setLayoutConstraints() {
        if (!this.myColumnCountSetByUser) {
            this.updateColummCount();
        }
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof DrilldownElement && comp.isVisible()) {
                constraints.useSpecificInsets(ELEMENT_INSETS);
                constraints.gridwidth = 1;
                constraints.anchor = 15;
                constraints.fillBoth();
                layout.setConstraints(comp, constraints);
                if (constraints.gridx == this.myColumnCount - 1) {
                    constraints.gridwidth = 0;
                    constraints.nextRow();
                    constraints.nextRow();
                } else {
                    constraints.nextColumn();
                }
            }
            ++n2;
        }
        ExtendedGridBagConstraints fillerConstraints = new ExtendedGridBagConstraints();
        fillerConstraints.gridx = this.myColumnCount;
        fillerConstraints.gridy = 0;
        fillerConstraints.weightx = 1.0;
        fillerConstraints.fillHorizontal();
        layout.setConstraints(this.myFiller, fillerConstraints);
        ExtendedGridBagConstraints bottomFillerConstraints = new ExtendedGridBagConstraints();
        bottomFillerConstraints.fillBoth();
        bottomFillerConstraints.weighty = 1.0;
        bottomFillerConstraints.anchor = 18;
        bottomFillerConstraints.gridy = this.getRowCount() + 12;
        bottomFillerConstraints.gridx = 0;
        layout.setConstraints(this.myBottomFiller, bottomFillerConstraints);
    }

    public final void setDrillDownPaneVisibleAt(Component element, boolean visible) {
        this.setDrillDownPaneVisibleAt(this.getElements().indexOf(element), visible);
    }

    public void setSlidingPanelVisible(boolean showSlidingPanel) {
        this.myShowSlidingPanel = showSlidingPanel;
    }

    public boolean getSlidingPanelIsVisible() {
        return this.myShowSlidingPanel;
    }

    public void setDrillDownPaneVisibleAt(int index, boolean visible) {
        if (this.myShowSlidingPanel) {
            DrilldownElement drillElement = (DrilldownElement)this.getElements().get(index);
            int visibleRow = this.getVisibleIndex(index) / this.myColumnCount;
            DrilldownPanel slidingPanel = this.myDrilldownPanels.get(this.getVisibleRow(index));
            if (slidingPanel == null) {
                slidingPanel = new DrilldownPanel(this.myAnimationEnabledForChildPanels);
                slidingPanel.setTimerDelay(this.myTimerDelay);
                slidingPanel.addStateListener(this);
                this.myDrilldownPanels.put(visibleRow, slidingPanel);
                ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
                constraints.gridwidth = 0;
                constraints.useSpecificInsets(new Insets(0, 0, 3, 0));
                constraints.fillBoth();
                constraints.gridy = 2 * visibleRow + 1;
                constraints.gridx = 0;
                slidingPanel.add(drillElement.getDetailsPane());
                this.add(slidingPanel, constraints, Math.min(this.getComponentCount(), (visibleRow + 1) * this.myColumnCount));
            }
            if (visible) {
                slidingPanel.showDetailsPane(drillElement.getDetailsPane());
                this.fireDrilldownOpened(drillElement);
            } else {
                slidingPanel.hidePanel();
                this.fireDrilldownClosed(drillElement);
            }
        }
        this.mySelectionModel.setSelectionInterval(index, index);
        this.revalidate();
        this.repaint();
    }

    public boolean isDrillDownPaneVisibleAt(int index) {
        if (index < 0 || index >= this.getElements().size()) {
            return false;
        }
        DrilldownElement element = (DrilldownElement)this.getModel().getElementAt(index);
        DrilldownPanel drilldownPanel = this.myDrilldownPanels.get(this.getVisibleRow(index));
        if (drilldownPanel == null || element == null || !element.isDetailsPanelCreated()) {
            return false;
        }
        return drilldownPanel.isVisible() && drilldownPanel.isShowing(element.getDetailsPane());
    }

    public int getVisibleIndex(T drillElement) {
        int visibleIndex = -1;
        for (DrilldownElement elem : this.getElements()) {
            if (elem.isVisible()) {
                ++visibleIndex;
            }
            if (elem != drillElement) continue;
            return visibleIndex;
        }
        return visibleIndex;
    }

    public int getVisibleIndex(int index) {
        return this.getVisibleIndex((DrilldownElement)this.getElements().get(index));
    }

    public List<T> getVisibleElements(int row) {
        ArrayList<DrilldownElement> result = new ArrayList<DrilldownElement>();
        int visibleIndex = -1;
        for (DrilldownElement element : this.getElements()) {
            int visibleRow;
            if (!element.isVisible() || row != (visibleRow = ++visibleIndex / this.myColumnCount)) continue;
            result.add(element);
        }
        return result;
    }

    public void addDrilldownListener(DrilldownListener listener) {
        if (!this.myDrilldownListeners.contains(listener)) {
            this.myDrilldownListeners.add(listener);
        }
    }

    public void removeDrilldownListener(DrilldownListener listener) {
        this.myDrilldownListeners.remove(listener);
    }

    public List<T> getElements() {
        return this.getElements(null);
    }

    public List<T> getElements(DrilldownFilter<T> filter) {
        ArrayList<DrilldownElement> result = new ArrayList<DrilldownElement>();
        int idx = 0;
        while (idx < this.myListModel.getSize()) {
            DrilldownElement element = (DrilldownElement)this.myListModel.getElementAt(idx);
            if (filter == null || filter.isAccepted(element, idx)) {
                result.add(element);
            }
            ++idx;
        }
        return result;
    }

    public int getColumnCount() {
        return this.myColumnCount;
    }

    public int getRowCount() {
        if (this.myListModel.getSize() == 0) {
            return 0;
        }
        return this.myListModel.getSize() / this.myColumnCount + 1;
    }

    public ListModel getModel() {
        return this.myListModel;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.removeDrilldownPanels();
        DrilldownElement element = (DrilldownElement)this.myListModel.getElementAt(e.getIndex0());
        this.add((Component)element, new GridBagConstraints());
        this.setLayoutConstraints();
        this.revalidate();
        this.repaint();
        for (ListDataListener l : this.myListDataListeners) {
            l.intervalAdded(e);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.removeDrilldownPanels();
        int removedIndex0 = e.getIndex0();
        int removedIndex1 = e.getIndex1();
        int index = removedIndex0;
        while (index <= removedIndex1) {
            T element = this.getElement(removedIndex0);
            this.remove((Component)element);
            ++index;
        }
        this.setLayoutConstraints();
        this.revalidate();
        this.repaint();
    }

    private T getElement(int index) {
        int elementIndex = 0;
        int idx = 0;
        while (idx < this.getComponentCount()) {
            Component component = this.getComponent(idx);
            if (component instanceof DrilldownElement) {
                if (elementIndex == index) {
                    return (T)((DrilldownElement)component);
                }
                ++elementIndex;
            }
            ++idx;
        }
        return null;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    public void setFilter(DrilldownFilter<T> filter) {
        if (this.myFilter != filter) {
            this.myFilter = filter;
            this.filter();
        }
    }

    public void filter() {
        this.removeDrilldownPanels();
        int idx = 0;
        while (idx < this.myListModel.getSize()) {
            DrilldownElement element = (DrilldownElement)this.myListModel.getElementAt(idx);
            element.setVisible(this.myFilter.isAccepted(element, idx));
            ++idx;
        }
        this.setLayoutConstraints();
        this.revalidate();
        this.repaint();
    }

    JComponent getDetailsPane(int row) {
        return this.myDrilldownPanels.get(row);
    }

    public int getColumn(int index) {
        int size = this.getModel().getSize();
        if (index < 0 || index >= size) {
            return -1;
        }
        return index % this.getColumnCount();
    }

    public int getRow(int index) {
        int size = this.getModel().getSize();
        if (index < 0 || index >= size) {
            return -1;
        }
        return index / this.getColumnCount();
    }

    public int getVisibleRow(int index) {
        int size = this.getModel().getSize();
        if (index < 0 || index >= size) {
            return -1;
        }
        int visibleIndex = this.getVisibleIndex(index);
        return visibleIndex / this.getColumnCount();
    }

    public int getIndex(int column, int row) {
        int size;
        if (column >= this.getColumnCount() || row >= this.getRowCount()) {
            return -1;
        }
        int index = this.getColumnCount() * row + column;
        if (index >= (size = this.getModel().getSize())) {
            return -1;
        }
        return index;
    }

    @Override
    public void stateChanged(SlidingPanelStateChangeEvent event) {
        this.repaint();
    }

    protected void fireDrilldownOpened(T element) {
        for (DrilldownListener listener : this.myDrilldownListeners) {
            listener.drilldownOpened(new DrilldownEvent((DrilldownElement)element));
        }
    }

    protected void fireDrilldownClosed(T element) {
        for (DrilldownListener listener : this.myDrilldownListeners) {
            listener.drilldownClosed(new DrilldownEvent((DrilldownElement)element));
        }
    }

    private void updateColummCount() {
        if (this.getWidth() > 0) {
            int largestCompWidth = 0;
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof DrilldownElement && comp.isVisible()) {
                    largestCompWidth = Math.max(largestCompWidth, comp.getPreferredSize().width);
                }
                ++n2;
            }
            this.myColumnCount = Math.max(1, this.getWidth() / (largestCompWidth + Drilldown.ELEMENT_INSETS.left + Drilldown.ELEMENT_INSETS.right));
        }
    }
}

