/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.drilldown;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.drilldown.DrillDownElementBorder;
import com.nokia.widgets.drilldown.Drilldown;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class DrilldownElement
extends PPanel {
    private JComponent myDetailsPane;

    public DrilldownElement() {
        this.setBorder(new DrillDownElementBorder());
        this.setOpaque(false);
        this.addMouseListener(new MouseHandler());
    }

    public boolean isDetailsPanelCreated() {
        return this.myDetailsPane != null;
    }

    public JComponent getDetailsPane() {
        if (this.myDetailsPane == null) {
            this.myDetailsPane = this.createDetailsPane();
        }
        return this.myDetailsPane;
    }

    protected abstract JComponent createDetailsPane();

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        private int adjustIndex(int index, Drilldown list) {
            return index < list.getModel().getSize() ? index : -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Drilldown drilldown = (Drilldown)DrilldownElement.this.getParent();
            drilldown.requestFocusInWindow();
            if (NetUtils.shouldIgnore(e, drilldown) || NetUtils.shouldIgnore(e, DrilldownElement.this)) {
                return;
            }
            drilldown.setValueIsAdjusting(true);
            this.adjustSelection(e);
        }

        private void adjustSelection(MouseEvent e) {
            boolean anchorSelected;
            Drilldown myDrilldown = (Drilldown)DrilldownElement.this.getParent();
            int row = myDrilldown.indexOf((DrilldownElement)e.getSource());
            if (row < 0) {
                return;
            }
            int anchorIndex = this.adjustIndex(myDrilldown.getAnchorSelectionIndex(), myDrilldown);
            if (anchorIndex == -1) {
                anchorIndex = 0;
                anchorSelected = false;
            } else {
                anchorSelected = myDrilldown.isSelectedIndex(anchorIndex);
            }
            if (NetUtils.isMenuShortcutKeyDown(e)) {
                if (e.isShiftDown()) {
                    if (anchorSelected) {
                        myDrilldown.addSelectionInterval(anchorIndex, row);
                    } else {
                        myDrilldown.removeSelectionInterval(anchorIndex, row);
                    }
                } else if (myDrilldown.isSelectedIndex(row)) {
                    myDrilldown.removeSelectionInterval(row, row);
                } else {
                    myDrilldown.addSelectionInterval(row, row);
                }
            } else if (e.isShiftDown()) {
                myDrilldown.setSelectionInterval(anchorIndex, row);
            } else {
                myDrilldown.setSelectionInterval(row, row);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Drilldown drilldown = (Drilldown)DrilldownElement.this.getParent();
            Component source = e.getComponent();
            if (source instanceof DrilldownElement && !e.isControlDown() && !e.isShiftDown() && !NetUtils.shouldIgnore(e, DrilldownElement.this)) {
                drilldown.setDrillDownPaneVisibleAt(source, !drilldown.isDrillDownPaneVisibleAt(drilldown.indexOf((DrilldownElement)source)));
            }
            if (NetUtils.shouldIgnore(e, drilldown) || NetUtils.shouldIgnore(e, DrilldownElement.this)) {
                return;
            }
            drilldown.setValueIsAdjusting(false);
        }
    }
}

