/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.drilldown;

import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.drilldown.DrilldownHeader;
import com.nokia.widgets.slidingpanel.SlidingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

class DrilldownPanel
extends SlidingPanel {
    private Component myCurrentDetailsPane;
    private boolean myIsWithAnimation;

    public DrilldownPanel() {
        this(true);
    }

    public DrilldownPanel(boolean isWithAnimation) {
        this.myIsWithAnimation = isWithAnimation;
        this.setLayout(new BorderLayout());
        this.setOptimizedPainting(true);
        this.setBackground(UIManager.getColor("Drilldown.background"));
        this.setTimerDelay(1);
        this.add((Component)new DrilldownHeader(), "North");
        this.add((Component)new DrilldownFooter(), "South");
        MatteBorder outerBorder = BorderFactory.createMatteBorder(0, 1, 0, 1, NetUtils.decodeColor("#CACACA"));
        this.setBorder(outerBorder);
    }

    @Override
    protected void prepareForAnimation() {
        if (this.myIsWithAnimation) {
            super.prepareForAnimation();
        }
    }

    public void showDetailsPane(Component detailsPane) {
        if (this.myCurrentDetailsPane != null) {
            this.remove(this.myCurrentDetailsPane);
        }
        this.add(detailsPane);
        this.myCurrentDetailsPane = detailsPane;
        if (this.isPanelVisible()) {
            this.revalidate();
            this.repaint();
        } else if (this.myIsWithAnimation) {
            this.showPanel();
        } else {
            this.setVisible(true);
        }
    }

    @Override
    public void hidePanel() {
        if (this.myIsWithAnimation) {
            super.hidePanel();
        } else {
            this.setVisible(false);
        }
    }

    public boolean isShowing(Component detailsPane) {
        return this.myCurrentDetailsPane == detailsPane;
    }

    private static class DrilldownFooter
    extends PPanel {
        private static final Color FOOTER_BOTTOM_HIGHLIGHT = Color.decode("#B7B7B7");
        Color[] FOOTER_GRADIENT = new Color[]{NetUtils.decodeColor("#DBDBDB"), NetUtils.decodeColor("#D3D3D3"), Color.decode("#C4C4C4")};

        public DrilldownFooter() {
            this.setPreferredSize(new Dimension(1, 6));
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float end = new Point2D.Float(0.0f, this.getHeight() - 2);
            float[] dist = new float[]{0.0f, 0.7f, 1.0f};
            Graphics2D g2d = (Graphics2D)g;
            LinearGradientPaint p = new LinearGradientPaint(start, end, dist, this.FOOTER_GRADIENT);
            g2d.setPaint(p);
            g2d.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            g2d.setColor(FOOTER_BOTTOM_HIGHLIGHT);
            g2d.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

