/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.drilldown;

import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.drilldown.Drilldown;
import com.nokia.widgets.drilldown.DrilldownElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.PanelUI;

public class DrilldownUI
extends PanelUI {
    private Drilldown myDrilldown;
    private FocusListener myFocusHandler = new FocusHandler();

    @Override
    public void installUI(JComponent c) {
        this.myDrilldown = (Drilldown)c;
        super.installUI(c);
        this.installKeyboardActions();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.myDrilldown = null;
    }

    private void installListeners() {
        this.myDrilldown.addFocusListener(this.myFocusHandler);
    }

    private void uninstallListeners() {
        this.myDrilldown.removeFocusListener(this.myFocusHandler);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("Drilldown.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.myDrilldown, 1, inputMap);
        ActionMap actionMap = new ActionMap();
        DrilldownUI.loadActionMap(actionMap);
        SwingUtilities.replaceUIActionMap(this.myDrilldown, actionMap);
    }

    static void loadActionMap(ActionMap map) {
        DrilldownUI.put(map, new DrilldownAction("selectPreviousColumn", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectPreviousColumnExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectPreviousColumnChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("selectNextColumn", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectNextColumnExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectNextColumnChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("selectPreviousRow", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectPreviousRowExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectPreviousRowChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("selectNextRow", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectNextRowExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectNextRowChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("selectFirstRow", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectFirstRowExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectFirstRowChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("selectLastRow", ChangeType.CHANGE));
        DrilldownUI.put(map, new DrilldownAction("selectLastRowExtendSelection", ChangeType.EXTEND));
        DrilldownUI.put(map, new DrilldownAction("selectLastRowChangeLead", ChangeType.CHANGE_LEAD));
        DrilldownUI.put(map, new DrilldownAction("scrollUp"));
        DrilldownUI.put(map, new DrilldownAction("scrollUpExtendSelection"));
        DrilldownUI.put(map, new DrilldownAction("scrollUpChangeLead"));
        DrilldownUI.put(map, new DrilldownAction("scrollDown"));
        DrilldownUI.put(map, new DrilldownAction("scrollDownExtendSelection"));
        DrilldownUI.put(map, new DrilldownAction("scrollDownChangeLead"));
        DrilldownUI.put(map, new DrilldownAction("selectAll"));
        DrilldownUI.put(map, new DrilldownAction("clearSelection"));
        DrilldownUI.put(map, new DrilldownAction("addToSelection"));
        DrilldownUI.put(map, new DrilldownAction("toggleAndAnchor"));
        DrilldownUI.put(map, new DrilldownAction("extendTo"));
        DrilldownUI.put(map, new DrilldownAction("moveSelectionTo"));
        DrilldownUI.put(map, new DrilldownAction("toggleDrill"));
        DrilldownUI.put(map, new DrilldownAction("openDrill"));
        DrilldownUI.put(map, new DrilldownAction("closeDrill"));
    }

    private static void put(ActionMap map, Action action) {
        map.put(action.getValue("Name"), action);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Drilldown drill = (Drilldown)c;
        int index = -1;
        for (DrilldownElement element : drill.getElements()) {
            if (!drill.isDrillDownPaneVisibleAt(++index)) continue;
            JComponent detailsPanel = drill.getDetailsPane(drill.getVisibleRow(index));
            int elementBottomY = element.getY() + element.getHeight();
            this.paintTopHighlight(g, detailsPanel, elementBottomY);
            this.paintArrow(g, element, index, elementBottomY);
        }
    }

    private void paintTopHighlight(Graphics g, JComponent detailsPanel, int elementBottomY) {
        int endX = detailsPanel.getX() + detailsPanel.getWidth() - 18;
        g.setColor(NetLookAndFeel.getWhite());
        g.drawLine(detailsPanel.getX(), elementBottomY + 1, endX, elementBottomY + 1);
        g.setColor(Color.decode("#818181"));
        g.drawLine(detailsPanel.getX(), elementBottomY + 2, endX, elementBottomY + 2);
    }

    private void paintArrow(Graphics g, DrilldownElement element, int index, int elementBottomY) {
        JComponent detailsPanel = this.myDrilldown.getDetailsPane(this.myDrilldown.getRow(index));
        int y = this.getArrowYPosition(elementBottomY, detailsPanel);
        int arrowSize = 3;
        int elementMidX = element.getX() + element.getWidth() / 2;
        Shape oldClip = g.getClip();
        g.clipRect(0, 0, this.myDrilldown.getWidth(), y);
        Polygon arrow = new Polygon(new int[]{elementMidX, elementMidX - arrowSize - 3, elementMidX + arrowSize + 3}, new int[]{elementBottomY - 6, elementBottomY + arrowSize, elementBottomY + arrowSize}, 3);
        Object oldAa = NetUtils.antiAliasingOn(g);
        g.translate(0, -2);
        g.setColor(Color.white);
        g.drawPolygon(arrow);
        g.translate(0, 2);
        GradientUtils.drawVerticalGradient((JComponent)this.myDrilldown, g, new Color[]{Color.decode("#aaaaaa"), Color.decode("#858585")}, (Shape)arrow);
        g.setColor(NetUtils.decodeColor("#6a6a6a"));
        g.drawPolygon(arrow);
        g.translate(0, -2);
        g.setColor(NetLookAndFeel.getWhite());
        g.translate(0, 2);
        NetUtils.setAntialiasing(g, oldAa);
        g.setClip(oldClip);
    }

    protected int getArrowYPosition(int elementBottomY, JComponent detailsPanel) {
        int y = detailsPanel != null && this.myDrilldown.getSlidingPanelIsVisible() ? detailsPanel.getY() : elementBottomY + 3;
        return y;
    }

    private static int adjustIndex(int index, Drilldown list) {
        return index < list.getModel().getSize() ? index : -1;
    }

    static enum ChangeType {
        CHANGE,
        EXTEND,
        CHANGE_LEAD;

    }

    private static class DrilldownAction
    extends AbstractAction {
        private static final String SELECT_PREVIOUS_COLUMN = "selectPreviousColumn";
        private static final String SELECT_PREVIOUS_COLUMN_EXTEND = "selectPreviousColumnExtendSelection";
        private static final String SELECT_PREVIOUS_COLUMN_CHANGE_LEAD = "selectPreviousColumnChangeLead";
        private static final String SELECT_NEXT_COLUMN = "selectNextColumn";
        private static final String SELECT_NEXT_COLUMN_EXTEND = "selectNextColumnExtendSelection";
        private static final String SELECT_NEXT_COLUMN_CHANGE_LEAD = "selectNextColumnChangeLead";
        private static final String SELECT_PREVIOUS_ROW = "selectPreviousRow";
        private static final String SELECT_PREVIOUS_ROW_EXTEND = "selectPreviousRowExtendSelection";
        private static final String SELECT_PREVIOUS_ROW_CHANGE_LEAD = "selectPreviousRowChangeLead";
        private static final String SELECT_NEXT_ROW = "selectNextRow";
        private static final String SELECT_NEXT_ROW_EXTEND = "selectNextRowExtendSelection";
        private static final String SELECT_NEXT_ROW_CHANGE_LEAD = "selectNextRowChangeLead";
        private static final String SELECT_FIRST_ROW = "selectFirstRow";
        private static final String SELECT_FIRST_ROW_EXTEND = "selectFirstRowExtendSelection";
        private static final String SELECT_FIRST_ROW_CHANGE_LEAD = "selectFirstRowChangeLead";
        private static final String SELECT_LAST_ROW = "selectLastRow";
        private static final String SELECT_LAST_ROW_EXTEND = "selectLastRowExtendSelection";
        private static final String SELECT_LAST_ROW_CHANGE_LEAD = "selectLastRowChangeLead";
        private static final String SCROLL_UP = "scrollUp";
        private static final String SCROLL_UP_EXTEND = "scrollUpExtendSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_DOWN = "scrollDown";
        private static final String SCROLL_DOWN_EXTEND = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String TOGGLE_DRILL = "toggleDrill";
        public static final String OPEN_DRILL = "openDrill";
        public static final String CLOSE_DRILL = "closeDrill";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";
        private ChangeType myType;

        DrilldownAction(String name) {
            this(name, (ChangeType)null);
        }

        DrilldownAction(String name, ChangeType type) {
            super(name);
            this.myType = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Drilldown drilldown = (Drilldown)e.getSource();
            int leadSelection = DrilldownUI.adjustIndex(drilldown.getSelectionModel().getLeadSelectionIndex(), drilldown);
            int previousColumnIndex = this.getNextColumnIndex(drilldown, false, leadSelection);
            int nextColumnIndex = this.getNextColumnIndex(drilldown, true, leadSelection);
            int previousIndex = this.getNextIndex(drilldown, false, leadSelection);
            int nextIndex = this.getNextIndex(drilldown, true, leadSelection);
            int lastIndex = drilldown.getModel().getSize() - 1;
            String name = (String)this.getValue("Name");
            if (SELECT_PREVIOUS_COLUMN.equals(name) || SELECT_PREVIOUS_COLUMN_EXTEND.equals(name) || SELECT_PREVIOUS_COLUMN_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, previousColumnIndex);
            } else if (SELECT_NEXT_COLUMN.equals(name) || SELECT_NEXT_COLUMN_EXTEND.equals(name) || SELECT_NEXT_COLUMN_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, nextColumnIndex);
            } else if (SELECT_PREVIOUS_ROW.equals(name) || SELECT_PREVIOUS_ROW_EXTEND.equals(name) || SELECT_PREVIOUS_ROW_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, previousIndex);
            } else if (SELECT_NEXT_ROW.equals(name) || SELECT_NEXT_ROW_EXTEND.equals(name) || SELECT_NEXT_ROW_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, nextIndex);
            } else if (SELECT_FIRST_ROW.equals(name) || SELECT_FIRST_ROW_EXTEND.equals(name) || SELECT_FIRST_ROW_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, 0);
            } else if (SELECT_LAST_ROW.equals(name) || SELECT_LAST_ROW_EXTEND.equals(name) || SELECT_LAST_ROW_CHANGE_LEAD.equals(name)) {
                this.changeSelection(drilldown, lastIndex);
            } else if (EXTEND_TO.equals(name) || MOVE_SELECTION_TO.equals(name)) {
                this.changeSelection(drilldown, leadSelection);
            } else if (SELECT_ALL.equals(name)) {
                this.selectAll(drilldown, leadSelection);
            } else if (CLEAR_SELECTION.equals(name)) {
                drilldown.clearSelection();
            } else if (ADD_TO_SELECTION.equals(name)) {
                if (!drilldown.isSelectedIndex(leadSelection)) {
                    int oldAnchor = drilldown.getSelectionModel().getAnchorSelectionIndex();
                    drilldown.setValueIsAdjusting(true);
                    drilldown.addSelectionInterval(leadSelection, leadSelection);
                    drilldown.getSelectionModel().setAnchorSelectionIndex(oldAnchor);
                    drilldown.setValueIsAdjusting(false);
                }
            } else if (TOGGLE_AND_ANCHOR.equals(name)) {
                if (drilldown.isSelectedIndex(leadSelection)) {
                    drilldown.removeSelectionInterval(leadSelection, leadSelection);
                } else {
                    drilldown.addSelectionInterval(leadSelection, leadSelection);
                }
            } else if (OPEN_DRILL.equals(name)) {
                if (leadSelection >= 0) {
                    drilldown.setDrillDownPaneVisibleAt(leadSelection, true);
                }
            } else if (TOGGLE_DRILL.equals(name)) {
                if (leadSelection >= 0) {
                    drilldown.setDrillDownPaneVisibleAt(leadSelection, !drilldown.isDrillDownPaneVisibleAt(leadSelection));
                }
            } else if (CLOSE_DRILL.equals(name)) {
                drilldown.setDrillDownPaneVisibleAt(leadSelection, false);
            }
        }

        private void selectAll(Drilldown drilldown, int lead) {
            int tempLead = lead;
            int size = drilldown.getModel().getSize();
            if (size <= 0) {
                return;
            }
            ListSelectionModel lsm = drilldown.getSelectionModel();
            if (lsm.getSelectionMode() == 0) {
                if (tempLead == -1) {
                    int min = DrilldownUI.adjustIndex(drilldown.getMinSelectionIndex(), drilldown);
                    tempLead = min == -1 ? 0 : min;
                }
                drilldown.setSelectionInterval(tempLead, tempLead);
                drilldown.ensureIndexIsVisible(tempLead);
            } else {
                drilldown.setValueIsAdjusting(true);
                int anchor = DrilldownUI.adjustIndex(lsm.getAnchorSelectionIndex(), drilldown);
                drilldown.setSelectionInterval(0, size - 1);
                NetUtils.setLeadAnchorWithoutSelection(lsm, anchor, tempLead);
                drilldown.setValueIsAdjusting(false);
            }
        }

        private void changeSelection(Drilldown drilldown, int index) {
            if (index < 0 || index >= drilldown.getModel().getSize()) {
                return;
            }
            ListSelectionModel lsm = drilldown.getSelectionModel();
            if (this.myType == ChangeType.CHANGE_LEAD && drilldown.getSelectionMode() != 2) {
                this.myType = ChangeType.CHANGE;
            }
            if (this.myType == ChangeType.EXTEND) {
                int anchor = DrilldownUI.adjustIndex(lsm.getAnchorSelectionIndex(), drilldown);
                if (anchor == -1) {
                    anchor = 0;
                }
                drilldown.setSelectionInterval(anchor, index);
            } else if (this.myType == ChangeType.CHANGE) {
                drilldown.setSelectedIndex(index);
            } else {
                ((DefaultListSelectionModel)lsm).moveLeadSelectionIndex(index);
            }
        }

        private int getNextColumnIndex(Drilldown drilldown, boolean forward, int leadSelection) {
            int size = drilldown.getModel().getSize();
            int columnCount = drilldown.getColumnCount();
            if (leadSelection == -1 || size == 1) {
                return 0;
            }
            if (columnCount <= 1) {
                return -1;
            }
            int columnLead = drilldown.getColumn(leadSelection);
            int rowLead = drilldown.getRow(leadSelection);
            if ((columnLead += forward ? 1 : -1) >= columnCount || columnLead < 0) {
                return -1;
            }
            if (rowLead >= drilldown.getRowCount()) {
                return -1;
            }
            return drilldown.getIndex(columnLead, rowLead);
        }

        private int getNextIndex(Drilldown drilldown, boolean forward, int index) {
            int tempIndex = index;
            int size = drilldown.getModel().getSize();
            if (tempIndex == -1) {
                if (size > 0) {
                    tempIndex = forward ? 0 : size - 1;
                }
            } else {
                tempIndex = size == 1 ? 0 : (tempIndex += drilldown.getColumnCount() * (forward ? 1 : -1));
            }
            return tempIndex;
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            DrilldownUI.this.myDrilldown.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DrilldownUI.this.myDrilldown.repaint();
        }
    }

    static enum SelectionType {
        NEXT_COLUMN,
        PREVIOUS_COLUMN,
        NEXT,
        PREVIOUS;

    }
}

