/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.folderbrowser;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.folderbrowser.ErrorFactory;
import com.nokia.widgets.folderbrowser.FolderBrowserTree;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.util.WidgetResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class FolderBrowser
extends JDialog {
    private FolderBrowserTree myTree = null;
    private PToolButton myNewDirButton = null;
    private PToolButton myDeleteButton = null;
    private PToolButton myRenameButton = null;
    private PToolButton myRefreshButton = null;
    private Action myNewDirAction = new NewDirectoryAction();
    private Action myDeleteAction = new DeleteAction();
    private Action myRenameAction = new RenameAction();
    private Action myRefreshAction = new RefreshAction();
    private Action myOkAction = new OKAction();
    private JButton myOkButton = null;
    private JButton myCancelButton = null;
    private PHelpButton myHelpButton = null;
    private boolean isOkClicked = false;
    private MyPopupMenu myPopupMenu = null;

    public FolderBrowser(Component parent) {
        this(parent, WidgetResources.getString("FolderBrowser.Title"));
    }

    public FolderBrowser(Component parent, String title) {
        super(JOptionPane.getFrameForComponent(parent), title, true);
        this.buildUI();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
        this.setVisibleExtendedActions(true);
    }

    private void buildUI() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(26, 26, 20, 26);
        constraints.fill = 1;
        FlowLayout f = new FlowLayout(0, 0, 0);
        JPanel extendedButtonsPanel = new JPanel(f);
        this.myNewDirButton = new PToolButton();
        this.myNewDirButton.setAction(this.myNewDirAction);
        this.myNewDirButton.setVisible(false);
        this.myNewDirButton.setFocusable(true);
        extendedButtonsPanel.add(this.myNewDirButton);
        this.myDeleteButton = new PToolButton();
        this.myDeleteButton.setAction(this.myDeleteAction);
        this.myDeleteButton.setVisible(false);
        this.myDeleteButton.setFocusable(true);
        extendedButtonsPanel.add(this.myDeleteButton);
        this.myRenameButton = new PToolButton();
        this.myRenameButton.setAction(this.myRenameAction);
        this.myRenameButton.setVisible(false);
        this.myRenameButton.setFocusable(true);
        extendedButtonsPanel.add(this.myRenameButton);
        this.myRefreshButton = new PToolButton();
        this.myRefreshButton.setAction(this.myRefreshAction);
        this.myRefreshButton.setVisible(false);
        this.myRefreshButton.setFocusable(true);
        extendedButtonsPanel.add(this.myRefreshButton);
        ImageIcon newFolderDefault = WidgetResources.getImageIcon("FolderBrowser.Create.Icon.Normal");
        this.myNewDirButton.setIcon(newFolderDefault);
        this.myNewDirButton.setToolTipText(WidgetResources.getString("FolderBrowser.Create.Tooltip"));
        ImageIcon removeDefault = CommonIcons.getDeleteIcon();
        this.myDeleteButton.setIcon(removeDefault);
        this.myDeleteButton.setToolTipText(WidgetResources.getString("FolderBrowser.Delete.Tooltip"));
        ImageIcon renameDefault = WidgetResources.getImageIcon("FolderBrowser.Rename.Icon.Normal");
        this.myRenameButton.setIcon(renameDefault);
        this.myRenameButton.setToolTipText(WidgetResources.getString("FolderBrowser.Rename.Tooltip"));
        this.myRefreshButton.setIcon(CommonIcons.getRefreshIcon());
        this.myRefreshButton.setToolTipText(WidgetResources.getString("FolderBrowser.Refresh.Tooltip"));
        JPanel browserPanel = new JPanel(new BorderLayout());
        browserPanel.add((Component)extendedButtonsPanel, "North");
        this.myTree = new FolderBrowserTree();
        this.myTree.getCellEditor().addCellEditorListener(new MyCellEditorListener());
        this.myTree.addTreeSelectionListener(new MyTreeSelectionListener());
        this.myTree.addTreeWillExpandListener(new MyTreeWillExpandListener());
        this.myTree.addTreeExpansionListener(new MyTreeExpansionListener());
        JScrollPane treeView = new JScrollPane(this.myTree);
        treeView.putClientProperty("OrangeTouch.curvedSheet", true);
        this.myTree.registerKeyboardAction(new ClosingListener(), KeyStroke.getKeyStroke(27, 0), 2);
        browserPanel.add((Component)treeView, "Center");
        p.add((Component)browserPanel, constraints);
        this.myOkButton = new JButton();
        this.myOkButton.setName(WidgetResources.getString("OkAction_Text"));
        this.myOkButton.setAction(this.myOkAction);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.myCancelButton = new JButton();
        this.myCancelButton.setText(WidgetResources.getString("CancelAction_Text"));
        this.myCancelButton.setMnemonic(WidgetResources.getMnemonic("CancelAction_Mnemonic"));
        this.myCancelButton.setAction(new CancelAction());
        this.myHelpButton = new PHelpButton();
        this.myHelpButton.setVisible(false);
        JPanel buttonPanel = new JPanel(new PButtonRowLayout());
        buttonPanel.add(this.myOkButton);
        buttonPanel.add(this.myCancelButton);
        buttonPanel.add((Component)this.myHelpButton, "East");
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        constraints.anchor = 15;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        p.add((Component)buttonPanel, constraints);
        this.getContentPane().add(p);
        this.setSize(new Dimension(650, 650));
        this.setModal(true);
    }

    public PHelpButton getHelpButton() {
        return this.myHelpButton;
    }

    public FolderBrowserTree getFolderBrowserTree() {
        return this.myTree;
    }

    public void setSelectedDirectory(File dir) {
        this.myTree.setSelectedDirectory(dir);
    }

    public void setVisibleExtendedActions(boolean aFlag) {
        this.myNewDirButton.setVisible(aFlag);
        this.myDeleteButton.setVisible(aFlag);
        this.myRenameButton.setVisible(aFlag);
        this.myRefreshButton.setVisible(aFlag);
        InputMap inputMap = this.myTree.getInputMap(2);
        ActionMap actionMap = this.myTree.getActionMap();
        if (aFlag) {
            inputMap.put(KeyStroke.getKeyStroke(114, 0), "rename");
            actionMap.put("rename", this.myRenameAction);
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
            actionMap.put("delete", this.myDeleteAction);
            inputMap.put(KeyStroke.getKeyStroke(78, 128), "newfolder");
            actionMap.put("newfolder", this.myNewDirAction);
            inputMap.put(KeyStroke.getKeyStroke(116, 0), "refreshtree");
            actionMap.put("refreshtree", this.myRefreshAction);
            if (this.myPopupMenu == null) {
                this.myPopupMenu = new MyPopupMenu();
                this.myTree.addMouseListener(this.myPopupMenu);
            }
        } else {
            inputMap.remove(KeyStroke.getKeyStroke(114, 0));
            inputMap.remove(KeyStroke.getKeyStroke(127, 0));
            inputMap.remove(KeyStroke.getKeyStroke(116, 0));
            inputMap.remove(KeyStroke.getKeyStroke(78, 128));
            actionMap.remove("rename");
            actionMap.remove("delete");
            actionMap.remove("newfolder");
            actionMap.remove("refreshtree");
            this.myTree.removeMouseListener(this.myPopupMenu);
            this.myPopupMenu = null;
        }
    }

    public File getSelectedDirectory() {
        File s = this.myTree.getSelectedDirectory();
        return s;
    }

    public boolean isOKClicked() {
        return this.isOkClicked;
    }

    private void setUIEnabled(boolean b) {
        this.myNewDirAction.setEnabled(b);
        this.myDeleteAction.setEnabled(b);
        this.myRenameAction.setEnabled(b);
        this.myOkAction.setEnabled(b);
    }

    private void setUIEnabled(File dir) {
        if (dir == null) {
            this.setUIEnabled(false);
        } else if (FolderBrowserTree.fileSystemView.isRoot(dir)) {
            this.myNewDirAction.setEnabled(true);
            this.myDeleteAction.setEnabled(false);
            this.myRenameAction.setEnabled(false);
            this.myOkAction.setEnabled(true);
        } else if (!FolderBrowserTree.fileSystemView.isFileSystem(dir)) {
            this.setUIEnabled(false);
        } else if (FolderBrowserTree.fileSystemView.isDrive(dir)) {
            this.myNewDirAction.setEnabled(true);
            this.myDeleteAction.setEnabled(false);
            this.myRenameAction.setEnabled(false);
            this.myOkAction.setEnabled(true);
        } else {
            this.setUIEnabled(true);
        }
    }

    public void setCanOpenReadOnlyFolder(boolean canOpenReadOnlyFolde) {
        ((OKAction)this.myOkAction).setCanOpenReadOnlyFolder(canOpenReadOnlyFolde);
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
            this.putValue("Name", WidgetResources.getString("CancelAction_Text"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FolderBrowser.this.setVisible(false);
        }
    }

    private class ClosingListener
    implements ActionListener {
        private ClosingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FolderBrowser.this.setVisible(false);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.isEnabled()) {
                return;
            }
            CancelButtonAction c = new CancelButtonAction();
            DeleteButtonAction d = new DeleteButtonAction();
            JOptionPane.showOptionDialog(FolderBrowser.this.myTree, new String[]{WidgetResources.getString("FolderBrowser.Delete.Confirmation_title"), WidgetResources.getString("FolderBrowser.Delete.Confirmation_text")}, WidgetResources.getString("FolderBrowser.Delete.Action"), 2, 2, null, new Object[]{d, c}, c);
        }

        private class CancelButtonAction
        extends AbstractAction {
            private CancelButtonAction() {
                this.putValue("Name", WidgetResources.getString("CancelAction_Text"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        }

        private class DeleteButtonAction
        extends AbstractAction {
            private DeleteButtonAction() {
                this.putValue("Name", WidgetResources.getString("FolderBrowser.Delete.Action"));
                int i = WidgetResources.getMnemonic("FolderBrowser.Delete.Mnemonic");
                this.putValue("MnemonicKey", i);
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean b = FolderBrowser.this.myTree.deleteSelectedDirectory();
                if (!b) {
                    ErrorFactory.showDeleteErrorGeneralFault(FolderBrowser.this);
                }
            }
        }
    }

    private class MyCellEditorListener
    implements CellEditorListener {
        private MyCellEditorListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            FolderBrowser.this.setUIEnabled(true);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            FolderBrowser.this.setUIEnabled(true);
        }
    }

    private class MyPopupMenu
    extends MouseAdapter {
        private JPopupMenu popupMenu = new JPopupMenu();

        public MyPopupMenu() {
            JMenuItem newDirItem = new JMenuItem(FolderBrowser.this.myNewDirAction);
            ImageIcon newFolderDefault = WidgetResources.getImageIcon("FolderBrowser.Create.Icon.Normal");
            newDirItem.setIcon(newFolderDefault);
            newDirItem.setText(WidgetResources.getString("FolderBrowser.Create.Action"));
            newDirItem.setToolTipText(WidgetResources.getString("FolderBrowser.Create.Tooltip"));
            this.popupMenu.add(newDirItem);
            JMenuItem deleteItem = new JMenuItem(FolderBrowser.this.myDeleteAction);
            ImageIcon removeDefault = CommonIcons.getDeleteIcon();
            deleteItem.setIcon(removeDefault);
            deleteItem.setText(WidgetResources.getString("FolderBrowser.Delete.Action"));
            deleteItem.setToolTipText(WidgetResources.getString("FolderBrowser.Delete.Tooltip"));
            this.popupMenu.add(deleteItem);
            JMenuItem renameItem = new JMenuItem(FolderBrowser.this.myRenameAction);
            ImageIcon renameDefault = WidgetResources.getImageIcon("FolderBrowser.Rename.Icon.Normal");
            renameItem.setIcon(renameDefault);
            renameItem.setText(WidgetResources.getString("FolderBrowser.Rename.Action"));
            renameItem.setToolTipText(WidgetResources.getString("FolderBrowser.Rename.Tooltip"));
            this.popupMenu.add(renameItem);
            JMenuItem refreshItem = new JMenuItem(FolderBrowser.this.myRefreshAction);
            ImageIcon refreshDefault = WidgetResources.getImageIcon("FolderBrowser.Refresh.Icon.Normal");
            refreshItem.setIcon(refreshDefault);
            refreshItem.setText(WidgetResources.getString("FolderBrowser.Refresh.Action"));
            refreshItem.setToolTipText(WidgetResources.getString("FolderBrowser.Refresh.Tooltip"));
            this.popupMenu.add(refreshItem);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreePath path;
            Point pt = e.getPoint();
            Component object = FolderBrowser.this.myTree.getComponentAt(pt);
            if (object != null && e.isPopupTrigger() && (path = FolderBrowser.this.myTree.getPathForLocation(pt.x, pt.y)) != null) {
                if (!(((FolderBrowser)FolderBrowser.this).myTree.createNewDirInProcess || ((FolderBrowser)FolderBrowser.this).myTree.nodeExpansionInProcess || ((FolderBrowser)FolderBrowser.this).myTree.renameDirInProcess)) {
                    FolderBrowser.this.myTree.setSelectionPath(path);
                }
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseReleased(e);
        }
    }

    private class MyTreeExpansionListener
    implements TreeExpansionListener {
        private MyTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent ev) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent ev) {
            if (FolderBrowser.this.myTree.getLastSelectedPathComponent() instanceof FolderBrowserTree.DirNode) {
                File dir = ((FolderBrowserTree.DirNode)FolderBrowser.this.myTree.getLastSelectedPathComponent()).getDir();
                FolderBrowser.this.setUIEnabled(dir);
            }
        }
    }

    private class MyTreeSelectionListener
    implements TreeSelectionListener {
        private MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent ev) {
            TreePath n = ev.getNewLeadSelectionPath();
            if (n == null) {
                FolderBrowser.this.setUIEnabled(false);
            }
            if (n != null && n.getLastPathComponent() instanceof FolderBrowserTree.DirNode) {
                FolderBrowserTree.DirNode node = (FolderBrowserTree.DirNode)n.getLastPathComponent();
                File dir = node.getDir();
                FolderBrowser.this.setUIEnabled(dir);
            }
        }
    }

    private class MyTreeWillExpandListener
    implements TreeWillExpandListener {
        private MyTreeWillExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent ev) throws ExpandVetoException {
            FolderBrowser.this.myNewDirAction.setEnabled(false);
            FolderBrowser.this.myDeleteAction.setEnabled(false);
            FolderBrowser.this.myRenameAction.setEnabled(false);
            FolderBrowser.this.myOkAction.setEnabled(false);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent ev) throws ExpandVetoException {
        }
    }

    private class NewDirectoryAction
    extends AbstractAction {
        private NewDirectoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FolderBrowser.this.setUIEnabled(false);
                }
            });
            FolderBrowser.this.myTree.createNewDirectory(null);
        }
    }

    private class OKAction
    extends AbstractAction {
        private boolean myCanOpenReadOnlyFolder = true;

        private OKAction() {
            this.putValue("Name", WidgetResources.getString("FolderBrowser.Select.Action"));
        }

        public void setCanOpenReadOnlyFolder(boolean canOpenReadOnlyFolder) {
            this.myCanOpenReadOnlyFolder = canOpenReadOnlyFolder;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File folder = FolderBrowser.this.getSelectedDirectory();
            if (!this.myCanOpenReadOnlyFolder && folder != null && !this.isFolderCanWrite(FolderBrowser.this, folder, "tempFile")) {
                return;
            }
            FolderBrowser.this.isOkClicked = true;
            FolderBrowser.this.setVisible(false);
        }

        private boolean isFolderCanWrite(Component parent, File folder, String fileName) {
            File tempFile = new File(folder, fileName);
            if (!tempFile.exists()) {
                boolean createNewFile;
                try {
                    createNewFile = tempFile.createNewFile();
                }
                catch (IOException e) {
                    createNewFile = false;
                }
                if (!createNewFile) {
                    ErrorFactory.showSelectErrorReadOnly(parent, folder.getName());
                    return createNewFile;
                }
                if (!tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
                return createNewFile;
            }
            this.isFolderCanWrite(parent, folder, String.valueOf(fileName) + "1");
            return true;
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.isEnabled()) {
                return;
            }
            FolderBrowser.this.myTree.refresh();
        }
    }

    private class RenameAction
    extends AbstractAction {
        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.isEnabled()) {
                return;
            }
            FolderBrowser.this.setUIEnabled(null);
            FolderBrowser.this.myTree.renameDirectory(null);
        }
    }
}

