/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.folderbrowser;

import com.nokia.widgets.folderbrowser.ErrorFactory;
import com.nokia.widgets.tree.PDefaultTreeCellRenderer;
import com.nokia.widgets.util.WidgetResources;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FolderBrowserTree
extends JTree {
    static FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private TreeSelectionModel treeSelectionModel = null;
    private Timer disableTreeSelectionTimer = null;
    public boolean nodeExpansionInProcess = false;
    public boolean createNewDirInProcess = false;
    public boolean renameDirInProcess = false;
    private File oldFolder;
    private MyTreeModelListener myTreeModelListener = new MyTreeModelListener();

    public FolderBrowserTree() {
        super(new DirNode(fileSystemView.getRoots()[0]));
        this.addTreeWillExpandListener(new MyTreeWillExpandListener());
        this.getSelectionModel().setSelectionMode(1);
        this.putClientProperty("JTree.lineStyle", "Vertical");
        ((DefaultTreeModel)this.treeModel).addTreeModelListener(this.myTreeModelListener);
        this.setCellRenderer(new MyDefaultTreeCellRenderer());
        this.setEditable(true);
        this.getCellEditor().addCellEditorListener(new MyCellEditorListener());
        this.setEditable(false);
        this.setDragEnabled(false);
        this.setSelectedDirectory(null);
    }

    public void refresh() {
        if (!this.stopEditing()) {
            this.cancelEditing();
        }
        this.createNewDirInProcess = false;
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.myTreeModelListener);
        }
        this.setModel(new DefaultTreeModel(new DirNode(fileSystemView.getRoots()[0]), false));
        this.treeModel.addTreeModelListener(this.myTreeModelListener);
        this.setSelectionRow(0);
        this.scrollRowToVisible(0);
    }

    public File getSelectedDirectory() {
        File dir;
        DirNode node = (DirNode)this.getLastSelectedPathComponent();
        if (node != null && fileSystemView.isFileSystem(dir = node.getDir())) {
            return dir;
        }
        return null;
    }

    public void setSelectedDirectory(File dir) {
        File tempDir = dir;
        if (tempDir == null) {
            tempDir = fileSystemView.getDefaultDirectory();
        }
        TreePath path = this.mkPath(tempDir);
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    private TreePath mkPath(File dir) {
        if (dir == null) {
            return null;
        }
        DirNode root = (DirNode)this.getModel().getRoot();
        if (root.getDir().equals(dir)) {
            return new TreePath(root);
        }
        TreePath parentPath = this.mkPath(fileSystemView.getParentDirectory(dir));
        if (parentPath != null) {
            DirNode parentNode = (DirNode)parentPath.getLastPathComponent();
            Enumeration enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                DirNode child = (DirNode)enumeration.nextElement();
                if (!child.getDir().equals(dir)) continue;
                return parentPath.pathByAddingChild(child);
            }
        }
        return null;
    }

    public boolean deleteSelectedDirectory() {
        File file = this.getSelectedDirectory();
        boolean b = file.delete();
        if (b) {
            DefaultMutableTreeNode selectedNode = null;
            TreePath selectionPath = this.getSelectionPath();
            selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            ((DefaultTreeModel)this.treeModel).removeNodeFromParent(selectedNode);
            ((DefaultTreeModel)this.treeModel).reload();
            this.expandPath(selectionPath.getParentPath());
            this.setSelectionPath(selectionPath.getParentPath());
        }
        return b;
    }

    public void renameDirectory(DirNode node) {
        DirNode tempNode = node;
        if (tempNode == null) {
            tempNode = (DirNode)this.getLastSelectedPathComponent();
        }
        if (tempNode != null) {
            if (!this.isEditable()) {
                this.setEditable(true);
            }
            if (tempNode.getDir() != null) {
                this.oldFolder = tempNode.getDir();
            }
            this.renameDirInProcess = true;
            this.startEditingAtPath(new TreePath(tempNode.getPath()));
        }
    }

    private String findFirstUniqueDirName(DirNode parentNode) {
        String defaultFolderName;
        String newFolderName = defaultFolderName = WidgetResources.getString("FolderBrowser.DefaultFolderName");
        boolean newFolderExists = false;
        int counter = 2;
        do {
            File newDir;
            if (!(newFolderExists = (newDir = new File(parentNode.getDir(), newFolderName)).exists())) continue;
            StringBuffer buffer = new StringBuffer();
            Object[] n = new Object[]{String.valueOf(counter++)};
            buffer.append(MessageFormat.format(WidgetResources.getString("FolderBrowser.DefaultFolderNameIfExists"), n));
            newFolderName = buffer.toString();
        } while (newFolderExists);
        return newFolderName;
    }

    public void createNewDirectory(DirNode childNode) {
        DirNode tempChildNode = childNode;
        if (!this.isEditable()) {
            this.setEditable(true);
        }
        DirNode parentNode = null;
        TreePath parentPath = this.getSelectionPath();
        if (parentPath == null) {
            return;
        }
        if (!this.createNewDirInProcess) {
            this.createNewDirInProcess = true;
            parentNode = (DirNode)parentPath.getLastPathComponent();
            String newName = this.findFirstUniqueDirName(parentNode);
            tempChildNode = new DirNode(newName);
            File newFile = new File(parentNode.getDir(), newName);
            tempChildNode.setUserObject(newFile);
            this.oldFolder = tempChildNode.getDir();
            ((DefaultTreeModel)this.treeModel).insertNodeInto(tempChildNode, parentNode, parentNode.getChildCount());
        }
        this.startEditingAtPath(new TreePath(tempChildNode.getPath()));
    }

    private boolean isValidDirectoryName(String name) {
        String os = System.getProperty("os.name").toLowerCase();
        String pattern = ".*[\\/:*?|<>\"].*";
        if (os.indexOf("windows") != -1) {
            pattern = ".*[\\/:*?|<>\"].*";
        } else if (os.indexOf("linux") != -1) {
            pattern = ".*[/].*";
        } else if (os.indexOf("mac") != -1) {
            pattern = ".*[:/].*";
        }
        return name != null && name.length() != 0 && !name.matches(pattern);
    }

    private void updateFilePathToAllChildren(DirNode parentNode) {
        if (!parentNode.areChildrenLoaded() || parentNode.getChildCount() == 0) {
            return;
        }
        Enumeration enumeration = parentNode.children();
        while (enumeration.hasMoreElements()) {
            DirNode childNode = (DirNode)enumeration.nextElement();
            File newDir = new File(parentNode.getDir(), ((File)childNode.getUserObject()).getName());
            childNode.setUserObject(newDir);
            if (!childNode.areChildrenLoaded() || childNode.getChildCount() <= 0) continue;
            this.updateFilePathToAllChildren(childNode);
        }
    }

    private void doFileSystem(DirNode node) {
        String newDirName;
        if (node.getDir() != null) {
            newDirName = node.getDir().getName();
        } else {
            newDirName = node.getUserObject().toString();
            newDirName = newDirName.trim();
            while (newDirName.endsWith(".")) {
                newDirName = newDirName.substring(0, newDirName.length() - 1);
                newDirName = newDirName.trim();
            }
        }
        if (this.createNewDirInProcess) {
            DirNode parentNode = (DirNode)node.getParent();
            File newDir = new File(parentNode.getDir(), newDirName);
            boolean b = false;
            if (newDir.getName().startsWith(".")) {
                ErrorFactory.showCreateErrorDotFirstChar(this);
                node.setUserObject(this.oldFolder);
                this.renameDirectory(node);
                return;
            }
            b = newDir.mkdir();
            if (b) {
                node.setUserObject(newDir);
                this.createNewDirInProcess = false;
                this.oldFolder = null;
                this.setEditable(false);
            } else {
                if (newDirName.length() == 0) {
                    ErrorFactory.showCreateErrorNoName(this);
                } else if (!this.isValidDirectoryName(newDir.getName())) {
                    ErrorFactory.showCreateErrorInvalidName(this);
                } else if (newDir.exists()) {
                    ErrorFactory.showCreateErrorNameExists(this);
                } else {
                    ErrorFactory.showCreateErrorGeneralFault(this);
                }
                node.setUserObject(this.oldFolder);
                this.createNewDirectory(node);
            }
        } else if (this.renameDirInProcess) {
            DirNode parentNode = (DirNode)node.getParent();
            File newDir = new File(parentNode.getDir(), newDirName);
            boolean b = false;
            if (newDir.getName().startsWith(".")) {
                ErrorFactory.showRenameErrorDotFirstChar(this);
                node.setUserObject(this.oldFolder);
                this.renameDirectory(node);
                return;
            }
            b = this.oldFolder.renameTo(newDir);
            if (b) {
                node.setUserObject(newDir);
                this.updateFilePathToAllChildren(node);
                this.renameDirInProcess = false;
                this.setEditable(false);
                this.oldFolder = null;
            } else {
                if (newDirName.length() == 0) {
                    ErrorFactory.showRenameErrorNoName(this);
                } else if (!this.isValidDirectoryName(newDir.getName())) {
                    ErrorFactory.showRenameErrorInvalidName(this);
                } else if (newDir.exists()) {
                    ErrorFactory.showRenameErrorNameExists(this);
                } else {
                    ErrorFactory.showRenameErrorGeneralFault(this);
                }
                node.setUserObject(this.oldFolder);
                this.renameDirectory(node);
            }
        }
    }

    private void enableTreeSelection() {
        if (this.treeSelectionModel != null) {
            this.setSelectionModel(this.treeSelectionModel);
            this.treeSelectionModel = null;
        }
    }

    private void disableTreeSelection() {
        this.disableTreeSelectionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (FolderBrowserTree.this.nodeExpansionInProcess && FolderBrowserTree.this.treeSelectionModel == null) {
                    FolderBrowserTree.this.treeSelectionModel = FolderBrowserTree.this.getSelectionModel();
                    FolderBrowserTree.this.setSelectionModel(null);
                } else {
                    FolderBrowserTree.this.stopTimer();
                }
            }
        });
        this.disableTreeSelectionTimer.start();
    }

    private void stopTimer() {
        if (this.disableTreeSelectionTimer != null) {
            this.disableTreeSelectionTimer.stop();
        }
    }

    public static void _printFileProperties(File file) {
        System.out.println("Absulute path: " + file.getAbsolutePath());
        System.out.println("display name: " + fileSystemView.getSystemDisplayName(file));
        System.out.println("can read: " + file.canRead());
        System.out.println("can write: " + file.canWrite());
        System.out.println("is coputer node: " + fileSystemView.isComputerNode(file));
        System.out.println("is drive: " + fileSystemView.isDrive(file));
        System.out.println("is root: " + fileSystemView.isFileSystemRoot(file));
        System.out.println("is floppy: " + fileSystemView.isFloppyDrive(file));
        System.out.println("is traversable: " + fileSystemView.isTraversable(file));
        System.out.println("is file system: " + fileSystemView.isFileSystem(file));
    }

    static class DirNode
    extends DefaultMutableTreeNode {
        private boolean childrenLoaded = false;

        DirNode(String fileName) {
            super(fileName);
        }

        DirNode(File dir) {
            super(dir);
        }

        public File getDir() {
            if (this.userObject instanceof File) {
                return (File)this.userObject;
            }
            return null;
        }

        public boolean areChildrenLoaded() {
            return this.childrenLoaded;
        }

        @Override
        public int getChildCount() {
            if (!this.childrenLoaded) {
                this.populateChildren();
                this.childrenLoaded = true;
            }
            return super.getChildCount();
        }

        public Enumeration children() {
            if (!this.childrenLoaded) {
                this.populateChildren();
                this.childrenLoaded = true;
            }
            return super.children();
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
            this.childrenLoaded = false;
        }

        private void populateChildren() {
            if (this.children == null || this.children.size() == 0) {
                Object[] files = fileSystemView.getFiles(this.getDir(), true);
                Arrays.sort(files);
                int i = 0;
                while (i < files.length) {
                    Object f = files[i];
                    if (((File)f).isDirectory()) {
                        this.insert(new DirNode((File)f), this.children == null ? 0 : this.children.size());
                    }
                    ++i;
                }
            }
        }

        @Override
        public String toString() {
            return fileSystemView.getSystemDisplayName(this.getDir());
        }

        public boolean equals(Object o) {
            return o instanceof DirNode && this.userObject.equals(((DirNode)o).userObject);
        }

        public int hashCode() {
            int hash = 1;
            return hash += this.userObject == null ? 0 : this.userObject.hashCode();
        }
    }

    private class MyCellEditorListener
    implements CellEditorListener {
        private MyCellEditorListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            final DirNode node = (DirNode)FolderBrowserTree.this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (FolderBrowserTree.this.createNewDirInProcess || FolderBrowserTree.this.oldFolder != null && !FolderBrowserTree.this.oldFolder.getAbsoluteFile().equals(node.getDir().getAbsoluteFile())) {
                FolderBrowserTree.this.doFileSystem(node);
                if (!node.getDir().exists()) {
                    final TreePath selectionPath = FolderBrowserTree.this.getSelectionPath();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((DefaultTreeModel)FolderBrowserTree.this.treeModel).removeNodeFromParent(node);
                            ((DefaultTreeModel)FolderBrowserTree.this.treeModel).reload();
                            FolderBrowserTree.this.expandPath(selectionPath.getParentPath());
                            FolderBrowserTree.this.setSelectionPath(selectionPath.getParentPath());
                        }
                    });
                }
            }
            FolderBrowserTree.this.createNewDirInProcess = false;
            FolderBrowserTree.this.renameDirInProcess = false;
            FolderBrowserTree.this.setEditable(false);
        }

        @Override
        public void editingStopped(ChangeEvent e) {
        }
    }

    private static class MyDefaultTreeCellRenderer
    extends PDefaultTreeCellRenderer {
        private Icon desktopIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        private Icon specialIcon = UIManager.getIcon("FileView.computerIcon");
        private Icon driveIcon = UIManager.getIcon("FileView.hardDriveIcon");

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocus);
            if (value instanceof DirNode) {
                File node = ((DirNode)value).getDir();
                if (fileSystemView.isRoot(node)) {
                    this.setIcon(this.desktopIcon);
                } else if (fileSystemView.isDrive(node)) {
                    this.setIcon(this.driveIcon);
                } else if (!fileSystemView.isFileSystem(node)) {
                    this.setIcon(this.specialIcon);
                }
            }
            return this;
        }
    }

    private class MyTreeModelListener
    implements TreeModelListener {
        private MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DirNode node = (DirNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DirNode)node.getChildAt(index);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            FolderBrowserTree.this.doFileSystem(node);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private class MyTreeWillExpandListener
    implements TreeWillExpandListener {
        private MyTreeWillExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            if (FolderBrowserTree.this.nodeExpansionInProcess) {
                throw new ExpandVetoException(evt);
            }
            FolderBrowserTree tree = FolderBrowserTree.this;
            tree.setCursor(new Cursor(3));
            final TreePath path = evt.getPath();
            final DirNode node = (DirNode)path.getLastPathComponent();
            if (!node.areChildrenLoaded()) {
                FolderBrowserTree.this.nodeExpansionInProcess = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        node.getChildCount();
                        ((MyTreeWillExpandListener)MyTreeWillExpandListener.this).FolderBrowserTree.this.nodeExpansionInProcess = false;
                        FolderBrowserTree.this.expandPath(path);
                    }
                });
                tree.disableTreeSelection();
                throw new ExpandVetoException(evt);
            }
            tree.enableTreeSelection();
            tree.setCursor(new Cursor(0));
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            if (FolderBrowserTree.this.nodeExpansionInProcess) {
                throw new ExpandVetoException(evt);
            }
        }
    }
}

