/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.hyperlink;

import com.nokia.widgets.hyperlink.HyperlinkUI;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class Hyperlink
extends JButton
implements ActionListener,
FocusListener {
    private static final String uiClassID = "LinkUI";
    private boolean myIsVisitsRemembered = false;
    private boolean myLinkVisited = false;
    private URL myURL = null;

    static {
        UIManager.put(uiClassID, HyperlinkUI.class.getName());
    }

    public Hyperlink() {
        this((String)null);
    }

    public Hyperlink(Action a) {
        this((String)null);
        this.setAction(a);
    }

    public Hyperlink(String text, URL target) {
        this(text);
        this.setURL(target);
    }

    public Hyperlink(String text) {
        super(text);
        this.setIconTextGap(3);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground(UIManager.getColor("Hyperlink.background"));
        this.setForeground(UIManager.getColor("Hyperlink.foreground"));
        this.setDefaultCapable(false);
        this.setBorder(UIManager.getBorder("Hyperlink.border"));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setFocusPainted(true);
        this.putClientProperty("OrangeTouch.darkBackground", Boolean.FALSE);
        this.addActionListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new HyperlinkMouseListener());
    }

    public Hyperlink(String text, Icon icon) {
        this(text);
        this.setIcon(icon);
    }

    public void setNegative(boolean negative) {
        this.setForeground(UIManager.getColor(negative ? "Hyperlink.lightForeground" : "Hyperlink.foreground"));
        this.putClientProperty("OrangeTouch.darkBackground", negative);
    }

    public void setUI(HyperlinkUI newUI) {
        super.setUI(newUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((HyperlinkUI)UIManager.getUI(this));
    }

    public void setURL(URL url) {
        URL oldURL = this.myURL;
        this.myURL = url;
        if (oldURL != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "url changed", oldURL, url);
            PropertyChangeListener[] l = this.getPropertyChangeListeners();
            int i = 0;
            while (i < l.length) {
                l[i].propertyChange(event);
                ++i;
            }
        }
    }

    public URL getURL() {
        return this.myURL;
    }

    public boolean openURL() {
        if (this.myURL == null) {
            return false;
        }
        boolean flag = SystemUtils.openInBrowser(this.myURL);
        if (flag) {
            this.myLinkVisited = true;
        }
        return flag;
    }

    public void setVisitsRemembered(boolean remember) {
        this.myIsVisitsRemembered = remember;
        if (!remember) {
            this.setForeground(UIManager.getColor("Hyperlink.foreground"));
        }
    }

    public boolean isVisitsRemembered() {
        return this.myIsVisitsRemembered;
    }

    public void setLinkVisited(boolean aFlag) {
        this.myLinkVisited = aFlag;
    }

    public boolean isLinkVisited() {
        return this.myLinkVisited;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myLinkVisited = true;
        if (this.myIsVisitsRemembered && this.myLinkVisited) {
            this.setForeground(UIManager.getColor("Hyperlink.visited"));
        } else {
            this.setForeground(UIManager.getColor("Hyperlink.foreground"));
        }
        if (this.myURL != null) {
            this.openURL();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.setBorderPainted(true);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.setBorderPainted(false);
    }

    private class HyperlinkMouseListener
    extends MouseAdapter {
        private HyperlinkMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            if (Hyperlink.this.myIsVisitsRemembered && Hyperlink.this.myLinkVisited) {
                Hyperlink.this.setForeground(UIManager.getColor("Hyperlink.foreground"));
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (Hyperlink.this.myIsVisitsRemembered && Hyperlink.this.myLinkVisited) {
                Hyperlink.this.setForeground(UIManager.getColor("Hyperlink.visited"));
            }
        }
    }
}

