/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.hyperlink;

import com.nokia.laf.NetButtonUI;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.util.SystemUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class HyperlinkUI
extends NetButtonUI {
    private static final HyperlinkUI linkUI = new HyperlinkUI();

    public static ComponentUI createUI(JComponent c) {
        return linkUI;
    }

    @Override
    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        button.setFont(UIManager.getFont("Hyperlink.font"));
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Object oldAa = NetUtils.antiAliasingOn(g);
        if (SystemUtils.isOrangeTouch()) {
            this.paintOrangeTouch(g, textRect, b, model);
            super.paintText(g, c, textRect, text);
            return;
        }
        if (b.isFocusOwner() || model.isRollover() || model.isArmed() || model.isPressed()) {
            NetUtils.paintHoverEffect(g, b, textRect.x, textRect.y, textRect.width, textRect.height + 1, textRect);
        }
        NetUtils.setAntialiasing(g, oldAa);
        super.paintText(g, c, textRect, text);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        Color background = c.getBackground();
        JButton btn = (JButton)c;
        ButtonModel model = btn.getModel();
        if (background instanceof UIResource) {
            if (model.isRollover()) {
                g.setColor(background);
                g.fillRect(0, 0, btn.getWidth() - 1, btn.getHeight() - 1);
                NetUtils.drawRoundedRect(g, (Color)NetTheme.COLOR_GRAY_10, 1, 1, iconRect.width + 3, iconRect.height + 3, 5);
                GradientUtils.drawDoubleGradient(c, g, this.myRolloverGradientKey, 1, 1, iconRect.width + 2, iconRect.height + 2);
            } else if (model.isPressed()) {
                GradientUtils.drawDoubleGradient(c, g, this.myPressedGradientKey, 1, 1, iconRect.width + 2, iconRect.height + 2);
            }
        }
        super.paintIcon(g, c, iconRect);
    }

    @Override
    protected boolean createFocusIcon(AbstractButton b, Icon icon) {
        return false;
    }

    @Override
    protected int getTextShiftOffset() {
        return 0;
    }

    private void paintOrangeTouch(Graphics g, Rectangle textRect, AbstractButton b, ButtonModel model) {
        int rounding = 6;
        if (b.isFocusOwner()) {
            g.setColor(NetLookAndFeel.getFocusColor());
            g.drawRoundRect(textRect.x - 2, textRect.y, textRect.width + 3, textRect.height, 6, 6);
        } else if (model.isRollover() || model.isArmed() || model.isPressed()) {
            g.setColor(NetTheme.getSelectionColor());
            g.drawRoundRect(textRect.x - 2, textRect.y, textRect.width + 3, textRect.height, 6, 6);
        } else {
            if (model.isEnabled()) {
                g.setColor(NetTheme.getHoverColor());
            } else {
                g.setColor(NetTheme.getDisabledComponentOutlineColor());
            }
            g.drawLine(textRect.x, textRect.y + textRect.height - 2, textRect.x + textRect.width, textRect.y + textRect.height - 2);
        }
    }
}

