/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import com.nokia.laf.util.NetUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.Icon;

public class CloseIcon
implements Icon {
    private static final Color BACKGROUND_CIRCLE_COLOR = NetUtils.decodeColor("#999999");
    private int mySize = 14;
    private Color myColor = null;
    private Color myBackgroundColor = BACKGROUND_CIRCLE_COLOR;
    private boolean myPaintRoundBackground = false;
    private int myMargin = 4;
    private BasicStroke myStroke = new BasicStroke(3.0f);

    public void setMargin(int margin) {
        this.myMargin = margin;
    }

    public void setPaintRoundBackground(boolean paintBackground) {
        this.myPaintRoundBackground = paintBackground;
    }

    public void setColor(Color color) {
        this.myColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.myBackgroundColor = color == null ? BACKGROUND_CIRCLE_COLOR : color;
    }

    public void setStrokeWidth(int width) {
        this.myStroke = new BasicStroke(width);
    }

    public void setSize(int size) {
        this.mySize = size;
    }

    @Override
    public int getIconWidth() {
        return this.mySize;
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int tempY = y;
        tempY = Math.max(0, tempY);
        Graphics2D graphics2d = (Graphics2D)g;
        Object oldAa = NetUtils.antiAliasingOn(graphics2d);
        Color oldColor = null;
        if (this.myPaintRoundBackground) {
            oldColor = g.getColor();
            g.setColor(this.myBackgroundColor);
            g.fillOval(x, tempY, this.mySize, this.mySize);
        }
        g.setColor(oldColor);
        Stroke oldStroke = graphics2d.getStroke();
        graphics2d.setStroke(this.myStroke);
        if (this.myColor != null) {
            oldColor = g.getColor();
            g.setColor(this.myColor);
        }
        this.paintCross(g, x, tempY);
        graphics2d.setStroke(oldStroke);
        if (oldColor != null) {
            g.setColor(oldColor);
        }
        NetUtils.setAntialiasing(graphics2d, oldAa);
    }

    private void paintCross(Graphics g, int x, int y) {
        g.drawLine(x + this.myMargin, y + this.myMargin, x + this.mySize - 1 - this.myMargin, y + this.mySize - 1 - this.myMargin);
        g.drawLine(x + this.myMargin, y + this.mySize - 1 - this.myMargin, x + this.mySize - 1 - this.myMargin, y + this.myMargin);
    }
}

