/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import com.nokia.widgets.icons.PEmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    private Icon myOuterIcon;
    private Icon myInnerIcon;
    private Insets myMargin = new Insets(0, 0, 0, 0);
    private int myInnerIconHorizontalAlignment = 2;
    private int myInnerIconVerticalAlignment = 0;

    public CompoundIcon(Icon outerIcon, Icon innerIcon) {
        this.myOuterIcon = outerIcon;
        this.myInnerIcon = innerIcon;
    }

    public CompoundIcon(int iconWidth, int iconHeight, Icon innerIcon) {
        this(new PEmptyIcon(iconHeight, iconWidth), innerIcon);
    }

    public CompoundIcon(int iconWidth, int iconHeight, Icon innerIcon, int innerIconHorizontalAlignment) {
        this(new PEmptyIcon(iconHeight, iconWidth), innerIcon);
        this.myInnerIconHorizontalAlignment = innerIconHorizontalAlignment;
    }

    public void setMargin(Insets margin) {
        this.myMargin = margin;
    }

    public Insets getMargin() {
        return new Insets(this.myMargin.top, this.myMargin.left, this.myMargin.bottom, this.myMargin.right);
    }

    public void setInnerIconHorizontalAlignment(int alignment) {
        this.myInnerIconHorizontalAlignment = alignment;
    }

    public void setInnerIconVerticalAlignment(int alignment) {
        this.myInnerIconVerticalAlignment = alignment;
    }

    @Override
    public int getIconHeight() {
        return this.myOuterIcon.getIconHeight() + this.myMargin.top + this.myMargin.bottom;
    }

    @Override
    public int getIconWidth() {
        return this.myOuterIcon.getIconWidth() + this.myMargin.left + this.myMargin.right;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.myOuterIcon.paintIcon(c, g, x + this.myMargin.left, y + this.myMargin.top);
        this.myInnerIcon.paintIcon(c, g, x + this.getInnerIconX(), y + this.getInnerIconY());
    }

    private int getInnerIconX() {
        switch (this.myInnerIconHorizontalAlignment) {
            case 2: {
                return 0;
            }
            case 4: {
                return this.getIconWidth() - this.myInnerIcon.getIconWidth();
            }
            case 0: {
                return (this.getIconWidth() - this.myInnerIcon.getIconWidth()) / 2;
            }
        }
        return 0;
    }

    private int getInnerIconY() {
        switch (this.myInnerIconVerticalAlignment) {
            case 1: {
                return 0;
            }
            case 3: {
                return this.getIconHeight() - this.myInnerIcon.getIconHeight();
            }
            case 0: {
                return (this.getIconHeight() - this.myInnerIcon.getIconHeight()) / 2;
            }
        }
        return 0;
    }

    public static class UIResource
    extends CompoundIcon
    implements javax.swing.plaf.UIResource {
        public UIResource(int iconWidth, int iconHeight, Icon innerIcon) {
            super(iconWidth, iconHeight, innerIcon);
        }
    }
}

