/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.widgets.icons;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class DropShadowComponent
extends JComponent {
    public static final String KEY_BLUR_QUALITY = "blur_quality";
    public static final String VALUE_BLUR_QUALITY_FAST = "fast";
    public static final String VALUE_BLUR_QUALITY_HIGH = "high";
    protected BufferedImage myShadowImage = null;
    protected BufferedImage myOriginalImage = null;
    protected float myAngle = 30.0f;
    protected int myDistance = 5;
    protected int myShadowSize = 5;
    protected float myShadowOpacity = 0.5f;
    protected Color myShadowColor = new Color(0);
    protected int myDistanceX = 0;
    protected int myDistanceY = 0;
    protected Map myHints;

    protected DropShadowComponent() {
        this.computeShadowPosition();
        this.myHints = new HashMap();
        this.myHints.put(KEY_BLUR_QUALITY, VALUE_BLUR_QUALITY_FAST);
    }

    public DropShadowComponent(String imageName) {
        this();
        this.setSubject(imageName);
    }

    public DropShadowComponent(URL imageUrl) {
        this();
        this.setSubject(imageUrl);
    }

    public DropShadowComponent(File imageFile) {
        this();
        this.setSubject(imageFile);
    }

    public DropShadowComponent(BufferedImage image) {
        this();
        this.setSubject(image);
    }

    public void setRenderingHint(Object hint, Object value) {
        this.myHints.put(hint, value);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.myOriginalImage == null ? new Dimension(50, 50) : new Dimension(this.myOriginalImage.getWidth() + (this.myDistance + this.myShadowSize) * 2, this.myOriginalImage.getHeight() + (this.myDistance + this.myShadowSize) * 2);
        return size;
    }

    public void setSubject(String imageName) {
        URL imageUrl = DropShadowComponent.class.getResource(imageName);
        this.setSubject(imageUrl);
    }

    public void setSubject(URL imageUrl) {
        if (imageUrl != null) {
            try {
                BufferedImage subject = ImageIO.read(imageUrl);
                this.setSubject(subject);
            }
            catch (IOException e) {
                this.myOriginalImage = null;
                this.myOriginalImage = null;
            }
        } else {
            this.myOriginalImage = null;
            this.myOriginalImage = null;
        }
    }

    public void setSubject(File imageFile) {
        if (imageFile != null) {
            try {
                BufferedImage subject = ImageIO.read(imageFile);
                this.setSubject(subject);
            }
            catch (IOException e) {
                this.myOriginalImage = null;
                this.myOriginalImage = null;
            }
        } else {
            this.myOriginalImage = null;
            this.myOriginalImage = null;
        }
    }

    public void setSubject(BufferedImage subject) {
        if (subject != null) {
            this.myOriginalImage = subject;
            this.refreshShadow();
        } else {
            this.myOriginalImage = null;
            this.myOriginalImage = null;
        }
    }

    public float getAngle() {
        return this.myAngle;
    }

    public void setAngle(float angle) {
        this.myAngle = angle;
        this.computeShadowPosition();
    }

    public int getDistance() {
        return this.myDistance;
    }

    public void setDistance(int distance) {
        this.myDistance = distance;
        this.computeShadowPosition();
    }

    public float getShadowOpacity() {
        return this.myShadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.myShadowOpacity = shadowOpacity;
        this.refreshShadow();
    }

    public int getShadowSize() {
        return this.myShadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.myShadowSize = shadowSize;
        this.refreshShadow();
    }

    public void refreshShadow() {
        if (this.myOriginalImage != null) {
            this.myShadowImage = this.createDropShadow(this.myOriginalImage);
        }
    }

    private void computeShadowPosition() {
        double angleRadians = Math.toRadians(this.myAngle);
        this.myDistanceX = (int)(Math.cos(angleRadians) * (double)this.myDistance);
        this.myDistanceY = (int)(Math.sin(angleRadians) * (double)this.myDistance);
    }

    private BufferedImage prepareImage(BufferedImage image) {
        BufferedImage subject = new BufferedImage(image.getWidth() + this.myShadowSize * 2, image.getHeight() + this.myShadowSize * 2, 2);
        Graphics2D g2 = subject.createGraphics();
        g2.drawImage(image, null, this.myShadowSize, this.myShadowSize);
        g2.dispose();
        return subject;
    }

    private BufferedImage createDropShadow(BufferedImage image) {
        BufferedImage subject = this.prepareImage(image);
        if (this.myHints.get(KEY_BLUR_QUALITY) == VALUE_BLUR_QUALITY_HIGH) {
            BufferedImage shadow = new BufferedImage(subject.getWidth(), subject.getHeight(), 2);
            BufferedImage shadowMask = this.createShadowMask(subject);
            this.getLinearBlurOp(this.myShadowSize).filter(shadowMask, shadow);
            return shadow;
        }
        this.applyShadow(subject);
        return subject;
    }

    private void applyShadow(BufferedImage image) {
        int a;
        int aSum;
        int dstWidth = image.getWidth();
        int dstHeight = image.getHeight();
        int left = this.myShadowSize - 1 >> 1;
        int right = this.myShadowSize - left;
        int xStart = left;
        int xStop = dstWidth - right;
        int yStart = left;
        int yStop = dstHeight - right;
        int shadowRgb = this.myShadowColor.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[this.myShadowSize];
        int historyIdx = 0;
        int[] dataBuffer = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int lastPixelOffset = right * dstWidth;
        float sumDivider = this.myShadowOpacity / (float)this.myShadowSize;
        int bufferOffset = 0;
        int y = 0;
        while (y < dstHeight) {
            aSum = 0;
            historyIdx = 0;
            int x = 0;
            while (x < this.myShadowSize) {
                aHistory[x] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++x;
                ++bufferOffset;
            }
            bufferOffset -= right;
            x = xStart;
            while (x < xStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + right] >>> 24;
                aSum += a;
                if (++historyIdx >= this.myShadowSize) {
                    historyIdx -= this.myShadowSize;
                }
                ++x;
                ++bufferOffset;
            }
            bufferOffset = ++y * dstWidth;
        }
        bufferOffset = 0;
        int x = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            int y2 = 0;
            while (y2 < this.myShadowSize) {
                aHistory[y2] = a = dataBuffer[bufferOffset] >>> 24;
                aSum += a;
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset -= lastPixelOffset;
            y2 = yStart;
            while (y2 < yStop) {
                a = (int)((float)aSum * sumDivider);
                dataBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dataBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= this.myShadowSize) {
                    historyIdx -= this.myShadowSize;
                }
                ++y2;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
    }

    private BufferedImage createShadowMask(BufferedImage image) {
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = mask.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(5, this.myShadowOpacity));
        g2d.setColor(this.myShadowColor);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
        return mask;
    }

    private ConvolveOp getLinearBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        int i = 0;
        while (i < data.length) {
            data[i] = value;
            ++i;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y;
        int x;
        if (this.myShadowImage != null) {
            x = (this.getWidth() - this.myShadowImage.getWidth()) / 2;
            y = (this.getHeight() - this.myShadowImage.getHeight()) / 2;
            g.drawImage(this.myShadowImage, x + this.myDistanceX, y + this.myDistanceY, null);
        }
        if (this.myOriginalImage != null) {
            x = (this.getWidth() - this.myOriginalImage.getWidth()) / 2;
            y = (this.getHeight() - this.myOriginalImage.getHeight()) / 2;
            g.drawImage(this.myOriginalImage, x, y, null);
        }
    }
}

